Summary: Awesant is a log shipper for logstash.
Name: awesant
Version: 0.13
Release: 1%{?dist}
License: distributable
Group: System Environment/Daemons
Distribution: RHEL and CentOS
URL: http://download.bloonix.de/

Packager: Jonny Schulz <js@bloonix.de>
Vendor: Bloonix

BuildArch: noarch
BuildRoot: %{_tmppath}/%{name}-%{version}-%{release}-%(%{__id_u} -n)

Source0: http://download.bloonix.de/sources/%{name}-%{version}.tar.gz
Requires: perl
Requires: perl(Log::Handler)
Requires: perl(Params::Validate)
Requires: perl(IO::Socket)
Requires: perl(IO::Select)
Requires: perl(JSON)
Requires: perl(Sys::Hostname)
Requires: perl(Time::HiRes)
Requires: perl(Class::Accessor::Fast)
AutoReqProv: no

%define initdir %{_sysconfdir}/rc.d/init.d
%define confdir %{_sysconfdir}/awesant
%define logrdir %{_sysconfdir}/logrotate.d
%define logdir %{_var}/log/awesant
%define libdir %{_var}/lib/awesant
%define defaults %{_sysconfdir}/sysconfig

%description
Awesant is a log shipper for logstash.

%prep
%setup -q -n %{name}-%{version}

%build
%{__perl} Configure.PL --prefix /usr --initdir %{initdir} --without-perl
%{__make}
cd perl;
%{__perl} Build.PL --installdirs vendor --destdir %{buildroot}
./Build

%install
rm -rf %{buildroot}
%{__make} install DESTDIR=%{buildroot}
mkdir -p %{buildroot}%{libdir}
mkdir -p %{buildroot}%{logdir}
install -D -m 644 etc/defaults/awesant-agent %{buildroot}%{defaults}/awesant-agent
install -D -m 644 etc/logrotate.d/awesant %{buildroot}%{logrdir}/awesant

cd perl;
./Build pure_install
find %{buildroot} -name .packlist -exec %{__rm} {} \;

%post
true

%clean
rm -rf %{buildroot}

%files
%defattr(-,root,root)

%{initdir}/awesant-agent
%{_bindir}/awesant
%{_bindir}/awesant-create-cert

%dir %attr(0750, root, root) %{libdir}
%dir %attr(0750, root, root) %{logdir}
%dir %attr(0750, root, root) %{confdir}
%config(noreplace) %attr(0640, root, root) %{confdir}/agent.conf
%config(noreplace) %attr(0640, root, root) %{logrdir}/awesant
%config(noreplace) %attr(0640, root, root) %{defaults}/awesant-agent

%dir %{perl_vendorlib}/Awesant/
%dir %{perl_vendorlib}/Awesant/Input
%dir %{perl_vendorlib}/Awesant/Output
%{perl_vendorlib}/Awesant/*.pm
%{perl_vendorlib}/Awesant/Input/*.pm
%{perl_vendorlib}/Awesant/Output/*.pm
%{_mandir}/man?/Awesant::*

%changelog
* Fri Jan 17 2014 Jonny Schulz <js@bloonix.de> - 0.13-1
- Awesant is ready for the new logstash json schema.
- oldlogstashjson is now set to 'no' by default.
* Mon Dec 09 2013 Jonny Schulz <js@bloonix.de> - 0.12-1
- Implemented a failover mechanism for the redis output.
- The hostname can now be set in the configuration file.
- Added parameter milliseconds for @timestamp.
- Added parameter oldlogstashjson to switch between the old
  and new logstash json schema.
- Added parameter skip for Input/File.pm to skip events.
* Fri Aug 30 2013 Jonny Schulz <js@bloonix.de> - 0.11-1
- Added option ssl_verify_mode to Input/Socket.pm and Output/Socket.pm.
- Fixed dependencies of Awesant. Class::Accessor was missed.
- Modified the init script to make it runable on Solaris.
- It's now possible to use a wildcard for output types.
- Improved logrotate handling - the file input waits up to 10 seconds
  for new lines before close the rotated file.
- Fixed a typo in the init script that removes insserv warnings on Debian:
  'insserv: warning: script 'awesant-agent' missing LSB tags and overrides'
* Wed Jul 17 2013 Jonny Schulz <js@bloonix.de> - 0.10-1
- Added new output Rabbitmq.
- Fixed "undefined value as a hash reference ... line 371" if
  only one input exists that has workers configured.
* Fri Apr 19 2013 Jonny Schulz <js@bloonix.de> - 0.9-1
- Fixed: add_field does not work if format is set to json_event.
* Sun Apr 15 2013 Jonny Schulz <js@bloonix.de> - 0.8-1
- A lot of bug fixes and features implemented.
* Sun Feb 03 2013 Jonny Schulz <js@bloonix.net> - 0.7-1
- Some readability improvements.
- Added the debian specific directory with its control files to to build awesant for debian quickly.
* Thu Dec 06 2012 Jonny Schulz <js@bloonix.net> - 0.6-1
- Added a disconnect message to Output/Socket.pm.
- Added some benchmarking options to Agent.pm.
- Fixed "cat pidfile" in the init script.
- Added the new parameter 'format' for incoming messages.
- Added a input for tcp sockets.
- Now process groups are created for inputs that have the parameter 'workers' configured.
* Sun Nov 15 2012 Jonny Schulz <js@bloonix.net> - 0.4-1
- Implemented a extended add_field feature.
* Sun Nov 11 2012 Jonny Schulz <js@bloonix.net> - 0.3-1
- Fixed timestamp formatting.
- Modified an confusing error message.
- Some code improvements in Output/Redis.pm.
* Sun Nov 11 2012 Jonny Schulz <js@bloonix.net> - 0.2-1
- Fixed "Can't call method is_debug" in Output/Screen.pm.
- Added the feature that multiple types can be set for outputs.
- Deleted awesant.conf - this file will be build by make.
* Thu Nov 08 2012 Jonny Schulz <js@bloonix.net> - 0.1-1
- Initial package.
