/*
 * Decompiled with CFR 0.152.
 */
package debuglog;

import debuglog.Backup;
import debuglog.ModuleParams;
import debuglog.TraceInfo;
import debuglog.TraceManager;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.prefs.Preferences;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class TraceConfigurator {
    private double logFileSizeInMB = 0.0;
    private String oem = null;
    private String logFileLocation = null;
    private String saveType = null;
    private Hashtable modulesSpec = new Hashtable();
    private ArrayList msmObjects = new ArrayList();
    private TraceInfo traceinfo = null;
    private Document doc = null;
    private Backup logbackup = null;
    public boolean featureEnable = false;

    public TraceConfigurator(TraceInfo traceInfo) {
        this.traceinfo = traceInfo;
        this.readConfigurationXml();
    }

    public TraceConfigurator(TraceInfo traceInfo, String string, String string2) {
        if (string.equals("readFrmPreference")) {
            this.readCfgFromPreference(string2);
        } else {
            this.traceinfo = traceInfo;
            this.readConfigurationXml();
        }
    }

    public void readConfigurationXml() {
        this.parseAllTags();
    }

    private void parseAllTags() {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
            documentBuilderFactory.setNamespaceAware(true);
            documentBuilderFactory.setValidating(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            this.doc = documentBuilder.parse(new File("debugcfg.xml"));
            if (this.validateXML(this.doc)) {
                this.parseXML();
            }
        }
        catch (ParserConfigurationException parserConfigurationException) {
            TraceManager.createErrorFile("Error while parsing the file");
        }
        catch (Exception exception) {
            TraceManager.createErrorFile("Could not parse the file...");
        }
    }

    private boolean validateXML(Document document) {
        try {
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            Schema schema = schemaFactory.newSchema(new File("debugschema.xsd"));
            Validator validator = schema.newValidator();
            validator.validate(new DOMSource(document));
            return true;
        }
        catch (SAXException sAXException) {
            TraceManager.createErrorFile("Error while parsing....please check schema file against xml file");
            TraceManager.createErrorFile(sAXException.toString());
        }
        catch (IOException iOException) {
            TraceManager.createErrorFile("Error while reading the file");
        }
        catch (Exception exception) {
            TraceManager.createErrorFile("TraceLogger parsing error...");
        }
        return false;
    }

    private void parseXML() {
        try {
            NodeList nodeList;
            Node node;
            int n;
            NodeList nodeList2;
            NodeList nodeList3;
            NodeList nodeList4;
            NodeList nodeList5;
            NodeList nodeList6;
            this.doc.getDocumentElement().normalize();
            NodeList nodeList7 = this.doc.getElementsByTagName("featureEnable");
            if (nodeList7 != null) {
                this.featureEnable = Boolean.parseBoolean(nodeList7.item(0).getTextContent());
            }
            this.doc.getDocumentElement().normalize();
            NodeList nodeList8 = this.doc.getElementsByTagName("oem");
            if (nodeList8 != null) {
                this.oem = nodeList8.item(0).getTextContent();
            }
            if ((nodeList6 = this.doc.getElementsByTagName("logfilesizeinmb")) != null) {
                this.logFileSizeInMB = Double.parseDouble(nodeList6.item(0).getTextContent());
            }
            if ((nodeList5 = this.doc.getElementsByTagName("logfilelocation")) != null && new File(nodeList5.item(0).getTextContent()).isDirectory()) {
                this.logFileLocation = nodeList5.item(0).getTextContent();
            }
            if ((nodeList4 = this.doc.getElementsByTagName("savetype")) != null) {
                this.saveType = this.detSavType(nodeList4.item(0).getTextContent().toUpperCase().trim());
            }
            if ((nodeList3 = this.doc.getElementsByTagName("msmobjects")) != null && (nodeList2 = nodeList3.item(0).getChildNodes()) != null) {
                for (n = 0; n < nodeList2.getLength(); ++n) {
                    node = nodeList2.item(n);
                    if (node == null || !node.getNodeName().equals("object")) continue;
                    this.addMSMObjects(node.getTextContent());
                }
            }
            if ((nodeList2 = this.doc.getElementsByTagName("module")) != null) {
                for (n = 0; n < nodeList2.getLength(); ++n) {
                    node = nodeList2.item(n);
                    this.createModuels(node);
                }
            }
            if ((nodeList = this.doc.getElementsByTagName("backup")) != null) {
                node = nodeList.item(0);
                this.logbackup = new Backup(Boolean.parseBoolean(node.getAttributes().getNamedItem("type").getTextContent()), node.getAttributes().getNamedItem("location").getTextContent());
            }
        }
        catch (Exception exception) {
            TraceManager.createErrorFile(exception.toString());
        }
    }

    private String detSavType(String string) {
        if (string.trim().toUpperCase().equals("XML")) {
            return "XML";
        }
        if (string.trim().toUpperCase().equals("TEXT")) {
            return "TEXT";
        }
        if (string.trim().toUpperCase().equals("CONSOLE")) {
            return "CONSOLE";
        }
        return null;
    }

    private void addMSMObjects(String string) {
        if (string != null) {
            string = string.toUpperCase().trim();
            this.msmObjects.add(string);
        }
    }

    private void createModuels(Node node) {
        ModuleParams moduleParams = new ModuleParams();
        ArrayList<String> arrayList = new ArrayList<String>();
        NodeList nodeList = node.getChildNodes();
        if (nodeList != null) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node2 = nodeList.item(i);
                if (node2 != null && node2.getNodeName().equals("depth")) {
                    moduleParams.setDepth(new Integer(node2.getTextContent()));
                }
                if (node2 == null || !node2.getNodeName().equals("tracetype")) continue;
                arrayList.add(node2.getTextContent().trim().toUpperCase());
            }
        }
        moduleParams.setSeverity(arrayList);
        this.modulesSpec.put(node.getAttributes().getNamedItem("name").getTextContent().trim().toUpperCase(), moduleParams);
    }

    public void writeConfigurationXml(int n, int n2, String string, String string2, Backup backup, ArrayList arrayList, Hashtable hashtable) {
        this.writeXmlFile(this.createDocument(n, n2, string, string2, backup, arrayList, hashtable), "debugcfg.xml");
        this.parseAllTags();
    }

    public double getLogFileSizeInMB() {
        return this.logFileSizeInMB;
    }

    public void setLogFileSizeInMB(int n) {
        this.logFileSizeInMB = n;
    }

    public String getSaveType() {
        return this.saveType;
    }

    public void setSaveType(String string) {
        this.saveType = string;
    }

    public String getLogFileLocation() {
        return this.logFileLocation;
    }

    public void setLogFileLocation(String string) {
        this.logFileLocation = string;
    }

    public void setModules(Hashtable hashtable) {
        this.modulesSpec = hashtable;
    }

    public Hashtable getModules() {
        return this.modulesSpec;
    }

    public void setMsmObjects(ArrayList arrayList) {
        this.msmObjects = arrayList;
    }

    public ArrayList getMsmObjects() {
        return this.msmObjects;
    }

    public void readCfgFromPreference(String string) {
        this.logFileSizeInMB = Double.parseDouble(this.get(string, "logfilesizeinmb"));
        this.logFileLocation = this.get(string, "logfilelocation");
        this.saveType = this.get(string, "savetype");
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.getByteArray(string, "msmobjects"));
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            this.msmObjects = (ArrayList)objectInputStream.readObject();
            byteArrayInputStream = new ByteArrayInputStream(this.getByteArray(string, "module"));
            objectInputStream = new ObjectInputStream(byteArrayInputStream);
            this.modulesSpec = (Hashtable)objectInputStream.readObject();
            byteArrayInputStream = new ByteArrayInputStream(this.getByteArray(string, "backup"));
            objectInputStream = new ObjectInputStream(byteArrayInputStream);
            this.logbackup = (Backup)objectInputStream.readObject();
        }
        catch (Exception exception) {
            TraceManager.createErrorFile(exception.toString());
        }
    }

    public void writeCfgToPreference(String string, long l, String string2, String string3, Hashtable hashtable, ArrayList arrayList) {
        this.oem = string;
        this.set(string, "logfilesizeinmb", l + "");
        this.set(string, "logfilelocation", string2);
        this.set(string, "savetype", string3);
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(arrayList);
            this.set(string, "msmobjects", byteArrayOutputStream.toByteArray());
            objectOutputStream.flush();
            objectOutputStream.writeObject(hashtable);
            this.set(string, "module", byteArrayOutputStream.toByteArray());
            objectOutputStream.flush();
            objectOutputStream.writeObject(this.logbackup);
            this.set(string, "backup", byteArrayOutputStream.toByteArray());
        }
        catch (Exception exception) {
            TraceManager.createErrorFile(exception.toString());
        }
    }

    public void writeXmlFile(Document document, String string) {
        try {
            DOMSource dOMSource = new DOMSource(document);
            File file = new File(string);
            StreamResult streamResult = new StreamResult(file);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.transform(dOMSource, streamResult);
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            TraceManager.createErrorFile(transformerConfigurationException.toString());
        }
        catch (TransformerException transformerException) {
            TraceManager.createErrorFile(transformerException.toString());
        }
    }

    private Document createDocument(int n, int n2, String string, String string2, Backup backup, ArrayList arrayList, Hashtable hashtable) {
        try {
            Text text = null;
            Text text2 = null;
            Element element = null;
            Element element2 = null;
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            Element element3 = document.createElement("configurator");
            element3.setAttribute("xmlns", "http://www.w3schools.com");
            element3.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
            element3.setAttribute("xsi:schemaLocation", "http://www.w3schools.com debugschema.xsd");
            element = document.createElement("oem");
            text = document.createTextNode(n + "");
            element.appendChild(text);
            element3.appendChild(element);
            element = document.createElement("logfilesizeinmb");
            text = document.createTextNode(n2 + "");
            element.appendChild(text);
            element3.appendChild(element);
            element = document.createElement("logfilelocation");
            text = document.createTextNode(string);
            element.appendChild(text);
            element3.appendChild(element);
            element = document.createElement("savetype");
            text = document.createTextNode(string2);
            element.appendChild(text);
            element3.appendChild(element);
            element = document.createElement("backup");
            element.setAttribute("location", backup.getLoc());
            element.setAttribute("type", backup.isBackup() + "");
            element3.appendChild(element);
            element = document.createElement("msmobjects");
            element3.appendChild(element);
            for (int i = 0; i < arrayList.size(); ++i) {
                element2 = document.createElement("object");
                element.appendChild(element2);
                text2 = document.createTextNode((String)arrayList.get(i));
                element2.appendChild(text2);
            }
            element = document.createElement("module");
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                Object k = enumeration.nextElement();
                if (!(k instanceof String)) continue;
                Object v = hashtable.get((String)k);
                element.setAttribute("name", (String)k);
                element3.appendChild(element);
                if (!(v instanceof ModuleParams)) continue;
                ModuleParams moduleParams = (ModuleParams)v;
                element2 = document.createElement("depth");
                element.appendChild(element2);
                text2 = document.createTextNode(moduleParams.getDepth() + "");
                element2.appendChild(text2);
                ArrayList arrayList2 = moduleParams.getSeverity();
                for (int i = 0; i < arrayList2.size(); ++i) {
                    element2 = document.createElement("tracetype");
                    element.appendChild(element2);
                    text2 = document.createTextNode((String)arrayList2.get(i));
                    element2.appendChild(text2);
                }
            }
            element3.appendChild(element);
            document.appendChild(element3);
            return document;
        }
        catch (Exception exception) {
            TraceManager.createErrorFile(exception.toString());
            return null;
        }
    }

    public Backup getLogbackup() {
        return this.logbackup;
    }

    public String getOem() {
        return this.oem;
    }

    public void setOem(String string) {
        this.oem = string;
    }

    private Preferences getNode(String string) {
        return Preferences.systemRoot().node("/com/LSI/Vivaldi/" + string);
    }

    public void set(String string, String string2, String string3) {
        try {
            this.getNode(string).put(string2, string3);
        }
        catch (Exception exception) {
            TraceManager.createErrorFile(exception.getMessage());
        }
    }

    public void set(String string, String string2, byte[] byArray) {
        try {
            this.getNode(string).putByteArray(string2, byArray);
        }
        catch (Exception exception) {
            TraceManager.createErrorFile(exception.getMessage());
        }
    }

    public String get(String string, String string2) {
        try {
            return this.get(string, string2, "");
        }
        catch (Exception exception) {
            TraceManager.createErrorFile(exception.getMessage());
            return "";
        }
    }

    public String get(String string, String string2, String string3) {
        try {
            return this.getNode(string).get(string2, string3);
        }
        catch (Exception exception) {
            TraceManager.createErrorFile(exception.getMessage());
            return "";
        }
    }

    public byte[] getByteArray(String string, String string2) {
        byte[] byArray = null;
        try {
            return this.getNode(string).getByteArray(string2, byArray);
        }
        catch (Exception exception) {
            TraceManager.createErrorFile(exception.getMessage());
            return null;
        }
    }
}

