/*
 * Decompiled with CFR 0.152.
 */
package debuglog;

import Framework.debuglogger.DebugLoggerInterface;
import debuglog.ModuleParams;
import debuglog.TraceConfigurator;
import debuglog.TraceInfo;
import debuglog.TraceWriter;
import java.io.File;
import java.io.PrintWriter;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Date;

public class TraceManager
implements DebugLoggerInterface {
    private TraceConfigurator cfgxml = null;
    private TraceInfo traceinfo = new TraceInfo();
    private TraceWriter writer = null;
    protected static PrintWriter fp = null;
    private static String[] allPremitivetypes = new String[]{"java.lang.Integer", "java.lang.String", "java.lang.Boolean", "java.lang.Float", "java.lang.Double", "java.lang.Long"};

    public TraceManager() {
        if (this.traceinfo != null) {
            this.cfgxml = new TraceConfigurator(this.traceinfo);
            if (this.cfgxml != null && this.cfgxml.getSaveType() != null) {
                this.writer = new TraceWriter(this.cfgxml.featureEnable, this.cfgxml.getLogFileSizeInMB(), this.cfgxml.getLogFileLocation(), this.cfgxml.getSaveType(), this.cfgxml.getLogbackup());
            }
        }
    }

    public TraceManager(String string, String string2) {
        if (this.traceinfo != null) {
            this.cfgxml = new TraceConfigurator(this.traceinfo, string, string2);
            if (this.cfgxml != null) {
                this.writer = new TraceWriter(this.cfgxml.featureEnable, this.cfgxml.getLogFileSizeInMB(), this.cfgxml.getLogFileLocation(), this.cfgxml.getSaveType(), this.cfgxml.getLogbackup());
            }
        }
    }

    public TraceConfigurator getConfigurator() {
        return this.cfgxml;
    }

    public TraceInfo getInfo() {
        return this.traceinfo;
    }

    @Override
    public boolean isFeatureEnable() {
        return this.cfgxml.featureEnable;
    }

    @Override
    public synchronized boolean log(String string, String string2, String string3) {
        try {
            if (this.cfgxml != null && this.cfgxml.getSaveType() != null && this.cfgxml.getSaveType().equals("TEXT")) {
                if (this.checkModuleSeverity(string2, string3)) {
                    this.writer.writeToTextFile(this.getLogDateTime() + "-----" + string + "----" + string2);
                } else if (this.cfgxml.getSaveType().equals("XML")) {
                    if (this.checkModuleSeverity(string2, string3)) {
                        this.writer.writeToXmlFile(this.getLogDateTime(), string2, string);
                    } else if (this.cfgxml.getSaveType().equals("CONSOLE") && this.checkModuleSeverity(string2, string3)) {
                        this.writer.writeToConsole(this.getLogDateTime() + "-----" + string + "----" + string2);
                    }
                }
            }
        }
        catch (Exception exception) {
            TraceManager.createErrorFile(exception.toString());
        }
        return false;
    }

    private boolean checkModuleSeverity(String string, String string2) {
        ArrayList arrayList;
        ModuleParams moduleParams = (ModuleParams)this.cfgxml.getModules().get(string.toUpperCase().trim());
        if (moduleParams != null && (arrayList = moduleParams.getSeverity()) != null) {
            for (int i = 0; i < arrayList.size(); ++i) {
                if (!arrayList.get(i).equals(string2.trim().toUpperCase())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public synchronized boolean log(char[] cArray, String string, String string2) {
        try {
            if (this.cfgxml != null && this.cfgxml.getSaveType() != null) {
                String string3 = new String(cArray);
                if (this.cfgxml.getSaveType().equals("TEXT")) {
                    if (this.checkModuleSeverity(string, string2)) {
                        this.writer.writeToTextFile(this.getLogDateTime() + "-----" + string3 + "----" + string);
                    } else if (this.cfgxml.getSaveType().equals("XML")) {
                        if (this.checkModuleSeverity(string, string2)) {
                            this.writer.writeToXmlFile(string3, this.getLogDateTime(), string);
                        } else if (this.cfgxml.getSaveType().equals("CONSOLE") && this.checkModuleSeverity(string, string2)) {
                            this.writer.writeToConsole(this.getLogDateTime() + "-----" + string3 + "----" + string);
                        }
                    }
                }
            }
        }
        catch (Exception exception) {
            TraceManager.createErrorFile(exception.toString());
        }
        return false;
    }

    @Override
    public synchronized boolean log(byte[] byArray, String string, String string2) {
        try {
            if (this.cfgxml != null && this.cfgxml.getSaveType() != null) {
                String string3 = new String(byArray);
                if (this.cfgxml.getSaveType().equals("TEXT")) {
                    if (this.checkModuleSeverity(string, string2)) {
                        this.writer.writeToTextFile(this.getLogDateTime() + "-----" + string3 + "----" + string);
                    } else if (this.cfgxml.getSaveType().equals("XML")) {
                        if (this.checkModuleSeverity(string, string2)) {
                            this.writer.writeToXmlFile(string3, this.getLogDateTime(), string);
                        } else if (this.cfgxml.getSaveType().equals("CONSOLE") && this.checkModuleSeverity(string, string2)) {
                            this.writer.writeToConsole(this.getLogDateTime() + "-----" + string3 + "----" + string);
                        }
                    }
                }
            }
        }
        catch (Exception exception) {
            TraceManager.createErrorFile(exception.toString());
        }
        return false;
    }

    @Override
    public synchronized boolean log(Throwable throwable, String string, String string2) {
        StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
        int n = this.logDepth(string, stackTraceElementArray.length);
        try {
            if (this.cfgxml != null && this.cfgxml.getSaveType() != null && this.cfgxml.getSaveType().equals("TEXT")) {
                if (this.checkModuleSeverity(string, string2)) {
                    this.writer.writeToTextFile(this.getLogDateTime() + "-----" + string);
                } else if (this.cfgxml.getSaveType().equals("CONSOLE") && this.checkModuleSeverity(string, string2)) {
                    this.writer.writeToConsole(this.getLogDateTime() + "-----" + string);
                }
            }
        }
        catch (Exception exception) {
            TraceManager.createErrorFile(exception.toString());
        }
        for (int i = 0; i < n; ++i) {
            try {
                if (this.cfgxml == null || this.cfgxml.getSaveType() == null || !this.cfgxml.getSaveType().equals("TEXT")) continue;
                if (this.checkModuleSeverity(string, string2)) {
                    this.writer.writeToTextFile(stackTraceElementArray[i].toString());
                    continue;
                }
                if (!this.cfgxml.getSaveType().equals("XML")) continue;
                if (this.checkModuleSeverity(string, string2)) {
                    this.writer.writeToXmlFile(this.getLogDateTime(), string, stackTraceElementArray[i].toString());
                    continue;
                }
                if (!this.cfgxml.getSaveType().equals("CONSOLE") || !this.checkModuleSeverity(string, string2)) continue;
                this.writer.writeToConsole(stackTraceElementArray[i].toString());
                continue;
            }
            catch (Exception exception) {
                TraceManager.createErrorFile(exception.toString());
            }
        }
        return false;
    }

    private int logDepth(String string, int n) {
        ModuleParams moduleParams = (ModuleParams)this.cfgxml.getModules().get(string.toUpperCase());
        if (moduleParams != null) {
            int n2 = moduleParams.getDepth();
            return n2 > n ? n : n2;
        }
        return -1;
    }

    private String getLogDateTime() {
        return new Date().toString();
    }

    @Override
    public synchronized boolean logObject(Object object, String string) {
        if (this.checkAllowedObj(string)) {
            return this.logObjects(object);
        }
        return false;
    }

    private boolean checkAllowedObj(String string) {
        ArrayList arrayList = this.cfgxml.getMsmObjects();
        for (int i = 0; i < arrayList.size(); ++i) {
            if (!((String)arrayList.get(i)).toUpperCase().trim().equals(string.toUpperCase().trim())) continue;
            return true;
        }
        return false;
    }

    private synchronized boolean logObjects(Object object) {
        Class<?> clazz;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(clazz.getName());
        stringBuffer.append("\n");
        if (clazz.isArray()) {
            stringBuffer.append("[");
            for (int i = 0; i < Array.getLength(object); ++i) {
                Object object2;
                if (i < 0) {
                    stringBuffer.append(",");
                }
                if ((object2 = Array.get(object, i)) == null) continue;
                stringBuffer.append(object2.getClass().isArray() ? Boolean.valueOf(this.logObjects(object2)) : object2);
            }
            stringBuffer.append("]");
        } else {
            stringBuffer.append("{");
            for (clazz = object.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
                Field[] fieldArray = clazz.getDeclaredFields();
                for (int i = 0; i < fieldArray.length; ++i) {
                    boolean bl = false;
                    if (stringBuffer.length() < 1) {
                        stringBuffer.append(",");
                    }
                    fieldArray[i].setAccessible(true);
                    stringBuffer.append(fieldArray[i].getName());
                    stringBuffer.append("=");
                    try {
                        Object object3 = fieldArray[i].get(object);
                        if (object3 == null) continue;
                        stringBuffer.append(object3.getClass().isArray() ? Boolean.valueOf(this.logObjects(object3)) : object3);
                        continue;
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        TraceManager.createErrorFile(illegalAccessException.toString());
                    }
                }
            }
            stringBuffer.append("}");
        }
        try {
            if (this.cfgxml.getSaveType().equals("TEXT")) {
                this.writer.writeToTextFile(stringBuffer.toString());
            } else if (this.cfgxml.getSaveType().equals("XML")) {
                this.writer.writeToXmlFile(stringBuffer.toString());
            } else if (this.cfgxml.getSaveType().equals("CONSOLE")) {
                this.writer.writeToConsole(stringBuffer.toString());
            }
            return true;
        }
        catch (Exception exception) {
            TraceManager.createErrorFile(exception.toString());
            return false;
        }
    }

    protected static void createErrorFile(String string) {
        try {
            if (fp == null) {
                fp = new PrintWriter(new File("debugerror"));
            }
            fp.println(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void exit() {
        if (fp != null) {
            fp.close();
        }
    }
}

