/*
 * Decompiled with CFR 0.152.
 */
package debuglog;

import debuglog.Backup;
import debuglog.TraceManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TraceWriter {
    private double logFileSizeInMB = 0.0;
    private long logFileSizes = 0L;
    private int zipFileCounter = 1;
    private String logFileLocation = null;
    private RandomAccessFile out = null;
    private Backup bak = null;
    private String filenamePath = null;
    private File file = null;
    private Document docu = null;
    private Element root = null;

    protected TraceWriter(boolean bl, double d, String string, String string2, Backup backup) {
        this.logFileLocation = string;
        this.logFileSizeInMB = d;
        this.bak = backup;
        try {
            if (bl) {
                String string3 = null;
                string3 = string2.equals("TEXT") ? "debuglog.txt" : "debuglog.xml";
                this.filenamePath = string + File.separator + string3;
                this.file = new File(this.filenamePath);
                this.logFileSizes = this.file.length();
                if (string2.equals("TEXT")) {
                    this.out = new RandomAccessFile(this.file, "rw");
                } else if (string2.equals("XML")) {
                    if (this.logFileSizes == 0L) {
                        this.createNewXml();
                    } else {
                        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                        documentBuilderFactory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
                        documentBuilderFactory.setNamespaceAware(true);
                        documentBuilderFactory.setValidating(true);
                        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                        this.docu = documentBuilder.parse(new File(this.filenamePath));
                        this.root = this.docu.getDocumentElement();
                    }
                }
            }
        }
        catch (Exception exception) {
            TraceManager.createErrorFile(exception.toString());
        }
    }

    protected boolean writeToXmlFile(String ... stringArray) throws IOException {
        this.updateXmlFileSize(stringArray);
        this.checkXmlFileSize();
        Element element = this.docu.createElement("log");
        for (int i = 0; i < stringArray.length - 2; ++i) {
            element.setAttribute("date", stringArray[0]);
            element.setAttribute("module", stringArray[1]);
            element.setTextContent(stringArray[i + 2]);
        }
        this.root.appendChild(element);
        this.writeXmlFile(this.docu);
        return true;
    }

    private void updateXmlFileSize(String ... stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            this.logFileSizes += (long)stringArray[i].length();
        }
        this.logFileSizes += 11L;
    }

    private void checkXmlFileSize() {
        if ((double)this.logFileSizes > 1048576.0 * this.logFileSizeInMB) {
            if (this.bak.isBackup()) {
                this.doBackUp();
            } else {
                try {
                    this.createOldXmlFile();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            this.createNewXml();
        }
    }

    private void createOldXmlFile() throws FileNotFoundException, IOException {
        byte[] byArray = new byte[(int)this.file.length()];
        new FileInputStream(this.file).read(byArray);
        new FileOutputStream(new File(this.logFileLocation + File.separator + "debuglog_old.xml")).write(byArray);
        this.logFileSizes = 0L;
    }

    private void doBackUp() {
        while (new File(this.bak.getLoc() + File.separator + "backup" + this.zipFileCounter + ".zip").exists()) {
            ++this.zipFileCounter;
        }
        this.backUpLog(this.bak.getLoc() + File.separator + "backup" + this.zipFileCounter + ".zip");
        ++this.zipFileCounter;
        this.logFileSizes = 0L;
    }

    private void createNewXml() {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            this.docu = documentBuilder.newDocument();
            this.root = this.docu.createElement("MSMLOG");
            this.docu.appendChild(this.root);
            this.writeXmlFile(this.docu);
        }
        catch (Exception exception) {
            TraceManager.createErrorFile(exception.toString());
        }
    }

    public void writeXmlFile(Document document) {
        try {
            DOMSource dOMSource = new DOMSource(document);
            StreamResult streamResult = new StreamResult(this.file);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.transform(dOMSource, streamResult);
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            TraceManager.createErrorFile(transformerConfigurationException.toString());
        }
        catch (TransformerException transformerException) {
            TraceManager.createErrorFile(transformerException.toString());
        }
    }

    protected boolean writeToTextFile(String ... stringArray) throws IOException {
        int n = this.determineLogSize(stringArray);
        this.checkTextFileSize(n);
        this.out.seek(this.logFileSizes);
        for (int i = 0; i < stringArray.length; ++i) {
            this.out.write(stringArray[i].getBytes());
            this.out.write("\n".getBytes());
        }
        this.logFileSizes += (long)n;
        return false;
    }

    private int determineLogSize(String ... stringArray) {
        int n = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            n += stringArray[i].length();
        }
        return ++n;
    }

    private void checkTextFileSize(int n) {
        if ((double)(this.logFileSizes + (long)n) > 1048576.0 * this.logFileSizeInMB) {
            if (this.bak.isBackup()) {
                this.doBackUp();
            } else {
                try {
                    this.createOldTextFile();
                }
                catch (Exception exception) {
                    TraceManager.createErrorFile(exception.toString());
                }
            }
        }
    }

    private void createOldTextFile() throws FileNotFoundException, IOException {
        byte[] byArray = new byte[(int)this.logFileSizes];
        new FileInputStream(this.file).read(byArray);
        new FileOutputStream(new File(this.logFileLocation + File.separator + "debuglog_old.txt")).write(byArray);
        this.logFileSizes = 0L;
    }

    protected boolean writeToConsole(String ... stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            System.out.println(stringArray[i]);
        }
        return false;
    }

    protected void backUpLog(String string) {
        try {
            int n;
            byte[] byArray = new byte[1024];
            ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(string));
            FileInputStream fileInputStream = new FileInputStream(this.filenamePath);
            zipOutputStream.putNextEntry(new ZipEntry(this.filenamePath));
            while ((n = fileInputStream.read(byArray)) > 0) {
                zipOutputStream.write(byArray, 0, n);
            }
            fileInputStream.close();
            zipOutputStream.close();
        }
        catch (Exception exception) {
            TraceManager.createErrorFile(exception.toString());
        }
    }
}

