/*
 * Decompiled with CFR 0.152.
 */
package debuglog;

import debuglog.XsAttribute;
import debuglog.XsElement;
import debuglog.XsEnum;
import debuglog.XsRestriction;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Stack;

public class XsdParser {
    private final String xselement = "xs:element";
    private final String xsattribute = "xs:attribute";
    private final String xsenumr = "xs:enumeration";
    private final String xsrest = "xs:restriction";
    private final String name_start = "name=\"";
    private final String type_start = "type=\"";
    private final String type_value = "value=\"";
    private final String type_base = "base=\"";
    private int offset = 0;
    private int startIndex = 0;
    private int endIndex;
    private Stack s = new Stack();

    public XsElement parse(String string) {
        int n = -1;
        int n2 = -1;
        try {
            RandomAccessFile randomAccessFile = this.getTheFile(string);
            this.endIndex = (int)randomAccessFile.length() - 1;
            byte[] byArray = new byte[(int)randomAccessFile.length()];
            randomAccessFile.read(byArray, 0, (int)randomAccessFile.length() - 1);
            while ((long)this.offset < randomAccessFile.length()) {
                n = this.getOffset_for__start_angularBracket(byArray);
                n2 = this.getOffset_for_end_angularBracket(byArray);
                if (n == -1 || n2 == -1) continue;
                byte[] byArray2 = this.getBytes(byArray, n, n2 + 1);
                if (new String(byArray2).contains("xs:element") && new String(byArray2).endsWith("/>")) {
                    this.pushInStack(this.createNode(false, new String(byArray2)));
                    continue;
                }
                if (new String(byArray2).contains("xs:element") && new String(byArray2).startsWith("</")) {
                    this.popFrmStack();
                    continue;
                }
                if (new String(byArray2).contains("xs:element")) {
                    this.pushInStack(this.createNode(true, new String(byArray2)));
                    continue;
                }
                if (new String(byArray2).contains("xs:attribute")) {
                    this.pushInStack(this.createNode(new String(byArray2)));
                    continue;
                }
                if (new String(byArray2).contains("xs:enumeration") && new String(byArray2).endsWith("/>")) {
                    this.pushInStack(this.createNodeEnum(new String(byArray2)));
                    continue;
                }
                if (!new String(byArray2).contains("xs:restriction")) continue;
                this.pushInStack(this.createNodeRest(new String(byArray2)));
            }
            if (this.s.size() == 1) {
                return (XsElement)this.s.pop();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return null;
    }

    private XsElement createNode(boolean bl, String string) {
        XsElement xsElement = new XsElement();
        xsElement.isChildrenAllowed(bl);
        xsElement.setName(this.findName(string));
        xsElement.setType(this.findType(string));
        return xsElement;
    }

    private XsAttribute createNode(String string) {
        XsAttribute xsAttribute = new XsAttribute();
        xsAttribute.setName(this.findName(string));
        xsAttribute.setType(this.findType(string));
        return xsAttribute;
    }

    private XsEnum createNodeEnum(String string) {
        XsEnum xsEnum = new XsEnum();
        xsEnum.setVal(this.findValue(string));
        return xsEnum;
    }

    private XsRestriction createNodeRest(String string) {
        XsRestriction xsRestriction = new XsRestriction();
        xsRestriction.setBase(this.findBase(string));
        return xsRestriction;
    }

    private String findBase(String string) {
        if (string.contains("base=\"")) {
            int n = string.indexOf("base=\"") + "base=\"".length();
            char[] cArray = string.toCharArray();
            int n2 = n;
            for (int i = n; i < cArray.length && cArray[i] != '\"'; ++i) {
                ++n2;
            }
            return string.substring(n, n2);
        }
        return null;
    }

    private String findName(String string) {
        if (string.contains("name=\"")) {
            int n = string.indexOf("name=\"") + "name=\"".length();
            char[] cArray = string.toCharArray();
            int n2 = n;
            for (int i = n; i < cArray.length && cArray[i] != '\"'; ++i) {
                ++n2;
            }
            return string.substring(n, n2);
        }
        return null;
    }

    private String findValue(String string) {
        if (string.contains("value=\"")) {
            int n = string.indexOf("value=\"") + "value=\"".length();
            char[] cArray = string.toCharArray();
            int n2 = n;
            for (int i = n; i < cArray.length && cArray[i] != '\"'; ++i) {
                ++n2;
            }
            return string.substring(n, n2);
        }
        return null;
    }

    private String findType(String string) {
        if (string.contains("type=\"")) {
            int n = string.indexOf("type=\"") + "type=\"".length();
            char[] cArray = string.toCharArray();
            int n2 = n;
            for (int i = n; i < cArray.length && cArray[i] != '\"'; ++i) {
                ++n2;
            }
            return string.substring(n, n2);
        }
        return null;
    }

    private void pushInStack(Object object) {
        this.s.push(object);
    }

    private void popFrmStack() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        ArrayList arrayList3 = new ArrayList();
        String string = null;
        while (!this.s.empty()) {
            Object object;
            Object e = this.s.pop();
            if (e instanceof XsElement) {
                object = (XsElement)e;
                if (((XsElement)object).isChildrenAllowed()) {
                    if (string != null) {
                        ((XsElement)object).setType(string);
                    }
                    ((XsElement)object).setChildren(arrayList);
                    ((XsElement)object).setAttribute(arrayList2);
                    ((XsElement)object).setEnumr(arrayList3);
                    ((XsElement)object).isChildrenAllowed(false);
                    this.pushInStack(object);
                    break;
                }
                arrayList.add(object);
                continue;
            }
            if (e instanceof XsAttribute) {
                object = (XsAttribute)e;
                if (string != null) {
                    ((XsAttribute)object).setType(string);
                }
                ((XsAttribute)object).setEnumr(arrayList3);
                arrayList2.add(object);
                continue;
            }
            if (e instanceof XsEnum) {
                arrayList3.add(e);
                continue;
            }
            if (!(e instanceof XsRestriction)) continue;
            string = ((XsRestriction)e).getBase();
        }
    }

    private RandomAccessFile getTheFile(String string) throws IOException {
        File file = null;
        file = new File(string);
        RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");
        if (file.getAbsolutePath().endsWith(".xsd")) {
            return randomAccessFile;
        }
        return null;
    }

    private int getOffset_for__start_angularBracket(byte[] byArray) throws IOException {
        while (byArray.length > this.offset) {
            char c = (char)byArray[this.offset];
            if (c == '<') {
                return this.offset;
            }
            ++this.offset;
        }
        return -1;
    }

    private int getOffset_for_end_angularBracket(byte[] byArray) throws IOException {
        while (byArray.length > this.offset) {
            char c = (char)byArray[this.offset];
            if (c == '>') {
                return this.offset;
            }
            ++this.offset;
        }
        return -1;
    }

    private byte[] getBytes(byte[] byArray, int n, int n2) throws IOException {
        byte[] byArray2 = new byte[n2 - n];
        int n3 = 0;
        for (int i = n; i < n2; ++i) {
            byArray2[n3] = byArray[i];
            ++n3;
        }
        return byArray2;
    }
}

