/*
 * Decompiled with CFR 0.152.
 */
package ExternalApp;

import Utils.ConfigRepository;

public class ConfigRepositoryMain {
    private static final String EXPORT_DEF_FILE = "ExportVivaldiConfig.xml";
    private static final int OEM_BASE = 71244;
    private static final int OEM_DELL = 2561;
    private static final int OEM_INTEL = 98761;

    public static void printHelp() {
        System.out.println("\nUsage:\n\tExternalApp.ConfigRepositoryMain [OEM_ID] [OPTIONS]\n");
        System.out.println("\nDescription:\n\tOEM_ID : LSI=71244, DELL=2561, INTEL=98761\n");
        System.out.println("\nOptions:\n\t-set [KEY] [VALUE]: Set configuration data\n\t-get [KEY] [DEFAULT_VAL]: Get configuration data, if not found DEFAULT_VAL will be returned\n\t-get [KEY]: Get configuration data for the key\n\t-exp [filename(Default=ExportVivaldiConfig.xml)]: Export existing configuration data\n\t-imp [filename]: Import configuration data from the file\n\t-clear [KEY]: Clear configuration data for the key\n\t-clear : Clear existing configuration data\n");
        System.out.println("\nExample:\n\tExternalApp.ConfigRepositoryMain 71244 -set INSTALLER_VERSION 2.00-04\n\tExternalApp.ConfigRepositoryMain 2561 -get INSTALLER_VERSION\n");
    }

    public static void main(String[] stringArray) {
        if (stringArray.length > 1) {
            switch (new Integer(stringArray[0].trim())) {
                case 2561: 
                case 71244: 
                case 98761: {
                    break;
                }
                default: {
                    System.out.println("\nInvalid OEM Id.\n");
                    return;
                }
            }
            if (stringArray[1].startsWith("-")) {
                String string = stringArray[1].toLowerCase().trim();
                if (string.equals("-set")) {
                    if (stringArray.length >= 4) {
                        ConfigRepository.set(stringArray[0].trim(), stringArray[2].toUpperCase().trim(), stringArray[3].trim());
                    } else {
                        System.out.println("\nIncomplete input data.\n");
                    }
                } else if (string.equals("-get")) {
                    if (stringArray.length >= 4) {
                        System.out.println("\n" + ConfigRepository.get(stringArray[0].trim(), stringArray[2].toUpperCase().trim(), stringArray[3].trim()));
                    } else if (stringArray.length >= 3) {
                        System.out.println("\n" + ConfigRepository.get(stringArray[0].trim(), stringArray[2].toUpperCase().trim()));
                    } else {
                        System.out.println("\nIncomplete input data.\n");
                    }
                } else if (string.equals("-exp")) {
                    if (stringArray.length > 2) {
                        ConfigRepository.exportData(stringArray[0].trim(), stringArray[2].trim());
                    } else {
                        ConfigRepository.exportData(stringArray[0].trim(), EXPORT_DEF_FILE);
                    }
                } else if (string.equals("-imp")) {
                    if (stringArray.length > 2) {
                        ConfigRepository.importData(stringArray[0].trim(), stringArray[2].trim());
                    } else {
                        System.out.println("\nPlease provide input file to be imported.\n");
                    }
                } else if (string.equals("-clear")) {
                    if (stringArray.length >= 3) {
                        ConfigRepository.clear(stringArray[0].trim(), stringArray[2].toUpperCase().trim());
                    } else {
                        ConfigRepository.clear(stringArray[0].trim());
                    }
                } else {
                    System.out.println("\nInvalid option.\n");
                }
                return;
            }
        } else {
            if (stringArray.length == 1) {
                if (stringArray[0].toLowerCase().trim().equals("-help") | stringArray[0].toLowerCase().trim().equals("/?")) {
                    ConfigRepositoryMain.printHelp();
                } else {
                    System.out.println("\nInvalid option.\n");
                }
                return;
            }
            ConfigRepositoryMain.printHelp();
            return;
        }
    }
}

