/*
 * Decompiled with CFR 0.152.
 */
package Framework.ClientManagers;

import Framework.ClientManagers.ClientInfo;
import Services.FrameworkUtilities;
import Services.NetworkPacket;
import Services.NetworkToJavaConverter;
import Services.WWNManager;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;

public class ClientManager {
    private static Hashtable clientHash = new Hashtable();
    public static ArrayList popupClientList = new ArrayList();
    public static String monitorWwn = null;
    private static int clientID = 0;

    public static void handleClientCall(NetworkPacket networkPacket) {
        switch (networkPacket.getRequestType()) {
            case 257: {
                ClientManager.handleRegisterCall(networkPacket);
                break;
            }
            case 268: {
                ClientManager.handleRemoteRegisterCall(networkPacket);
                break;
            }
            case 258: {
                ClientManager.handleUnRegisterCall(networkPacket);
            }
        }
    }

    private static void handleUnRegisterCall(NetworkPacket networkPacket) {
        System.out.println(" CM : handleUnRegisterCall() : Remove from clientHash : " + NetworkPacket.convertByteArrayToWWNString(networkPacket.getDatabuffer()));
        clientHash.remove(NetworkPacket.convertByteArrayToWWNString(networkPacket.getDatabuffer()));
    }

    private static void handleRegisterCall(NetworkPacket networkPacket) {
        ClientInfo clientInfo = new ClientInfo();
        byte[] byArray = networkPacket.getDatabuffer();
        clientInfo.setMajorNumber(NetworkToJavaConverter.byteArrayToInt(byArray));
        clientInfo.setMinorNumber(NetworkToJavaConverter.byteArrayToInt(byArray, 4));
        clientInfo.setListenPort(NetworkToJavaConverter.byteArrayToInt(byArray, 40));
        clientInfo.setDescription(byArray, 44, 256);
        clientInfo.setVersion(byArray, 8, 32);
        String string = WWNManager.createWWNForClient("127.0.0.1", clientInfo.getListenPort(), clientID++);
        clientInfo.setWWN(string);
        ClientManager.unRegisterStaleClient(FrameworkUtilities.getLocalHostAddress(), clientInfo.getListenPort());
        System.out.println(" CM : handleRegisterCall() : Add to clientHash : " + string);
        clientHash.put(string, clientInfo);
        System.out.println(" CM : handleRegisterCall() : clientHash Size : " + clientHash.size());
        networkPacket.setDatabuffer(NetworkPacket.convertWWNStringToByteArray(string));
        if (clientInfo.getMajorNumber() == 0 && clientInfo.getMinorNumber() == 10) {
            popupClientList.add(string);
        }
        if (clientInfo.getMajorNumber() == 0 && clientInfo.getMinorNumber() == 9) {
            monitorWwn = string;
        }
    }

    private static void handleRemoteRegisterCall(NetworkPacket networkPacket) {
        ClientInfo clientInfo = new ClientInfo();
        byte[] byArray = networkPacket.getDatabuffer();
        clientInfo.setMajorNumber(NetworkToJavaConverter.byteArrayToInt(byArray));
        clientInfo.setMinorNumber(NetworkToJavaConverter.byteArrayToInt(byArray, 4));
        clientInfo.setListenPort(NetworkToJavaConverter.byteArrayToInt(byArray, 40));
        clientInfo.setDescription(byArray, 44, 256);
        clientInfo.setVersion(byArray, 8, 32);
        String string = networkPacket.getSenderIPAsString();
        int n = clientInfo.getListenPort();
        String string2 = WWNManager.createWWNForClient(string, clientInfo.getListenPort(), clientID++);
        clientInfo.setWWN(string2);
        ClientManager.unRegisterStaleClient(string, n);
        System.out.println(" CM : handleRemoteRegisterCall() : Add to clientHash : " + string2);
        clientHash.put(string2, clientInfo);
        networkPacket.setDatabuffer(NetworkPacket.convertWWNStringToByteArray(string2));
        System.out.println(" CM : handleRemoteRegisterCall() : clientHash Size : " + clientHash.size());
        if (clientInfo.getMajorNumber() == 0 && clientInfo.getMinorNumber() == 10) {
            popupClientList.add(string2);
        }
        if (clientInfo.getMajorNumber() == 0 && clientInfo.getMinorNumber() == 9) {
            monitorWwn = string2;
        }
    }

    private static void unRegisterStaleClient(String string, int n) {
        Object object;
        if (string == null || clientHash == null) {
            return;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        Enumeration enumeration = clientHash.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = enumeration.nextElement().toString();
            object = (ClientInfo)clientHash.get(string2);
            int n2 = ((ClientInfo)object).getListenPort();
            String string3 = ((ClientInfo)object).getWWN();
            String string4 = "";
            if (string3.indexOf(":") >= 0) {
                string4 = string3.substring(0, string3.indexOf(":"));
            }
            if (!string.equalsIgnoreCase(string4) || n != n2) continue;
            arrayList.add(string3);
            popupClientList.remove(string3);
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            object = (String)arrayList.get(i);
            System.out.println(" CM : unRegisterStaleClient() : Remove from clientHash : " + (String)object);
            clientHash.remove(object);
        }
        arrayList.clear();
        arrayList = null;
    }

    public static Object[] getClientList() {
        return clientHash.values().toArray();
    }

    public static void handleUnRegisterClient(String string) {
        if (string != null && clientHash != null) {
            string = string.trim();
            System.out.println(" CM : handleUnRegisterClient() : Remove from clientHash : " + string);
            clientHash.remove(string);
        }
    }

    public static boolean isStaleClient(String string) {
        boolean bl = true;
        if (string != null && clientHash != null && clientHash.get(string = string.trim()) != null) {
            bl = false;
        }
        return bl;
    }
}

