/*
 * Decompiled with CFR 0.152.
 */
package Framework.Configurator;

import Framework.Configurator.ComponentDescriptor;
import Framework.Configurator.ConfiguratorManager;
import Framework.Network.VivaldiFrameworkProtocolErrorException;
import KernelExceptions.VKInvalidOperationException;
import SASKernel.ClientInfo;
import SASKernel.PluginInfo;
import Services.NetworkDataPacket;
import java.io.IOException;

public class ComponentAccessHelper {
    private Object componentInfo;
    private ComponentDescriptor compDescriptor;

    public ComponentAccessHelper(Object object, ComponentDescriptor componentDescriptor) {
        this.componentInfo = object;
        this.compDescriptor = componentDescriptor;
    }

    public Object getComponentInfo() {
        return this.componentInfo;
    }

    public ComponentDescriptor getComponentDescriptor() {
        return this.compDescriptor;
    }

    public int processCommand(NetworkDataPacket networkDataPacket) throws IOException, VivaldiFrameworkProtocolErrorException, VKInvalidOperationException {
        int n = 0;
        try {
            n = ConfiguratorManager.getInstance().processCommand(this.getComponentWWN(), networkDataPacket);
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (VivaldiFrameworkProtocolErrorException vivaldiFrameworkProtocolErrorException) {
            throw vivaldiFrameworkProtocolErrorException;
        }
        catch (VKInvalidOperationException vKInvalidOperationException) {
            throw vKInvalidOperationException;
        }
        catch (Exception exception) {
            throw new IOException(exception.getMessage());
        }
        return n;
    }

    private String getComponentWWN() {
        switch (this.compDescriptor.getComponentType()) {
            case 1: {
                return ((PluginInfo)this.componentInfo).getWWN();
            }
            case 2: {
                return ((ClientInfo)this.componentInfo).getWWN();
            }
        }
        return "";
    }
}

