/*
 * Decompiled with CFR 0.152.
 */
package Framework.Configurator;

import Framework.Configurator.ComponentAccessHelper;
import Framework.Configurator.ComponentDescriptor;
import Framework.Configurator.ConfiguratorInfo;
import Framework.Configurator.ConfiguratorInterface;
import Framework.Configurator.ConfiguratorNameFilter;
import Framework.Configurator.LoggedInServerInfo;
import Framework.Network.VivaldiFrameworkProtocolErrorException;
import KernelExceptions.VKInvalidOperationException;
import KernelExceptions.VKNotRespondingException;
import KernelExceptions.VKObjectNotPresentException;
import KernelExceptions.VKOperationFailedException;
import SASKernel.ClientInfo;
import SASKernel.PluginInfo;
import SASKernel.SASKernel;
import SASKernel.SASServer;
import Services.NetworkDataPacket;
import Services.WWNExtractor;
import java.awt.Container;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;

public class ConfiguratorManager {
    public static final String CONFIGURATOR_PACKAGE = "configurators.";
    private int configuratorCount = 0;
    private ConfiguratorInfo[] listOfConfigurators = null;
    private Hashtable configInterfaceHash = new Hashtable();
    private Hashtable configComponentsHash = new Hashtable();
    private SASServer server = null;
    private Container mainFrame = null;
    private LoggedInServerInfo serverInfo = null;
    private static ConfiguratorManager configManager = null;

    private ConfiguratorManager(Container container) {
        this.mainFrame = container;
        try {
            this.server = SASKernel.getInstance().getLoggedinServer();
        }
        catch (IOException iOException) {
        }
        catch (VKOperationFailedException vKOperationFailedException) {
        }
        catch (VivaldiFrameworkProtocolErrorException vivaldiFrameworkProtocolErrorException) {
            // empty catch block
        }
        if (this.server != null) {
            this.serverInfo = new LoggedInServerInfo(this.server.getInformation(), this.server.getAccMode());
        }
    }

    public static ConfiguratorManager getInstance(Container container) {
        if (configManager == null) {
            configManager = new ConfiguratorManager(container);
        }
        return configManager;
    }

    public static ConfiguratorManager getInstance() {
        return configManager;
    }

    public static void initilaize() {
        if (configManager != null) {
            configManager = null;
        }
    }

    public void discoverConfigurators() {
        int n;
        File file = new File(System.getProperty("user.dir") + File.separator + "configurators");
        String[] stringArray = file.list(new ConfiguratorNameFilter());
        ArrayList<ConfiguratorInfo> arrayList = new ArrayList<ConfiguratorInfo>();
        for (n = 0; stringArray != null && n < stringArray.length; ++n) {
            String string = stringArray[n].substring(0, stringArray[n].indexOf(ConfiguratorNameFilter.getJavaClassExn()));
            try {
                ConfiguratorInterface configuratorInterface = (ConfiguratorInterface)Class.forName(CONFIGURATOR_PACKAGE + string).newInstance();
                ++this.configuratorCount;
                ComponentDescriptor[] componentDescriptorArray = configuratorInterface.getComponentList();
                if (componentDescriptorArray == null) continue;
                ConfiguratorInfo configuratorInfo = configuratorInterface.getConfiguratorInfo();
                arrayList.add(configuratorInfo);
                this.configInterfaceHash.put(configuratorInfo.getName(), configuratorInterface);
                this.configComponentsHash.put(configuratorInfo.getName(), componentDescriptorArray);
                System.out.println("Loaded Configurator:: " + configuratorInfo.getName());
                continue;
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (arrayList.size() != 0) {
            this.listOfConfigurators = new ConfiguratorInfo[arrayList.size()];
            for (n = 0; n < arrayList.size(); ++n) {
                this.listOfConfigurators[n] = (ConfiguratorInfo)arrayList.get(n);
            }
        }
    }

    public boolean isCIMOMMonitor(ConfiguratorInfo configuratorInfo) {
        String string = configuratorInfo.getName();
        ComponentDescriptor[] componentDescriptorArray = this.getComponentList(string);
        for (int i = 0; i < componentDescriptorArray.length; ++i) {
            ComponentDescriptor componentDescriptor = componentDescriptorArray[i];
            if (componentDescriptor.getComponentType() != 1 || componentDescriptor.getMajorGroup() != 0 || componentDescriptor.getMinorGroup() != 11) continue;
            PluginInfo[] pluginInfoArray = null;
            pluginInfoArray = this.server.getPluginList();
            if (pluginInfoArray == null) {
                return false;
            }
            for (int j = 0; j < pluginInfoArray.length; ++j) {
                if (pluginInfoArray[j].getMajorGroup() != 0 || pluginInfoArray[j].getMinorGroup() != 11) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isMonitorPlugin(ConfiguratorInfo configuratorInfo) {
        String string = configuratorInfo.getName();
        ComponentDescriptor[] componentDescriptorArray = this.getComponentList(string);
        for (int i = 0; i < componentDescriptorArray.length; ++i) {
            ComponentDescriptor componentDescriptor = componentDescriptorArray[i];
            if (componentDescriptor.getComponentType() != 1 || componentDescriptor.getMajorGroup() != 0 || componentDescriptor.getMinorGroup() != 8) continue;
            PluginInfo[] pluginInfoArray = null;
            pluginInfoArray = this.server.getPluginList();
            if (pluginInfoArray == null) {
                return false;
            }
            for (int j = 0; j < pluginInfoArray.length; ++j) {
                if (pluginInfoArray[j].getMajorGroup() != 0 || pluginInfoArray[j].getMinorGroup() != 8) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isMRMonitor(ConfiguratorInfo configuratorInfo) {
        String string = configuratorInfo.getName();
        ComponentDescriptor[] componentDescriptorArray = this.getComponentList(string);
        for (int i = 0; i < componentDescriptorArray.length; ++i) {
            ComponentDescriptor componentDescriptor = componentDescriptorArray[i];
            if (componentDescriptor.getComponentType() != 2 || componentDescriptor.getMajorGroup() != 0 || componentDescriptor.getMinorGroup() != 9) continue;
            ClientInfo[] clientInfoArray = null;
            clientInfoArray = this.server.getClientList();
            if (clientInfoArray == null) {
                return false;
            }
            for (int j = 0; j < clientInfoArray.length; ++j) {
                if (clientInfoArray[j].getMajorNumber() != 0 || clientInfoArray[j].getMinorNumber() != 9) continue;
                PluginInfo[] pluginInfoArray = null;
                pluginInfoArray = this.server.getPluginList();
                if (pluginInfoArray == null) {
                    return true;
                }
                for (int k = 0; k < pluginInfoArray.length; ++k) {
                    if (pluginInfoArray[k].getMajorGroup() != 0 || pluginInfoArray[k].getMinorGroup() != 8) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public ConfiguratorInfo[] getConfiguratorList() {
        return this.listOfConfigurators;
    }

    public int getConfiguratorCount() {
        return this.listOfConfigurators == null ? 0 : this.listOfConfigurators.length;
    }

    public ComponentDescriptor[] getComponentList(String string) {
        return (ComponentDescriptor[])this.configComponentsHash.get(string);
    }

    public int invokeConfigurator(String string) throws VKObjectNotPresentException, VKNotRespondingException, VKInvalidOperationException, VKOperationFailedException, Exception {
        try {
            ComponentAccessHelper[] componentAccessHelperArray = this.makeAccessHelpers(string);
            ConfiguratorInterface configuratorInterface = (ConfiguratorInterface)this.configInterfaceHash.get(string);
            if (this.serverInfo != null && componentAccessHelperArray != null) {
                configuratorInterface.invoke(this.serverInfo, componentAccessHelperArray, this.mainFrame);
            }
        }
        catch (VKObjectNotPresentException vKObjectNotPresentException) {
            throw vKObjectNotPresentException;
        }
        catch (VKNotRespondingException vKNotRespondingException) {
            throw vKNotRespondingException;
        }
        catch (VKInvalidOperationException vKInvalidOperationException) {
            throw vKInvalidOperationException;
        }
        catch (VKOperationFailedException vKOperationFailedException) {
            throw vKOperationFailedException;
        }
        catch (Exception exception) {
            throw exception;
        }
        return 1;
    }

    private ComponentAccessHelper[] makeAccessHelpers(String string) throws VKObjectNotPresentException {
        ComponentDescriptor[] componentDescriptorArray = this.getComponentList(string);
        ClientInfo[] clientInfoArray = null;
        PluginInfo[] pluginInfoArray = null;
        ComponentAccessHelper[] componentAccessHelperArray = new ComponentAccessHelper[componentDescriptorArray.length];
        int n = 0;
        block6: for (int i = 0; i < componentDescriptorArray.length; ++i) {
            ComponentDescriptor componentDescriptor = componentDescriptorArray[i];
            switch (componentDescriptor.getComponentType()) {
                case 2: {
                    int n2;
                    if (clientInfoArray == null) {
                        clientInfoArray = this.server.getClientList();
                    }
                    if (clientInfoArray == null) continue block6;
                    for (n2 = 0; n2 < clientInfoArray.length; ++n2) {
                        if (clientInfoArray[n2].getMajorNumber() != componentDescriptor.getMajorGroup() || clientInfoArray[n2].getMinorNumber() != componentDescriptor.getMinorGroup()) continue;
                        try {
                            System.out.println("Retrieved Monitor wwn:" + clientInfoArray[n2].getWWN());
                            String string2 = clientInfoArray[n2].getWWN();
                            String string3 = this.serverInfo.getFrameworkInfo().getIP();
                            WWNExtractor wWNExtractor = new WWNExtractor(string2);
                            String string4 = string3 + ":" + wWNExtractor.getPort() + ":" + wWNExtractor.getID();
                            clientInfoArray[n2].setWWN(string4);
                            System.out.println("Changed Monitor wwn:" + clientInfoArray[n2].getWWN());
                            componentAccessHelperArray[n++] = new ComponentAccessHelper(clientInfoArray[n2], componentDescriptor);
                            continue;
                        }
                        catch (Exception exception) {
                            System.out.println("Component access helper could not be created, continue with next helper " + exception);
                        }
                    }
                    continue block6;
                }
                case 1: {
                    int n2;
                    if (pluginInfoArray == null) {
                        pluginInfoArray = this.server.getPluginList();
                    }
                    if (pluginInfoArray == null) continue block6;
                    for (n2 = 0; n2 < pluginInfoArray.length; ++n2) {
                        if (pluginInfoArray[n2].getMajorGroup() != componentDescriptor.getMajorGroup() || pluginInfoArray[n2].getMinorGroup() != componentDescriptor.getMinorGroup()) continue;
                        componentAccessHelperArray[n++] = new ComponentAccessHelper(pluginInfoArray[n2], componentDescriptor);
                    }
                    continue block6;
                }
            }
        }
        if (n < componentDescriptorArray.length) {
            throw new VKObjectNotPresentException(7);
        }
        return componentAccessHelperArray;
    }

    public int processCommand(String string, NetworkDataPacket networkDataPacket) throws IOException, VivaldiFrameworkProtocolErrorException, VKInvalidOperationException {
        int n = 0;
        try {
            n = this.server.processCommand(string, networkDataPacket, 2);
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (VivaldiFrameworkProtocolErrorException vivaldiFrameworkProtocolErrorException) {
            throw vivaldiFrameworkProtocolErrorException;
        }
        catch (VKInvalidOperationException vKInvalidOperationException) {
            throw vKInvalidOperationException;
        }
        catch (Exception exception) {
            throw new IOException(exception.getMessage());
        }
        return n;
    }
}

