/*
 * Decompiled with CFR 0.152.
 */
package Framework;

import Framework.AccessControllers.AccessControlManager;
import Framework.ClientManagers.ClientInfo;
import Framework.ClientManagers.ClientManager;
import Framework.FrameworkInfo;
import Framework.FrameworkInterface;
import Framework.Network.NetworkManager;
import Framework.Network.VivaldiFrameworkProtocolErrorException;
import Framework.PluginManagers.PluginDataInfo;
import Framework.PluginManagers.PluginInfo;
import Framework.PluginManagers.PluginInterface;
import Framework.PluginManagers.PluginManager;
import Services.CommonConstants;
import Services.FrameworkUtilities;
import Services.NetworkPacket;
import Services.NetworkToJavaConverter;
import Services.RoutingManager;
import java.io.File;
import java.io.FileInputStream;
import java.util.Properties;

public class FrameworkManager
implements FrameworkInterface,
CommonConstants {
    private static FrameworkManager frameworkManager1 = null;

    private FrameworkManager() {
    }

    public static final FrameworkManager getFrameworkManager() {
        return frameworkManager1;
    }

    public static void main(String[] stringArray) {
        System.setProperty("javax.net.ssl.keyStore", System.getProperty("user.dir") + File.separator + "vivaldikeys");
        System.setProperty("javax.net.ssl.keyStorePassword", "knqwhner");
        System.setProperty("javax.net.ssl.trustStore", System.getProperty("user.dir") + File.separator + "vivaldikeys");
        System.setProperty("java.net.preferIPv4Stack", "true");
        System.out.println("MSM Framework version 3.1");
        frameworkManager1 = new FrameworkManager();
        System.out.println("frameworkManager1 :" + frameworkManager1);
        PluginManager.discoverPlugins();
        System.out.println("doStartupOperations");
        PluginManager.doStartupOperations();
        int n = FrameworkManager.getInstallationMode();
        if (n != 1) {
            System.out.println("in full instalaltion mode");
            new NetworkManager().startListen();
        } else {
            System.out.println("in standalone mode");
            new NetworkManager(true).startListen();
        }
    }

    @Override
    public FrameworkInfo getFrameworkInfo() {
        return FrameworkInfo.getInstance();
    }

    @Override
    public byte[] getPlugIns() {
        PluginInfo[] pluginInfoArray = PluginManager.getPlugInList();
        if (pluginInfoArray == null) {
            byte[] byArray = new byte[4];
            NetworkToJavaConverter.intToByteArray(0, byArray);
            return byArray;
        }
        byte[] byArray = pluginInfoArray[0].converToBytetArray();
        int n = byArray.length;
        byte[] byArray2 = new byte[pluginInfoArray.length * n + 4];
        int n2 = 0;
        NetworkToJavaConverter.intToByteArray(pluginInfoArray.length, byArray2);
        System.arraycopy(byArray, 0, byArray2, n2 += 4, n);
        n2 += n;
        for (int i = 1; i < pluginInfoArray.length; ++i) {
            System.arraycopy(pluginInfoArray[i].converToBytetArray(), 0, byArray2, n2, n);
            n2 += n;
        }
        return byArray2;
    }

    private PluginInfo[] updatePlugins(String string, PluginInfo[] pluginInfoArray) {
        if (pluginInfoArray != null) {
            for (int i = 0; i < pluginInfoArray.length; ++i) {
                PluginInfo pluginInfo = pluginInfoArray[i];
                if (this.getIP(pluginInfo.getWWN()).equals(string)) continue;
                pluginInfo.setWWN(this.updateWWN(pluginInfo.getWWN(), string));
            }
        }
        return pluginInfoArray;
    }

    public byte[] getPlugIns(String string) {
        PluginInfo[] pluginInfoArray = PluginManager.getPlugInList();
        PluginInfo[] pluginInfoArray2 = null;
        try {
            pluginInfoArray2 = (PluginInfo[])FrameworkUtilities.deepCopy(pluginInfoArray);
            pluginInfoArray2 = this.updatePlugins(string, pluginInfoArray2);
        }
        catch (Exception exception) {
            System.out.println("got exception in cloning");
            exception.printStackTrace();
        }
        if (pluginInfoArray2 == null) {
            System.out.println("got exception in cloning null");
            pluginInfoArray2 = pluginInfoArray;
        }
        pluginInfoArray = PluginManager.getPlugInList();
        if (pluginInfoArray2 == null) {
            byte[] byArray = new byte[4];
            NetworkToJavaConverter.intToByteArray(0, byArray);
            return byArray;
        }
        byte[] byArray = pluginInfoArray2[0].converToBytetArray();
        int n = byArray.length;
        byte[] byArray2 = new byte[pluginInfoArray2.length * n + 4];
        int n2 = 0;
        NetworkToJavaConverter.intToByteArray(pluginInfoArray2.length, byArray2);
        System.arraycopy(byArray, 0, byArray2, n2 += 4, n);
        n2 += n;
        for (int i = 1; i < pluginInfoArray2.length; ++i) {
            System.arraycopy(pluginInfoArray2[i].converToBytetArray(), 0, byArray2, n2, n);
            n2 += n;
        }
        return byArray2;
    }

    @Override
    public byte[] getClientList() {
        int n;
        Object[] objectArray = ClientManager.getClientList();
        byte[] byArray = null;
        if (objectArray.length != 0) {
            byArray = ((ClientInfo)objectArray[0]).getBytes();
            n = byArray.length;
        } else {
            n = 0;
        }
        byte[] byArray2 = new byte[objectArray.length * n + 4];
        int n2 = 0;
        NetworkToJavaConverter.intToByteArray(objectArray.length, byArray2);
        if (objectArray.length == 0) {
            return byArray2;
        }
        System.arraycopy(byArray, 0, byArray2, n2 += 4, n);
        n2 += n;
        for (int i = 1; i < objectArray.length; ++i) {
            System.arraycopy(((ClientInfo)objectArray[i]).getBytes(), 0, byArray2, n2, n);
            n2 += n;
        }
        return byArray2;
    }

    private void GetSpecifiedPlugin(NetworkPacket networkPacket) {
        int n;
        byte[] byArray = networkPacket.getDatabuffer();
        int n2 = NetworkToJavaConverter.byteArrayToInt(byArray);
        PluginInfo pluginInfo = PluginManager.getPluginInfo(n2, n = NetworkToJavaConverter.byteArrayToInt(byArray, 4));
        if (pluginInfo == null) {
            byte[] byArray2 = new byte[4];
            NetworkToJavaConverter.intToByteArray(1, byArray2);
            networkPacket.setDatabuffer(byArray2);
            return;
        }
        byte[] byArray3 = pluginInfo.converToBytetArray();
        byte[] byArray4 = new byte[byArray3.length + 4];
        NetworkToJavaConverter.intToByteArray(0, byArray4);
        System.arraycopy(byArray3, 0, byArray4, 4, byArray3.length);
        networkPacket.setDatabuffer(byArray4);
    }

    public void DiscoverRemoteFrameworks(NetworkPacket networkPacket) {
        PluginInterface pluginInterface = PluginManager.getPluginInterface(0, 2);
        if (pluginInterface == null) {
            byte[] byArray = new byte[4];
            NetworkToJavaConverter.intToByteArray(0, byArray);
            networkPacket.setDatabuffer(byArray);
            return;
        }
        byte[] byArray = new byte[4];
        NetworkToJavaConverter.intToByteArray(262, byArray);
        networkPacket.setDatabuffer(byArray);
        PluginDataInfo pluginDataInfo = new PluginDataInfo(networkPacket);
        if (pluginInterface.processCommand(pluginDataInfo)) {
            networkPacket.setDatabuffer(pluginDataInfo.getBuffer());
        } else {
            networkPacket.setDatabuffer(null);
        }
    }

    private boolean stopDiscoveryOperation(boolean bl) {
        return PluginManager.stopNwPlugin(bl);
    }

    @Override
    public boolean ProcessCommand(int n, PluginDataInfo pluginDataInfo) {
        NetworkPacket networkPacket = new NetworkPacket(n, pluginDataInfo);
        try {
            RoutingManager.routeCall(networkPacket);
            if (n == 271 || n == 257) {
                pluginDataInfo.setBuffer(networkPacket.getDatabuffer());
            }
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public void handleFrameworkCalls(NetworkPacket networkPacket) throws VivaldiFrameworkProtocolErrorException {
        switch (networkPacket.getRequestType()) {
            case 257: 
            case 258: 
            case 268: {
                ClientManager.handleClientCall(networkPacket);
                break;
            }
            case 259: {
                networkPacket.setDatabuffer(this.getPlugIns(this.getIP(networkPacket.getReceiverWWN())));
                break;
            }
            case 260: {
                networkPacket.setDatabuffer(this.getClientList());
                break;
            }
            case 263: {
                this.GetSpecifiedPlugin(networkPacket);
                break;
            }
            case 261: 
            case 266: 
            case 267: {
                AccessControlManager.handleClientCall(networkPacket);
                break;
            }
            case 262: {
                this.DiscoverRemoteFrameworks(networkPacket);
                break;
            }
            case 265: {
                byte[] byArray = new byte[32];
                byte[] byArray2 = "3.1".getBytes();
                System.arraycopy(byArray2, 0, byArray, 0, byArray2.length <= byArray.length ? byArray2.length : byArray.length);
                networkPacket.setDatabuffer(byArray);
                break;
            }
            case 264: {
                byte[] byArray = new byte[4];
                NetworkToJavaConverter.intToByteArray(NetworkManager.getAFreePort(), byArray);
                networkPacket.setDatabuffer(byArray);
                break;
            }
            case 269: 
            case 270: 
            case 271: 
            case 272: {
                Object object;
                PluginInterface pluginInterface = PluginManager.getPluginInterface(1, 6);
                if (pluginInterface == null) {
                    object = new byte[4];
                    NetworkToJavaConverter.intToByteArray(0, (byte[])object);
                    networkPacket.setDatabuffer((byte[])object);
                }
                if (pluginInterface.processCommand((PluginDataInfo)(object = (Object)new PluginDataInfo(networkPacket)))) {
                    networkPacket.setDatabuffer(((PluginDataInfo)object).getBuffer());
                    break;
                }
                networkPacket.setDatabuffer(null);
                break;
            }
            case 278: {
                boolean bl = this.notifytoMonitors(networkPacket);
                if (!bl) {
                    System.out.println("FrameworkManager.handleFrameworkCalls() not notified to Plugins regarding popup registration");
                }
                byte[] byArray = new byte[4];
                NetworkToJavaConverter.intToByteArray(0, byArray);
                networkPacket.setDatabuffer(byArray);
                break;
            }
            case 276: {
                Object object;
                PluginInterface pluginInterface = PluginManager.getPluginInterface(0, 11);
                if (pluginInterface == null) {
                    object = new byte[4];
                    NetworkToJavaConverter.intToByteArray(0, (byte[])object);
                    networkPacket.setDatabuffer((byte[])object);
                }
                if (pluginInterface.processCommand((PluginDataInfo)(object = (Object)new PluginDataInfo(networkPacket)))) {
                    networkPacket.setDatabuffer(((PluginDataInfo)object).getBuffer());
                    break;
                }
                networkPacket.setDatabuffer(null);
                break;
            }
            case 277: {
                Object object;
                PluginInterface pluginInterface = PluginManager.getPluginInterface(0, 11);
                if (pluginInterface == null) {
                    object = new byte[4];
                    NetworkToJavaConverter.intToByteArray(0, (byte[])object);
                    networkPacket.setDatabuffer((byte[])object);
                }
                if (pluginInterface.processCommand((PluginDataInfo)(object = (Object)new PluginDataInfo(networkPacket)))) {
                    networkPacket.setDatabuffer(((PluginDataInfo)object).getBuffer());
                    break;
                }
                networkPacket.setDatabuffer(null);
                break;
            }
            case 279: {
                Object object;
                PluginInterface pluginInterface = PluginManager.getPluginInterface(0, 11);
                if (pluginInterface == null) {
                    object = new byte[4];
                    NetworkToJavaConverter.intToByteArray(0, (byte[])object);
                    networkPacket.setDatabuffer((byte[])object);
                }
                if (pluginInterface.processCommand((PluginDataInfo)(object = (Object)new PluginDataInfo(networkPacket)))) {
                    networkPacket.setDatabuffer(((PluginDataInfo)object).getBuffer());
                    break;
                }
                networkPacket.setDatabuffer(null);
                break;
            }
            case 280: {
                Object object;
                PluginInterface pluginInterface = PluginManager.getPluginInterface(0, 11);
                if (pluginInterface == null) {
                    object = new byte[4];
                    NetworkToJavaConverter.intToByteArray(0, object);
                    networkPacket.setDatabuffer((byte[])object);
                }
                if (pluginInterface.processCommand((PluginDataInfo)(object = (Object)new PluginDataInfo(networkPacket)))) {
                    byte[] byArray = new byte[4];
                    NetworkToJavaConverter.intToByteArray(0, byArray);
                    networkPacket.setDatabuffer(byArray);
                    break;
                }
                networkPacket.setDatabuffer(null);
                break;
            }
            case 273: {
                System.out.println("inside handleFrameworkCalls NW_SHUTDOWN");
                if (this.stopDiscoveryOperation(true)) break;
                throw new VivaldiFrameworkProtocolErrorException();
            }
            case 274: {
                System.out.println("inside handleFrameworkCalls NW_START");
                if (this.stopDiscoveryOperation(false)) break;
                throw new VivaldiFrameworkProtocolErrorException();
            }
            case 275: {
                boolean bl = PluginManager.NCPStatus();
                String string = bl ? "1" : "0";
                byte[] byArray = string.getBytes();
                byte[] byArray3 = new byte[32];
                System.arraycopy(byArray, 0, byArray3, 0, byArray.length <= byArray3.length ? byArray.length : byArray3.length);
                networkPacket.setDatabuffer(byArray3);
                break;
            }
            default: {
                throw new VivaldiFrameworkProtocolErrorException();
            }
        }
    }

    public static String getFrameworkWWN() {
        return FrameworkUtilities.getLocalHostAddress() + ":" + NetworkManager.getPort() + ":" + "0";
    }

    private String getIP(String string) {
        if (string == null || string.trim().length() == 0) {
            return "";
        }
        return string.split(":")[0];
    }

    private String updateWWN(String string, String string2) {
        if (string == null || string.trim().length() == 0) {
            return "";
        }
        String[] stringArray = string.split(":");
        string = string2;
        for (int i = 1; i < stringArray.length; ++i) {
            string = string + ":" + stringArray[i];
        }
        return string;
    }

    public static int getInstallationMode() {
        int n = 0;
        String string = null;
        Properties properties = new Properties();
        FileInputStream fileInputStream = null;
        try {
            String string2 = System.getProperty("user.dir");
            fileInputStream = new FileInputStream(".." + File.separator + "installationmode.properties");
            properties.load(fileInputStream);
            string = properties.getProperty("INSTALLATION_MODE");
            if (string != null) {
                n = Integer.parseInt(string);
            }
            fileInputStream.close();
        }
        catch (Exception exception) {
            try {
                fileInputStream = new FileInputStream("installationmode.properties");
                properties.load(fileInputStream);
                string = properties.getProperty("INSTALLATION_MODE");
                if (string != null) {
                    n = Integer.parseInt(string);
                }
                fileInputStream.close();
            }
            catch (Exception exception2) {
                n = 0;
            }
        }
        return n;
    }

    private boolean notifytoMonitors(NetworkPacket networkPacket) {
        boolean bl = false;
        byte[] byArray = networkPacket.getDatabuffer();
        int n = NetworkToJavaConverter.byteArrayToInt(byArray);
        int n2 = NetworkToJavaConverter.byteArrayToInt(byArray, 4);
        System.out.println("FrameworkManager.notifytoMonitors()= " + NetworkToJavaConverter.byteArrayToInt(byArray, 0));
        System.out.println("FrameworkManager.notifytoMonitors()== " + NetworkToJavaConverter.byteArrayToInt(byArray, 4));
        System.out.println("FrameworkManager.notifytoMonitors()=== " + NetworkToJavaConverter.byteArrayToInt(byArray, 8));
        PluginInterface pluginInterface = null;
        if (n2 == 11) {
            pluginInterface = PluginManager.getPluginInterface(0, 11);
        } else if (n2 == 8) {
            pluginInterface = PluginManager.getPluginInterface(0, 8);
        }
        System.out.println("FrameworkManager.notifytoMonitors() 2");
        if (pluginInterface == null) {
            return false;
        }
        System.out.println("FrameworkManager.notifytoMonitors() plugin interface not null");
        System.out.println("FrameworkManager.notifytoMonitors() npacket.getDatabuffer().length " + networkPacket.getDatabuffer().length);
        PluginDataInfo pluginDataInfo = new PluginDataInfo(networkPacket);
        System.out.println("FrameworkManager.notifytoMonitors() pluginDataInfo.getBuffer().length " + pluginDataInfo.getBuffer().length);
        bl = pluginInterface.processCommand(pluginDataInfo);
        return bl;
    }
}

