/*
 * Decompiled with CFR 0.152.
 */
package Framework.Network;

import Framework.Network.NetworkManager;
import Framework.Network.VivaldiFrameworkProtocolErrorException;
import KernelExceptions.VKOperationFailedException;
import KernelServices.NotifyObject;
import SASKernel.SASKernel;
import SASKernel.SASServer;
import Services.LogCallBackPacket;
import Services.NetworkPacket;
import Services.NetworkToJavaConverter;
import Services.WWNExtractor;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;

public class Worker
implements Runnable {
    private volatile Socket s;
    private SASKernel sasKernel;
    private volatile BufferedOutputStream os = null;
    private volatile DataInputStream is = null;

    public Worker(SASKernel sASKernel) {
        this.sasKernel = sASKernel;
    }

    synchronized void setSocket(Socket socket) {
        this.s = socket;
        this.notify();
    }

    protected void closeSocket() {
        try {
            this.s.close();
            this.is.close();
            this.os.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void run() {
        while (true) {
            ArrayList arrayList;
            if (this.s == null) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
            }
            if (!NetworkManager.continueListen) {
                return;
            }
            try {
                this.handleClient();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            if (!NetworkManager.continueListen) {
                return;
            }
            this.s = null;
            ArrayList arrayList2 = arrayList = NetworkManager.reservedWorkers;
            synchronized (arrayList2) {
                if (arrayList.size() >= 10) {
                    return;
                }
                NetworkManager.activeWorkers.remove(this);
                arrayList.add(this);
            }
        }
    }

    protected synchronized void stopRun() {
        NetworkManager.continueListen = false;
        this.notify();
    }

    private void handleClient() {
        try {
            while (true) {
                Object object;
                if (this.is == null) {
                    this.is = new DataInputStream(this.s.getInputStream());
                }
                NetworkPacket networkPacket = NetworkManager.readNetworkPacketFromInputStream(this.is);
                switch (networkPacket.getRequestType()) {
                    case 4098: {
                        this.routeStoreLibCall(networkPacket);
                        networkPacket.setFrameworkError(0);
                        break;
                    }
                    case 2: {
                        object = null;
                        try {
                            Worker worker = this;
                            object = worker.sasKernel.getInstance();
                        }
                        catch (VKOperationFailedException vKOperationFailedException) {
                            vKOperationFailedException.printStackTrace();
                        }
                        catch (VivaldiFrameworkProtocolErrorException vivaldiFrameworkProtocolErrorException) {
                            vivaldiFrameworkProtocolErrorException.printStackTrace();
                        }
                        if (null == object) break;
                        ((SASKernel)object).notifyPopup(networkPacket);
                        break;
                    }
                    case 4097: {
                        Object[] objectArray;
                        networkPacket.setFrameworkError(0);
                        byte[] byArray = new byte[4];
                        int n = 0;
                        SASServer sASServer = this.sasKernel.getLoggedinServer();
                        if (null != sASServer) {
                            objectArray = new WWNExtractor(sASServer.getSvrWWN()).getIP();
                            if (Arrays.equals(networkPacket.getSenderIP(), (int[])objectArray)) {
                                n = 1;
                            }
                            if (this.checkIfIPAddrIsLocal((int[])objectArray) && this.checkIfIPAddrIsLocal(networkPacket.getSenderIP())) {
                                n = 1;
                            }
                        }
                        NetworkToJavaConverter.intToByteArray(n, byArray);
                        networkPacket.setDatabuffer(byArray);
                        break;
                    }
                    case 4099: {
                        Object[] objectArray = networkPacket.getDatabuffer();
                        byte[] byArray = new byte[NetworkToJavaConverter.byteArrayToInt(objectArray, 4)];
                        System.arraycopy(objectArray, 8, byArray, 0, byArray.length);
                        networkPacket.setFrameworkError(0);
                        SASServer sASServer = this.sasKernel.getLoggedinServer();
                        if (null == sASServer) break;
                        sASServer.notifyMethod(new NotifyObject(0x101001, new LogCallBackPacket(NetworkToJavaConverter.byteArrayToInt(objectArray, 0), byArray)));
                        break;
                    }
                    case 4101: {
                        byte[] byArray = networkPacket.getDatabuffer();
                        networkPacket.setFrameworkError(0);
                        SASServer sASServer = this.sasKernel.getLoggedinServer();
                        if (null == sASServer || sASServer.isCIMOMServer()) break;
                        Object object2 = this.getCfginArrayList(byArray);
                        sASServer.notifyMethod(new NotifyObject(4101, object2));
                        break;
                    }
                    case 4102: {
                        Object object2 = networkPacket.getDatabuffer();
                        networkPacket.setFrameworkError(0);
                        SASServer sASServer = this.sasKernel.getLoggedinServer();
                        if (null == sASServer || !sASServer.isCIMOMServer()) break;
                        ArrayList arrayList = this.getCfginArrayList((byte[])object2);
                        sASServer.notifyMethod(new NotifyObject(4101, arrayList));
                        break;
                    }
                    case 4100: {
                        this.routeCIMOMCall(networkPacket);
                        networkPacket.setFrameworkError(0);
                        break;
                    }
                    default: {
                        System.out.println("Worker.handleClient() -> dafault . => setFrameworkError ");
                        networkPacket.setFrameworkError(1);
                    }
                }
                object = networkPacket.getByteArray();
                if (this.os == null) {
                    this.os = new BufferedOutputStream(this.s.getOutputStream(), ((Object)object).length);
                }
                this.os.write((byte[])object);
                this.os.flush();
            }
        }
        catch (IOException iOException) {
            try {
                this.is.close();
                this.os.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return;
        }
    }

    private ArrayList getCfginArrayList(byte[] byArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            int n = NetworkToJavaConverter.byteArrayToInt(byArray, 0);
            if (n == 1) {
                System.out.println("Worker.getCfginArrayList() error @ reading vivaldi config");
            }
            int n2 = NetworkToJavaConverter.byteArrayToInt(byArray, 8);
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            while (n5 < n2) {
                n4 = NetworkToJavaConverter.byteArrayToInt(byArray, 12 + n3);
                String string = new String(byArray, 12 + n3 + 4, n4);
                if (string == null) {
                    System.out.println("Worker.getCfginArrayList()" + n5 + "th event is null");
                } else {
                    arrayList.add(string);
                }
                ++n5;
                n3 += 4 + n4;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return arrayList;
    }

    public boolean checkIfIPAddrIsLocal(int[] nArray) {
        String string = null;
        String string2 = null;
        if (nArray != null && nArray.length > 0) {
            string = new String();
            for (int i = 0; i < nArray.length; ++i) {
                string = string + nArray[i];
                if (i == nArray.length - 1) continue;
                string = string + ".";
            }
        }
        if (string.equals("127.0.0.1")) {
            return true;
        }
        try {
            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
            while (enumeration.hasMoreElements()) {
                Enumeration<InetAddress> enumeration2 = enumeration.nextElement().getInetAddresses();
                while (enumeration2.hasMoreElements()) {
                    InetAddress inetAddress = enumeration2.nextElement();
                    if (inetAddress.isLoopbackAddress() || !(inetAddress instanceof Inet4Address) || !(string2 = inetAddress.getHostAddress()).equals(string)) continue;
                    return true;
                }
            }
        }
        catch (Exception exception) {
            return false;
        }
        return false;
    }

    synchronized void routeStoreLibCall(NetworkPacket networkPacket) {
        Iterator iterator = this.sasKernel.getSASServerArrayList().iterator();
        while (iterator.hasNext() && !((SASServer)iterator.next()).callBackAEN(networkPacket)) {
        }
    }

    synchronized void routeCIMOMCall(NetworkPacket networkPacket) {
        this.sasKernel.handleAEN(networkPacket);
        Iterator iterator = this.sasKernel.getSASServerArrayList().iterator();
        while (iterator.hasNext() && !((SASServer)iterator.next()).callBackCIMOMAEN(networkPacket)) {
        }
    }
}

