/*
 * Decompiled with CFR 0.152.
 */
package Framework.debuglogger;

import Framework.debuglogger.DebugLoggerInterface;
import java.io.File;

public class Logger {
    private static DebugLoggerInterface traceManager;
    private static String onlyClassName;
    private static String onlyJarName;
    private static String classExt;
    private static String jarExt;
    private static final String DEBUGLOGGER_PACKAGE = "debuglog.";
    private static final String debuglog_str = "DebugLog";
    private static int count;
    private static Logger logger;
    private static boolean flag;

    private Logger() {
    }

    public static Logger getInstance() {
        if (traceManager == null && count == 0) {
            int n;
            File file = new File(System.getProperty("user.dir") + File.separator + debuglog_str);
            File file2 = new File(System.getProperty("user.dir"));
            String[] stringArray = file.list();
            String[] stringArray2 = file2.list();
            for (n = 0; stringArray2 != null && n < stringArray2.length; ++n) {
                if (!stringArray2[n].equalsIgnoreCase(debuglog_str + jarExt)) continue;
                flag = true;
            }
            for (n = 0; stringArray != null && n < stringArray.length; ++n) {
                onlyClassName = stringArray[n].substring(0, stringArray[n].indexOf(classExt));
                try {
                    if (!flag) continue;
                    traceManager = (DebugLoggerInterface)Class.forName(DEBUGLOGGER_PACKAGE + onlyClassName).newInstance();
                    ++count;
                    continue;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            if (logger == null) {
                logger = new Logger();
            }
        }
        return logger;
    }

    public boolean log(String string, String string2, String string3) {
        if (traceManager != null && traceManager.isFeatureEnable()) {
            traceManager.log(string, string2, string3);
        }
        return true;
    }

    public boolean log(char[] cArray, String string, String string2) {
        if (traceManager != null && traceManager.isFeatureEnable()) {
            traceManager.log(cArray, string, string2);
        }
        return true;
    }

    public boolean log(byte[] byArray, String string, String string2) {
        if (traceManager != null) {
            traceManager.log(byArray, string, string2);
        }
        return true;
    }

    public boolean log(Throwable throwable, String string, String string2) {
        if (traceManager != null && traceManager.isFeatureEnable()) {
            traceManager.log(throwable, string, string2);
        }
        return true;
    }

    public boolean logObject(Object object, String string) {
        if (traceManager != null && traceManager.isFeatureEnable()) {
            traceManager.logObject(object, string);
        }
        return true;
    }

    static {
        classExt = ".class";
        jarExt = ".jar";
        count = 0;
        flag = false;
    }
}

