/*
 * Decompiled with CFR 0.152.
 */
package GUI;

import GUI.MainFrame;
import GUI.VersionDetailsDialog;
import GUI.VivaldiBaseDialog;
import GUI.VivaldiStartupDialog;
import SASKernel.SASServer;
import Utils.ColorHash;
import Utils.Resource;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Calendar;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class AboutDialog
extends VivaldiBaseDialog {
    private String[] mnemonics;
    private JPanel aboutPanel = new JPanel(new BorderLayout());
    private JLabel aboutText = new JLabel();
    private SASServer server;
    private JButton okButton = new JButton(Resource.getString("ABOUT_OKBUTTON_TEXT", "OK"));
    private JButton infoButton;

    public AboutDialog(SASServer sASServer) {
        this.mnemonics = Resource.getResourceMnemonic(Resource.getString("ABOUT_SERVERINFO_TEXT", "Server Info"));
        this.infoButton = new JButton(this.mnemonics[0]);
        if (this.mnemonics.length == 2) {
            this.infoButton.setMnemonic(this.mnemonics[1].charAt(0));
        }
        this.server = sASServer;
        this.setTitle(VivaldiStartupDialog.FRAME_TITLE);
        Calendar calendar = Calendar.getInstance();
        this.aboutText.setText("<html><h3>" + VivaldiStartupDialog.FRAME_TITLE + "</h3>" + Resource.getString("MSG_ABOUT_LINE1", "Client Build : ") + VivaldiStartupDialog.VERSION_INFO + "<br>" + Resource.getString("MSG_ABOUT_LINE2", "Copyright \u00a9 ") + calendar.get(1) + " " + Resource.getString("MSG_ABOUT_LINE2_LSI", "LSI Corporation. All Rights Reserved.") + "<br></html>");
        this.aboutText.setOpaque(true);
        this.aboutText.setHorizontalAlignment(0);
        this.aboutText.setBorder(BorderFactory.createEtchedBorder());
        this.aboutText.setBackground(ColorHash.getColor("LIGHT_BACKGROUND"));
        this.aboutPanel.add((Component)this.aboutText, "Center");
        this.contentPane.add((Component)this.aboutPanel, "Center");
        JPanel jPanel = new JPanel(new FlowLayout());
        jPanel.add(this.infoButton);
        jPanel.add(this.okButton);
        this.contentPane.add((Component)jPanel, "South");
        this.setModal(true);
        this.setResizable(false);
        int n = MainFrame.SCREEN_SIZE.height > 700 ? 250 : 300;
        int n2 = MainFrame.SCREEN_SIZE.width > 1000 ? 412 : 480;
        this.setSize(MainFrame.SCREEN_SIZE.width * n2 / 1024, MainFrame.SCREEN_SIZE.height * n / 768);
        this.getRootPane().setDefaultButton(this.okButton);
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AboutDialog.this.dispose();
            }
        });
        this.infoButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                VersionDetailsDialog versionDetailsDialog = new VersionDetailsDialog(AboutDialog.this.server);
                versionDetailsDialog.setLocation((MainFrame.SCREEN_SIZE.width - versionDetailsDialog.getWidth()) / 2, (MainFrame.SCREEN_SIZE.height - versionDetailsDialog.getHeight()) / 2);
                versionDetailsDialog.show();
            }
        });
    }
}

