/*
 * Decompiled with CFR 0.152.
 */
package GUI;

import GUI.AdapterMenuListener;
import GUI.CSA.CSABootVolumeCreationPage;
import GUI.CSA.CSAConfigurationSummaryPage;
import GUI.CSA.CSADriveGroupCreationPage;
import GUI.CSA.CSAModeSelectionPage;
import GUI.CSA.CSAVirtualDiskCreationPage;
import GUI.DetailPanel;
import GUI.GroupShowProgressDialog;
import GUI.MainFrame;
import GUI.OperationViewPanel;
import GUI.PremiumFeatures.PremiumFeaturesDialog;
import GUI.PropertyViewPanel;
import GUI.VivaldiStartupDialog;
import GUI.venus.configuration.advanced.AdvanceConfigEngine;
import GUI.venus.configuration.supersizedcache.SSCConfigurationSummaryPage;
import GUI.venus.configuration.supersizedcache.SSCDriveGroupCreationPage;
import GUI.venus.configuration.supersizedcache.SSCHolesUnconfigPdSelectionPage;
import GUI.venus.configuration.supersizedcache.SSCVirtualDiskCreationPage;
import GUI.venus.wizard.WizardController;
import GUI.venus.wizard.WizardNavigationException;
import GUIHelper.AdapterHelper;
import GUIHelper.LogicalDriveHelper;
import GUIHelper.PhysicalDriveHelper;
import GUIHelper.ServerObjectHelper;
import SASKernel.LibraryAPI.StoreLib.ADV_SYSTEM_INFO;
import SASKernel.LibraryAPI.StoreLib.MR_DRV_DRIVER_VERSION;
import SASKernel.LibraryAPI.StoreLib.MR_EVT_CLASS_LOCALE;
import SASKernel.LibraryAPI.StoreLib.MR_EVT_LIST;
import SASKernel.LibraryAPI.StoreLib.MR_EVT_LOG_INFO;
import SASKernel.LibraryAPI.StoreLib.MR_FLASH_COMP_INFO;
import SASKernel.LibraryAPI.StoreLib.MR_TIME_STAMP;
import SASKernel.LibraryAPI.StoreLib.MR_TTY_DATA;
import SASKernel.LibraryAPI.StoreLib.adapterOperations_MR_CTRL_INFO;
import SASKernel.Operations.OperationDetails;
import SASKernel.SASAdapter.SASAdapter;
import SASKernel.SASAdapter.SASBatteryBackUp;
import SASKernel.SASLogical.SASLogicalDrive;
import SASKernel.SASPhysical.SASPhysicalDrive;
import SASKernel.SASServer;
import Services.KernelConstants;
import Snapshot.CreateConcurrentPitDialog;
import Snapshot.ManageSnapshotSchedules;
import Utils.CustomMsgBox;
import Utils.CustomTabbedPane;
import Utils.Resource;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class AdapterDetailPanel
extends DetailPanel {
    private CustomTabbedPane tabbedPane = new CustomTabbedPane();
    private JPanel propertiesTab = new JPanel();
    private OperationViewPanel opView;
    private AdapterHelper adapter;
    private JMenuItem l_objSetPatrolReadMenuItem = null;
    private static String FRAME_TITLE = Resource.getString("NO_FOREIGN", "No Foreign Config");
    private ArrayList<LogicalDriveHelper> m_sourceldHelpers = null;
    private boolean isWindowsServer;
    private boolean viewOnly;
    private ArrayList enabledOperations = new ArrayList();
    private PremiumFeaturesDialog pfkDialog = null;

    public AdapterDetailPanel(AdapterHelper adapterHelper, MainFrame mainFrame) {
        super(adapterHelper, mainFrame);
        this.adapter = adapterHelper;
        this.isWindowsServer = this.adapter.isWindowsAndNotDell();
        this.viewOnly = this.adapter.isViewOnlyMode();
        this.tabbedPane.addTab(Resource.getString("PROPERTY_TAB_TEXT", "Properties"), null, new JScrollPane(this.propertiesTab), Resource.getString("PROPERTY_TAB_TEXT", "Properties"));
        this.add((Component)this.tabbedPane, "Center");
        this.propertiesTab.setLayout(new BorderLayout());
        this.init();
        this.adapter.addObserver(this);
    }

    @Override
    public void init() {
        this.propertiesTab.removeAll();
        ArrayList arrayList = this.adapter.getPropertyList();
        int n = 40;
        if (arrayList.size() > 40) {
            n = arrayList.size() % 2 == 1 ? arrayList.size() + 1 : arrayList.size();
        }
        PropertyViewPanel propertyViewPanel = new PropertyViewPanel(this.adapter.getPropertyList(), n);
        this.propertiesTab.add((Component)propertyViewPanel, "North");
        this.opView = new OperationViewPanel(this.adapter);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.opView, "Center");
        JPanel jPanel2 = new JPanel(new FlowLayout());
        String[] stringArray = Resource.getResourceMnemonic(Resource.getString("BUTTON_OPERATION_GO", "Go"));
        JButton jButton = new JButton(stringArray[0]);
        jButton.setToolTipText(Resource.getString("BUTTON_OPERATION_GO_DSC", "Go"));
        if (stringArray.length == 2) {
            jButton.setMnemonic(stringArray[1].charAt(0));
        }
        jButton.setPreferredSize(new Dimension(MainFrame.SCREEN_SIZE.width * 120 / 1024, MainFrame.SCREEN_SIZE.height * 30 / 768));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AdapterDetailPanel.this.opView.invokeOperation();
            }
        });
        jPanel2.add(jButton);
    }

    @Override
    public boolean canClose() {
        this.adapter.deleteObserver(this);
        return true;
    }

    @Override
    public void gotoTab(int n) {
        this.tabbedPane.setSelectedIndex(n);
    }

    @Override
    public int getTabIndex() {
        return this.tabbedPane.getSelectedIndex();
    }

    @Override
    public JMenu getSubMenu(JMenu jMenu) {
        int n = jMenu.getItemCount();
        JMenu jMenu2 = null;
        for (int i = 0; i < n; ++i) {
            jMenu2 = (JMenu)jMenu.getItem(i);
            if (!jMenu2.getName().trim().equals("Controller")) continue;
            return jMenu2;
        }
        return jMenu2;
    }

    @Override
    public void populateOperationMenu(JMenu jMenu, OperationDetails operationDetails) {
        if (jMenu == null) {
            return;
        }
        if (((SASAdapter)this.adapter.getDeviceObject()).isMRApiIncompatible()) {
            return;
        }
        String[] stringArray = null;
        block1 : switch (operationDetails.getOpcode()) {
            case 1120: {
                boolean bl;
                if (!this.adapter.isSecuritySupported()) break;
                stringArray = Resource.getResourceMnemonic(Resource.getString("BUTTON_ENABLE_ENCRYPTION", "Ena(b)le..."));
                JMenuItem jMenuItem = new JMenuItem(stringArray[0]);
                boolean bl2 = bl = !this.adapter.isLockKeyAssigned();
                if (!bl) break;
                jMenuItem.setEnabled(true);
                jMenuItem.setMnemonic(stringArray[1].charAt(0));
                jMenu.add(jMenuItem);
                this.enabledOperations.add(1120);
                jMenuItem.setActionCommand("1120");
                jMenuItem.addActionListener(new AdapterMenuListener(this.adapter));
                break;
            }
            case 1121: {
                stringArray = Resource.getResourceMnemonic(Resource.getString("BUTTON_DISABLE_ENCRYPTION", "(D)isable..."));
                JMenuItem jMenuItem = new JMenuItem(stringArray[0]);
                boolean bl = this.adapter.isLockKeyAssigned();
                if (!bl) break;
                jMenuItem.setEnabled(true);
                jMenuItem.setMnemonic(stringArray[1].charAt(0));
                jMenuItem.setActionCommand("1121");
                jMenuItem.addActionListener(new AdapterMenuListener(this.adapter));
                this.enabledOperations.add(1121);
                jMenu.add(jMenuItem);
                break;
            }
            case 1122: {
                stringArray = Resource.getResourceMnemonic(Resource.getString("BUTTON_CHANGE_PASSPHRASE", "Chan(g)e Security Settings..."));
                boolean bl = this.adapter.isLockKeyAssigned();
                if (!bl) break;
                JMenuItem jMenuItem = new JMenuItem(stringArray[0]);
                jMenuItem.setEnabled(true);
                jMenuItem.setMnemonic(stringArray[1].charAt(0));
                jMenuItem.setActionCommand("1122");
                jMenuItem.addActionListener(new AdapterMenuListener(this.adapter));
                this.enabledOperations.add(1122);
                jMenu.add(jMenuItem);
                break;
            }
            case 1100: {
                int n = this.isConfigAllowed();
                if (!this.isConversionAllowedJBODtoUCG() && (n & 1) != 1) break;
                try {
                    AdvanceConfigEngine advanceConfigEngine = new AdvanceConfigEngine(this.adapter);
                    if (!advanceConfigEngine.canCreateConfig() && !this.isConversionAllowedJBODtoUCG()) break;
                    stringArray = Resource.getResourceMnemonic(Resource.getString("OPERATION_CREATE_VD"));
                    JMenuItem jMenuItem = new JMenuItem(stringArray[0]);
                    if (stringArray.length == 2) {
                        jMenuItem.setMnemonic(stringArray[1].charAt(0));
                    }
                    jMenuItem.setActionCommand("1100");
                    jMenuItem.addActionListener(new AdapterMenuListener(this.adapter));
                    if (!this.enabledOperations.contains(1100)) {
                        this.enabledOperations.add(1100);
                    }
                    jMenu.add(jMenuItem);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                break;
            }
            case 1141: {
                int n;
                if (this.adapter.isCSA() || ((n = this.isConfigAllowed()) & 1) != 1) break;
                short s = this.adapter.getAdapterInfo().getMaxSSCsize();
                short s2 = this.adapter.getAdapterInfo().getcurrentSSCsize();
                int n2 = s - s2;
                if (s == 0 || n2 <= 0) break;
                boolean bl = false;
                PhysicalDriveHelper[] physicalDriveHelperArray = this.adapter.getUnconfiguredPhysicalDrives();
                if (physicalDriveHelperArray == null || physicalDriveHelperArray.length <= 0) break;
                for (int i = 0; i < physicalDriveHelperArray.length; ++i) {
                    if (!physicalDriveHelperArray[i].isSSDDrive() || physicalDriveHelperArray[i].isIneligibleForSSCD()) continue;
                    stringArray = Resource.getResourceMnemonic(Resource.getString("OPERATION_CREATE_SSCD", "Create CacheCade\u2122"));
                    JMenuItem jMenuItem = new JMenuItem(stringArray[0]);
                    if (stringArray.length == 2) {
                        jMenuItem.setMnemonic(stringArray[1].charAt(0));
                    }
                    jMenuItem.addActionListener(new CreateSSCAction());
                    jMenu.add(jMenuItem);
                    bl = true;
                    break block1;
                }
                break;
            }
            case 1116: {
                int n = this.isConfigAllowed();
                int n3 = n & 1;
                int n4 = n >> 1 & 1;
                if (n3 != 1 && n4 != 1) break;
                JMenuItem jMenuItem = new JMenuItem(Resource.getResourceMnemonic(Resource.getString("MENU_ADD_CONFIG", "Add Configuration from file"))[0]);
                if (Resource.getResourceMnemonic(Resource.getString("MENU_ADD_CONFIG", "Add Configuration from file")).length == 2) {
                    jMenuItem.setMnemonic(Resource.getResourceMnemonic(Resource.getString("MENU_ADD_CONFIG", "Add Configuration from file"))[1].charAt(0));
                }
                jMenuItem.setActionCommand("1116");
                jMenuItem.addActionListener(new AdapterMenuListener(this.adapter));
                this.enabledOperations.add(1116);
                jMenu.add(jMenuItem);
                break;
            }
            case 1117: {
                int n = this.isConfigAllowed();
                int n5 = n & 1;
                int n6 = n >> 1 & 1;
                PhysicalDriveHelper[] physicalDriveHelperArray = this.adapter.getPhysicalDrives();
                boolean bl = false;
                for (int i = 0; i < physicalDriveHelperArray.length; ++i) {
                    if (physicalDriveHelperArray[i].getStatus() != 20) continue;
                    bl = true;
                    break;
                }
                if (bl) break;
                stringArray = Resource.getResourceMnemonic(Resource.getString("MENU_SAVE_CONFIG", "Save Configuration to file"));
                JMenuItem jMenuItem = new JMenuItem(stringArray[0]);
                if (stringArray.length == 2) {
                    jMenuItem.setMnemonic(stringArray[1].charAt(0));
                }
                jMenuItem.setActionCommand("1117");
                jMenuItem.addActionListener(new AdapterMenuListener(this.adapter));
                this.enabledOperations.add(1117);
                jMenu.add(jMenuItem);
                break;
            }
            case 1118: {
                int n = this.isConfigAllowed();
                int n7 = n & 1;
                int n8 = n >> 1 & 1;
                if (((SASAdapter)this.adapter.getDeviceObject()).getAdapterType() == 2 || ((SASAdapter)this.adapter.getDeviceObject()).getAdapterType() == 3 || ((SASAdapter)this.adapter.getDeviceObject()).getAdapterType() == 4) {
                    if (n8 == 0) break;
                    stringArray = Resource.getResourceMnemonic(Resource.getString("MENU_CLEAR_CONFIG", "Clear Configuration"));
                    JMenuItem jMenuItem = new JMenuItem(stringArray[0]);
                    if (stringArray.length == 2) {
                        jMenuItem.setMnemonic(stringArray[1].charAt(0));
                    }
                    jMenuItem.setActionCommand("1118");
                    jMenuItem.addActionListener(new AdapterMenuListener(this.adapter));
                    this.enabledOperations.add(1118);
                    jMenu.add(jMenuItem);
                    break;
                }
                stringArray = Resource.getResourceMnemonic(Resource.getString("MENU_CLEAR_CONFIG", "Clear Configuration"));
                JMenuItem jMenuItem = new JMenuItem(stringArray[0]);
                if (stringArray.length == 2) {
                    jMenuItem.setMnemonic(stringArray[1].charAt(0));
                }
                jMenuItem.setActionCommand("1118");
                jMenuItem.addActionListener(new AdapterMenuListener(this.adapter));
                this.enabledOperations.add(1118);
                jMenu.add(jMenuItem);
                break;
            }
            case 1115: {
                String[] stringArray2 = Resource.getResourceMnemonic(Resource.getString("MENU_FOREIGN_CONFIG", "Scan For Foreign Configuration"));
                JMenuItem jMenuItem = new JMenuItem(stringArray2[0]);
                if (stringArray2.length == 2) {
                    jMenuItem.setMnemonic(stringArray2[1].charAt(0));
                }
                if (this.adapter.getAdapterInfo().getadapterOperations_MR_CTRL_INFO().getforeignConfigImport() != 0) {
                    this.enabledOperations.add(1115);
                    jMenu.add(jMenuItem);
                }
                jMenuItem.setActionCommand("1115");
                jMenuItem.addActionListener(new AdapterMenuListener(this.adapter));
                break;
            }
            case 1119: {
                stringArray = Resource.getResourceMnemonic(Resource.getString("MENU_MANAGE_PRESERVED_CACHE", "Manage Preserved Cache"));
                JMenuItem jMenuItem = new JMenuItem(stringArray[0]);
                if (stringArray.length == 2) {
                    jMenuItem.setMnemonic(stringArray[1].charAt(0));
                }
                jMenu.add(jMenuItem);
                this.enabledOperations.add(1119);
                jMenuItem.setEnabled(this.adapter.getAdapterInfo().getCacheIsPinned() != 0);
                jMenuItem.setActionCommand("1119");
                jMenuItem.addActionListener(new AdapterMenuListener(this.adapter));
                break;
            }
            case 1129: {
                if (!((SASAdapter)this.adapter.getDeviceObject()).isOperationAllowed(15)) {
                    return;
                }
                stringArray = Resource.getResourceMnemonic(Resource.getString("PR_SET_PROPERTIES", "(S)et Patrol Read Properties..."));
                this.l_objSetPatrolReadMenuItem = new JMenuItem();
                this.l_objSetPatrolReadMenuItem.setText(stringArray[0]);
                if (stringArray.length == 2) {
                    this.l_objSetPatrolReadMenuItem.setMnemonic(stringArray[1].charAt(0));
                }
                this.l_objSetPatrolReadMenuItem.setActionCommand("1129");
                this.l_objSetPatrolReadMenuItem.addActionListener(new AdapterMenuListener(this.adapter));
                this.enabledOperations.add(1129);
                jMenu.add(this.l_objSetPatrolReadMenuItem);
                if (this.l_objSetPatrolReadMenuItem == null) break;
                if (this.adapter.getNoOfOnlinePds() <= 0) {
                    this.l_objSetPatrolReadMenuItem.setEnabled(false);
                    break;
                }
                this.l_objSetPatrolReadMenuItem.setEnabled(true);
                break;
            }
            case 1160: {
                if (((SASAdapter)this.adapter.getDeviceObject()).getAdapterType() != 1 || this.adapter.isSWRController() || !this.adapter.getAdapterInfo().getpdOperations_MR_CTRL_INFO().isSupportPowerState() && !this.adapter.isPowerSaveSupportedOnConfiguredDrives()) break;
                stringArray = Resource.getResourceMnemonic(Resource.getString("DS_MANAGE_POWER_SAVE_SETTINGS", "Manage Po(w)er Save Settings"));
                JMenuItem jMenuItem = new JMenuItem();
                jMenuItem.setText(stringArray[0]);
                if (stringArray.length == 2) {
                    jMenuItem.setMnemonic(stringArray[1].charAt(0));
                }
                jMenuItem.setActionCommand("1160");
                jMenuItem.addActionListener(new AdapterMenuListener(this.adapter));
                this.enabledOperations.add(1160);
                jMenu.add(jMenuItem);
                break;
            }
            case 1123: {
                Object object;
                ServerObjectHelper serverObjectHelper = this.mainScreen.getServerHelper();
                boolean bl = false;
                if (serverObjectHelper != null) {
                    object = serverObjectHelper.getAdapterHelpers();
                    for (int i = 0; i < ((AdapterHelper[])object).length; ++i) {
                        if (((SASAdapter)object[i].getDeviceObject()).isWarhawk()) continue;
                        bl |= true;
                        break;
                    }
                }
                stringArray = Resource.getResourceMnemonic(Resource.getString("MENU_GRPROGRESS_TEXT", "Show Progress"));
                object = new JMenuItem(stringArray[0]);
                if (stringArray.length == 2) {
                    ((AbstractButton)object).setMnemonic(stringArray[1].charAt(0));
                }
                ((AbstractButton)object).addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        new GroupShowProgressDialog(AdapterDetailPanel.this.mainScreen.getServerHelper());
                    }
                });
                if (!bl) break;
                jMenu.add((JMenuItem)object);
                break;
            }
            case 1139: {
                adapterOperations_MR_CTRL_INFO adapterOperations_MR_CTRL_INFO2;
                LogicalDriveHelper[] logicalDriveHelperArray = this.adapter.getLogicalDrives();
                this.m_sourceldHelpers = new ArrayList();
                for (int n = 0; n < logicalDriveHelperArray.length; n = (int)((byte)(n + 1))) {
                    if (((SASLogicalDrive)logicalDriveHelperArray[n].getDeviceObject()).getInformation().getldConfig().getparams().getSnapshotEnabled() != 1 || ((SASLogicalDrive)logicalDriveHelperArray[n].getDeviceObject()).getInformation().getldConfig().getparams().getstate() == '\u0000') continue;
                    this.m_sourceldHelpers.add(logicalDriveHelperArray[n]);
                }
                if (this.viewOnly || !this.isWindowsServer || this.m_sourceldHelpers.size() <= 0 || !(adapterOperations_MR_CTRL_INFO2 = this.adapter.getAdapterInfo().getadapterOperations_MR_CTRL_INFO()).isSupportSnapshot()) break;
                stringArray = Resource.getResourceMnemonic(Resource.getString("LDRIVE_OPERATION_CREATE_SNAPSHOT", "(C)reate Snapshots"));
                JMenuItem jMenuItem = new JMenuItem(stringArray[0]);
                if (stringArray.length == 2) {
                    jMenuItem.setMnemonic(stringArray[1].charAt(0));
                }
                jMenu.add(jMenuItem);
                jMenuItem.setEnabled(true);
                jMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        try {
                            new CreateConcurrentPitDialog(AdapterDetailPanel.this.m_sourceldHelpers, AdapterDetailPanel.this.adapter);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                });
                break;
            }
            case 1145: {
                stringArray = this.adapter.isWarhawk() ? Resource.getResourceMnemonic(Resource.getString("IR_MANAGE_ADV_SOFTWARE_OPTIONS_TEXT", "Manag(e) Advanced Software Options")) : Resource.getResourceMnemonic(Resource.getString("PFKEY_TITLE", "Activate Premium Feature"));
                JMenuItem jMenuItem = new JMenuItem(stringArray[0]);
                adapterOperations_MR_CTRL_INFO adapterOperations_MR_CTRL_INFO3 = this.adapter.getAdapterInfo().getadapterOperations_MR_CTRL_INFO();
                if (!adapterOperations_MR_CTRL_INFO3.isPFKSupported()) break;
                jMenuItem.setEnabled(true);
                if (stringArray.length == 2) {
                    jMenuItem.setMnemonic(stringArray[1].charAt(0));
                }
                jMenu.add(jMenuItem);
                this.enabledOperations.add(1145);
                jMenuItem.setActionCommand("1145");
                jMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        System.out.println("inside mouse click");
                        PremiumFeaturesDialog premiumFeaturesDialog = new PremiumFeaturesDialog(AdapterDetailPanel.this.adapter);
                    }
                });
                break;
            }
            case 1155: {
                LogicalDriveHelper[] logicalDriveHelperArray = this.adapter.getLogicalDrives();
                ArrayList<LogicalDriveHelper> arrayList = new ArrayList<LogicalDriveHelper>();
                for (int n = 0; n < logicalDriveHelperArray.length; n = (int)((byte)(n + 1))) {
                    if (((SASLogicalDrive)logicalDriveHelperArray[n].getDeviceObject()).getInformation().getldConfig().getparams().getSnapshotEnabled() != 1 || ((SASLogicalDrive)logicalDriveHelperArray[n].getDeviceObject()).getInformation().getldConfig().getparams().getstate() == '\u0000') continue;
                    arrayList.add(logicalDriveHelperArray[n]);
                }
                if (arrayList.size() == 0) break;
                stringArray = Resource.getResourceMnemonic(Resource.getString("ADAPTER_OPERATION_MANAGE_SNAPSHOT_SCHEDULES"));
                JMenuItem jMenuItem = new JMenuItem(stringArray[0]);
                if (stringArray.length == 2) {
                    jMenuItem.setMnemonic(stringArray[1].charAt(0));
                }
                if (this.isWindowsServer) {
                    jMenu.add(jMenuItem);
                }
                jMenuItem.setEnabled(true);
                jMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        try {
                            new ManageSnapshotSchedules(AdapterDetailPanel.this.m_sourceldHelpers, AdapterDetailPanel.this.adapter);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                });
                break;
            }
            case 1157: {
                boolean bl = this.isConversionAllowedJBODtoUCG();
                if (!bl) break;
                stringArray = Resource.getResourceMnemonic(Resource.getString("MENU_MAKE_DRIVES_UCG", "Make Drive(s) Unconfigured Good"));
                JMenuItem jMenuItem = new JMenuItem(stringArray[0]);
                if (stringArray.length == 2) {
                    jMenuItem.setMnemonic(stringArray[1].charAt(0));
                }
                jMenuItem.setActionCommand("1157");
                jMenuItem.addActionListener(new AdapterMenuListener(this.adapter));
                this.enabledOperations.add(1157);
                jMenu.add(jMenuItem);
                break;
            }
            case 1156: {
                if (((SASAdapter)this.adapter.getDeviceObject()).getAdapterType() != 1 || this.adapter.isSWRController()) break;
                stringArray = Resource.getResourceMnemonic(Resource.getString("TTYLOG_OPERATION_DESC"));
                JMenuItem jMenuItem = new JMenuItem(stringArray[0]);
                if (stringArray.length == 2) {
                    jMenuItem.setMnemonic(stringArray[1].charAt(0));
                }
                jMenu.add(jMenuItem);
                jMenuItem.setEnabled(true);
                jMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        FileOutputStream fileOutputStream = null;
                        try {
                            JFileChooser jFileChooser = new JFileChooser();
                            SASServer sASServer = (SASServer)((ServerObjectHelper)AdapterDetailPanel.this.adapter.getParent()).getDeviceObject();
                            String string = new String(sASServer.getInformation().getHostName() + ".txt");
                            jFileChooser.setCurrentDirectory(new File("."));
                            jFileChooser.setSelectedFile(new File(string));
                            File file = null;
                            if (jFileChooser.showSaveDialog(VivaldiStartupDialog.mainScreen) == 0) {
                                file = jFileChooser.getSelectedFile();
                                if (file.exists() && !CustomMsgBox.confirm(Resource.getString("MSG_CONFIRM_CFG_FILE_OVERWRITE", "File already exists. Do you want to overwrite ?"))) {
                                    return;
                                }
                            } else {
                                return;
                            }
                            int n = 0;
                            int n2 = 1028;
                            MR_TTY_DATA mR_TTY_DATA = null;
                            VivaldiStartupDialog.mainScreen.setCursor(Cursor.getPredefinedCursor(3));
                            VivaldiStartupDialog.mainScreen.setEnabled(false);
                            fileOutputStream = new FileOutputStream(file);
                            StringBuffer stringBuffer = AdapterDetailPanel.this.getSystemInfo();
                            stringBuffer.append("\n");
                            stringBuffer.append("\n");
                            stringBuffer.append(AdapterDetailPanel.this.getCtrlInfo());
                            stringBuffer.append("\n");
                            stringBuffer.append("\n");
                            stringBuffer.append(AdapterDetailPanel.this.getPhysicalDriveInfo());
                            stringBuffer.append("\n");
                            stringBuffer.append("\n");
                            stringBuffer.append(AdapterDetailPanel.this.getLogicalDriveInfo());
                            stringBuffer.append("\n");
                            stringBuffer.append("\n");
                            stringBuffer.append(AdapterDetailPanel.this.getEventInfo());
                            stringBuffer.append("\n");
                            stringBuffer.append("\n");
                            stringBuffer.append(Resource.getString("ONLINE_HISTORY", "Online History"));
                            stringBuffer.append("\n");
                            stringBuffer.append("=================================");
                            stringBuffer.append("\n");
                            stringBuffer.append("\n");
                            fileOutputStream.write(stringBuffer.toString().getBytes());
                            while (true) {
                                mR_TTY_DATA = ((SASAdapter)AdapterDetailPanel.this.adapter.getDeviceObject()).getTtyData(n2, n);
                                try {
                                    fileOutputStream.write(mR_TTY_DATA.getdata());
                                }
                                catch (FileNotFoundException fileNotFoundException) {
                                    System.out.println("FileNotFoundException : " + fileNotFoundException);
                                }
                                catch (IOException iOException) {
                                    System.out.println("IOException : " + iOException);
                                }
                                if (mR_TTY_DATA.getactualByteCount() < 1016) break;
                                n += mR_TTY_DATA.getactualByteCount();
                            }
                            fileOutputStream.close();
                            VivaldiStartupDialog.mainScreen.setCursor(Cursor.getDefaultCursor());
                            VivaldiStartupDialog.mainScreen.setEnabled(true);
                        }
                        catch (Exception exception) {
                            try {
                                fileOutputStream.close();
                            }
                            catch (Exception exception2) {
                                // empty catch block
                            }
                            exception.printStackTrace();
                        }
                    }
                });
                break;
            }
            case 1164: {
                ArrayList arrayList;
                if (this.adapter.isCSA() || ((SASAdapter)this.adapter.getDeviceObject()).getAdapterType() != 1 || !this.adapter.isSSCEnabled() || !this.adapter.getAdapterInfo().getldOperations_MR_CTRL_INFO().isSupportSSCAssociation() || (arrayList = this.adapter.getSSCCacheableLDList(this.adapter.getNonSSCDsList(), 0)).size() <= 0) break;
                stringArray = Resource.getResourceMnemonic(Resource.getString("OPERATION_MANAGE_SSD_CACHING", "(M)anage SSD Caching"));
                JMenuItem jMenuItem = new JMenuItem(stringArray[0]);
                jMenuItem.setMnemonic(stringArray[1].charAt(0));
                jMenuItem.setEnabled(true);
                this.enabledOperations.add(1164);
                jMenuItem.setActionCommand("1164");
                jMenuItem.addActionListener(new AdapterMenuListener(this.adapter));
                jMenu.add(jMenuItem);
                break;
            }
            case 3: {
                if (!((SASAdapter)this.adapter.getDeviceObject()).isOperationAllowed(3)) {
                    return;
                }
                stringArray = ((SASAdapter)this.adapter.getDeviceObject()).isWarhawk() ? Resource.getResourceMnemonic(Resource.getString("FIRMWARE_PACKAGE_UPDATE_TEXT", "Update C(o)ntroller Firmware Package")) : Resource.getResourceMnemonic(Resource.getString("ADAPTER_OPERATION_4", "Update C(o)ntroller Firmware"));
                JMenuItem jMenuItem = new JMenuItem(stringArray[0]);
                jMenuItem.setMnemonic(stringArray[1].charAt(0));
                jMenuItem.setEnabled(true);
                this.enabledOperations.add(3);
                jMenuItem.setActionCommand("3");
                jMenuItem.addActionListener(new AdapterMenuListener(this.adapter));
                jMenu.add(jMenuItem);
                break;
            }
            case 1172: {
                int n = this.isConfigAllowed();
                if ((n & 1) != 1 || !this.adapter.canCreateCSACacheCade() || this.adapter.getAdapterInfo().getCacheIsPinned() != 0) break;
                stringArray = Resource.getResourceMnemonic(Resource.getString("OPERATION_CREATE_CSA_CACHECADE", "Create Nytro\u2122 Cache"));
                JMenuItem jMenuItem = new JMenuItem(stringArray[0]);
                if (stringArray.length == 2) {
                    jMenuItem.setMnemonic(stringArray[1].charAt(0));
                }
                jMenuItem.addActionListener(new CreateCSACacheCadeAction());
                jMenu.add(jMenuItem);
                break;
            }
            case 1173: {
                ArrayList arrayList;
                if (!this.adapter.isCSA() || ((SASAdapter)this.adapter.getDeviceObject()).getAdapterType() != 1 || !this.adapter.isSSCEnabled() || !this.adapter.getAdapterInfo().getldOperations_MR_CTRL_INFO().isSupportSSCAssociation() || (arrayList = this.adapter.getCSACacheableLDList(this.adapter.getNonSSCDsList(), 0)).size() <= 0) break;
                stringArray = Resource.getResourceMnemonic(Resource.getString("OPERATION_MANAGE_CSA_CACHECADE"));
                JMenuItem jMenuItem = new JMenuItem(stringArray[0]);
                jMenuItem.setMnemonic(stringArray[1].charAt(0));
                jMenuItem.setEnabled(true);
                this.enabledOperations.add(1173);
                jMenuItem.setActionCommand("1173");
                jMenuItem.addActionListener(new AdapterMenuListener(this.adapter));
                jMenu.add(jMenuItem);
                break;
            }
            case 1174: {
                if (!this.adapter.isCSA() || this.adapter.getSlicedForBootVolumeArray() == null) break;
                stringArray = Resource.getResourceMnemonic(Resource.getString("OPERATION_DELETE_SLICED_CSA_CACHECADE", "Delete (N)ytro\u2122 Cache and Boot Drives"));
                JMenuItem jMenuItem = new JMenuItem(stringArray[0]);
                jMenuItem.setMnemonic(stringArray[1].charAt(0));
                jMenuItem.setEnabled(true);
                this.enabledOperations.add(1174);
                jMenuItem.setActionCommand("1174");
                jMenuItem.addActionListener(new AdapterMenuListener(this.adapter));
                jMenu.add(jMenuItem);
            }
        }
    }

    private int isConfigAllowed() {
        OperationDetails operationDetails = new OperationDetails(9, null);
        int n = 0;
        try {
            ((SASAdapter)this.adapter.getDeviceObject()).fireConfigOperation(operationDetails);
            n = (Integer)operationDetails.getParam();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n;
    }

    private boolean isConversionAllowedJBODtoUCG() {
        boolean bl = false;
        int n = this.adapter.getAdapterProperties().getOnOffProperties_MR_CTRL_PROP().getEnableJBOD();
        if (n == 1) {
            int n2 = this.adapter.findunconfiguredAndOnlinePdCnt();
            PhysicalDriveHelper[] physicalDriveHelperArray = this.adapter.getSystemDrivesList();
            int n3 = 0;
            if (physicalDriveHelperArray != null) {
                n3 = physicalDriveHelperArray.length;
            }
            if (n2 < this.adapter.getAdapterInfo().getmaxConfigurablePds() && n3 > 0) {
                bl = true;
            }
        }
        return bl;
    }

    @Override
    public ArrayList getEnabledOpers() {
        System.out.println("inside adapetr getEnabledOpers");
        return this.enabledOperations;
    }

    public StringBuffer getSystemInfo() {
        StringBuffer stringBuffer = new StringBuffer(Resource.getString("PRODUCT_INFO1", "MegaRAID Storage Manager"));
        stringBuffer.append("\n");
        stringBuffer.append("=================================");
        stringBuffer.append("\n");
        try {
            stringBuffer.append(Resource.getString("STRING_ADAPTER", "Adapter"));
            stringBuffer.append("#" + ((SASAdapter)this.adapter.getDeviceObject()).getCtrlID());
            stringBuffer.append("\n");
            stringBuffer.append("\n");
            stringBuffer.append(Resource.getString("STR_DATE_TIME", "Date/Time:"));
            stringBuffer.append(this.NoOfTabsToBeAdded(Resource.getString("STR_DATE_TIME", "Date/Time:"), 20));
            MR_TIME_STAMP mR_TIME_STAMP = ((SASAdapter)this.adapter.getDeviceObject()).getCtrlTime();
            mR_TIME_STAMP.setmonth((byte)(mR_TIME_STAMP.getmonth() - 1));
            stringBuffer.append(KernelConstants.getTimeText(mR_TIME_STAMP));
            stringBuffer.append("\n");
            ADV_SYSTEM_INFO aDV_SYSTEM_INFO = null;
            try {
                aDV_SYSTEM_INFO = this.adapter.getAdvSysInfo();
            }
            catch (Exception exception) {
                // empty catch block
            }
            stringBuffer.append(Resource.getString("HOSTOS_TEXT", "Operating System:"));
            stringBuffer.append(this.NoOfTabsToBeAdded(Resource.getString("HOSTOS_TEXT", "Operating System:"), 20));
            SASServer sASServer = (SASServer)((ServerObjectHelper)this.adapter.getParent()).getDeviceObject();
            stringBuffer.append(sASServer.getInformation().OperatingSystemName());
            stringBuffer.append("\n");
            stringBuffer.append(Resource.getString("MEM_STR", "Physical Memory:"));
            stringBuffer.append(this.NoOfTabsToBeAdded(Resource.getString("MEM_STR", "Physical Memory:"), 20));
            if (aDV_SYSTEM_INFO != null) {
                stringBuffer.append(Resource.zeroTrim(aDV_SYSTEM_INFO.getMemStr()));
            }
            stringBuffer.append("\n");
            stringBuffer.append(Resource.getString("OS_VER", "Operating Version:"));
            stringBuffer.append(this.NoOfTabsToBeAdded(Resource.getString("OS_VER", "Operating Version:"), 20));
            if (aDV_SYSTEM_INFO != null) {
                stringBuffer.append(Resource.zeroTrim(aDV_SYSTEM_INFO.getOSStr()));
            }
            stringBuffer.append("\n");
            MR_DRV_DRIVER_VERSION mR_DRV_DRIVER_VERSION = this.adapter.getMrDrvDriverVersion();
            stringBuffer.append(Resource.getString("DRIVER_NAME", "Driver Name:"));
            stringBuffer.append(this.NoOfTabsToBeAdded(Resource.getString("DRIVER_NAME", "Driver Name:"), 20));
            if (aDV_SYSTEM_INFO != null && mR_DRV_DRIVER_VERSION != null) {
                stringBuffer.append("" + new String(mR_DRV_DRIVER_VERSION.getdriverName()).trim());
            }
            stringBuffer.append("\n");
            stringBuffer.append(Resource.getString("DRIVER_VERSION", "Driver Version:"));
            stringBuffer.append(this.NoOfTabsToBeAdded(Resource.getString("DRIVER_VERSION", "Driver Version:"), 20));
            stringBuffer.append("" + new String(mR_DRV_DRIVER_VERSION.getdriverVersion()).trim());
            stringBuffer.append("\n");
            stringBuffer.append(Resource.getString("STR_PROCESSOR", "Processor:"));
            stringBuffer.append(this.NoOfTabsToBeAdded(Resource.getString("STR_PROCESSOR", "Processor:"), 20));
            if (aDV_SYSTEM_INFO != null) {
                stringBuffer.append(Resource.zeroTrim(aDV_SYSTEM_INFO.getProcStr()));
            }
            stringBuffer.append("\n");
            return stringBuffer;
        }
        catch (Exception exception) {
            return stringBuffer;
        }
    }

    public StringBuffer getCtrlInfo() {
        StringBuffer stringBuffer = new StringBuffer(Resource.getString("RAID_CTRL_TEXT", "RAID Controller"));
        stringBuffer.append(" " + Resource.zeroTrim(this.adapter.getAdapterInfo().getproductName()) + " ");
        stringBuffer.append(Resource.getString("INFO", "Information"));
        stringBuffer.append("\n");
        stringBuffer.append("==============================================");
        stringBuffer.append("\n");
        stringBuffer.append("\n");
        try {
            int n;
            stringBuffer.append(Resource.getString("CTRL_NAME", "RAID Type:"));
            stringBuffer.append(this.NoOfTabsToBeAdded(Resource.getString("CTRL_NAME", "RAID Type:"), 20));
            stringBuffer.append(Resource.zeroTrim(this.adapter.getAdapterInfo().getproductName()));
            stringBuffer.append("\n");
            stringBuffer.append(Resource.getString("SLOT_ADDR", "Slot/Address:"));
            stringBuffer.append(this.NoOfTabsToBeAdded(Resource.getString("SLOT_ADDR", "Slot/Address:"), 20));
            stringBuffer.append(((SASAdapter)this.adapter.getDeviceObject()).getPciInformation().getbusNumber() + "/" + ((SASAdapter)this.adapter.getDeviceObject()).getPciInformation().getdeviceNumber() + "");
            stringBuffer.append("\n");
            stringBuffer.append(Resource.getString("HOST_INTR", "Host Intr:"));
            stringBuffer.append(this.NoOfTabsToBeAdded(Resource.getString("HOST_INTR", "Host Intr:"), 20));
            char c = this.adapter.getAdapterInfo().gethostInterface_MR_CTRL_INFO().getHostType();
            switch (c) {
                case '\u0003': {
                    stringBuffer.append(Resource.getString("ADAPTER_TYPE_ISCSI", "iSCSI"));
                    break;
                }
                case '\u0002': {
                    stringBuffer.append(Resource.getString("ADAPTER_TYPE_PCIE", "PCIE"));
                    break;
                }
                case '\u0001': {
                    stringBuffer.append(Resource.getString("ADAPTER_TYPE_PCIX", "PCIX"));
                    break;
                }
                case '\u0004': {
                    stringBuffer.append(Resource.getString("ADAPTER_TYPE_SAS_3G", "SAS_3G"));
                    break;
                }
                default: {
                    stringBuffer.append(Resource.getString("ADAPTER_TYPE_ISCSI", "Unknown"));
                }
            }
            stringBuffer.append("\n");
            stringBuffer.append(Resource.getString("DEV_INTR", "Device Intr:"));
            stringBuffer.append(this.NoOfTabsToBeAdded(Resource.getString("DEV_INTR", "Device Intr:"), 20));
            if (this.adapter.getAdapterInfo().getdeviceInterface_MR_CTRL_INFO().getSAS_3G() == '\u0001') {
                stringBuffer.append("SAS 3G");
            } else if (this.adapter.getAdapterInfo().getdeviceInterface_MR_CTRL_INFO().getSAS_6G() == 1) {
                stringBuffer.append("SAS 6G");
            } else if (this.adapter.getAdapterInfo().getdeviceInterface_MR_CTRL_INFO().getSAS_12G() == 1) {
                stringBuffer.append("SAS 12G");
            } else {
                stringBuffer.append(Resource.getString("ADAPTER_TYPE_ISCSI", "Unknown"));
            }
            stringBuffer.append("\n");
            stringBuffer.append(Resource.getString("PORT_COUNT", "Port Count:"));
            stringBuffer.append(this.NoOfTabsToBeAdded(Resource.getString("PORT_COUNT", "Port Count:"), 20));
            stringBuffer.append(this.adapter.getAdapterInfo().getdeviceInterface_MR_CTRL_INFO().getportCount());
            stringBuffer.append("\n");
            stringBuffer.append(Resource.getString("SERIAL_NO", "Serial #"));
            stringBuffer.append(this.NoOfTabsToBeAdded(Resource.getString("SERIAL_NO", "Serial #"), 20));
            stringBuffer.append(Resource.zeroTrim(this.adapter.getAdapterInfo().getserialNo()));
            stringBuffer.append("\n");
            stringBuffer.append(Resource.getString("VER_BIOS", "BIOS Version:"));
            stringBuffer.append(this.NoOfTabsToBeAdded(Resource.getString("VER_BIOS", "BIOS Version:"), 20));
            MR_FLASH_COMP_INFO[] mR_FLASH_COMP_INFOArray = this.adapter.getAdapterInfo().getimageComponent_MR_CTRL_INFO();
            int n2 = Math.min(mR_FLASH_COMP_INFOArray.length, this.adapter.getAdapterInfo().getimageComponentCount());
            for (n = 0; n < n2; ++n) {
                if (!Resource.zeroTrim(mR_FLASH_COMP_INFOArray[n].getname()).equals("BIOS")) continue;
                stringBuffer.append(Resource.zeroTrim(mR_FLASH_COMP_INFOArray[n].getversion()));
            }
            stringBuffer.append("\n");
            stringBuffer.append(Resource.getString("VER_APP", "APP  Version:"));
            stringBuffer.append(this.NoOfTabsToBeAdded(Resource.getString("VER_APP", "APP  Version:"), 20));
            for (n = 0; n < n2; ++n) {
                if (!Resource.zeroTrim(mR_FLASH_COMP_INFOArray[n].getname()).equals("APP")) continue;
                stringBuffer.append(Resource.zeroTrim(mR_FLASH_COMP_INFOArray[n].getversion()));
            }
            stringBuffer.append("\n");
            stringBuffer.append(Resource.getString("VER_PCLI", "PCLI Version:"));
            stringBuffer.append(this.NoOfTabsToBeAdded(Resource.getString("VER_PCLI", "PCLI Version:"), 20));
            for (n = 0; n < n2; ++n) {
                if (!Resource.zeroTrim(mR_FLASH_COMP_INFOArray[n].getname()).equals("PCLI")) continue;
                stringBuffer.append(Resource.zeroTrim(mR_FLASH_COMP_INFOArray[n].getversion()));
            }
            stringBuffer.append("\n");
            stringBuffer.append(Resource.getString("VER_BCON", "BCON Version:"));
            stringBuffer.append(this.NoOfTabsToBeAdded(Resource.getString("VER_BCON", "BCON Version:"), 20));
            for (n = 0; n < n2; ++n) {
                if (!Resource.zeroTrim(mR_FLASH_COMP_INFOArray[n].getname()).equals("BCON")) continue;
                stringBuffer.append(Resource.zeroTrim(mR_FLASH_COMP_INFOArray[n].getversion()));
            }
            stringBuffer.append("\n");
            stringBuffer.append(Resource.getString("VER_NVDATA", "NVDT Version:"));
            stringBuffer.append(this.NoOfTabsToBeAdded(Resource.getString("VER_NVDATA", "NVDT Version:"), 20));
            for (n = 0; n < n2; ++n) {
                if (!Resource.zeroTrim(mR_FLASH_COMP_INFOArray[n].getname()).equals("NVDT")) continue;
                stringBuffer.append(Resource.zeroTrim(mR_FLASH_COMP_INFOArray[n].getversion()));
            }
            stringBuffer.append("\n");
            stringBuffer.append(Resource.getString("VER_BTBL", "BTBL Version:"));
            stringBuffer.append(this.NoOfTabsToBeAdded(Resource.getString("VER_BTBL", "BTBL Version:"), 20));
            for (n = 0; n < n2; ++n) {
                if (!Resource.zeroTrim(mR_FLASH_COMP_INFOArray[n].getname()).equals("BTBL")) continue;
                stringBuffer.append(Resource.zeroTrim(mR_FLASH_COMP_INFOArray[n].getversion()));
            }
            stringBuffer.append("\n");
            stringBuffer.append(Resource.getString("VER_BOOT", "BOOT Version:"));
            stringBuffer.append(this.NoOfTabsToBeAdded(Resource.getString("VER_BOOT", "BOOT Version:"), 20));
            for (n = 0; n < n2; ++n) {
                if (!Resource.zeroTrim(mR_FLASH_COMP_INFOArray[n].getname()).equals("BOOT")) continue;
                stringBuffer.append(Resource.zeroTrim(mR_FLASH_COMP_INFOArray[n].getversion()));
            }
            stringBuffer.append("\n");
            stringBuffer.append(Resource.getString("NVRAM_SIZE", "NVRAM Size:"));
            stringBuffer.append(this.NoOfTabsToBeAdded(Resource.getString("NVRAM_SIZE", "NVRAM Size:"), 20));
            stringBuffer.append(KernelConstants.getConvertedSize(KernelConstants.getSizeInBlocks(this.adapter.getAdapterInfo().getnvramSize(), 1)));
            stringBuffer.append("\n");
            stringBuffer.append(Resource.getString("SUPP_RAIDS", "RAID Level:"));
            stringBuffer.append(this.NoOfTabsToBeAdded(Resource.getString("SUPP_RAIDS", "RAID Level:"), 20));
            if (this.adapter.getAdapterInfo().getraidLevels_MR_CTRL_INFO().getraidLevel_0() != 0) {
                stringBuffer.append("0 ");
            }
            if (this.adapter.getAdapterInfo().getraidLevels_MR_CTRL_INFO().getraidLevel_1() != 0) {
                stringBuffer.append("1 ");
            }
            if (this.adapter.getAdapterInfo().getraidLevels_MR_CTRL_INFO().getraidLevel_5() != 0) {
                stringBuffer.append("5 ");
            }
            if (this.adapter.getAdapterInfo().getraidLevels_MR_CTRL_INFO().getraidLevel_6() != 0) {
                stringBuffer.append("6 ");
            }
            if (this.adapter.getAdapterInfo().getraidLevels_MR_CTRL_INFO().getraidLevel_00_unsupported() == 0) {
                stringBuffer.append("00 ");
            }
            if (this.adapter.getAdapterInfo().getraidLevels_MR_CTRL_INFO().getraidLevel_10() != 0) {
                stringBuffer.append("10 ");
            }
            if (this.adapter.getAdapterInfo().getraidLevels_MR_CTRL_INFO().getraidLevel_50() != 0) {
                stringBuffer.append("50 ");
            }
            if (this.adapter.getAdapterInfo().getraidLevels_MR_CTRL_INFO().getraidLevel_60() != 0) {
                stringBuffer.append("60 ");
            }
            stringBuffer.append("\n");
            if (this.adapter.getAdapterInfo().gethwPresent_MR_CTRL_INFO().getmemory() != 0) {
                stringBuffer.append(Resource.getString("CACHE_SIZE", "Cache Size:"));
                stringBuffer.append(this.NoOfTabsToBeAdded(Resource.getString("CACHE_SIZE", "Cache Size:"), 20));
                stringBuffer.append(KernelConstants.getConvertedSize(KernelConstants.getSizeInBlocks(this.adapter.getAdapterInfo().getmemorySize(), 2)));
            }
            stringBuffer.append("\n");
            stringBuffer.append(Resource.getString("FLASH_SIZE", "Flash Size:"));
            stringBuffer.append(this.NoOfTabsToBeAdded(Resource.getString("FLASH_SIZE", "Flash Size:"), 20));
            if (this.adapter.getAdapterInfo().gethwPresent_MR_CTRL_INFO().getflash() != 0) {
                stringBuffer.append(KernelConstants.getConvertedSize(KernelConstants.getSizeInBlocks(this.adapter.getAdapterInfo().getflashSize(), 2)));
            }
            stringBuffer.append("\n");
            stringBuffer.append(Resource.getString("RCV_ERROR", "RCV Error:"));
            stringBuffer.append(this.NoOfTabsToBeAdded(Resource.getString("RCV_ERROR", "RCV Error:"), 20));
            stringBuffer.append(this.adapter.getAdapterInfo().getmemCorrectableErrorCount());
            stringBuffer.append("\n");
            stringBuffer.append(Resource.getString("UN_RCV_ERROR", "Un-RCV Error:"));
            stringBuffer.append(this.NoOfTabsToBeAdded(Resource.getString("UN_RCV_ERROR", "Un-RCV Error:"), 20));
            stringBuffer.append(this.adapter.getAdapterInfo().getmemUnCorrectableErrorCount());
            stringBuffer.append("\n");
            stringBuffer.append(Resource.getString("CLUSTER_SUPPORT", "Support Cluster:"));
            stringBuffer.append(this.NoOfTabsToBeAdded(Resource.getString("CLUSTER_SUPPORT", "Support Cluster:"), 20));
            if (this.adapter.getAdapterProperties().getclusterEnable() != '\u0000') {
                stringBuffer.append(Resource.getString("PROPERTY_YES_TEXT", "Yes"));
            } else {
                stringBuffer.append(Resource.getString("PROPERTY_NO_TEXT", "No"));
            }
            stringBuffer.append("\n");
            stringBuffer.append(Resource.getString("CLUSTER_MODE", "Cluster Mode:"));
            stringBuffer.append(this.NoOfTabsToBeAdded(Resource.getString("CLUSTER_MODE", "Cluster Mode:"), 20));
            if (this.adapter.getAdapterInfo().getclusterActive() != '\u0000') {
                stringBuffer.append(Resource.getString("ACTIVE_TEXT", "Active"));
            } else {
                stringBuffer.append(Resource.getString("INACTIVE_TEXT", "Inactive"));
            }
            stringBuffer.append("\n");
            stringBuffer.append("\n");
            stringBuffer.append(Resource.getString("TEXT_CTRL_PROP", "Controller Properties"));
            stringBuffer.append("\n");
            stringBuffer.append("-------------------------------------");
            stringBuffer.append("\n");
            stringBuffer.append(Resource.getString("REBUIL_DRATE_DSC", "Rebuild Rate"));
            stringBuffer.append(this.NoOfTabsToBeAdded(Resource.getString("REBUIL_DRATE_DSC", "Rebuild Rate"), 50));
            n = (short)((short)this.adapter.getAdapterProperties().getrebuildRate() >= 0 ? this.adapter.getAdapterProperties().getrebuildRate() : 256 + (short)this.adapter.getAdapterProperties().getrebuildRate());
            stringBuffer.append(": " + n);
            stringBuffer.append("\n");
            stringBuffer.append(Resource.getString("PATROL_READ_RATE_DSC", "Patrol Read Rate"));
            stringBuffer.append(this.NoOfTabsToBeAdded(Resource.getString("PATROL_READ_RATE_DSC", "Patrol Read Rate"), 50));
            stringBuffer.append(": " + this.adapter.getAdapterProperties().getpatrolReadRate());
            stringBuffer.append("\n");
            stringBuffer.append(Resource.getString("BGI_TEXT", "Back Ground Initialization(BGI) Rate"));
            stringBuffer.append(this.NoOfTabsToBeAdded(Resource.getString("BGI_TEXT", "Back Ground Initialization(BGI) Rate"), 50));
            stringBuffer.append(": " + this.adapter.getAdapterProperties().getbgiRate());
            stringBuffer.append("\n");
            stringBuffer.append(Resource.getString("CC_TEXT", "Consistency Check(CC) Rate"));
            stringBuffer.append(this.NoOfTabsToBeAdded(Resource.getString("CC_TEXT", "Consistency Check(CC) Rate"), 50));
            stringBuffer.append(": " + this.adapter.getAdapterProperties().getccRate());
            stringBuffer.append("\n");
            stringBuffer.append(Resource.getString("RECON_RATE_DSC", "Reconstruction Rate"));
            stringBuffer.append(this.NoOfTabsToBeAdded(Resource.getString("RECON_RATE_DSC", "Reconstruction Rate"), 50));
            stringBuffer.append(": " + this.adapter.getAdapterProperties().getreconRate());
            stringBuffer.append("\n");
            stringBuffer.append(Resource.getString("MAX_SPINUP_COUNT", "Maximum # of drives to spin up at one time"));
            stringBuffer.append(this.NoOfTabsToBeAdded(Resource.getString("MAX_SPINUP_COUNT", "Maximum # of drives to spin up at one time"), 50));
            stringBuffer.append(": " + this.adapter.getAdapterProperties().getspinupDriveCount());
            stringBuffer.append("\n");
            stringBuffer.append(Resource.getString("DELAY_SPINUP_GRP", "# of seconds to delay among spinup groups"));
            stringBuffer.append(this.NoOfTabsToBeAdded(Resource.getString("DELAY_SPINUP_GRP", "# of seconds to delay among spinup groups"), 50));
            stringBuffer.append(": " + this.adapter.getAdapterProperties().getspinupDelay());
            stringBuffer.append("\n");
            stringBuffer.append(Resource.getString("PROPERTY_CLUSTERENABLE_TEXT", "Cluster Enable"));
            stringBuffer.append(this.NoOfTabsToBeAdded(Resource.getString("PROPERTY_CLUSTERENABLE_TEXT", "Cluster Enable"), 50));
            if (this.adapter.getAdapterProperties().getclusterEnable() != '\u0000') {
                stringBuffer.append(": " + Resource.getString("PROPERTY_YES_TEXT", "Yes"));
            } else {
                stringBuffer.append(": " + Resource.getString("PROPERTY_NO_TEXT", "No"));
            }
            stringBuffer.append("\n");
            stringBuffer.append(Resource.getString("COERC_MODE", "Drive capacity coercion mode"));
            stringBuffer.append(this.NoOfTabsToBeAdded(Resource.getString("COERC_MODE", "Drive capacity coercion mode"), 50));
            char c2 = this.adapter.getAdapterProperties().getcoercionMode();
            switch (c2) {
                case '\u0000': {
                    stringBuffer.append(": " + Resource.getString("COER_MODE_NONE", "None"));
                    break;
                }
                case '\u0001': {
                    stringBuffer.append(": " + Resource.getString("COER_MODE_128MB", "128 MB"));
                    break;
                }
                case '\u0002': {
                    stringBuffer.append(": " + Resource.getString("COER_MODE_1GB", "1 GB"));
                }
            }
            stringBuffer.append("\n");
            stringBuffer.append(Resource.getString("ALRM_EN", "Alarm Enable"));
            stringBuffer.append(this.NoOfTabsToBeAdded(Resource.getString("ALRM_EN", "Alarm Enable"), 50));
            if (this.adapter.getAdapterProperties().getalarmEnable() != '\u0000') {
                stringBuffer.append(": " + Resource.getString("PROPERTY_YES_TEXT", "Yes"));
            } else {
                stringBuffer.append(": " + Resource.getString("PROPERTY_NO_TEXT", "No"));
            }
            stringBuffer.append("\n");
            stringBuffer.append(Resource.getString("DISBLE_AURORBLD", "Disable AutoRebuild"));
            stringBuffer.append(this.NoOfTabsToBeAdded(Resource.getString("DISBLE_AURORBLD", "Disable AutoRebuild"), 50));
            if (this.adapter.getAdapterProperties().getdisableAutoRebuild() != '\u0000') {
                stringBuffer.append(": " + Resource.getString("PROPERTY_YES_TEXT", "Yes"));
            } else {
                stringBuffer.append(": " + Resource.getString("PROPERTY_NO_TEXT", "No"));
            }
            stringBuffer.append("\n");
            stringBuffer.append(Resource.getString("BAT_DSBL_WARN", "Disable Battery Warning"));
            stringBuffer.append(this.NoOfTabsToBeAdded(Resource.getString("BAT_DSBL_WARN", "Disable Battery Warning"), 50));
            if (this.adapter.getAdapterProperties().getdisableBatteryWarning() != '\u0000') {
                stringBuffer.append(": " + Resource.getString("PROPERTY_YES_TEXT", "Yes"));
            } else {
                stringBuffer.append(": " + Resource.getString("PROPERTY_NO_TEXT", "No"));
            }
            stringBuffer.append("\n");
            stringBuffer.append(Resource.getString("REST_HSP", "Restore Hotspare on Insertion"));
            stringBuffer.append(this.NoOfTabsToBeAdded(Resource.getString("REST_HSP", "Restore Hotspare on Insertion"), 50));
            if (this.adapter.getAdapterProperties().getrestoreHotSpareOnInsertion() != '\u0000') {
                stringBuffer.append(": " + Resource.getString("PROPERTY_YES_TEXT", "Yes"));
            } else {
                stringBuffer.append(": " + Resource.getString("PROPERTY_NO_TEXT", "No"));
            }
            stringBuffer.append("\n");
            stringBuffer.append(Resource.getString("EXPOSE_DEV", "Expose Enclosure Devices"));
            stringBuffer.append(this.NoOfTabsToBeAdded(Resource.getString("EXPOSE_DEV", "Expose Enclosure Devices"), 50));
            if (this.adapter.getAdapterProperties().getexposeEnclosureDevices() != '\u0000') {
                stringBuffer.append(": " + Resource.getString("PROPERTY_YES_TEXT", "Yes"));
            } else {
                stringBuffer.append(": " + Resource.getString("PROPERTY_NO_TEXT", "No"));
            }
            stringBuffer.append("\n");
            stringBuffer.append("\n");
            stringBuffer.append(Resource.getString("BBU_PROP", "BBU Properties"));
            stringBuffer.append("\n");
            stringBuffer.append("-------------------------------------");
            stringBuffer.append("\n");
            if (this.adapter.getBBU() != null) {
                stringBuffer.append(Resource.getString("BBU_TYPE", "BBU Battery Type"));
                stringBuffer.append(this.NoOfTabsToBeAdded(Resource.getString("BBU_TYPE", "BBU Battery Type"), 50));
                stringBuffer.append(": " + this.adapter.getBBU().getBatteryType());
                stringBuffer.append("\n");
                stringBuffer.append(Resource.getString("BBU_VOLT", "BBU Voltage"));
                stringBuffer.append(this.NoOfTabsToBeAdded(Resource.getString("BBU_VOLT", "BBU Voltage"), 50));
                stringBuffer.append(": " + ((SASBatteryBackUp)this.adapter.getBBU().getDeviceObject()).getInformation().getStatus().getvoltage() + " mV");
                stringBuffer.append("\n");
                stringBuffer.append(Resource.getString("BBU_CURRENT", "BBU Current"));
                stringBuffer.append(this.NoOfTabsToBeAdded(Resource.getString("BBU_CURRENT", "BBU Current"), 50));
                stringBuffer.append(": " + ((SASBatteryBackUp)this.adapter.getBBU().getDeviceObject()).getInformation().getStatus().getcurrent() + " mA");
                stringBuffer.append("\n");
                stringBuffer.append(Resource.getString("BBU_TEMP", "BBU Temperature"));
                stringBuffer.append(this.NoOfTabsToBeAdded(Resource.getString("BBU_TEMP", "BBU Temperature"), 50));
                stringBuffer.append(": " + ((SASBatteryBackUp)this.adapter.getBBU().getDeviceObject()).getInformation().getStatus().gettemperature() + " C");
                stringBuffer.append("\n");
                stringBuffer.append(Resource.getString("IBBU_REL_CHARGE", "IBBU Relative State Of Charge"));
                stringBuffer.append(this.NoOfTabsToBeAdded(Resource.getString("IBBU_REL_CHARGE", "IBBU Relative State Of Charge"), 50));
                stringBuffer.append(": " + ((SASBatteryBackUp)this.adapter.getBBU().getDeviceObject()).getInformation().getCapacityInfo().getrelativeStateOfCharge() + " %");
                stringBuffer.append("\n");
                stringBuffer.append(Resource.getString("IBBU_CHARGE_CURR", "IBBU Charging Current"));
                stringBuffer.append(this.NoOfTabsToBeAdded(Resource.getString("IBBU_CHARGE_CURR", "IBBU Charging Current"), 50));
                stringBuffer.append(": " + ((SASBatteryBackUp)this.adapter.getBBU().getDeviceObject()).getInformation().getStatus().getcurrent() + " mA");
                stringBuffer.append("\n");
                stringBuffer.append(Resource.getString("IBBU_ABSL_CHARGE", "IBBU Absolute State Of Charge"));
                stringBuffer.append(this.NoOfTabsToBeAdded(Resource.getString("IBBU_ABSL_CHARGE", "IBBU Absolute State Of Charge"), 50));
                stringBuffer.append(": " + ((SASBatteryBackUp)this.adapter.getBBU().getDeviceObject()).getInformation().getCapacityInfo().getabsoluteStateOfCharge() + " %");
                stringBuffer.append("\n");
                stringBuffer.append("\n");
                stringBuffer.append(Resource.getString("BBU_FW_STAT", "BBU Firmware Status"));
                stringBuffer.append("\n");
                stringBuffer.append("-------------------------------------");
                stringBuffer.append("\n");
                stringBuffer.append(Resource.getString("VOLT_LOW", "voltageLow"));
                stringBuffer.append(this.NoOfTabsToBeAdded(Resource.getString("VOLT_LOW", "voltageLow"), 50));
                if ((((SASBatteryBackUp)this.adapter.getBBU().getDeviceObject()).getInformation().getStatus().getfwStatus() & 2) != 0) {
                    stringBuffer.append(": " + Resource.getString("PROPERTY_YES_TEXT", "Yes"));
                } else {
                    stringBuffer.append(": " + Resource.getString("PROPERTY_NO_TEXT", "No"));
                }
                stringBuffer.append("\n");
                stringBuffer.append(Resource.getString("TEMP_HIGH", "temperatureHigh"));
                stringBuffer.append(this.NoOfTabsToBeAdded(Resource.getString("TEMP_HIGH", "temperatureHigh"), 50));
                if ((((SASBatteryBackUp)this.adapter.getBBU().getDeviceObject()).getInformation().getStatus().getfwStatus() & 4) != 0) {
                    stringBuffer.append(": " + Resource.getString("PROPERTY_YES_TEXT", "Yes"));
                } else {
                    stringBuffer.append(": " + Resource.getString("PROPERTY_NO_TEXT", "No"));
                }
                stringBuffer.append("\n");
                stringBuffer.append(Resource.getString("LRN_CYC_REQ", "learnCycleRequested"));
                stringBuffer.append(this.NoOfTabsToBeAdded(Resource.getString("LRN_CYC_REQ", "learnCycleRequested"), 50));
                if ((((SASBatteryBackUp)this.adapter.getBBU().getDeviceObject()).getInformation().getStatus().getfwStatus() & 0x20) != 0) {
                    stringBuffer.append(": " + Resource.getString("PROPERTY_YES_TEXT", "Yes"));
                } else {
                    stringBuffer.append(": " + Resource.getString("PROPERTY_NO_TEXT", "No"));
                }
                stringBuffer.append("\n");
                stringBuffer.append(Resource.getString("LRN_CYC_ACT", "learnCycleActive"));
                stringBuffer.append(this.NoOfTabsToBeAdded(Resource.getString("LRN_CYC_ACT", "learnCycleActive"), 50));
                if ((((SASBatteryBackUp)this.adapter.getBBU().getDeviceObject()).getInformation().getStatus().getfwStatus() & 0x40) != 0) {
                    stringBuffer.append(": " + Resource.getString("PROPERTY_YES_TEXT", "Yes"));
                } else {
                    stringBuffer.append(": " + Resource.getString("PROPERTY_NO_TEXT", "No"));
                }
                stringBuffer.append("\n");
                stringBuffer.append(Resource.getString("LRN_CYC_FAIL", "learnCycleFailed"));
                stringBuffer.append(this.NoOfTabsToBeAdded(Resource.getString("LRN_CYC_FAIL", "learnCycleFailed"), 50));
                if ((((SASBatteryBackUp)this.adapter.getBBU().getDeviceObject()).getInformation().getStatus().getfwStatus() & 0x80) != 0) {
                    stringBuffer.append(": " + Resource.getString("PROPERTY_YES_TEXT", "Yes"));
                } else {
                    stringBuffer.append(": " + Resource.getString("PROPERTY_NO_TEXT", "No"));
                }
                stringBuffer.append("\n");
                stringBuffer.append(Resource.getString("LRN_CYC_TMOUT", "learnCycleTimeout"));
                stringBuffer.append(this.NoOfTabsToBeAdded(Resource.getString("LRN_CYC_TMOUT", "learnCycleTimeout"), 50));
                if ((((SASBatteryBackUp)this.adapter.getBBU().getDeviceObject()).getInformation().getStatus().getfwStatus() & 0x100) != 0) {
                    stringBuffer.append(": " + Resource.getString("PROPERTY_YES_TEXT", "Yes"));
                } else {
                    stringBuffer.append(": " + Resource.getString("PROPERTY_NO_TEXT", "No"));
                }
                stringBuffer.append("\n");
            }
            return stringBuffer;
        }
        catch (Exception exception) {
            return stringBuffer;
        }
    }

    public StringBuffer getPhysicalDriveInfo() {
        StringBuffer stringBuffer = new StringBuffer(Resource.getString("RAID_CTRL_TEXT_", "Device"));
        stringBuffer.append(Resource.getString("INFO", "Information"));
        stringBuffer.append("\n");
        stringBuffer.append("=================================");
        stringBuffer.append("\n");
        stringBuffer.append("\n");
        try {
            PhysicalDriveHelper[] physicalDriveHelperArray = this.adapter.getPhysicalDrives();
            for (int i = 0; i < physicalDriveHelperArray.length; ++i) {
                short s = physicalDriveHelperArray[i].getUserDataBlockSize();
                stringBuffer.append(Resource.getString("DEV_NAME", "Device Name"));
                stringBuffer.append(this.NoOfTabsToBeAdded(Resource.getString("DEV_NAME", "Device Name"), 50));
                stringBuffer.append(": " + ((SASPhysicalDrive)physicalDriveHelperArray[i].getDeviceObject()).getVendorInfo());
                stringBuffer.append("\n");
                stringBuffer.append(Resource.getString("PROPERTY_PRODUCTID_TEXT", "Product Id"));
                stringBuffer.append(this.NoOfTabsToBeAdded(Resource.getString("PROPERTY_PRODUCTID_TEXT", "Product Id"), 50));
                stringBuffer.append(": " + ((SASPhysicalDrive)physicalDriveHelperArray[i].getDeviceObject()).getProductInfo());
                stringBuffer.append("\n");
                stringBuffer.append(Resource.getString("REV", "Rev"));
                stringBuffer.append(this.NoOfTabsToBeAdded(Resource.getString("REV", "Rev"), 50));
                stringBuffer.append(": " + ((SASPhysicalDrive)physicalDriveHelperArray[i].getDeviceObject()).getProductRevisionLevel());
                stringBuffer.append("\n");
                stringBuffer.append(Resource.getString("VENDOR_SPEC", "Vendor Specific"));
                stringBuffer.append(this.NoOfTabsToBeAdded(Resource.getString("VENDOR_SPEC", "Vendor Specific"), 50));
                stringBuffer.append(": " + new String(((SASPhysicalDrive)physicalDriveHelperArray[i].getDeviceObject()).GetPDInquiryData(), 36, 32).trim());
                stringBuffer.append("\n");
                stringBuffer.append(Resource.getString("PROPERTY_DEVICETYPE_TEXT", "Device Type"));
                stringBuffer.append(this.NoOfTabsToBeAdded(Resource.getString("PROPERTY_DEVICETYPE_TEXT", "Device Type"), 50));
                byte by = (byte)((SASPhysicalDrive)physicalDriveHelperArray[i].getDeviceObject()).getInformation().getscsiDevType();
                if (by == 5) {
                    stringBuffer.append(": " + Resource.getString("DEV_CDROM_TEXT", "CDROM"));
                } else if (by == 0) {
                    stringBuffer.append(": " + Resource.getString("DEV_DIRECT_TEXT", "Disk"));
                } else if (by == 1) {
                    stringBuffer.append(": " + Resource.getString("DEV_TAPE_TEXT", "TAPE"));
                }
                stringBuffer.append("\n");
                stringBuffer.append(Resource.getString("PROPERTY_DEVICEID_TEXT", "Device ID"));
                stringBuffer.append(this.NoOfTabsToBeAdded(Resource.getString("PROPERTY_DEVICEID_TEXT", "Device ID"), 50));
                stringBuffer.append(": " + ((SASPhysicalDrive)physicalDriveHelperArray[i].getDeviceObject()).getDeviceId());
                stringBuffer.append("\n");
                stringBuffer.append(Resource.getString("SASADDR0", "SAS Address 0"));
                stringBuffer.append(this.NoOfTabsToBeAdded(Resource.getString("SASADDR0", "SAS Address 0"), 50));
                if (((SASPhysicalDrive)physicalDriveHelperArray[i].getDeviceObject()).getInformation().getpathInfo_MR_PD_INFO1().getsasAddr().length != 0) {
                    stringBuffer.append(": 0x" + Long.toHexString(((SASPhysicalDrive)physicalDriveHelperArray[i].getDeviceObject()).getInformation().getpathInfo_MR_PD_INFO1().getsasAddr()[0]).toUpperCase());
                } else {
                    stringBuffer.append(" ");
                }
                stringBuffer.append("\n");
                stringBuffer.append(Resource.getString("SASADDR1", "SAS Address 1"));
                stringBuffer.append(this.NoOfTabsToBeAdded(Resource.getString("SASADDR1", "SAS Address 1"), 50));
                if (((SASPhysicalDrive)physicalDriveHelperArray[i].getDeviceObject()).getInformation().getpathInfo_MR_PD_INFO1().getsasAddr().length != 0) {
                    stringBuffer.append(": 0x" + Long.toHexString(((SASPhysicalDrive)physicalDriveHelperArray[i].getDeviceObject()).getInformation().getpathInfo_MR_PD_INFO1().getsasAddr()[1]).toUpperCase());
                } else {
                    stringBuffer.append(" ");
                }
                stringBuffer.append("\n");
                stringBuffer.append(Resource.getString("MED_ERR", "Media Error"));
                stringBuffer.append(this.NoOfTabsToBeAdded(Resource.getString("MED_ERR", "Media Error"), 50));
                stringBuffer.append(": " + ((SASPhysicalDrive)physicalDriveHelperArray[i].getDeviceObject()).getInformation().getmediaErrCount());
                stringBuffer.append("\n");
                stringBuffer.append(Resource.getString("OTH_ERR", "Other Error"));
                stringBuffer.append(this.NoOfTabsToBeAdded(Resource.getString("OTH_ERR", "Other Error"), 50));
                stringBuffer.append(": " + ((SASPhysicalDrive)physicalDriveHelperArray[i].getDeviceObject()).getInformation().getotherErrCount());
                stringBuffer.append("\n");
                stringBuffer.append(Resource.getString("PRED_FAIL", "PredictiveFail"));
                stringBuffer.append(this.NoOfTabsToBeAdded(Resource.getString("PRED_FAIL", "PredictiveFail"), 50));
                stringBuffer.append(": " + ((SASPhysicalDrive)physicalDriveHelperArray[i].getDeviceObject()).getInformation().getpredFailCount());
                stringBuffer.append("\n");
                stringBuffer.append(Resource.getString("PROPERTY_FWSTATE_TEXT", "Firmware State"));
                stringBuffer.append(this.NoOfTabsToBeAdded(Resource.getString("PROPERTY_FWSTATE_TEXT", "Firmware State"), 50));
                stringBuffer.append(": " + physicalDriveHelperArray[i].getState());
                stringBuffer.append("\n");
                stringBuffer.append(Resource.getString("PROPERTY_FAN_SPEED_TEXT", "Speed"));
                stringBuffer.append(this.NoOfTabsToBeAdded(Resource.getString("PROPERTY_FAN_SPEED_TEXT", "Speed"), 50));
                stringBuffer.append(": " + physicalDriveHelperArray[i].getDeviceLinkSpeed(((SASPhysicalDrive)physicalDriveHelperArray[i].getDeviceObject()).getInformation().getdeviceSpeed()));
                stringBuffer.append("\n");
                stringBuffer.append(Resource.getString("DDFS", "DDF State"));
                stringBuffer.append(this.NoOfTabsToBeAdded(Resource.getString("DDFS", "DDF State"), 50));
                stringBuffer.append(": " + physicalDriveHelperArray[i].getPDDriveType());
                stringBuffer.append("\n");
                stringBuffer.append(Resource.getString("PRIM_DEF", "Primary Defect"));
                stringBuffer.append(this.NoOfTabsToBeAdded(Resource.getString("PRIM_DEF", "Primary Defect"), 50));
                stringBuffer.append(": NA");
                stringBuffer.append("\n");
                stringBuffer.append(Resource.getString("GRO_DEF", "Grown Defect"));
                stringBuffer.append(this.NoOfTabsToBeAdded(Resource.getString("GRO_DEF", "Grown Defect"), 50));
                stringBuffer.append(": NA");
                stringBuffer.append("\n");
                stringBuffer.append(Resource.getString("PROPERTY_RAWSIZE_TEXT", "Raw size"));
                stringBuffer.append(this.NoOfTabsToBeAdded(Resource.getString("PROPERTY_RAWSIZE_TEXT", "Raw size"), 50));
                stringBuffer.append(": " + KernelConstants.getConvertedSize(((SASPhysicalDrive)physicalDriveHelperArray[i].getDeviceObject()).getInformation().getrawSize(), s));
                stringBuffer.append("\n");
                stringBuffer.append(Resource.getString("PROPERTY_NON_COERCEDSIZE_TEXT", "Non-coerced size"));
                stringBuffer.append(this.NoOfTabsToBeAdded(Resource.getString("PROPERTY_NON_COERCEDSIZE_TEXT", "Non-coerced size"), 50));
                stringBuffer.append(": " + KernelConstants.getConvertedSize(((SASPhysicalDrive)physicalDriveHelperArray[i].getDeviceObject()).getInformation().getnonCoercedSize(), s));
                stringBuffer.append("\n");
                stringBuffer.append(Resource.getString("PROPERTY_COERCEDSIZE_TEXT", "Coerced size"));
                stringBuffer.append(this.NoOfTabsToBeAdded(Resource.getString("PROPERTY_COERCEDSIZE_TEXT", "Coerced size"), 50));
                stringBuffer.append(": " + KernelConstants.getConvertedSize(((SASPhysicalDrive)physicalDriveHelperArray[i].getDeviceObject()).getInformation().getcoercedSize(), s));
                stringBuffer.append("\n");
                stringBuffer.append(Resource.getString("ENC_IND", "Enclosure index"));
                stringBuffer.append(this.NoOfTabsToBeAdded(Resource.getString("ENC_IND", "Enclosure index"), 50));
                stringBuffer.append(": " + ((SASPhysicalDrive)physicalDriveHelperArray[i].getDeviceObject()).getInformation().getenclIndex());
                stringBuffer.append("\n");
                stringBuffer.append(Resource.getString("PATH_C", "Path Count"));
                stringBuffer.append(this.NoOfTabsToBeAdded(Resource.getString("PATH_C", "Path Count"), 50));
                stringBuffer.append(": " + ((SASPhysicalDrive)physicalDriveHelperArray[i].getDeviceObject()).getInformation().getpathInfo_MR_PD_INFO1().getcount());
                stringBuffer.append("\n");
                stringBuffer.append(Resource.getString("PROPERTY_SLOT_NUMBER", "Slot Number"));
                stringBuffer.append(this.NoOfTabsToBeAdded(Resource.getString("PROPERTY_SLOT_NUMBER", "Slot Number"), 50));
                stringBuffer.append(": " + ((SASPhysicalDrive)physicalDriveHelperArray[i].getDeviceObject()).getInformation().getslotNumber());
                stringBuffer.append("\n");
                stringBuffer.append("\n");
                stringBuffer.append("-----------------------------------------------------------------");
                stringBuffer.append("\n");
                stringBuffer.append("\n");
            }
            return stringBuffer;
        }
        catch (Exception exception) {
            return stringBuffer;
        }
    }

    public StringBuffer getLogicalDriveInfo() {
        StringBuffer stringBuffer = new StringBuffer(Resource.getString("LOGICAL_RAID_CTRL_TEXT_", "Logical Drive"));
        stringBuffer.append(" " + Resource.getString("INFO", "Information"));
        stringBuffer.append("\n");
        stringBuffer.append("=================================");
        stringBuffer.append("\n");
        stringBuffer.append("\n");
        try {
            LogicalDriveHelper[] logicalDriveHelperArray = this.adapter.getLogicalDrives();
            stringBuffer.append(Resource.getString("NUM_LDS", "# of Logical Drives"));
            stringBuffer.append(this.NoOfTabsToBeAdded(Resource.getString("NUM_LDS", "# of Logical Drives"), 50));
            stringBuffer.append(": " + logicalDriveHelperArray.length);
            stringBuffer.append("\n");
            stringBuffer.append("\n");
            for (int i = 0; i < logicalDriveHelperArray.length; ++i) {
                PhysicalDriveHelper[] physicalDriveHelperArray = logicalDriveHelperArray[i].getPDListInLd();
                short s = physicalDriveHelperArray[0].getUserDataBlockSize();
                stringBuffer.append(Resource.getString("LD_TEXT", "Logical Drive# "));
                stringBuffer.append(this.NoOfTabsToBeAdded(Resource.getString("LD_TEXT", "Logical Drive# "), 50));
                stringBuffer.append(": " + ((SASLogicalDrive)logicalDriveHelperArray[i].getDeviceObject()).getID());
                stringBuffer.append("\n");
                stringBuffer.append(Resource.getString("LD_ID", "Target ID"));
                stringBuffer.append(this.NoOfTabsToBeAdded(Resource.getString("LD_ID", "Target ID"), 50));
                stringBuffer.append(": " + ((SASLogicalDrive)logicalDriveHelperArray[i].getDeviceObject()).getID());
                stringBuffer.append("\n");
                stringBuffer.append(Resource.getString("LD_SIZE", "Size"));
                stringBuffer.append(this.NoOfTabsToBeAdded(Resource.getString("LD_SIZE", "Size"), 50));
                stringBuffer.append(": " + KernelConstants.getConvertedSize(((SASLogicalDrive)logicalDriveHelperArray[i].getDeviceObject()).getInformation().getsize(), s));
                stringBuffer.append("\n");
                stringBuffer.append(Resource.getString("LD_NAME", "Logical Drive name"));
                stringBuffer.append(this.NoOfTabsToBeAdded(Resource.getString("LD_NAME", "Logical Drive name"), 50));
                stringBuffer.append(": " + ((SASLogicalDrive)logicalDriveHelperArray[i].getDeviceObject()).getName());
                stringBuffer.append("\n");
                stringBuffer.append(Resource.getString("DEF_RD_POLICY", "Default Read Policy"));
                stringBuffer.append(this.NoOfTabsToBeAdded(Resource.getString("DEF_RD_POLICY", "Default Read Policy"), 50));
                switch (((SASLogicalDrive)logicalDriveHelperArray[i].getDeviceObject()).getReadPolicy()) {
                    case 12: {
                        stringBuffer.append(": " + Resource.getString("READ_AHEAD_ALWAYS", "Read Ahead Always"));
                        break;
                    }
                    case 4: {
                        stringBuffer.append(": " + Resource.getString("READ_AHEAD_ALWAYS", "Read Ahead Always"));
                        break;
                    }
                    default: {
                        stringBuffer.append(": " + Resource.getString("READ_AHEAD_NONE", "No Read Ahead"));
                    }
                }
                stringBuffer.append("\n");
                stringBuffer.append(Resource.getString("PROPERTY_DEFWRITEPOLICY_TEXT", "Default Write Policy"));
                stringBuffer.append(this.NoOfTabsToBeAdded(Resource.getString("PROPERTY_DEFWRITEPOLICY_TEXT", "Default Write Policy"), 50));
                switch (((SASLogicalDrive)logicalDriveHelperArray[i].getDeviceObject()).getDefaultWritePolicy()) {
                    case 2: {
                        stringBuffer.append(": " + Resource.getString("WRITEPOLICY_WRITE_ADAPTIVE", "Write Adaptive"));
                        break;
                    }
                    case 1: {
                        stringBuffer.append(": " + Resource.getString("WRITEPOLICY_WRITE_BACK_WITH_BBU", "Write Back with BBU"));
                        break;
                    }
                    case 0: {
                        stringBuffer.append(": " + Resource.getString("WRITEPOLICY_WRITE_THROUGH", "Write Through"));
                        break;
                    }
                    case 17: {
                        stringBuffer.append(": " + Resource.getString("WRITEPOLICY_ALWAYS_WRITE_BACK"));
                        break;
                    }
                    default: {
                        stringBuffer.append(": ");
                    }
                }
                stringBuffer.append("\n");
                stringBuffer.append(Resource.getString("DEF_CH_POLICY", "Default Cache Policy"));
                stringBuffer.append(this.NoOfTabsToBeAdded(Resource.getString("DEF_CH_POLICY", "Default Cache Policy"), 50));
                switch (((SASLogicalDrive)logicalDriveHelperArray[i].getDeviceObject()).getIOCachePolicy()) {
                    case 96: {
                        stringBuffer.append(": " + Resource.getString("IOPOLICY_CACHED", "Cached IO"));
                        break;
                    }
                    case 0: {
                        stringBuffer.append(": " + Resource.getString("IOPOLICY_DIRECT", "Direct IO"));
                        break;
                    }
                    default: {
                        stringBuffer.append(": ");
                    }
                }
                stringBuffer.append("\n");
                stringBuffer.append(Resource.getString("CURR_RD_POLICY=", "Current Read Policy"));
                stringBuffer.append(this.NoOfTabsToBeAdded(Resource.getString("CURR_RD_POLICY=", "Current Read Policy"), 50));
                switch (((SASLogicalDrive)logicalDriveHelperArray[i].getDeviceObject()).getReadPolicy()) {
                    case 12: {
                        stringBuffer.append(": " + Resource.getString("READ_AHEAD_ALWAYS", "Read Ahead Always"));
                        break;
                    }
                    case 4: {
                        stringBuffer.append(": " + Resource.getString("READ_AHEAD_ALWAYS", "Read Ahead Always"));
                        break;
                    }
                    default: {
                        stringBuffer.append(": " + Resource.getString("READ_AHEAD_NONE", "No Read Ahead"));
                    }
                }
                stringBuffer.append("\n");
                stringBuffer.append(Resource.getString("CURR_WR_POLICY=", "Current Write Policy"));
                stringBuffer.append(this.NoOfTabsToBeAdded(Resource.getString("CURR_WR_POLICY=", "Current Write Policy"), 50));
                switch (((SASLogicalDrive)logicalDriveHelperArray[i].getDeviceObject()).getWritePolicy()) {
                    case 2: {
                        stringBuffer.append(": " + Resource.getString("WRITEPOLICY_WRITE_ADAPTIVE", "Write Adaptive"));
                        break;
                    }
                    case 1: {
                        stringBuffer.append(": " + Resource.getString("WRITEPOLICY_WRITE_BACK", "Write Back"));
                        break;
                    }
                    case 0: {
                        stringBuffer.append(": " + Resource.getString("WRITEPOLICY_WRITE_THROUGH", "Write Through"));
                        break;
                    }
                    case 16: {
                        stringBuffer.append(": " + Resource.getString("WRITEPOLICY_WRITE_BACK", "Write Back"));
                        break;
                    }
                    default: {
                        stringBuffer.append(": ");
                    }
                }
                stringBuffer.append("\n");
                stringBuffer.append(Resource.getString("CURR_CH_POLICY=", "Current Cache Policy"));
                stringBuffer.append(this.NoOfTabsToBeAdded(Resource.getString("CURR_CH_POLICY=", "Current Cache Policy"), 50));
                switch (((SASLogicalDrive)logicalDriveHelperArray[i].getDeviceObject()).getIOCachePolicy()) {
                    case 96: {
                        stringBuffer.append(": " + Resource.getString("IOPOLICY_CACHED", "Cached IO"));
                        break;
                    }
                    case 0: {
                        stringBuffer.append(": " + Resource.getString("IOPOLICY_DIRECT", "Direct IO"));
                        break;
                    }
                    default: {
                        stringBuffer.append(": ");
                    }
                }
                stringBuffer.append("\n");
                stringBuffer.append(Resource.getString("PDCACH_POL", "PD Cache Policy"));
                stringBuffer.append(this.NoOfTabsToBeAdded(Resource.getString("PDCACH_POL", "PD Cache Policy"), 50));
                switch (((SASLogicalDrive)logicalDriveHelperArray[i].getDeviceObject()).getDefaultCachePolicy()) {
                    case 2: {
                        stringBuffer.append(": " + Resource.getString("DISK_CACHE_DISABLED", "Disabled"));
                        break;
                    }
                    case 0: {
                        stringBuffer.append(": " + Resource.getString("PD_CACHE_UNCHANGED", "Unchanged"));
                        break;
                    }
                    case 1: {
                        stringBuffer.append(": " + Resource.getString("DISK_CACHE_ENABLED", "Enabled"));
                        break;
                    }
                    default: {
                        stringBuffer.append(": ");
                    }
                }
                stringBuffer.append("\n");
                stringBuffer.append(Resource.getString("ACCESSPOLICY_DSC", "Access Policy"));
                stringBuffer.append(this.NoOfTabsToBeAdded(Resource.getString("ACCESSPOLICY_DSC", "Access Policy"), 50));
                switch (((SASLogicalDrive)logicalDriveHelperArray[i].getDeviceObject()).getInformation().getldConfig().getproperties().getaccessPolicy()) {
                    case '\u0002': {
                        stringBuffer.append(": " + Resource.getString("LD_ACCESS_RDONLY", "Read Only"));
                        break;
                    }
                    case '\u0000': {
                        stringBuffer.append(": " + Resource.getString("LD_ACCESS_RDWRITE", "Read Write"));
                        break;
                    }
                    case '\u0003': {
                        stringBuffer.append(": " + Resource.getString("LD_ACCESS_BLOCKED", "Blocked"));
                        break;
                    }
                    default: {
                        stringBuffer.append(": ");
                    }
                }
                stringBuffer.append("\n");
                stringBuffer.append(Resource.getString("BACK_GROUNDINIT_DSC", "Background Initialization"));
                stringBuffer.append(this.NoOfTabsToBeAdded(Resource.getString("BACK_GROUNDINIT_DSC", "Background Initialization"), 50));
                switch ((byte)((SASLogicalDrive)logicalDriveHelperArray[i].getDeviceObject()).getInformation().getldConfig().getproperties().getnoBGI()) {
                    case 1: {
                        stringBuffer.append(": " + Resource.getString("DISK_CACHE_DISABLED", "Disabled"));
                        break;
                    }
                    case 0: {
                        stringBuffer.append(": " + Resource.getString("DISK_CACHE_ENABLED", "Enabled"));
                        break;
                    }
                    default: {
                        stringBuffer.append(": ");
                    }
                }
                stringBuffer.append("\n");
                stringBuffer.append(Resource.getString("PRM_RL", "Primary RAID Level"));
                stringBuffer.append(this.NoOfTabsToBeAdded(Resource.getString("PRM_RL", "Primary RAID Level"), 50));
                stringBuffer.append(": " + ((SASLogicalDrive)logicalDriveHelperArray[i].getDeviceObject()).getInformation().getldConfig().getparams().getPRL());
                stringBuffer.append("\n");
                stringBuffer.append(Resource.getString("RLQ", "RAID Level Qualifier"));
                stringBuffer.append(this.NoOfTabsToBeAdded(Resource.getString("RLQ", "RAID Level Qualifier"), 50));
                stringBuffer.append(": " + ((SASLogicalDrive)logicalDriveHelperArray[i].getDeviceObject()).getInformation().getldConfig().getparams().getRLQ());
                stringBuffer.append("\n");
                stringBuffer.append(Resource.getString("SRL", "Secondary RAID Level"));
                stringBuffer.append(this.NoOfTabsToBeAdded(Resource.getString("SRL", "Secondary RAID Level"), 50));
                stringBuffer.append(": " + ((SASLogicalDrive)logicalDriveHelperArray[i].getDeviceObject()).getInformation().getldConfig().getparams().getSRL());
                stringBuffer.append("\n");
                stringBuffer.append(Resource.getString("STRP_SZ_DDF", "Stripe Size per DDF"));
                stringBuffer.append(this.NoOfTabsToBeAdded(Resource.getString("STRP_SZ_DDF", "Stripe Size per DDF"), 50));
                stringBuffer.append(": " + ((SASLogicalDrive)logicalDriveHelperArray[i].getDeviceObject()).getInformation().getldConfig().getparams().getstripeSize());
                stringBuffer.append("\n");
                stringBuffer.append(Resource.getString("NUM_DRV_SPN", "# of drivers per span"));
                stringBuffer.append(this.NoOfTabsToBeAdded(Resource.getString("NUM_DRV_SPN", "# of drivers per span"), 50));
                stringBuffer.append(": " + ((SASLogicalDrive)logicalDriveHelperArray[i].getDeviceObject()).getInformation().getldConfig().getparams().getnumDrives() / ((SASLogicalDrive)logicalDriveHelperArray[i].getDeviceObject()).getInformation().getldConfig().getparams().getspanDepth());
                stringBuffer.append("\n");
                stringBuffer.append(Resource.getString("NUM_SPAN", "# of spans"));
                stringBuffer.append(this.NoOfTabsToBeAdded(Resource.getString("NUM_SPAN", "# of spans"), 50));
                stringBuffer.append(": " + ((SASLogicalDrive)logicalDriveHelperArray[i].getDeviceObject()).getInformation().getldConfig().getparams().getspanDepth());
                stringBuffer.append("\n");
                for (int j = 0; j < ((SASLogicalDrive)logicalDriveHelperArray[i].getDeviceObject()).getInformation().getldConfig().getparams().getspanDepth(); ++j) {
                    stringBuffer.append(Resource.getString("SPAN_NUM_TEXT", "Span#"));
                    stringBuffer.append(this.NoOfTabsToBeAdded(Resource.getString("SPAN_NUM_TEXT", "Span#"), 20));
                    stringBuffer.append(": " + j);
                    stringBuffer.append("\n");
                    stringBuffer.append(Resource.getString("START_BLOC", "Start Block"));
                    stringBuffer.append(this.NoOfTabsToBeAdded(Resource.getString("START_BLOC", "Start Block"), 20));
                    stringBuffer.append(": " + KernelConstants.getConvertedSize(((SASLogicalDrive)logicalDriveHelperArray[i].getDeviceObject()).getInformation().getldConfig().getspan()[j].getstartBlock(), s));
                    stringBuffer.append("\n");
                    stringBuffer.append(Resource.getString("NUM_BLOCS", "# blocks"));
                    stringBuffer.append(this.NoOfTabsToBeAdded(Resource.getString("NUM_BLOCS", "# blocks"), 20));
                    stringBuffer.append(": " + KernelConstants.getConvertedSize(((SASLogicalDrive)logicalDriveHelperArray[i].getDeviceObject()).getInformation().getldConfig().getspan()[j].getnumBlocks(), s));
                    stringBuffer.append("\n");
                    stringBuffer.append(Resource.getString("ARR_INDX", "Array Index"));
                    stringBuffer.append(this.NoOfTabsToBeAdded(Resource.getString("ARR_INDX", "Array Index"), 20));
                    stringBuffer.append(": " + KernelConstants.getConvertedSize(((SASLogicalDrive)logicalDriveHelperArray[i].getDeviceObject()).getInformation().getldConfig().getspan()[j].getarrayRef(), s));
                    stringBuffer.append("\n");
                }
                stringBuffer.append(Resource.getString("INIT_PROG", "Init Progress State"));
                stringBuffer.append(this.NoOfTabsToBeAdded(Resource.getString("INIT_PROG", "Init Progress State"), 20));
                switch ((byte)((SASLogicalDrive)logicalDriveHelperArray[i].getDeviceObject()).getInformation().getldConfig().getparams().getinitState()) {
                    case 0: {
                        stringBuffer.append(": " + Resource.getString("NO_INIT_TEXT_PROGRESS", "No init in Progress"));
                        break;
                    }
                    case 1: {
                        stringBuffer.append(": " + Resource.getString("FAST_INIT_TEXT_PROGRESS", "Fast init in Progress"));
                        break;
                    }
                    case 2: {
                        stringBuffer.append(": " + Resource.getString("FULL_INIT_TEXT_PROGRESS", "Full init in Progress"));
                        break;
                    }
                    default: {
                        stringBuffer.append(": ");
                    }
                }
                stringBuffer.append("\n");
                stringBuffer.append(Resource.getString("STATE_FIELD", "State"));
                stringBuffer.append(this.NoOfTabsToBeAdded(Resource.getString("STATE_FIELD", "State"), 50));
                stringBuffer.append(": " + logicalDriveHelperArray[i].getState());
                stringBuffer.append("\n");
                stringBuffer.append(Resource.getString("CONSISTENCY", "Consistency"));
                stringBuffer.append(this.NoOfTabsToBeAdded(Resource.getString("CONSISTENCY", "Consistency"), 50));
                switch ((byte)((SASLogicalDrive)logicalDriveHelperArray[i].getDeviceObject()).getInformation().getldConfig().getparams().getISConsistent()) {
                    case 0: {
                        stringBuffer.append(": " + Resource.getString("NO_CONSISTENT_LD", "LD is not consistent"));
                        break;
                    }
                    case 1: {
                        stringBuffer.append(": " + Resource.getString("CONSISTENT_LD", "LD is consistent"));
                        break;
                    }
                    default: {
                        stringBuffer.append(": ");
                    }
                }
                stringBuffer.append("\n");
                stringBuffer.append("\n");
                stringBuffer.append("-------------------------------------------");
                stringBuffer.append("\n");
                stringBuffer.append("\n");
            }
            return stringBuffer;
        }
        catch (Exception exception) {
            return stringBuffer;
        }
    }

    public StringBuffer getEventInfo() {
        StringBuffer stringBuffer = new StringBuffer(Resource.getString("NV_HIST", "NVRAM Event History"));
        stringBuffer.append("\n");
        stringBuffer.append("=================================");
        stringBuffer.append("\n");
        stringBuffer.append("\n");
        try {
            int n;
            MR_EVT_LOG_INFO mR_EVT_LOG_INFO = ((SASAdapter)this.adapter.getDeviceObject()).getAenSequenceInfo();
            stringBuffer.append(Resource.getString("EVT_SEQ_INFO", "EVENT SEQUENCE INFORMATION"));
            stringBuffer.append("\n");
            stringBuffer.append("-------------------------------------");
            stringBuffer.append("\n");
            stringBuffer.append("\n");
            stringBuffer.append(Resource.getString("SEQ_NEW", "Sequence # of newest event in the log"));
            stringBuffer.append(this.NoOfTabsToBeAdded(Resource.getString("SEQ_NEW", "Sequence # of newest event in the log"), 50));
            stringBuffer.append(": " + mR_EVT_LOG_INFO.getnewestSeqNum());
            stringBuffer.append("\n");
            stringBuffer.append(Resource.getString("SEQ_OLD", "Sequence # of oldest event in the log"));
            stringBuffer.append(this.NoOfTabsToBeAdded(Resource.getString("SEQ_OLD", "Sequence # of oldest event in the log"), 50));
            stringBuffer.append(": " + mR_EVT_LOG_INFO.getoldestSeqNum());
            stringBuffer.append("\n");
            stringBuffer.append(Resource.getString("SEQ_LAS_LOG", "Sequence # of last log clear"));
            stringBuffer.append(this.NoOfTabsToBeAdded(Resource.getString("SEQ_LAS_LOG", "Sequence # of last log clear"), 50));
            stringBuffer.append(": " + mR_EVT_LOG_INFO.getclearSeqNum());
            stringBuffer.append("\n");
            stringBuffer.append(Resource.getString("SEQ_CLN_SHUT", "Sequence # of last clean shutdown"));
            stringBuffer.append(this.NoOfTabsToBeAdded(Resource.getString("SEQ_CLN_SHUT", "Sequence # of last clean shutdown"), 50));
            stringBuffer.append(": " + mR_EVT_LOG_INFO.getshutdownSeqNum());
            stringBuffer.append("\n");
            stringBuffer.append(Resource.getString("SEQ_SESS_BOOT", "Sequence # of this session boot"));
            stringBuffer.append(this.NoOfTabsToBeAdded(Resource.getString("SEQ_SESS_BOOT", "Sequence # of this session boot"), 50));
            stringBuffer.append(": " + mR_EVT_LOG_INFO.getbootSeqNum());
            stringBuffer.append("\n");
            stringBuffer.append("\n");
            stringBuffer.append(Resource.getString("EVT_DET", "EVENT DETAILS"));
            stringBuffer.append("\n");
            stringBuffer.append("-------------------------------------");
            stringBuffer.append("\n");
            stringBuffer.append("\n");
            MR_EVT_CLASS_LOCALE mR_EVT_CLASS_LOCALE = new MR_EVT_CLASS_LOCALE();
            mR_EVT_CLASS_LOCALE.setlocale((short)-1);
            mR_EVT_CLASS_LOCALE.seteventClass((byte)0);
            int n2 = 0;
            int n3 = mR_EVT_LOG_INFO.getoldestSeqNum();
            int n4 = n = mR_EVT_LOG_INFO.getnewestSeqNum() - n3 + 1;
            while (n4 > 0) {
                int n5 = 0;
                n5 = n4 > 32 ? 8200 : 264 + (n4 - 1) * 256;
                MR_EVT_LIST mR_EVT_LIST = ((SASAdapter)this.adapter.getDeviceObject()).getEventList(n3, mR_EVT_CLASS_LOCALE, n5);
                if (mR_EVT_LIST == null) break;
                for (int i = 0; i < mR_EVT_LIST.getcount(); ++i) {
                    stringBuffer.append(++n2 + ":");
                    MR_TIME_STAMP mR_TIME_STAMP = KernelConstants.getTimeStamp(mR_EVT_LIST.getEvent()[i].gettimeStamp());
                    stringBuffer.append(" " + mR_TIME_STAMP.getyear() + "-" + (mR_TIME_STAMP.getmonth() + 1) + "-" + mR_TIME_STAMP.getday() + "," + mR_TIME_STAMP.gethour() + ":" + mR_TIME_STAMP.getmin() + ":" + mR_TIME_STAMP.getsec());
                    switch (mR_EVT_LIST.getEvent()[i].getcl().geteventClass()) {
                        case 0: {
                            stringBuffer.append(" " + Resource.getString("INFO", "Information"));
                            break;
                        }
                        case 1: {
                            stringBuffer.append(" " + Resource.getString("WARN", "Warning"));
                            break;
                        }
                        case 2: {
                            stringBuffer.append(" " + Resource.getString("CRTL", "Critical"));
                            break;
                        }
                        case 3: {
                            stringBuffer.append(" " + Resource.getString("FATAL", "Fatal"));
                            break;
                        }
                        case 4: {
                            stringBuffer.append(" " + Resource.getString("DEAD", "Dead"));
                            break;
                        }
                    }
                    stringBuffer.append(": " + Resource.zeroTrim(mR_EVT_LIST.getEvent()[i].getdescription()));
                    stringBuffer.append("\n");
                }
                if (mR_EVT_LIST.getcount() >= 32) {
                    n4 -= mR_EVT_LIST.getcount();
                    n3 += mR_EVT_LIST.getcount();
                    continue;
                }
                n4 = 0;
            }
            return stringBuffer;
        }
        catch (Exception exception) {
            return stringBuffer;
        }
    }

    public String NoOfTabsToBeAdded(String string, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = string.length();
        if ((n2 = n - n2) > 0) {
            for (int n3 = 0; n3 < n2; n3 = (int)((byte)(n3 + 1))) {
                stringBuffer.append(" ");
            }
            return stringBuffer.toString();
        }
        return "";
    }

    public void resetEnabledOperations() {
        this.enabledOperations.clear();
    }

    class CreateCSACacheCadeAction
    implements ActionListener {
        CreateCSACacheCadeAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                WizardController wizardController = new WizardController();
                HashMap hashMap = wizardController.getWizardData();
                hashMap.put("AdapterHelper", AdapterDetailPanel.this.adapter);
                AdvanceConfigEngine advanceConfigEngine = new AdvanceConfigEngine(AdapterDetailPanel.this.adapter);
                hashMap.put("AdvanceConfigEngine", advanceConfigEngine);
                wizardController.addPage(CSAModeSelectionPage.class.getName(), "CSAModeSelectionPage");
                wizardController.addPage(CSADriveGroupCreationPage.class.getName(), "CSADriveGroupCreationPage");
                wizardController.addPage(CSAVirtualDiskCreationPage.class.getName(), "CSAVirtualDiskCreationPage");
                wizardController.addPage(CSAConfigurationSummaryPage.class.getName(), "CSAConfigurationSummaryPage");
                wizardController.addPage(CSABootVolumeCreationPage.class.getName(), "CSABootVolumeCreationPage");
                wizardController.setFirstPage("CSADriveGroupCreationPage");
                try {
                    if (AdapterDetailPanel.this.adapter.getAdapterInfo().getadapterOperationsEx_MR_CTRL_INFO().getSupportDataLDonSSCArray() != 0) {
                        wizardController.setFirstPage("CSAModeSelectionPage");
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                wizardController.addPageTransition("CSAModeSelectionPage", 0, "CSADriveGroupCreationPage");
                wizardController.addPageTransition("CSAHolesUnconfigPdSelectionPage", 2, "CSAVirtualDiskCreationPage");
                wizardController.addPageTransition("CSAHolesUnconfigPdSelectionPage", 3, "CSADriveGroupCreationPage");
                wizardController.addPageTransition("CSADriveGroupCreationPage", 0, "CSAVirtualDiskCreationPage");
                wizardController.addPageTransition("CSAVirtualDiskCreationPage", 0, "CSAConfigurationSummaryPage");
                wizardController.addPageTransition("CSAModeSelectionPage", 1, "CSABootVolumeCreationPage");
                wizardController.addPageTransition("CSABootVolumeCreationPage", 0, "CSAConfigurationSummaryPage");
                wizardController.launchWizard();
            }
            catch (WizardNavigationException wizardNavigationException) {
                wizardNavigationException.printStackTrace();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    class CreateSSCAction
    implements ActionListener {
        CreateSSCAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                WizardController wizardController = new WizardController();
                HashMap hashMap = wizardController.getWizardData();
                hashMap.put("AdapterHelper", AdapterDetailPanel.this.adapter);
                AdvanceConfigEngine advanceConfigEngine = new AdvanceConfigEngine(AdapterDetailPanel.this.adapter);
                hashMap.put("AdvanceConfigEngine", advanceConfigEngine);
                wizardController.addPage(SSCHolesUnconfigPdSelectionPage.class.getName(), "SSCHolesUnconfigPdSelectionPage");
                wizardController.addPage(SSCDriveGroupCreationPage.class.getName(), "SSCDriveGroupCreationPage");
                wizardController.addPage(SSCVirtualDiskCreationPage.class.getName(), "SSCVirtualDiskCreationPage");
                wizardController.addPage(SSCConfigurationSummaryPage.class.getName(), "SSCConfigurationSummaryPage");
                wizardController.setFirstPage("SSCDriveGroupCreationPage");
                wizardController.addPageTransition("SSCHolesUnconfigPdSelectionPage", 2, "SSCVirtualDiskCreationPage");
                wizardController.addPageTransition("SSCHolesUnconfigPdSelectionPage", 3, "SSCDriveGroupCreationPage");
                wizardController.addPageTransition("SSCDriveGroupCreationPage", 0, "SSCVirtualDiskCreationPage");
                wizardController.addPageTransition("SSCVirtualDiskCreationPage", 0, "SSCConfigurationSummaryPage");
                wizardController.launchWizard();
            }
            catch (WizardNavigationException wizardNavigationException) {
                wizardNavigationException.printStackTrace();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

