/*
 * Decompiled with CFR 0.152.
 */
package GUI;

import GUI.GroupInitializeDialog;
import GUIHelper.AdapterHelper;
import GUIHelper.GUIHelperInterface;
import GUIHelper.LogicalDriveHelper;
import KernelServices.NotifyObject;
import SASKernel.LibraryAPI.StoreLib.MR_EVT_DETAIL;
import SASKernel.Operations.OperationDetails;
import SASKernel.SASAdapter.SASAdapter;
import SASKernel.SASLogical.SASLogicalDrive;
import SASKernel.SASLogical.SASLogicalDriveOperationsAllowed;
import Utils.ColorHash;
import Utils.CustomMsgBox;
import Utils.HelpContextResourse;
import Utils.Resource;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Observable;
import java.util.Observer;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

class AdapterInitTab
extends JPanel
implements Observer {
    private ArrayList allLogicalDrives = new ArrayList();
    private JCheckBox[] allCheckBoxes;
    private JCheckBox fastInit;
    private AdapterHelper m_adapterHelper;
    private JPanel grid = new JPanel();
    private String[] mnemonics;
    private final GroupInitializeDialog parent;
    private JButton m_deselectAll = null;
    private JButton m_selectAll = null;
    private JButton m_checkCons = null;
    private ArrayList<LogicalDriveHelper> OSLogicalDrives = new ArrayList();
    private ArrayList selectedLdIdList = new ArrayList();
    private ArrayList<LogicalDriveHelper> m_selectedLdList = new ArrayList();
    ActionListener CheckBoxActionListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n = AdapterInitTab.this.getNumSelectedVDs();
            AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
            boolean bl = abstractButton.getModel().isSelected();
            if (bl) {
                AdapterInitTab.this.m_checkCons.setEnabled(true);
                AdapterInitTab.this.m_deselectAll.setEnabled(true);
                AdapterInitTab.this.m_selectAll.setEnabled(true);
                if (n == AdapterInitTab.this.allCheckBoxes.length) {
                    AdapterInitTab.this.m_selectAll.setEnabled(false);
                }
            } else if (n == 0) {
                AdapterInitTab.this.m_checkCons.setEnabled(false);
                AdapterInitTab.this.m_selectAll.setEnabled(true);
                AdapterInitTab.this.m_deselectAll.setEnabled(false);
            } else if (n != 0) {
                AdapterInitTab.this.m_checkCons.setEnabled(true);
                AdapterInitTab.this.m_selectAll.setEnabled(true);
                AdapterInitTab.this.m_deselectAll.setEnabled(true);
            }
            AdapterInitTab.this.setSelectedLdList();
            AdapterInitTab.this.allowFullFGInit();
        }
    };

    public AdapterInitTab(AdapterHelper adapterHelper, final GroupInitializeDialog groupInitializeDialog) {
        this.m_adapterHelper = adapterHelper;
        this.parent = groupInitializeDialog;
        JPanel jPanel = new JPanel(new BorderLayout());
        this.grid.setLayout(new BoxLayout(this.grid, 3));
        this.grid.setBorder(BorderFactory.createTitledBorder(Resource.getString("MSG_SELCCLDRIVE_TEXT", "Select Virtual Disks :")));
        this.grid.setBackground(ColorHash.getColor("LIGHT_BACKGROUND"));
        this.setLayout(new BorderLayout());
        jPanel.add((Component)new JScrollPane(this.grid), "Center");
        JPanel jPanel2 = new JPanel();
        jPanel2.setBackground(ColorHash.getColor("LIGHT_BACKGROUND"));
        jPanel2.setBorder(BorderFactory.createTitledBorder(Resource.getString("MSG_INITTYPE_TEXT", "Initialization Type :")));
        this.mnemonics = Resource.getResourceMnemonic(Resource.getString("GRPINIT_CHECKBOX_FASTINIT_TEXT", "Fast Initialization"));
        this.fastInit = new JCheckBox(this.mnemonics[0]);
        this.fastInit.setToolTipText(Resource.getString("GRPINIT_CHECKBOX_FASTINIT_DSC", "Fast Initialization"));
        if (this.mnemonics.length == 2) {
            this.fastInit.setMnemonic(this.mnemonics[1].charAt(0));
        }
        this.fastInit.setOpaque(false);
        jPanel2.add(this.fastInit);
        jPanel.add((Component)jPanel2, "South");
        this.add((Component)jPanel, "Center");
        JPanel jPanel3 = new JPanel();
        this.mnemonics = Resource.getResourceMnemonic(Resource.getString("BUTTON_SELECTALL_TEXT", "Select All"));
        this.m_selectAll = new JButton(this.mnemonics[0]);
        if (this.mnemonics.length == 2) {
            this.m_selectAll.setMnemonic(this.mnemonics[1].charAt(0));
        }
        this.m_selectAll.setToolTipText(Resource.getString("BUTTON_SELECTALL_DSC", "Select All"));
        this.mnemonics = Resource.getResourceMnemonic(Resource.getString("BUTTON_DESELECTALL_TEXT", "Deselect All"));
        this.m_deselectAll = new JButton(this.mnemonics[0]);
        if (this.mnemonics.length == 2) {
            this.m_deselectAll.setMnemonic(this.mnemonics[1].charAt(0));
        }
        this.m_deselectAll.setToolTipText(Resource.getString("BUTTON_DESELECTALL_DSC", "Deselect All"));
        this.m_selectAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                for (int i = 0; i < AdapterInitTab.this.allCheckBoxes.length; ++i) {
                    AdapterInitTab.this.allCheckBoxes[i].setSelected(true);
                }
                AdapterInitTab.this.m_selectAll.setEnabled(false);
                AdapterInitTab.this.m_deselectAll.setEnabled(true);
                AdapterInitTab.this.m_checkCons.setEnabled(true);
                AdapterInitTab.this.setSelectedLdList();
                AdapterInitTab.this.allowFullFGInit();
            }
        });
        this.mnemonics = Resource.getResourceMnemonic(Resource.getString("BUTTON_START", "Start"));
        this.m_checkCons = new JButton(this.mnemonics[0]);
        if (this.mnemonics.length == 2) {
            this.m_checkCons.setMnemonic(this.mnemonics[1].charAt(0));
        }
        this.m_checkCons.setToolTipText(Resource.getString("BUTTON_INIT_START_DSC", "Intialization Start"));
        this.m_deselectAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                for (int i = 0; i < AdapterInitTab.this.allCheckBoxes.length; ++i) {
                    AdapterInitTab.this.allCheckBoxes[i].setSelected(false);
                }
                AdapterInitTab.this.m_selectAll.setEnabled(true);
                AdapterInitTab.this.m_deselectAll.setEnabled(false);
                AdapterInitTab.this.m_checkCons.setEnabled(false);
                AdapterInitTab.this.setSelectedLdList();
                AdapterInitTab.this.allowFullFGInit();
            }
        });
        this.m_checkCons.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n;
                LogicalDriveHelper[] logicalDriveHelperArray = AdapterInitTab.this.m_adapterHelper.getLogicalDrives();
                AdapterInitTab.this.stopObserving();
                boolean bl = false;
                for (int i = 0; i < AdapterInitTab.this.allCheckBoxes.length; ++i) {
                    if (AdapterInitTab.this.allCheckBoxes[i] == null || !AdapterInitTab.this.allCheckBoxes[i].isSelected()) continue;
                    LogicalDriveHelper logicalDriveHelper = (LogicalDriveHelper)AdapterInitTab.this.allLogicalDrives.get(i);
                    for (int j = 0; j < logicalDriveHelperArray.length; ++j) {
                        if (((SASLogicalDrive)logicalDriveHelperArray[j].getDeviceObject()).getID() == ((SASLogicalDrive)logicalDriveHelper.getDeviceObject()).getID()) {
                            bl = false;
                            break;
                        }
                        bl = true;
                    }
                    if (!bl) continue;
                    if (!CustomMsgBox.confirm(Resource.getString("MSG_LDINIT_REFRSH_VD", "VD list is not updated! Do you want to update?"))) {
                        return;
                    }
                    AdapterInitTab.this.refresh();
                    return;
                }
                if (AdapterInitTab.this.getNumSelectedVDs() > 0 && !CustomMsgBox.confirmWithCheck(Resource.getString("MSG_LDGPINIT_DATA_LOST", "<html>Initialization operation will be started on the selected Virtual Disk(s) <br>This operation results in data loss and may take some time to complete.<br> When operation is in progress, you will not be able to perform any other task.<br> <br>Are you sure you want to proceed?</HTML>"))) {
                    return;
                }
                ArrayList<LogicalDriveHelper> arrayList = new ArrayList<LogicalDriveHelper>();
                for (n = 0; n < AdapterInitTab.this.allCheckBoxes.length; ++n) {
                    if (AdapterInitTab.this.allCheckBoxes[n] == null || !AdapterInitTab.this.allCheckBoxes[n].isSelected()) continue;
                    LogicalDriveHelper logicalDriveHelper = (LogicalDriveHelper)AdapterInitTab.this.allLogicalDrives.get(n);
                    if (logicalDriveHelper.isOSDrive()) {
                        arrayList.add(logicalDriveHelper);
                        AdapterInitTab.this.OSLogicalDrives.add(logicalDriveHelper);
                        continue;
                    }
                    logicalDriveHelper.issueOperation(new OperationDetails(9, new Boolean(!AdapterInitTab.this.fastInit.isSelected())));
                }
                n = arrayList.size();
                if (n > 0) {
                    StringBuffer stringBuffer = new StringBuffer();
                    for (int n2 = 0; n2 < n; n2 = (int)((short)(n2 + 1))) {
                        stringBuffer.append(((LogicalDriveHelper)arrayList.get(n2)).getDeviceObject().getID() + ",");
                    }
                    stringBuffer.deleteCharAt(stringBuffer.length() - 1);
                    Object[] objectArray = new Object[]{new String(stringBuffer.toString())};
                    if (n > 1) {
                        new CustomMsgBox(MessageFormat.format(Resource.getString("DS_NO_INIT_OS_VD_S", "Virtual Drives({0}) are OS drives. These virtual drives cannot be initialized."), objectArray));
                    } else {
                        new CustomMsgBox(MessageFormat.format(Resource.getString("DS_NO_INIT_OS_VD", "Virtual Drive({0}) is an OS drive. This virtual drive cannot be initialized."), objectArray));
                    }
                }
                AdapterInitTab.this.refresh();
            }
        });
        this.refresh();
        this.mnemonics = Resource.getResourceMnemonic(Resource.getString("BUTTON_CLOSE", "Close"));
        JButton jButton = new JButton(this.mnemonics[0]);
        if (this.mnemonics.length == 2) {
            jButton.setMnemonic(this.mnemonics[1].charAt(0));
        }
        jButton.setToolTipText(Resource.getString("BUTTON_CLOSE_DSC_1", "Close Intialization Operation"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                groupInitializeDialog.closeOpt();
            }
        });
        jPanel3.add(this.m_selectAll);
        jPanel3.add(this.m_deselectAll);
        jPanel3.add(this.m_checkCons);
        jPanel3.add(jButton);
        this.add((Component)jPanel3, "South");
    }

    private int getNumSelectedVDs() {
        int n = 0;
        int n2 = this.allCheckBoxes.length;
        for (int i = 0; i < n2; ++i) {
            if (this.allCheckBoxes[i] == null || !this.allCheckBoxes[i].isSelected()) continue;
            ++n;
        }
        return n;
    }

    private void refresh() {
        int n;
        this.grid.removeAll();
        this.allLogicalDrives.clear();
        LogicalDriveHelper[] logicalDriveHelperArray = this.m_adapterHelper.getLogicalDrives();
        if (logicalDriveHelperArray.length == 0) {
            this.m_selectAll.setEnabled(false);
            this.m_deselectAll.setEnabled(false);
            this.m_checkCons.setEnabled(false);
        } else {
            this.m_selectAll.setEnabled(true);
            this.m_deselectAll.setEnabled(false);
            this.m_checkCons.setEnabled(false);
        }
        for (n = 0; n < logicalDriveHelperArray.length; ++n) {
            try {
                if (!((SASLogicalDrive)logicalDriveHelperArray[n].getDeviceObject()).getAllAllowedOperations().isOperationAllowed(9)) continue;
                this.allLogicalDrives.add(logicalDriveHelperArray[n]);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.allCheckBoxes = new JCheckBox[this.allLogicalDrives.size()];
        for (n = 0; n < this.allCheckBoxes.length; ++n) {
            LogicalDriveHelper logicalDriveHelper = (LogicalDriveHelper)this.allLogicalDrives.get(n);
            if (this.OSLogicalDrives.contains(logicalDriveHelper)) continue;
            this.allCheckBoxes[n] = new JCheckBox(logicalDriveHelper.getText());
            this.allCheckBoxes[n].addActionListener(this.CheckBoxActionListener);
            this.allCheckBoxes[n].setOpaque(false);
            this.grid.add(this.allCheckBoxes[n]);
            if (!this.selectedLdIdList.contains(logicalDriveHelper.getDeviceObject().getID())) continue;
            this.allCheckBoxes[n].setSelected(true);
            this.m_checkCons.setEnabled(true);
            this.m_deselectAll.setEnabled(true);
        }
        this.validate();
        this.repaint();
        for (n = 0; n < this.m_adapterHelper.getLogicalDrives().length; ++n) {
            this.m_adapterHelper.getLogicalDrives()[n].addObserver(this);
        }
    }

    @Override
    public void update(Observable observable, Object object) {
        GUIHelperInterface gUIHelperInterface = (GUIHelperInterface)((Object)observable);
        NotifyObject notifyObject = (NotifyObject)object;
        MR_EVT_DETAIL mR_EVT_DETAIL = (MR_EVT_DETAIL)notifyObject.getNotifyObject();
        if (mR_EVT_DETAIL != null) {
            System.out.println("GroupInit Received AEN : " + new String(mR_EVT_DETAIL.getdescription()).trim());
        }
        switch (mR_EVT_DETAIL.getcode()) {
            case 52: 
            case 65: 
            case 69: 
            case 77: {
                break;
            }
            default: {
                this.stopObserving();
                this.setSelectedLdIdList();
                this.refresh();
                this.selectedLdIdList.clear();
            }
        }
    }

    private void stopObserving() {
        for (int i = 0; i < this.m_adapterHelper.getLogicalDrives().length; ++i) {
            this.m_adapterHelper.getLogicalDrives()[i].deleteObserver(this);
        }
    }

    public String getHelpPage() {
        if (this.m_adapterHelper.isCSA()) {
            return HelpContextResourse.getHelpPageName("MSM_CSA_RUNNING_A_GROUP_INITIALIZATION");
        }
        if (((SASAdapter)this.m_adapterHelper.getDeviceObject()).getAdapterType() == 1) {
            return HelpContextResourse.getHelpPageName("");
        }
        return HelpContextResourse.getHelpPageName("");
    }

    public void setSelectedLdIdList() {
        for (int i = 0; i < this.allCheckBoxes.length; ++i) {
            LogicalDriveHelper logicalDriveHelper = (LogicalDriveHelper)this.allLogicalDrives.get(i);
            if (!this.allCheckBoxes[i].isSelected()) continue;
            this.selectedLdIdList.add(logicalDriveHelper.getDeviceObject().getID());
        }
    }

    public void setSelectedLdList() {
        this.m_selectedLdList = new ArrayList();
        for (int i = 0; i < this.allCheckBoxes.length; ++i) {
            LogicalDriveHelper logicalDriveHelper = (LogicalDriveHelper)this.allLogicalDrives.get(i);
            if (!this.allCheckBoxes[i].isSelected()) continue;
            this.m_selectedLdList.add(logicalDriveHelper);
        }
    }

    private void allowFullFGInit() {
        boolean bl = false;
        for (int i = 0; i < this.m_selectedLdList.size(); ++i) {
            LogicalDriveHelper logicalDriveHelper = this.m_selectedLdList.get(i);
            try {
                SASLogicalDrive sASLogicalDrive = (SASLogicalDrive)logicalDriveHelper.getDeviceObject();
                SASLogicalDriveOperationsAllowed sASLogicalDriveOperationsAllowed = sASLogicalDrive.getAllAllowedOperations();
                if (!sASLogicalDriveOperationsAllowed.canfullFGDisallow()) continue;
                bl = true;
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (bl) {
            this.fastInit.setSelected(true);
            this.fastInit.setEnabled(false);
            this.fastInit.setForeground(Color.BLACK);
        } else {
            this.fastInit.setSelected(false);
            this.fastInit.setEnabled(true);
        }
    }
}

