/*
 * Decompiled with CFR 0.152.
 */
package GUI;

import GUI.CSA.ManageCSACachingDialog;
import GUI.ConfigFileManager;
import GUI.FirmwareDialog;
import GUI.ManagePowerSettingsPanel;
import GUI.ManageSSDCachingDialog;
import GUI.PatrolReadPropDialog;
import GUI.PreservedCache.ManagePreservedCacheDialog;
import GUI.PreservedCache.PreservedCachePresent;
import GUI.VivaldiStartupDialog;
import GUI.makeDrivesUnconfiguredGood;
import GUI.security.DisableEncryptionErrorDialog;
import GUI.venus.configuration.ConfigurationSummaryPage;
import GUI.venus.configuration.DriveGroupSelectionPage;
import GUI.venus.configuration.JBODToUnconfiguredGoodConversion;
import GUI.venus.configuration.ModeSelectionPage;
import GUI.venus.configuration.advanced.AdvanceConfigEngine;
import GUI.venus.configuration.advanced.DriveGroupCreationPage;
import GUI.venus.configuration.advanced.VirtualDiskCreationPage;
import GUI.venus.configuration.simple.SimpleConfigEngine;
import GUI.venus.configuration.simple.VirtualDriveSettingsPage;
import GUI.venus.wizard.WizardController;
import GUI.venus.wizard.WizardNavigationException;
import GUIHelper.AdapterHelper;
import GUIHelper.LogicalDriveHelper;
import GUIHelper.PhysicalDriveHelper;
import KernelExceptions.VKOperationFailedException;
import SASKernel.LibraryAPI.StoreLib.SL_DRIVE_DISTRIBUTION_T;
import SASKernel.Operations.OperationDetails;
import SASKernel.SASAdapter.SASAdapter;
import SASKernel.SASLogical.SASLogicalDrive;
import Utils.CustomMsgBox;
import Utils.Resource;
import Wizard.ForeignConfigWizard.ForeignConfigActionListener;
import Wizard.controllerSecurityWizard.EKMS.ChangeSecuritySettingsPage;
import Wizard.controllerSecurityWizard.EKMS.KeyManagementModeSelectionPage;
import Wizard.controllerSecurityWizard.SecurityBasedOperations;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.JOptionPane;

public class AdapterMenuListener
implements ActionListener {
    private AdapterHelper adapter;

    public AdapterMenuListener(AdapterHelper adapterHelper) {
        this.adapter = adapterHelper;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        int n = -1;
        try {
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        block10 : switch (n) {
            case 1120: {
                if (this.adapter.isEKMSPossible()) {
                    new KeyManagementModeSelectionPage(this.adapter);
                    break;
                }
                new SecurityBasedOperations(this.adapter, false);
                break;
            }
            case 1121: {
                Vector vector = this.adapter.getSecuredArrays();
                if (vector != null && vector.size() > 0) {
                    DisableEncryptionErrorDialog disableEncryptionErrorDialog = new DisableEncryptionErrorDialog(this.adapter, vector);
                    break;
                }
                StringBuffer stringBuffer = new StringBuffer(Resource.getString("LABEL_CONTROLLER", "Controller:"));
                stringBuffer.append(" ");
                stringBuffer.append(this.adapter.getText());
                stringBuffer.append("\n\n");
                Object[] objectArray = new Object[1];
                boolean bl = false;
                PhysicalDriveHelper[] physicalDriveHelperArray = this.adapter.getPhysicalDrives();
                for (int i = 0; i < physicalDriveHelperArray.length; ++i) {
                    if (!physicalDriveHelperArray[i].isFDECapable()) continue;
                    bl = true;
                    break;
                }
                objectArray[0] = bl ? " " + Resource.getString("MESSAGE_ALL_FDE_DRIVES_ERASED", "and all secure unconfigured FDE\ndrives will be securely erased") : "";
                stringBuffer.append(MessageFormat.format(Resource.getString("MESSAGE_CONFIRM_DISABLE_ENCRYPTION"), objectArray));
                if (JOptionPane.showConfirmDialog(VivaldiStartupDialog.mainScreen, stringBuffer.toString(), Resource.getString("TITLE_CONFIRM_DISABLE_DRIVE_SECURITY", "Confirm Disable Drive Security"), 0, 2) != 0) break;
                this.adapter.fireDestroyKeyOperation();
                break;
            }
            case 1122: {
                if (this.adapter.isEKMSPossible()) {
                    new ChangeSecuritySettingsPage(this.adapter);
                    break;
                }
                new SecurityBasedOperations(this.adapter, false);
                break;
            }
            case 1100: {
                try {
                    SimpleConfigEngine simpleConfigEngine = new SimpleConfigEngine(this.adapter);
                    AdvanceConfigEngine advanceConfigEngine = new AdvanceConfigEngine(this.adapter);
                    WizardController wizardController = new WizardController();
                    HashMap hashMap = wizardController.getWizardData();
                    hashMap.put("isSimpleAllowed", true);
                    hashMap.put("SimpleConfigEngine", simpleConfigEngine);
                    if (this.isConversionAllowedJBODtoUCG()) {
                        hashMap.put("JBODToUnconfiguredGoodConversion", this.adapter);
                    }
                    hashMap.put("AdapterHelper", this.adapter);
                    hashMap.put("WarningDialogTitle", Resource.getString("CONFIG_CONFIRMATION_TITLE", "Create virtual Drive - Confirmation"));
                    hashMap.put("AdvanceConfigEngine", advanceConfigEngine);
                    wizardController.addPage(JBODToUnconfiguredGoodConversion.class.getName(), "JBODToUnconfiguredGoodConversion");
                    wizardController.addPage(ModeSelectionPage.class.getName(), "ModeSelectionPage");
                    wizardController.addPage(DriveGroupSelectionPage.class.getName(), "DriveGroupSelectionPage");
                    wizardController.addPage(VirtualDriveSettingsPage.class.getName(), "VirtualDriveSettingsPage");
                    wizardController.addPage(DriveGroupCreationPage.class.getName(), "AdvanceDGCreationPage");
                    wizardController.addPage(VirtualDiskCreationPage.class.getName(), "AdvanceVDCreationPage");
                    wizardController.addPage(ConfigurationSummaryPage.class.getName(), "ConfigurationSummaryPage");
                    if (this.isConversionAllowedJBODtoUCG()) {
                        wizardController.setFirstPage("JBODToUnconfiguredGoodConversion");
                        wizardController.addPageTransition("JBODToUnconfiguredGoodConversion", 0, "ModeSelectionPage");
                    } else {
                        wizardController.setFirstPage("ModeSelectionPage");
                    }
                    wizardController.addPageTransition("ModeSelectionPage", 0, "DriveGroupSelectionPage");
                    wizardController.addPageTransition("ModeSelectionPage", 1, "VirtualDriveSettingsPage");
                    wizardController.addPageTransition("DriveGroupSelectionPage", 0, "ConfigurationSummaryPage");
                    wizardController.addPageTransition("DriveGroupSelectionPage", 1, "VirtualDriveSettingsPage");
                    wizardController.addPageTransition("VirtualDriveSettingsPage", 0, "ConfigurationSummaryPage");
                    wizardController.addPageTransition("ModeSelectionPage", 2, "AdvanceDGCreationPage");
                    wizardController.addPageTransition("DriveGroupSelectionPage", 2, "AdvanceVDCreationPage");
                    wizardController.addPageTransition("DriveGroupSelectionPage", 3, "AdvanceDGCreationPage");
                    wizardController.addPageTransition("AdvanceDGCreationPage", 0, "AdvanceVDCreationPage");
                    wizardController.addPageTransition("AdvanceVDCreationPage", 0, "ConfigurationSummaryPage");
                    wizardController.launchWizard();
                }
                catch (WizardNavigationException wizardNavigationException) {
                    wizardNavigationException.printStackTrace();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                break;
            }
            case 1116: {
                ConfigFileManager configFileManager = new ConfigFileManager(this.adapter);
                if (configFileManager.loadConfig()) break;
                new CustomMsgBox(Resource.getString("MSG_FAIL_ADD_CONFIG", "Add configuration failed"));
                break;
            }
            case 1117: {
                ConfigFileManager configFileManager = new ConfigFileManager(this.adapter);
                if (configFileManager.saveConfig()) break;
                new CustomMsgBox(Resource.getString("MSG_FAIL_SAVE_CONFIG", "Save configuration failed"));
                break;
            }
            case 1118: {
                LogicalDriveHelper[] logicalDriveHelperArray;
                Object object;
                OperationDetails operationDetails = new OperationDetails(12, null);
                try {
                    ((SASAdapter)this.adapter.getDeviceObject()).fireOperation(operationDetails);
                    object = (SL_DRIVE_DISTRIBUTION_T)operationDetails.getParam();
                    logicalDriveHelperArray = this.adapter.getLogicalDrives();
                    for (int i = 0; i < logicalDriveHelperArray.length; ++i) {
                        if (!logicalDriveHelperArray[i].isOSDrive((SL_DRIVE_DISTRIBUTION_T)object)) continue;
                        new CustomMsgBox(Resource.getString("MSG_CONFIG_OS_DRIVE_PRESENT", "This configuration contains atleast one OS drive. Configuration can not be cleared."));
                        return;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                object = new StringBuffer(Resource.getString("MSG_DELETE_CONFIG", "<html>You have chosen to clear the configuration.  This will<br>destroy all virtual disks.  All data on all virtual disks<br>will be lost"));
                logicalDriveHelperArray = Resource.getString("MSG_DELETE_CONFIG_CONFIRM_TITLE", "Confirm Clear Configuration");
                if (this.adapter.getAdapterInfo().getCacheIsPinned() != 0) {
                    ((StringBuffer)object).append(" " + Resource.getString("MSG_DELETE_CONFIG2", "and the preserved cache will be<br>discarded"));
                }
                SASAdapter sASAdapter = (SASAdapter)this.adapter.getDeviceObject();
                ((StringBuffer)object).append(".<br><br>");
                if (sASAdapter.getAdapterType() == 1) {
                    if (sASAdapter.getMrConfigAlloweOps().isClearConfigAllowed()) {
                        ((StringBuffer)object).append(Resource.getString("MSG_DELETE_CONFIG3", "Are you sure you want to clear the configuration?</html>"));
                        if (!CustomMsgBox.confirmWithCheck(VivaldiStartupDialog.mainScreen, (String)logicalDriveHelperArray, ((StringBuffer)object).toString())) {
                            return;
                        }
                        try {
                            sASAdapter.fireConfigOperation(new OperationDetails(2, null));
                        }
                        catch (VKOperationFailedException vKOperationFailedException) {
                            if (vKOperationFailedException.GetErrorCode() == 102) {
                                this.showConfirmLossOfCache(sASAdapter);
                                break;
                            }
                            CustomMsgBox.errorMsg(vKOperationFailedException);
                            vKOperationFailedException.printStackTrace();
                        }
                        catch (Exception exception) {
                            new CustomMsgBox(Resource.getString("MSG_CLEARCONFIG_FAILED", "Clear Configuration failed : Unknown Exception"));
                            exception.printStackTrace();
                        }
                        break;
                    }
                    ((StringBuffer)object).append(Resource.getString("MSG_DELETE_CONFIG4", "Note: There is currently data stored in the cache. Clearing<br>the configuration will permanently delete the cached data.<br><br>Are you sure you want to clear the configuration and<br>permanently lose the cached data?<br><br></html>"));
                    if (!CustomMsgBox.confirmWithCheck(VivaldiStartupDialog.mainScreen, (String)logicalDriveHelperArray, ((StringBuffer)object).toString(), "MR_CLEARING_CONFIGURATION_ON_CACHECADE_PRO_2.0_VIRTUAL_DRIVES")) {
                        return;
                    }
                    try {
                        sASAdapter.clearConfiguration();
                    }
                    catch (VKOperationFailedException vKOperationFailedException) {
                        CustomMsgBox.errorMsg(vKOperationFailedException);
                        vKOperationFailedException.printStackTrace();
                    }
                    break;
                }
                ((StringBuffer)object).append(Resource.getString("MSG_DELETE_CONFIG3", "Are you sure you want to clear the configuration?</html>"));
                if (!CustomMsgBox.confirmWithCheck(VivaldiStartupDialog.mainScreen, (String)logicalDriveHelperArray, ((StringBuffer)object).toString())) {
                    return;
                }
                try {
                    sASAdapter.fireConfigOperation(new OperationDetails(2, null));
                }
                catch (VKOperationFailedException vKOperationFailedException) {
                    CustomMsgBox.errorMsg(vKOperationFailedException);
                    vKOperationFailedException.printStackTrace();
                }
                catch (Exception exception) {
                    new CustomMsgBox(Resource.getString("MSG_CLEARCONFIG_FAILED", "Clear Configuration failed : Unknown Exception"));
                    exception.printStackTrace();
                }
                break;
            }
            case 1115: {
                new ForeignConfigActionListener(this.adapter).actionPerformed(actionEvent);
                break;
            }
            case 1119: {
                try {
                    new ManagePreservedCacheDialog(this.adapter);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                break;
            }
            case 1129: {
                try {
                    new PatrolReadPropDialog(this.adapter);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                break;
            }
            case 1123: {
                break;
            }
            case 1157: {
                try {
                    new makeDrivesUnconfiguredGood(this.adapter);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                break;
            }
            case 1160: {
                new ManagePowerSettingsPanel(this.adapter, ((SASAdapter)this.adapter.getDeviceObject()).getInformation().getpdOperations_MR_CTRL_INFO().isPowerStateForConfig());
                break;
            }
            case 1164: {
                new ManageSSDCachingDialog(this.adapter, this.adapter.getSSCCacheableLDList(this.adapter.getNonSSCDsList(), 0), 0);
                break;
            }
            case 3: {
                if (this.adapter.getAdapterInfo().getCacheIsPinned() == 1) {
                    new PreservedCachePresent();
                    break;
                }
                new FirmwareDialog(this.adapter);
                break;
            }
            case 1173: {
                new ManageCSACachingDialog(this.adapter, this.adapter.getCSACacheableLDList(this.adapter.getNonSSCDsList(), 0), 0);
                break;
            }
            case 1174: {
                LogicalDriveHelper[] logicalDriveHelperArray = this.adapter.getSlicedForBootVolumeArray().getLogicalDriveHelpers();
                for (int i = 1; i < logicalDriveHelperArray.length; ++i) {
                    if (!logicalDriveHelperArray[i].isOSDrive()) continue;
                    String string2 = "<html>" + logicalDriveHelperArray[i].getText() + " " + Resource.getString("MSG_CSA_OS_LD_FORMAT", "is an OS drive.<br>This virtual drive cannot be formated.</html>");
                    new CustomMsgBox(string2);
                    return;
                }
                StringBuffer stringBuffer = null;
                String string3 = null;
                stringBuffer = new StringBuffer(Resource.getString("MSG_DELETE_SLICED_CSA_CACHECADE_1", "You have chosen to delete Nytro\u2122 Cache Drive<br>and Boot Drive. All data on the Drives will be lost"));
                if (logicalDriveHelperArray[0].getLdParameters().getPinnedCacheState() != 0) {
                    stringBuffer.append(" ").append(Resource.getString("MSG_DELETE_SLICED_CSA_CACHECADE_2", "and the preserved cache for Nytro\u2122 Cache Drive<br>will be discarded"));
                }
                stringBuffer.append(".");
                stringBuffer.append(Resource.getString("MSG_DELETE_SLICED_CSA_CACHECADE_3", "Are you sure you want to delete the Drives?"));
                stringBuffer.append("?</html>");
                string3 = Resource.getString("DELETE_SLICED_CSA_CACHECADE_TITLE", "Delete Nytro\u2122 Cache and Boot Drives");
                if (!CustomMsgBox.confirmWithCheck(VivaldiStartupDialog.mainScreen, string3, stringBuffer.toString())) {
                    return;
                }
                OperationDetails operationDetails = new OperationDetails(3, null);
                for (int i = logicalDriveHelperArray.length - 1; i >= 0; --i) {
                    try {
                        ((SASLogicalDrive)logicalDriveHelperArray[i].getDeviceObject()).fireOperation(operationDetails);
                        continue;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        break block10;
                    }
                }
                break;
            }
        }
    }

    private boolean isConversionAllowedJBODtoUCG() {
        boolean bl = false;
        int n = this.adapter.getAdapterProperties().getOnOffProperties_MR_CTRL_PROP().getEnableJBOD();
        if (n == 1) {
            int n2 = this.adapter.findunconfiguredAndOnlinePdCnt();
            PhysicalDriveHelper[] physicalDriveHelperArray = this.adapter.getSystemDrivesList();
            int n3 = 0;
            if (physicalDriveHelperArray != null) {
                n3 = physicalDriveHelperArray.length;
            }
            if (n2 < this.adapter.getAdapterInfo().getmaxConfigurablePds() && n3 > 0) {
                bl = true;
            }
        }
        return bl;
    }

    private void showConfirmLossOfCache(SASAdapter sASAdapter) {
        String string;
        String string2 = Resource.getString("MSG_DELETE_CONFIG_CONFIRM_TITLE", "Confirm Clear Configuration");
        if (!CustomMsgBox.confirmWithCheck(VivaldiStartupDialog.mainScreen, string2, string = Resource.getString("MSG_DELETE_CONFIG5", "<html>There is currently data stored in the cache. Clearing the<br>configuration will permanently delete the cached data.<br><br>Are you sure you want to clear the configuration and<br>permanently lose the cached data?<br><br></html>"), "HELP_PAGE_DEFAULT")) {
            return;
        }
        try {
            sASAdapter.clearConfiguration();
        }
        catch (VKOperationFailedException vKOperationFailedException) {
            CustomMsgBox.errorMsg(vKOperationFailedException);
            vKOperationFailedException.printStackTrace();
        }
    }
}

