/*
 * Decompiled with CFR 0.152.
 */
package GUI;

import GUI.GroupShowProgressDialog;
import GUI.MainFrame;
import GUI.VivaldiBaseDialog;
import GUIHelper.AdapterHelper;
import GUIHelper.GUIHelperInterface;
import GUIHelper.LogicalDriveHelper;
import GUIHelper.OperationProgressBar;
import GUIHelper.PhysicalDriveHelper;
import KernelServices.NotifyObject;
import SASKernel.LibraryAPI.StoreLib.MR_EVT_DETAIL;
import SASKernel.LibraryAPI.StoreLib.MR_PD_PROGRESS;
import SASKernel.SASAdapter.SASAdapter;
import SASKernel.SASLogical.SASLogicalDrive;
import SASKernel.SASPhysical.SASPhysicalDrive;
import Utils.ColorHash;
import Utils.CustomMsgBox;
import Utils.Resource;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;

public class AdapterShowProgressTab
extends JPanel
implements Observer {
    private JPanel physicalPart = new JPanel(new GridLayout(0, 1, 0, 20));
    private JPanel virtualPart = new JPanel(new GridLayout(0, 1, 0, 20));
    private LogicalDriveHelper[] logi;
    private PhysicalDriveHelper[] phys;
    private AdapterHelper adapter;
    JButton resumeallButton;
    JButton suspendallButton;
    JButton suspendPRButton;
    JButton resumePRButton;
    JButton abortAllButton;
    boolean suspendallenabled = false;
    private Hashtable progHash = new Hashtable();
    private VivaldiBaseDialog iGroupprogressDialog = null;
    JScrollPane m_virtualScrollPane = null;

    public AdapterShowProgressTab(AdapterHelper adapterHelper, VivaldiBaseDialog vivaldiBaseDialog) {
        int n;
        int n2;
        int n3;
        this.iGroupprogressDialog = vivaldiBaseDialog;
        this.adapter = adapterHelper;
        this.adapter.addObserver(this);
        this.setLayout(new BorderLayout());
        this.virtualPart.setBorder(BorderFactory.createTitledBorder(Resource.getString("MSG_LDPROGRESS_TEXT", "Ongoing Operations on Virtual Disks")));
        this.physicalPart.setBorder(BorderFactory.createTitledBorder(Resource.getString("MSG_PDPROGRESS_TEXT", "Ongoing Operations on Physical Drives")));
        this.physicalPart.setBackground(ColorHash.getColor("LIGHT_BACKGROUND"));
        this.virtualPart.setBackground(ColorHash.getColor("LIGHT_BACKGROUND"));
        JSplitPane jSplitPane = new JSplitPane(1, new JScrollPane(this.virtualPart), new JScrollPane(this.physicalPart));
        jSplitPane.setDividerLocation(MainFrame.SCREEN_SIZE.width * 320 / 1024);
        this.add((Component)jSplitPane, "Center");
        this.refresh();
        JPanel jPanel = new JPanel();
        String[] stringArray = Resource.getStringWithMnemonic(Resource.getString("BUTTON_CLOSE_TEXT", "Close[C]"));
        JButton jButton = new JButton(stringArray[0]);
        if (stringArray.length == 2) {
            jButton.setMnemonic(stringArray[1].charAt(0));
        }
        jButton.setToolTipText(Resource.getString("BUTTON_CLOSE_DSC_2", "Close progress window"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ((GroupShowProgressDialog)AdapterShowProgressTab.this.iGroupprogressDialog).closeOpt();
            }
        });
        stringArray = Resource.getStringWithMnemonic(Resource.getString("BUTTON_ABORTALL_TEXT", "Abort All[A]"));
        this.abortAllButton = new JButton(stringArray[0]);
        if (stringArray.length == 2) {
            this.abortAllButton.setMnemonic(stringArray[1].charAt(0));
        }
        this.abortAllButton.setVisible(MainFrame.fullAccess);
        this.abortAllButton.setToolTipText(Resource.getString("BUTTON_ABORTALL_DSC", "Abort All"));
        this.abortAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object[] objectArray = AdapterShowProgressTab.this.progHash.values().toArray();
                if (objectArray.length > 0 && !CustomMsgBox.confirm(Resource.getString("MSG_ABORTALL_CONFIRM", "This will abort all the operations shown above ! Are you sure ?"))) {
                    return;
                }
                for (int i = 0; i < objectArray.length; ++i) {
                    ((OperationProgressBar)objectArray[i]).kill();
                }
            }
        });
        stringArray = Resource.getStringWithMnemonic(Resource.getString("BUTTON_RESUMEALL_TEXT", "Resume All[R]"));
        this.resumeallButton = new JButton(stringArray[0]);
        if (stringArray.length == 2) {
            this.resumeallButton.setMnemonic(stringArray[1].charAt(0));
        }
        stringArray = Resource.getStringWithMnemonic(Resource.getString("BUTTON_SUSPENDALL_TEXT", "Suspend All[u]"));
        this.suspendallButton = new JButton(stringArray[0]);
        if (stringArray.length == 2) {
            this.suspendallButton.setMnemonic(stringArray[1].charAt(0));
        }
        stringArray = Resource.getStringWithMnemonic(Resource.getString("BUTTON_PRSUSPEND_TEXT", "Suspend Patrol Read[P]"));
        this.suspendPRButton = new JButton(stringArray[0]);
        if (stringArray.length == 2) {
            this.suspendPRButton.setMnemonic(stringArray[1].charAt(0));
        }
        stringArray = Resource.getStringWithMnemonic(Resource.getString("BUTTON_PRRESUME_TEXT", "Resume Patrol Read[P]"));
        this.resumePRButton = new JButton(stringArray[0]);
        if (stringArray.length == 2) {
            this.resumePRButton.setMnemonic(stringArray[1].charAt(0));
        }
        if (this.adapter.getAdapterInfo().getadapterOperationsEx_MR_CTRL_INFO().getSupportSuspendResumeBGops() != 0) {
            this.resumeallButton.setVisible(MainFrame.fullAccess);
            this.resumeallButton.setToolTipText(Resource.getString("BUTTON_RESUMEALL_DSC", "Resume All"));
            this.resumeallButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Object[] objectArray = AdapterShowProgressTab.this.progHash.values().toArray();
                    if (objectArray.length > 0 && !CustomMsgBox.confirm(Resource.getString("MSG_RESUMEALL_CONFIRM", "This will resume all the operations shown above ! Are you sure ?"))) {
                        return;
                    }
                    for (int i = 0; i < objectArray.length; ++i) {
                        ((OperationProgressBar)objectArray[i]).suspendresume(true);
                    }
                }
            });
            this.suspendallButton.setVisible(MainFrame.fullAccess);
            this.suspendallButton.setToolTipText(Resource.getString("BUTTON_SUSPENDALL_DSC", "Suspend All"));
            this.suspendallButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Object[] objectArray = AdapterShowProgressTab.this.progHash.values().toArray();
                    if (objectArray.length > 0 && !CustomMsgBox.confirm(Resource.getString("MSG_SUSPENDALL_CONFIRM", "This will suspend all the operations shown above ! Are you sure ?"))) {
                        return;
                    }
                    for (int i = 0; i < objectArray.length; ++i) {
                        ((OperationProgressBar)objectArray[i]).suspendresume(false);
                    }
                }
            });
            this.suspendPRButton.setVisible(MainFrame.fullAccess);
            this.suspendPRButton.setToolTipText(Resource.getString("BUTTON_SUSPENDPR_DSC", "Suspend Patrol Read"));
            this.suspendPRButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Object[] objectArray = AdapterShowProgressTab.this.progHash.values().toArray();
                    if (objectArray.length > 0 && !CustomMsgBox.confirm(Resource.getString("MSG_SUSPENDALL_CONFIRM", "This will suspend all the operations shown above ! Are you sure ?"))) {
                        return;
                    }
                    SASAdapter sASAdapter = (SASAdapter)AdapterShowProgressTab.this.adapter.getDeviceObject();
                    sASAdapter.suspendPR(false);
                }
            });
            this.resumePRButton.setVisible(MainFrame.fullAccess);
            this.resumePRButton.setToolTipText(Resource.getString("BUTTON_RESUMEPR_DSC", "Resume Patrol Read"));
            this.resumePRButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Object[] objectArray = AdapterShowProgressTab.this.progHash.values().toArray();
                    if (objectArray.length > 0 && !CustomMsgBox.confirm(Resource.getString("MSG_RESUMEALL_CONFIRM", "This will resume all the operations shown above ! Are you sure ?"))) {
                        return;
                    }
                    SASAdapter sASAdapter = (SASAdapter)AdapterShowProgressTab.this.adapter.getDeviceObject();
                    sASAdapter.suspendPR(true);
                }
            });
        }
        Object[] objectArray = this.progHash.values().toArray();
        boolean bl = false;
        if (objectArray != null && objectArray.length > 0) {
            for (n3 = 0; n3 < objectArray.length; ++n3) {
                if (!((OperationProgressBar)objectArray[n3]).canKill()) continue;
                bl = true;
                break;
            }
        }
        n3 = 0;
        if (objectArray != null && objectArray.length > 0) {
            for (n2 = 0; n2 < objectArray.length; ++n2) {
                if (!((OperationProgressBar)objectArray[n2]).cansuspendresumeall()) continue;
                n3 = 1;
                break;
            }
        }
        n2 = 0;
        int n4 = 0;
        if (objectArray != null && objectArray.length > 0) {
            for (n = 0; n < objectArray.length; ++n) {
                if (!((OperationProgressBar)objectArray[n]).checkIfPaused()) continue;
                n2 = 1;
                break;
            }
        }
        if (objectArray != null && objectArray.length > 0) {
            for (n = 0; n < objectArray.length; ++n) {
                if (!((OperationProgressBar)objectArray[n]).checkIfPaused()) continue;
                n2 = 1;
                break;
            }
            for (n = 0; n < objectArray.length; ++n) {
                if (!((OperationProgressBar)objectArray[n]).checkIfPaused()) continue;
                ++n4;
            }
            if (n4 == objectArray.length) {
                this.suspendallenabled = true;
            }
        }
        jPanel.add(jButton);
        n = ((SASAdapter)adapterHelper.getDeviceObject()).getAdapterType();
        if (n != 2 && n != 3 && n != 4 && this.adapter.getAdapterInfo().getadapterOperationsEx_MR_CTRL_INFO().getSupportSuspendResumeBGops() != 0 && n3 != 0) {
            if (this.canDisableSuspendAll() && this.canDisableResumeAll()) {
                this.suspendallButton.setEnabled(false);
                this.resumeallButton.setEnabled(false);
            } else if (this.canDisableSuspendAll()) {
                this.suspendallButton.setEnabled(false);
            } else if (this.canDisableResumeAll()) {
                this.resumeallButton.setEnabled(false);
            }
            jPanel.add(this.suspendallButton);
            jPanel.add(this.resumeallButton);
        }
        if (n != 2 && n != 3 && n != 4 && bl) {
            jPanel.add(this.abortAllButton);
        }
        if (!this.adapter.isSWRController() && this.adapter.getAdapterInfo().getadapterOperationsEx_MR_CTRL_INFO().getSupportSuspendResumeBGops() != 0) {
            boolean bl2 = this.canDisableSuspendPR();
            boolean bl3 = this.canDisableResumePR();
            if (this.isPRavailable()) {
                if (bl2) {
                    this.suspendPRButton.setEnabled(false);
                }
                if (bl3) {
                    this.resumePRButton.setEnabled(false);
                }
                jPanel.add(this.suspendPRButton);
                jPanel.add(this.resumePRButton);
            }
        }
        this.m_virtualScrollPane = new JScrollPane(jPanel, 20, 30);
        this.m_virtualScrollPane.setPreferredSize(new Dimension(250, 50));
        this.add((Component)this.m_virtualScrollPane, "South");
    }

    private boolean canDisableSuspendAll() {
        int n;
        boolean bl = false;
        for (n = 0; n < this.logi.length; ++n) {
            try {
                PhysicalDriveHelper[] physicalDriveHelperArray;
                SASLogicalDrive sASLogicalDrive = (SASLogicalDrive)this.logi[n].getDeviceObject();
                if (this.logi[n].getProgressInfo() != null) {
                    if (sASLogicalDrive.getInformation().getprogInfo().getactive_MR_LD_PROGRESS1().getdisassociate()) {
                        bl = true;
                        continue;
                    }
                    if (sASLogicalDrive.getInformation().getprogInfo().getactive_MR_LD_PROGRESS1().getfgi() || sASLogicalDrive.getInformation().getprogInfo().getactive_MR_LD_PROGRESS1().getrecon() || sASLogicalDrive.getInformation().getprogInfo().getactive_MR_LD_PROGRESS1().geterase()) {
                        for (PhysicalDriveHelper physicalDriveHelper : physicalDriveHelperArray = this.logi[n].getPDListInLd()) {
                            if (physicalDriveHelper.getProgressInfo() != null) {
                                if (physicalDriveHelper.getProgressInfo().state) {
                                    bl = true;
                                    return true;
                                }
                                bl = true;
                                continue;
                            }
                            bl = true;
                        }
                        continue;
                    }
                    if (!this.logi[n].getProgressInfo().state) {
                        bl = false;
                        return false;
                    }
                    for (PhysicalDriveHelper physicalDriveHelper : physicalDriveHelperArray = this.logi[n].getPDListInLd()) {
                        if (physicalDriveHelper.getProgressInfo() != null) {
                            if (!physicalDriveHelper.getProgressInfo().state) continue;
                            bl = true;
                            return true;
                        }
                        bl = true;
                    }
                    continue;
                }
                for (PhysicalDriveHelper physicalDriveHelper : physicalDriveHelperArray = this.logi[n].getPDListInLd()) {
                    if (physicalDriveHelper.getProgressInfo() == null) continue;
                    if (!physicalDriveHelper.getProgressInfo().state && physicalDriveHelper.getInformation().getprogInfo().getactive_MR_PD_PROGRESS1().getpatrol() != 1) {
                        bl = false;
                        return false;
                    }
                    bl = true;
                }
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        for (n = 0; n < this.phys.length; ++n) {
            if (this.phys[n].getProgressInfo() == null) continue;
            if (!this.phys[n].getProgressInfo().state && this.phys[n].getInformation().getprogInfo().getactive_MR_PD_PROGRESS1().getCopyBack() == 1) {
                bl = false;
                return false;
            }
            bl = true;
        }
        return bl;
    }

    private boolean canDisableResumeAll() {
        int n;
        boolean bl = false;
        for (n = 0; n < this.logi.length; ++n) {
            try {
                PhysicalDriveHelper[] physicalDriveHelperArray;
                SASLogicalDrive sASLogicalDrive = (SASLogicalDrive)this.logi[n].getDeviceObject();
                if (this.logi[n].getProgressInfo() != null) {
                    if (sASLogicalDrive.getInformation().getprogInfo().getactive_MR_LD_PROGRESS1().getdisassociate()) {
                        bl = true;
                        continue;
                    }
                    if (!this.logi[n].getProgressInfo().state) {
                        for (PhysicalDriveHelper physicalDriveHelper : physicalDriveHelperArray = this.logi[n].getPDListInLd()) {
                            if (physicalDriveHelper.getProgressInfo() != null) {
                                if (!physicalDriveHelper.getProgressInfo().state) continue;
                                bl = true;
                                return true;
                            }
                            bl = true;
                        }
                        continue;
                    }
                    if (this.logi[n].getProgressInfo().state) {
                        bl = false;
                        return false;
                    }
                    for (PhysicalDriveHelper physicalDriveHelper : physicalDriveHelperArray = this.logi[n].getPDListInLd()) {
                        if (physicalDriveHelper.getProgressInfo() == null) continue;
                        if (physicalDriveHelper.getProgressInfo().state) {
                            bl = true;
                            return true;
                        }
                        bl = false;
                    }
                    continue;
                }
                for (PhysicalDriveHelper physicalDriveHelper : physicalDriveHelperArray = this.logi[n].getPDListInLd()) {
                    if (physicalDriveHelper.getProgressInfo() == null) continue;
                    if (physicalDriveHelper.getProgressInfo().state && physicalDriveHelper.getInformation().getprogInfo().getactive_MR_PD_PROGRESS1().getpatrol() != 1) {
                        bl = false;
                        return false;
                    }
                    bl = true;
                }
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        for (n = 0; n < this.phys.length; ++n) {
            if (this.phys[n].getProgressInfo() == null) continue;
            if (this.phys[n].getProgressInfo().state && this.phys[n].getInformation().getprogInfo().getactive_MR_PD_PROGRESS1().getCopyBack() == 1) {
                bl = false;
                return false;
            }
            bl = true;
        }
        return bl;
    }

    private boolean isPRavailable() {
        boolean bl = false;
        for (int i = 0; i < this.phys.length; ++i) {
            if (this.phys[i].getProgressInfo() == null || this.phys[i].getInformation().getprogInfo().getactive_MR_PD_PROGRESS1().getpatrol() != 1) continue;
            bl = true;
            return true;
        }
        return bl;
    }

    private boolean canDisableSuspendPR() {
        boolean bl = false;
        for (int i = 0; i < this.phys.length; ++i) {
            if (this.phys[i].getProgressInfo() == null || this.phys[i].getInformation().getprogInfo().getactive_MR_PD_PROGRESS1().getpatrol() != 1) continue;
            if (!this.phys[i].getProgressInfo().state) {
                Object[] objectArray = this.progHash.values().toArray();
                for (int j = 0; j < objectArray.length; ++j) {
                    ((OperationProgressBar)objectArray[j]).PRprogAdd();
                }
                bl = false;
                return false;
            }
            bl = true;
            return true;
        }
        return bl;
    }

    private boolean canDisableResumePR() {
        boolean bl = false;
        for (int i = 0; i < this.phys.length; ++i) {
            if (this.phys[i].getProgressInfo() == null || this.phys[i].getInformation().getprogInfo().getactive_MR_PD_PROGRESS1().getpatrol() != 1) continue;
            if (this.phys[i].getProgressInfo().state) {
                Object[] objectArray = this.progHash.values().toArray();
                for (int j = 0; j < objectArray.length; ++j) {
                    ((OperationProgressBar)objectArray[j]).PRprogRemove();
                }
                bl = false;
                return false;
            }
            bl = true;
            return true;
        }
        return bl;
    }

    private void updateLDProgress() {
        boolean bl = false;
        int n = 0;
        this.virtualPart.removeAll();
        for (int i = 0; i < this.logi.length; ++i) {
            try {
                if (this.logi[i].getProgressInfo() == null) continue;
                OperationProgressBar operationProgressBar = new OperationProgressBar(this.logi[i]);
                SASLogicalDrive sASLogicalDrive = (SASLogicalDrive)this.logi[i].getDeviceObject();
                if (this.canDisableSuspendAll()) {
                    bl = true;
                }
                this.progHash.put(this.logi[i], operationProgressBar);
                this.virtualPart.add(operationProgressBar);
                ++n;
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (bl && this.suspendallButton != null) {
            this.suspendallButton.setEnabled(false);
        }
        this.virtualPart.validate();
        this.virtualPart.repaint();
    }

    private void updatePDProgress() {
        int n = 0;
        this.physicalPart.removeAll();
        for (int i = 0; i < this.phys.length; ++i) {
            try {
                if (this.phys[i].getProgressInfo() == null) continue;
                OperationProgressBar operationProgressBar = new OperationProgressBar(this.phys[i]);
                this.progHash.put(this.phys[i], operationProgressBar);
                this.physicalPart.add(operationProgressBar);
                ++n;
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.physicalPart.validate();
        this.physicalPart.repaint();
    }

    @Override
    public void update(Observable observable, Object object) {
        NotifyObject notifyObject = (NotifyObject)object;
        int n = notifyObject.getNotifyCode() - 0x102000;
        GUIHelperInterface gUIHelperInterface = (GUIHelperInterface)((Object)observable);
        MR_EVT_DETAIL mR_EVT_DETAIL = (MR_EVT_DETAIL)notifyObject.getNotifyObject();
        if (mR_EVT_DETAIL != null) {
            if (gUIHelperInterface instanceof AdapterHelper && mR_EVT_DETAIL != null) {
                switch (mR_EVT_DETAIL.getcode()) {
                    case 35: {
                        this.phys = this.adapter.getPhysicalDrives();
                        int n2 = this.phys.length;
                        for (int i = 0; i < n2; ++i) {
                            short s = ((SASPhysicalDrive)this.phys[i].getDeviceObject()).getState();
                            if (s != 24 && s != 2) continue;
                            this.phys[i].getInformation().getprogInfo().getactive_MR_PD_PROGRESS1().setpatrol(0);
                            this.phys[i].getInformation().getprogInfo().getpause_MR_PD_PROGRESS1().setpatrol(0);
                        }
                        this.refresh();
                        break;
                    }
                    case 36: {
                        this.resumePRButton.setEnabled(true);
                        this.refresh();
                        boolean bl = this.canDisableSuspendPR();
                        boolean bl2 = this.canDisableResumePR();
                        if (bl && bl2) break;
                        if (bl) {
                            this.suspendPRButton.setEnabled(false);
                        }
                        if (!bl2) break;
                        this.resumePRButton.setEnabled(false);
                        break;
                    }
                    case 38: {
                        this.suspendPRButton.setEnabled(true);
                        this.refresh();
                        boolean bl = this.canDisableSuspendPR();
                        boolean bl3 = this.canDisableResumePR();
                        if (bl && bl3) break;
                        if (bl) {
                            this.suspendPRButton.setEnabled(false);
                            break;
                        }
                        if (!bl3) break;
                        this.resumePRButton.setEnabled(false);
                        break;
                    }
                    case 37: 
                    case 39: {
                        this.refresh();
                        break;
                    }
                    case 419: {
                        this.refresh();
                    }
                }
            } else {
                try {
                    switch (n) {
                        case 52: 
                        case 53: 
                        case 65: 
                        case 66: 
                        case 69: 
                        case 71: 
                        case 77: 
                        case 80: 
                        case 103: 
                        case 105: 
                        case 106: 
                        case 276: 
                        case 279: 
                        case 281: 
                        case 422: 
                        case 427: 
                        case 435: 
                        case 438: {
                            if (gUIHelperInterface.getProgressInfo() != null) {
                                if (this.progHash.containsKey(gUIHelperInterface)) break;
                                OperationProgressBar operationProgressBar = new OperationProgressBar(gUIHelperInterface);
                                this.progHash.put(gUIHelperInterface, operationProgressBar);
                                if (gUIHelperInterface instanceof LogicalDriveHelper) {
                                    this.virtualPart.add(operationProgressBar);
                                    this.virtualPart.validate();
                                    this.virtualPart.repaint();
                                    break;
                                }
                                if (gUIHelperInterface instanceof PhysicalDriveHelper) {
                                    this.physicalPart.add(operationProgressBar);
                                    this.physicalPart.validate();
                                    this.physicalPart.repaint();
                                }
                            }
                            break;
                        }
                        case 94: {
                            MR_PD_PROGRESS mR_PD_PROGRESS = ((PhysicalDriveHelper)gUIHelperInterface).getInformation().getprogInfo();
                            if ((int)mR_PD_PROGRESS.getpatrol().getprogress() != 100) {
                                if (gUIHelperInterface.getProgressInfo() != null) {
                                    if (this.progHash.containsKey(gUIHelperInterface)) break;
                                    OperationProgressBar operationProgressBar = new OperationProgressBar(gUIHelperInterface);
                                    this.progHash.put(gUIHelperInterface, operationProgressBar);
                                    if (gUIHelperInterface instanceof LogicalDriveHelper) {
                                        this.virtualPart.add(operationProgressBar);
                                        this.virtualPart.validate();
                                        this.virtualPart.repaint();
                                        break;
                                    }
                                    if (gUIHelperInterface instanceof PhysicalDriveHelper) {
                                        this.physicalPart.add(operationProgressBar);
                                        this.physicalPart.validate();
                                        this.physicalPart.repaint();
                                    }
                                }
                                break;
                            }
                            if (!this.progHash.containsKey(gUIHelperInterface)) break;
                            OperationProgressBar operationProgressBar = (OperationProgressBar)this.progHash.get(gUIHelperInterface);
                            operationProgressBar.remove();
                            if (gUIHelperInterface instanceof PhysicalDriveHelper) {
                                this.physicalPart.remove(operationProgressBar);
                            }
                            this.progHash.remove(gUIHelperInterface);
                            this.validate();
                            this.repaint();
                            break;
                        }
                        case 46: 
                        case 48: 
                        case 49: 
                        case 51: 
                        case 56: 
                        case 58: 
                        case 59: 
                        case 61: 
                        case 62: 
                        case 67: 
                        case 68: 
                        case 72: 
                        case 74: 
                        case 75: 
                        case 98: 
                        case 100: 
                        case 101: 
                        case 102: 
                        case 107: 
                        case 277: 
                        case 278: 
                        case 282: 
                        case 293: 
                        case 294: 
                        case 295: 
                        case 420: 
                        case 421: 
                        case 424: 
                        case 425: 
                        case 426: 
                        case 429: 
                        case 436: 
                        case 437: 
                        case 439: {
                            if (!this.progHash.containsKey(gUIHelperInterface)) break;
                            OperationProgressBar operationProgressBar = (OperationProgressBar)this.progHash.get(gUIHelperInterface);
                            operationProgressBar.remove();
                            if (gUIHelperInterface instanceof LogicalDriveHelper) {
                                this.virtualPart.remove(operationProgressBar);
                            } else if (gUIHelperInterface instanceof PhysicalDriveHelper) {
                                this.physicalPart.remove(operationProgressBar);
                            }
                            this.progHash.remove(gUIHelperInterface);
                            this.validate();
                            this.repaint();
                            break;
                        }
                        case 407: 
                        case 409: 
                        case 411: 
                        case 412: 
                        case 413: {
                            this.resumeallButton.setEnabled(true);
                            this.refresh();
                            if (this.canDisableSuspendAll() && this.canDisableResumeAll()) {
                                this.suspendallButton.setEnabled(false);
                                this.resumeallButton.setEnabled(false);
                                break;
                            }
                            if (this.canDisableSuspendAll()) {
                                this.suspendallButton.setEnabled(false);
                                break;
                            }
                            if (this.canDisableResumeAll()) {
                                this.resumeallButton.setEnabled(false);
                            }
                            break;
                        }
                        case 78: 
                        case 104: 
                        case 280: 
                        case 408: 
                        case 410: {
                            this.suspendallButton.setEnabled(true);
                            this.abortAllButton.setEnabled(true);
                            this.refresh();
                            if (this.canDisableSuspendAll() && this.canDisableResumeAll()) {
                                this.suspendallButton.setEnabled(false);
                                this.resumeallButton.setEnabled(false);
                                break;
                            }
                            if (this.canDisableSuspendAll()) {
                                this.suspendallButton.setEnabled(false);
                                break;
                            }
                            if (this.canDisableResumeAll()) {
                                this.resumeallButton.setEnabled(false);
                            }
                            break;
                        }
                        default: {
                            break;
                        }
                        case 414: 
                        case 415: 
                        case 416: 
                        case 417: 
                        case 418: {
                            this.refresh();
                        }
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }

    public void cleanUp() {
        this.stopObserving();
        Enumeration enumeration = this.progHash.keys();
        while (enumeration.hasMoreElements()) {
            Observable observable = (Observable)enumeration.nextElement();
            Observer observer = (Observer)this.progHash.get(observable);
            if (observer == null) continue;
            observable.deleteObserver(observer);
        }
        this.progHash.clear();
    }

    private void refresh() {
        int n;
        this.progHash.clear();
        this.logi = this.adapter.getLogicalDrives();
        this.phys = this.adapter.getPhysicalDrives();
        this.updateLDProgress();
        this.updatePDProgress();
        for (n = 0; n < this.logi.length; ++n) {
            this.logi[n].addObserver(this);
        }
        for (n = 0; n < this.phys.length; ++n) {
            this.phys[n].addObserver(this);
        }
    }

    private void stopObserving() {
        int n;
        if (this.logi != null) {
            for (n = 0; n < this.logi.length; ++n) {
                this.logi[n].deleteObserver(this);
            }
        }
        if (this.phys != null) {
            for (n = 0; n < this.phys.length; ++n) {
                this.phys[n].deleteObserver(this);
            }
        }
    }
}

