/*
 * Decompiled with CFR 0.152.
 */
package GUI;

import GUI.DetailPanel;
import GUI.DriveGroupPowerSavingsDialog;
import GUI.JoinMirrorDialog;
import GUI.MainFrame;
import GUI.OperationViewPanel;
import GUI.PropertyViewPanel;
import GUI.venus.configuration.ModifySSC.ModifySSCActionListener;
import GUI.venus.configuration.reconfiguration.DriveGroupModificationPage;
import GUI.venus.configuration.reconfiguration.ModeSelectionPage;
import GUI.venus.configuration.reconfiguration.RAIDTransitionUnit;
import GUI.venus.configuration.reconfiguration.ReconfigAddModeDriveFilter;
import GUI.venus.configuration.reconfiguration.ReconfigurationSummaryPage;
import GUI.venus.configuration.reconfiguration.SelectRaidLevelPage;
import GUI.venus.configuration.reconfiguration.TargetRaidLevelSelector;
import GUI.venus.wizard.WizardController;
import GUI.venus.wizard.WizardNavigationException;
import GUIHelper.AdapterHelper;
import GUIHelper.ArrayHelper;
import GUIHelper.LogicalDriveHelper;
import GUIHelper.PhysicalDriveHelper;
import KernelServices.NotifyObject;
import SASKernel.LibraryAPI.StoreLib.MR_MFC_DEFAULTS;
import SASKernel.Operations.OperationDetails;
import SASKernel.SASAdapter.SASAdapter;
import SASKernel.SASLogical.SASLogicalDrive;
import SASKernel.SASLogical.SASLogicalDriveOperationsAllowed;
import Utils.CustomMsgBox;
import Utils.CustomTabbedPane;
import Utils.Resource;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Observable;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class ArrayDetailPanel
extends DetailPanel {
    private CustomTabbedPane m_tabbedPane = new CustomTabbedPane();
    private JPanel m_propertiesTab = new JPanel();
    private OperationViewPanel m_opView = null;
    private ArrayHelper m_arrayHelper = null;

    public ArrayDetailPanel(ArrayHelper arrayHelper, MainFrame mainFrame) {
        super(arrayHelper, mainFrame);
        this.m_arrayHelper = arrayHelper;
        this.m_propertiesTab.setLayout(new BorderLayout());
        this.init();
        this.m_arrayHelper.addObserver(this);
        this.m_tabbedPane.addTab(Resource.getString("PROPERTY_TAB_TEXT", "Properties"), null, new JScrollPane(this.m_propertiesTab), Resource.getString("PROPERTY_TAB_TEXT", "Properties"));
        this.add((Component)this.m_tabbedPane, "Center");
    }

    @Override
    public void init() {
        this.m_propertiesTab.removeAll();
        ArrayList arrayList = this.m_arrayHelper.getPropertyList();
        PropertyViewPanel propertyViewPanel = new PropertyViewPanel(arrayList, arrayList.size());
        this.m_propertiesTab.add((Component)propertyViewPanel, "North");
        ArrayList arrayList2 = this.m_arrayHelper.getOperationList();
        if (arrayList2 != null && arrayList2.size() > 0) {
            this.m_opView = new OperationViewPanel(this.m_arrayHelper);
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BorderLayout());
            jPanel.add((Component)this.m_opView, "Center");
            JPanel jPanel2 = new JPanel(new FlowLayout());
            String[] stringArray = Resource.getResourceMnemonic(Resource.getString("BUTTON_OPERATION_GO", "Go"));
            JButton jButton = new JButton(stringArray[0]);
            jButton.setToolTipText(Resource.getString("BUTTON_OPERATION_GO_DSC", "Go"));
            if (stringArray.length == 2) {
                jButton.setMnemonic(stringArray[1].charAt(0));
            }
            jButton.setPreferredSize(new Dimension(MainFrame.SCREEN_SIZE.width * 120 / 1024, MainFrame.SCREEN_SIZE.height * 30 / 768));
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ArrayDetailPanel.this.m_opView.invokeOperation();
                }
            });
            jPanel2.add(jButton);
        } else if (this.m_tabbedPane.getTabCount() > 1) {
            this.m_tabbedPane.removeTabAt(1);
        }
    }

    @Override
    public boolean canClose() {
        this.m_arrayHelper.deleteObserver(this);
        return true;
    }

    @Override
    public void gotoTab(int n) {
        this.m_tabbedPane.setSelectedIndex(n);
    }

    @Override
    public int getTabIndex() {
        return this.m_tabbedPane.getSelectedIndex();
    }

    @Override
    public void update(Observable observable, Object object) {
        NotifyObject notifyObject = (NotifyObject)object;
        int n = notifyObject.getNotifyCode() - 0x102000;
        if (n == 316 || n == 317 || n == 387 || n == 73) {
            super.update(observable, object);
        }
    }

    @Override
    public JMenu getSubMenu(JMenu jMenu) {
        int n = jMenu.getItemCount();
        JMenu jMenu2 = null;
        for (int i = 0; i < n; ++i) {
            jMenu2 = (JMenu)jMenu.getItem(i);
            if (!jMenu2.getName().trim().equals("Drive Group")) continue;
            return jMenu2;
        }
        return jMenu2;
    }

    @Override
    public void populateOperationMenu(JMenu jMenu, OperationDetails operationDetails) {
        System.out.println("ArrayDetailPanel.populateOperationMenu()");
        if (jMenu == null) {
            return;
        }
        Object var3_3 = null;
        switch (operationDetails.getOpcode()) {
            case 1142: {
                LogicalDriveHelper[] logicalDriveHelperArray;
                if (((AdapterHelper)this.m_arrayHelper.getParent()).getAdapterInfo().getldOperations_MR_CTRL_INFO().isSupportSSCAssociation() || ((AdapterHelper)(logicalDriveHelperArray = this.m_arrayHelper.getLogicalDriveHelpers())[0].getParent()).getAdapterInfo().getMaxSSCsize() == 0) break;
                int n = ((AdapterHelper)this.m_arrayHelper.getParent()).getAdapterInfo().getldOperations_MR_CTRL_INFO().getreconstruction();
                SASLogicalDriveOperationsAllowed sASLogicalDriveOperationsAllowed = null;
                try {
                    sASLogicalDriveOperationsAllowed = ((SASLogicalDrive)logicalDriveHelperArray[0].getDeviceObject()).getAllAllowedOperations();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (!logicalDriveHelperArray[0].isSSCD() || sASLogicalDriveOperationsAllowed == null || logicalDriveHelperArray == null || logicalDriveHelperArray.length != 1 || this.m_arrayHelper.getSpanDepth() != 1 || n == 0 || !this.m_arrayHelper.canSSCBeModified() || !sASLogicalDriveOperationsAllowed.isOperationAllowed(12)) break;
                String[] stringArray = Resource.getResourceMnemonic(Resource.getString("RECONFIG_SSC_MENU", "(M)odify CacheCade\u2122 - SSD Caching Drive Group"));
                JMenuItem jMenuItem = new JMenuItem(stringArray[0]);
                if (stringArray.length == 2) {
                    jMenuItem.setMnemonic(stringArray[1].charAt(0));
                }
                jMenu.add(jMenuItem);
                jMenuItem.addActionListener(new ModifySSCActionListener(this.m_arrayHelper));
                break;
            }
            case 1128: {
                PhysicalDriveHelper[] physicalDriveHelperArray;
                TargetRaidLevelSelector targetRaidLevelSelector;
                Vector<RAIDTransitionUnit> vector;
                System.out.println("For reconfig population");
                LogicalDriveHelper[] logicalDriveHelperArray = this.m_arrayHelper.getLogicalDriveHelpers();
                if (logicalDriveHelperArray == null || logicalDriveHelperArray[0].isSSCD()) break;
                int n = ((AdapterHelper)this.m_arrayHelper.getParent()).getAdapterInfo().getldOperations_MR_CTRL_INFO().getreconstruction();
                SASLogicalDriveOperationsAllowed sASLogicalDriveOperationsAllowed = null;
                try {
                    sASLogicalDriveOperationsAllowed = ((SASLogicalDrive)logicalDriveHelperArray[0].getDeviceObject()).getAllAllowedOperations();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (sASLogicalDriveOperationsAllowed == null || logicalDriveHelperArray.length != 1 || this.m_arrayHelper.getSpanDepth() != 1 || n == 0 || !sASLogicalDriveOperationsAllowed.isOperationAllowed(12) || (vector = (targetRaidLevelSelector = new TargetRaidLevelSelector(logicalDriveHelperArray[0], physicalDriveHelperArray = ReconfigAddModeDriveFilter.getCandidatePhysicalDrives(logicalDriveHelperArray[0]))).getPossibleRaidLevelsToMigrate()) == null || vector.isEmpty()) break;
                byte by = ((SASLogicalDrive)logicalDriveHelperArray[0].getDeviceObject()).getInformation().getldConfig().getparams().getPRL();
                System.out.println("raidLevel: " + by);
                if (physicalDriveHelperArray == null && by == 0) break;
                System.out.println("Inside the menu add.");
                String[] stringArray = Resource.getResourceMnemonic(Resource.getString("RECONFIG_MENU", "(M)odify Drive Group"));
                JMenuItem jMenuItem = new JMenuItem(stringArray[0]);
                if (stringArray.length == 2) {
                    jMenuItem.setMnemonic(stringArray[1].charAt(0));
                }
                jMenu.add(jMenuItem);
                jMenuItem.addActionListener(new ReconfigDGAction(logicalDriveHelperArray[0], physicalDriveHelperArray, vector));
                break;
            }
            case 1144: {
                MR_MFC_DEFAULTS mR_MFC_DEFAULTS;
                if (this.m_arrayHelper.getSpanDepth() != 1 || this.m_arrayHelper.isSSCD() || this.m_arrayHelper.isSRArray()) break;
                LogicalDriveHelper[] logicalDriveHelperArray = this.m_arrayHelper.getLogicalDriveHelpers();
                boolean bl = false;
                if (logicalDriveHelperArray.length != 0 && logicalDriveHelperArray != null) {
                    for (int n = 0; n < logicalDriveHelperArray.length && !(bl = ((SASLogicalDrive)logicalDriveHelperArray[n].getDeviceObject()).getInformation().getprogInfo().getactive_MR_LD_PROGRESS1().getrecon()); n = (int)((short)(n + 1))) {
                    }
                }
                if (bl || (mR_MFC_DEFAULTS = ((AdapterHelper)this.m_arrayHelper.getParent()).getMFCDefaults()) == null || (mR_MFC_DEFAULTS.getdisablePowerSavings() & 8) == 8 || !((AdapterHelper)this.m_arrayHelper.getParent()).isPowerSaveSupportedOnConfiguredDrives()) break;
                String[] stringArray = Resource.getResourceMnemonic(Resource.getString("DS_MANAGE_POWER_SAVE_SETTINGS", "Manage (P)ower Save Settings"));
                JMenuItem jMenuItem = new JMenuItem(stringArray[0]);
                if (stringArray.length == 2) {
                    jMenuItem.setMnemonic(stringArray[1].charAt(0));
                }
                jMenu.add(jMenuItem);
                jMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        new DriveGroupPowerSavingsDialog(ArrayDetailPanel.this.m_arrayHelper);
                    }
                });
                break;
            }
            case 1161: {
                LogicalDriveHelper[] logicalDriveHelperArray;
                MR_MFC_DEFAULTS mR_MFC_DEFAULTS = ((AdapterHelper)this.m_arrayHelper.getParent()).getMFCDefaults();
                if (mR_MFC_DEFAULTS == null || !mR_MFC_DEFAULTS.isBreakMirrorRAIDsupport() || mR_MFC_DEFAULTS.isDisableJoinMirror() || (logicalDriveHelperArray = this.m_arrayHelper.getLogicalDriveHelpers()).length <= 0) break;
                SASLogicalDriveOperationsAllowed sASLogicalDriveOperationsAllowed = null;
                try {
                    sASLogicalDriveOperationsAllowed = ((SASLogicalDrive)logicalDriveHelperArray[0].getDeviceObject()).getAllAllowedOperations();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (!sASLogicalDriveOperationsAllowed.canjoinMirror()) break;
                String[] stringArray = Resource.getResourceMnemonic(Resource.getString("LD_OPERTAION_JOIN_MIRROR", "Join Mirror"));
                JMenuItem jMenuItem = new JMenuItem(stringArray[0]);
                if (stringArray.length == 2) {
                    jMenuItem.setMnemonic(stringArray[1].charAt(0));
                }
                jMenu.add(jMenuItem);
                jMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        JoinMirrorDialog joinMirrorDialog = new JoinMirrorDialog(ArrayDetailPanel.this.m_arrayHelper);
                    }
                });
            }
        }
    }

    public void populateOperationMenu(JMenu jMenu) {
        System.out.println("ArrayDetailPanel.populateOperationMenu()");
        if (jMenu != null) {
            // empty if block
        }
    }

    private class ReconfigDGAction
    implements ActionListener {
        private PhysicalDriveHelper[] m_selectablePDHelpers = null;
        private LogicalDriveHelper m_ldHelper = null;
        private Vector<RAIDTransitionUnit> m_vecRTUs = null;

        public ReconfigDGAction(LogicalDriveHelper logicalDriveHelper, PhysicalDriveHelper[] physicalDriveHelperArray, Vector<RAIDTransitionUnit> vector) {
            this.m_ldHelper = logicalDriveHelper;
            this.m_selectablePDHelpers = physicalDriveHelperArray;
            this.m_vecRTUs = vector;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                if (((SASAdapter)ArrayDetailPanel.this.m_arrayHelper.getParent().getDeviceObject()).getInformation().gethwPresent_MR_CTRL_INFO().getmemory() == 0 && !CustomMsgBox.confirmWithCheck(Resource.getString("MSG_DATA_BACKUP_AND_NO_RESTART", "<html>Please note that rebooting virtual drives containing boot partitions that are<br>undergoing RAID level migration or capacity expansion operations may<br>lead to undesirable boot process behavior.  It is advised that these<br>operations complete in their entirety before the system is restarted.<br><br>It is advisable to backup your data before you proceed.<br><br></html>"))) {
                    return;
                }
                if (!CustomMsgBox.confirmWithCheck(Resource.getString("MSG_DATA_BAKUP"))) {
                    return;
                }
                WizardController wizardController = new WizardController();
                HashMap hashMap = wizardController.getWizardData();
                hashMap.put("LogicalDriveHelper", this.m_ldHelper);
                hashMap.put("SelectablePDHelpers", this.m_selectablePDHelpers);
                hashMap.put("WarningDialogTitle", Resource.getString("MODIFY_DG_CONFIRM_TITLE"));
                hashMap.put("ListOfRTU", this.m_vecRTUs);
                wizardController.addPage(SelectRaidLevelPage.class.getName(), "RAIDSelectionPage");
                wizardController.addPage(DriveGroupModificationPage.class.getName(), "DGModificationPage");
                wizardController.addPage(ModeSelectionPage.class.getName(), "MODESelectionPage");
                wizardController.addPage(ReconfigurationSummaryPage.class.getName(), "ReconfigSummaryPage");
                wizardController.setFirstPage("RAIDSelectionPage");
                wizardController.addPageTransition("RAIDSelectionPage", 0, "DGModificationPage");
                wizardController.addPageTransition("RAIDSelectionPage", 1, "MODESelectionPage");
                wizardController.addPageTransition("RAIDSelectionPage", 2, "ReconfigSummaryPage");
                wizardController.addPageTransition("DGModificationPage", 0, "ReconfigSummaryPage");
                wizardController.addPageTransition("MODESelectionPage", 0, "DGModificationPage");
                wizardController.addPageTransition("MODESelectionPage", 1, "ReconfigSummaryPage");
                wizardController.launchWizard();
            }
            catch (WizardNavigationException wizardNavigationException) {
                wizardNavigationException.printStackTrace();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

