/*
 * Decompiled with CFR 0.152.
 */
package GUI;

import GUI.MainFrame;
import GUIHelper.ArrayHelper;
import GUIHelper.PhysicalDriveHelper;
import Utils.ColorHash;
import Utils.Cylinder3D;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JPanel;

public class ArrayGraphicalView
extends JPanel {
    private int MAXWIDTH;
    private int MAXHEIGHT;
    private int ARRAYWIDTH;
    private int GAP;
    private PhysicalDriveHelper[] phDriveList;

    public ArrayGraphicalView(ArrayHelper arrayHelper) {
        this.phDriveList = arrayHelper.getPhysicalDrives();
        this.MAXWIDTH = 560 * MainFrame.SCREEN_SIZE.width / 1024;
        this.MAXHEIGHT = 360 * MainFrame.SCREEN_SIZE.height / 768;
        this.ARRAYWIDTH = 96 * MainFrame.SCREEN_SIZE.width / 1024;
        this.GAP = 16 * MainFrame.SCREEN_SIZE.width / 1024;
        this.setPreferredSize(new Dimension(this.MAXWIDTH + 2 * this.GAP, this.MAXHEIGHT));
    }

    @Override
    public void paint(Graphics graphics) {
        int n = (this.getWidth() - this.MAXWIDTH) / 2;
        int n2 = (this.getHeight() - this.MAXHEIGHT) / 2;
        for (int i = 0; i < this.phDriveList.length; ++i) {
            int n3 = n2;
            int n4 = n + i * (this.GAP + this.ARRAYWIDTH);
            int n5 = this.ARRAYWIDTH;
            int n6 = this.MAXHEIGHT / 2;
            Cylinder3D cylinder3D = new Cylinder3D(graphics, n4, n3, n5, n6, 30, ColorHash.getColor("GRAPHICAL_VIEW_ARRAY"), ColorHash.getColor("GRAPHICAL_VIEW_ARRAY"), Color.white);
        }
    }
}

