/*
 * Decompiled with CFR 0.152.
 */
package GUI;

import GUI.HostView;
import GUI.MainFrame;
import GUI.RemoteServer;
import GUI.VivaldiBaseDialog;
import GUI.VivaldiStartupDialog;
import SASKernel.SASKernel;
import Utils.ColorHash;
import Utils.CustomComboBox;
import Utils.CustomJOptionDialog;
import Utils.HelpContext;
import Utils.HelpContextResourse;
import Utils.HelpException;
import Utils.HelpInterface;
import Utils.Resource;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRootPane;
import javax.swing.JTextField;

public class AuthenticationDialog
extends VivaldiBaseDialog
implements HelpInterface {
    private JTextField userName;
    private JPasswordField password;
    private JComboBox mode;
    public JButton loginButton;
    public JButton cancelButton;
    private JLabel passwordLabel;
    private JLabel loginModeLabel;
    private JLabel userNameLabel;
    JRootPane rootPane;
    JButton defaultButton;
    private JLabel i_lblServer;
    private JLabel i_lblServerIP;
    JPanel content = new JPanel();

    public AuthenticationDialog(HostView hostView) {
        super((Frame)null);
        int n;
        int n2;
        try {
            HelpContext.registerHelp(this);
        }
        catch (HelpException helpException) {
            helpException.printStackTrace();
        }
        this.addComponents();
        this.i_lblServerIP.setText(hostView.getHostIPAddress());
        if (hostView.isCIMOMHost()) {
            JLabel jLabel = new JLabel(Resource.getString("LOGINMODE_FULLACCESS", "Full Access"));
            this.content.add(jLabel);
        } else {
            this.content.add(this.mode);
        }
        this.contentPane.add((Component)this.content, "Center");
        this.setModal(true);
        int n3 = MainFrame.SCREEN_SIZE.height > 700 ? (MainFrame.SCREEN_SIZE.height > 900 ? 225 : 275) : (n2 = 310);
        if (VivaldiStartupDialog.OEM_TYPE == 98761) {
            n = 500;
            this.banner.setPreferredSize(new Dimension(n, (int)this.banner.getDimension().getHeight()));
        } else {
            n = MainFrame.SCREEN_SIZE.width > 1100 ? 412 : 450;
        }
        this.setSize(MainFrame.SCREEN_SIZE.width * n / 1024, MainFrame.SCREEN_SIZE.height * n2 / 768);
        this.pack();
        this.setResizable(false);
        this.userName.requestFocus();
    }

    private void newaddComponents(RemoteServer remoteServer) {
        JComponent jComponent;
        this.userName = new JTextField(15);
        this.userName.setToolTipText(Resource.getString("USER_NAME_DSC", "Enter Host User Name"));
        this.password = new JPasswordField(15);
        this.password.setToolTipText(Resource.getString("PASSWORD_DSC", "Enter Host Password"));
        this.mode = VivaldiStartupDialog.isWindows ? new JComboBox<String>(new String[]{Resource.getString("LOGINMODE_FULLACCESS", "Full Access"), Resource.getString("LOGINMODE_VIEWONLY", "View Only")}) : new CustomComboBox(new String[]{Resource.getString("LOGINMODE_FULLACCESS", "Full Access"), Resource.getString("LOGINMODE_VIEWONLY", "View Only")});
        this.mode.setToolTipText(Resource.getString("LOGINMODE_DSC", "Mode"));
        String[] stringArray = Resource.getResourceMnemonic(Resource.getString("BUTTON_LOGIN_TEXT", "Login"));
        this.loginButton = new JButton(stringArray[0]);
        if (stringArray.length == 2) {
            this.loginButton.setMnemonic(stringArray[1].charAt(0));
        }
        this.cancelButton = new JButton(Resource.getString("BUTTON_CANCEL_TEXT", "Cancel"));
        stringArray = Resource.getResourceMnemonic(Resource.getString("PASSWORD_TEXT", "Password :"));
        this.passwordLabel = new JLabel(stringArray[0], 2);
        if (stringArray.length == 2) {
            this.passwordLabel.setDisplayedMnemonic(stringArray[1].charAt(0));
        }
        this.passwordLabel.setLabelFor(this.password);
        stringArray = Resource.getResourceMnemonic(Resource.getString("LOGINMODE_TEXT", "Login Mode :"));
        this.loginModeLabel = new JLabel(stringArray[0], 2);
        if (stringArray.length == 2) {
            this.loginModeLabel.setDisplayedMnemonic(stringArray[1].charAt(0));
        }
        this.loginModeLabel.setLabelFor(this.mode);
        stringArray = Resource.getResourceMnemonic(Resource.getString("USERNAME_TEXT", "User Name :"));
        this.userNameLabel = new JLabel(stringArray[0], 2);
        if (stringArray.length == 2) {
            this.userNameLabel.setDisplayedMnemonic(stringArray[1].charAt(0));
        }
        this.userNameLabel.setLabelFor(this.userName);
        this.i_lblServer = new JLabel(Resource.getString("SERVERIP_TEXT", "Server :"), 2);
        this.i_lblServerIP = new JLabel();
        this.setTitle(Resource.getString("AUTHENTICATE_DIALOG_TITLE", "Enter User Name & Password"));
        this.content.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 4, 14, 10);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.content.add((Component)this.i_lblServer, gridBagConstraints);
        ++gridBagConstraints.gridx;
        this.content.add((Component)this.i_lblServerIP, gridBagConstraints);
        String string = Resource.getString("LOGIN_TIP", "<html>Use your Operating System's login username <br>and password to login the server</html>");
        JLabel jLabel = new JLabel();
        jLabel.setText(string);
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets = new Insets(0, 4, 5, 10);
        this.content.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.insets = new Insets(0, 4, 14, 10);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        this.content.add((Component)this.userNameLabel, gridBagConstraints);
        JPanel jPanel = new JPanel(new FlowLayout(0));
        jPanel.add(this.userName);
        JButton jButton = new JButton();
        ImageIcon imageIcon = Resource.getImage("TIPIMAGE", "Help16.png");
        jButton.setOpaque(false);
        jButton.setIcon(imageIcon);
        jButton.setBorderPainted(false);
        jButton.setContentAreaFilled(false);
        jButton.setHorizontalAlignment(2);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = Resource.getString("DIALOG_TIPS_TO_LOGIN", "Please use your selected server's Operating System's username and password to login.");
                Image image = Toolkit.getDefaultToolkit().getImage(Resource.getString("LSI_PROGRAM_ICON_16", "16_prg_icon.png"));
                int n = CustomJOptionDialog.showDialog(Resource.getString("DIALOG_TIPS_TO_LOGIN_TITLE"), image, string, 1, 99, 99);
            }
        });
        jPanel.add(jButton);
        ++gridBagConstraints.gridx;
        gridBagConstraints.insets = new Insets(0, 0, 14, 10);
        this.content.add((Component)jPanel, gridBagConstraints);
        gridBagConstraints.insets = new Insets(0, 4, 14, 10);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        this.content.add((Component)this.passwordLabel, gridBagConstraints);
        ++gridBagConstraints.gridx;
        this.userName.setNextFocusableComponent(this.password);
        this.content.add((Component)this.password, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        this.content.add((Component)this.loginModeLabel, gridBagConstraints);
        this.loginModeLabel.setPreferredSize(this.password.getPreferredSize());
        ++gridBagConstraints.gridx;
        this.i_lblServerIP.setText(remoteServer.getIpAddress());
        if (remoteServer.isCIMOMHost()) {
            jComponent = new JLabel(Resource.getString("LOGINMODE_FULLACCESS", "Full Access"));
            this.content.add((Component)jComponent, gridBagConstraints);
            jComponent.setPreferredSize(this.password.getPreferredSize());
        } else {
            this.mode.setPreferredSize(this.password.getPreferredSize());
            this.content.add((Component)this.mode, gridBagConstraints);
        }
        this.userNameLabel.setForeground(ColorHash.getColor("LABEL_FRGROUND_ON_BLUE"));
        this.rootPane = this.getRootPane();
        this.i_lblServer.setForeground(ColorHash.getColor("LABEL_FRGROUND_ON_BLUE"));
        this.passwordLabel.setForeground(ColorHash.getColor("LABEL_FRGROUND_ON_BLUE"));
        this.loginModeLabel.setForeground(ColorHash.getColor("LABEL_FRGROUND_ON_BLUE"));
        this.content.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jComponent = new JPanel();
        jComponent.add(this.loginButton);
        jComponent.add(this.cancelButton);
        this.defaultButton = this.loginButton;
        this.rootPane.setDefaultButton(this.defaultButton);
        FocusAdapter focusAdapter = new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                if (focusEvent.getSource() instanceof JTextField) {
                    JTextField jTextField = (JTextField)focusEvent.getSource();
                    jTextField.setSelectionStart(0);
                    jTextField.setSelectionEnd(jTextField.getText().length());
                } else if (focusEvent.getSource() instanceof JButton) {
                    AuthenticationDialog.this.defaultButton = (JButton)focusEvent.getSource();
                    AuthenticationDialog.this.rootPane.setDefaultButton(AuthenticationDialog.this.defaultButton);
                }
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                if (focusEvent.getSource() instanceof JButton) {
                    AuthenticationDialog.this.defaultButton = AuthenticationDialog.this.loginButton;
                    AuthenticationDialog.this.rootPane.setDefaultButton(AuthenticationDialog.this.defaultButton);
                }
            }
        };
        this.userName.addFocusListener(focusAdapter);
        this.password.addFocusListener(focusAdapter);
        this.loginButton.addFocusListener(focusAdapter);
        this.cancelButton.addFocusListener(focusAdapter);
        this.contentPane.add((Component)jComponent, "South");
    }

    private void addComponents() {
        this.userName = new JTextField(15);
        this.userName.setToolTipText(Resource.getString("USER_NAME_DSC", "Enter Host User Name"));
        this.password = new JPasswordField(15);
        this.password.setToolTipText(Resource.getString("PASSWORD_DSC", "Enter Host Password"));
        this.mode = VivaldiStartupDialog.isWindows ? new JComboBox<String>(new String[]{Resource.getString("LOGINMODE_FULLACCESS", "Full Access"), Resource.getString("LOGINMODE_VIEWONLY", "View Only")}) : new CustomComboBox(new String[]{Resource.getString("LOGINMODE_FULLACCESS", "Full Access"), Resource.getString("LOGINMODE_VIEWONLY", "View Only")});
        this.mode.setToolTipText(Resource.getString("LOGINMODE_DSC", "Mode"));
        String[] stringArray = Resource.getResourceMnemonic(Resource.getString("BUTTON_LOGIN_TEXT", "Login"));
        this.loginButton = new JButton(stringArray[0]);
        if (stringArray.length == 2) {
            this.loginButton.setMnemonic(stringArray[1].charAt(0));
        }
        this.cancelButton = new JButton(Resource.getString("BUTTON_CANCEL_TEXT", "Cancel"));
        stringArray = Resource.getResourceMnemonic(Resource.getString("PASSWORD_TEXT", "Password :"));
        this.passwordLabel = new JLabel(stringArray[0]);
        if (stringArray.length == 2) {
            this.passwordLabel.setDisplayedMnemonic(stringArray[1].charAt(0));
        }
        this.passwordLabel.setLabelFor(this.password);
        stringArray = Resource.getResourceMnemonic(Resource.getString("LOGINMODE_TEXT", "Login Mode :"));
        this.loginModeLabel = new JLabel(stringArray[0]);
        if (stringArray.length == 2) {
            this.loginModeLabel.setDisplayedMnemonic(stringArray[1].charAt(0));
        }
        this.loginModeLabel.setLabelFor(this.mode);
        stringArray = Resource.getResourceMnemonic(Resource.getString("USERNAME_TEXT", "User Name :"));
        this.userNameLabel = new JLabel(stringArray[0]);
        if (stringArray.length == 2) {
            this.userNameLabel.setDisplayedMnemonic(stringArray[1].charAt(0));
        }
        this.userNameLabel.setLabelFor(this.userName);
        this.i_lblServer = new JLabel(Resource.getString("SERVERIP_TEXT", "Server :"));
        this.i_lblServerIP = new JLabel();
        this.setTitle(Resource.getString("AUTHENTICATE_DIALOG_TITLE", "Enter User Name & Password"));
        this.content.setLayout(new GridLayout(0, 2, MainFrame.SCREEN_SIZE.width * 20 / 1024, MainFrame.SCREEN_SIZE.height * 20 / 768));
        System.out.println("content size " + this.content.getSize().width + ":" + this.content.getSize().height);
        System.out.println("banner size " + this.banner.getSize().width + ":" + this.banner.getSize().height);
        this.content.add(this.i_lblServer);
        this.content.add(this.i_lblServerIP);
        JPanel jPanel = new JPanel(new BorderLayout());
        String string = Resource.getString("LOGIN_TIP", "<html>Use your Operating System's login username <br>and password to login the MSM server</html>");
        JLabel jLabel = new JLabel();
        jLabel.setText(string);
        jPanel.add((Component)jLabel, "North");
        jPanel.add((Component)this.userNameLabel, "West");
        jPanel.add((Component)this.userName, "East");
        this.content.add(this.userNameLabel);
        this.content.add(jPanel);
        this.content.add(this.passwordLabel);
        this.content.add(this.password);
        this.content.add(this.loginModeLabel);
        this.userNameLabel.setForeground(ColorHash.getColor("LABEL_FRGROUND_ON_BLUE"));
        this.rootPane = this.getRootPane();
        this.i_lblServer.setForeground(ColorHash.getColor("LABEL_FRGROUND_ON_BLUE"));
        this.passwordLabel.setForeground(ColorHash.getColor("LABEL_FRGROUND_ON_BLUE"));
        this.loginModeLabel.setForeground(ColorHash.getColor("LABEL_FRGROUND_ON_BLUE"));
        this.content.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JPanel jPanel2 = new JPanel();
        jPanel2.add(this.loginButton);
        jPanel2.add(this.cancelButton);
        this.defaultButton = this.loginButton;
        this.rootPane.setDefaultButton(this.defaultButton);
        FocusAdapter focusAdapter = new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                if (focusEvent.getSource() instanceof JTextField) {
                    JTextField jTextField = (JTextField)focusEvent.getSource();
                    jTextField.setSelectionStart(0);
                    jTextField.setSelectionEnd(jTextField.getText().length());
                } else if (focusEvent.getSource() instanceof JButton) {
                    AuthenticationDialog.this.defaultButton = (JButton)focusEvent.getSource();
                    AuthenticationDialog.this.rootPane.setDefaultButton(AuthenticationDialog.this.defaultButton);
                }
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                if (focusEvent.getSource() instanceof JButton) {
                    AuthenticationDialog.this.defaultButton = AuthenticationDialog.this.loginButton;
                    AuthenticationDialog.this.rootPane.setDefaultButton(AuthenticationDialog.this.defaultButton);
                }
            }
        };
        this.userName.addFocusListener(focusAdapter);
        this.password.addFocusListener(focusAdapter);
        this.loginButton.addFocusListener(focusAdapter);
        this.cancelButton.addFocusListener(focusAdapter);
        this.contentPane.add((Component)jPanel2, "South");
    }

    public AuthenticationDialog(RemoteServer remoteServer) {
        super((Frame)null);
        int n;
        int n2;
        this.newaddComponents(remoteServer);
        this.contentPane.add((Component)this.content, "Center");
        this.setModal(true);
        int n3 = MainFrame.SCREEN_SIZE.height > 700 ? (MainFrame.SCREEN_SIZE.height > 900 ? 225 : 275) : (n2 = 310);
        if (VivaldiStartupDialog.OEM_TYPE == 98761) {
            n = 500;
            this.banner.setPreferredSize(new Dimension(n, (int)this.banner.getDimension().getHeight()));
        } else {
            n = MainFrame.SCREEN_SIZE.width > 1100 ? 412 : 450;
        }
        this.setSize(MainFrame.SCREEN_SIZE.width * n / 1024, MainFrame.SCREEN_SIZE.height * n2 / 768);
        this.pack();
        this.setResizable(false);
        this.userName.requestFocus();
    }

    public String getUserName() {
        return this.userName.getText();
    }

    public String getPassword() {
        return new String(this.password.getPassword());
    }

    public byte getLoginMode() {
        if (this.mode.getSelectedIndex() == 0) {
            return 0;
        }
        return 1;
    }

    @Override
    public String getHelpPage() {
        return HelpContextResourse.getHelpPageName("MR_DISCOVERY_AND_LOGIN");
    }

    public void setButtonFocus() {
        this.defaultButton = this.loginButton;
        this.rootPane.setDefaultButton(this.defaultButton);
    }

    @Override
    protected final void processWindowEvent(WindowEvent windowEvent) {
        if (windowEvent.getID() == 201) {
            if (this.closeWindowFunction(windowEvent)) {
                HelpContext.unregisterHelp(this);
                this.closeOpt();
                if (SASKernel.isLocalStandAlone) {
                    System.exit(0);
                }
            }
        } else {
            super.processWindowEvent(windowEvent);
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (n == 27) {
            this.closeOpt();
            if (SASKernel.isLocalStandAlone) {
                System.exit(0);
            }
        }
    }
}

