/*
 * Decompiled with CFR 0.152.
 */
package GUI;

import GUI.BBUMenuListener;
import GUI.DetailPanel;
import GUI.MainFrame;
import GUI.OperationViewPanel;
import GUI.PropertyViewPanel;
import GUIHelper.BBUHelper;
import SASKernel.Operations.OperationDetails;
import SASKernel.SASAdapter.SASBatteryBackUp;
import Utils.CustomTabbedPane;
import Utils.Resource;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class BBUDetailPanel
extends DetailPanel {
    private CustomTabbedPane tabbedPane = new CustomTabbedPane();
    private JPanel propertiesTab = new JPanel();
    private OperationViewPanel opView;
    private BBUHelper BBU;
    private String[] mnimonics = null;
    private JMenuItem l_objSetBBUMenuItem = null;
    private ArrayList enabledOperations = new ArrayList();

    public BBUDetailPanel(BBUHelper bBUHelper, MainFrame mainFrame) {
        super(bBUHelper, mainFrame);
        this.BBU = bBUHelper;
        this.tabbedPane.addTab(Resource.getString("PROPERTY_TAB_TEXT", "Properties"), null, new JScrollPane(this.propertiesTab), Resource.getString("PROPERTY_TAB_TEXT", "Properties"));
        this.add((Component)this.tabbedPane, "Center");
        this.propertiesTab.setLayout(new BorderLayout());
        this.init();
        this.BBU.addObserver(this);
    }

    @Override
    public void init() {
        this.propertiesTab.removeAll();
        PropertyViewPanel propertyViewPanel = new PropertyViewPanel(this.BBU.getPropertyList());
        this.propertiesTab.add((Component)propertyViewPanel, "North");
    }

    @Override
    public boolean canClose() {
        this.BBU.deleteObserver(this);
        return true;
    }

    @Override
    public void gotoTab(int n) {
        this.tabbedPane.setSelectedIndex(n);
    }

    @Override
    public JMenu getSubMenu(JMenu jMenu) {
        int n = jMenu.getItemCount();
        JMenu jMenu2 = null;
        for (int i = 0; i < n; ++i) {
            jMenu2 = (JMenu)jMenu.getItem(i);
            if (!jMenu2.getName().trim().equals("BBU")) continue;
            return jMenu2;
        }
        return jMenu2;
    }

    @Override
    public void populateOperationMenu(JMenu jMenu, OperationDetails operationDetails) {
        if (jMenu == null) {
            return;
        }
        String[] stringArray = null;
        switch (operationDetails.getOpcode()) {
            case 1168: {
                stringArray = Resource.getResourceMnemonic(Resource.getString("BBU_OPERATION_START_LEARN", "(S)tart Manual Learn Cycle"));
                this.l_objSetBBUMenuItem = new JMenuItem();
                this.l_objSetBBUMenuItem.setText(stringArray[0]);
                if (stringArray.length == 2) {
                    this.l_objSetBBUMenuItem.setMnemonic(stringArray[1].charAt(0));
                }
                this.l_objSetBBUMenuItem.setActionCommand("1168");
                this.l_objSetBBUMenuItem.addActionListener(new BBUMenuListener(this.BBU));
                this.enabledOperations.add(1168);
                jMenu.add(this.l_objSetBBUMenuItem);
                break;
            }
            case 1167: {
                if (!((SASBatteryBackUp)this.BBU.getDeviceObject()).isOperationAllowed(4)) {
                    return;
                }
                stringArray = Resource.getResourceMnemonic(Resource.getString("BBU_OPERATION_SET_LEARN_PROP", "Set Learn Cycle Properties"));
                this.l_objSetBBUMenuItem = new JMenuItem();
                this.l_objSetBBUMenuItem.setText(stringArray[0]);
                if (stringArray.length == 2) {
                    this.l_objSetBBUMenuItem.setMnemonic(stringArray[1].charAt(0));
                }
                this.l_objSetBBUMenuItem.setActionCommand("1167");
                this.l_objSetBBUMenuItem.addActionListener(new BBUMenuListener(this.BBU));
                this.enabledOperations.add(1167);
                jMenu.add(this.l_objSetBBUMenuItem);
            }
        }
    }

    @Override
    public ArrayList getEnabledOpers() {
        System.out.println("inside adapetr getEnabledOpers");
        return this.enabledOperations;
    }
}

