/*
 * Decompiled with CFR 0.152.
 */
package GUI;

import GUI.BBUPropDialog;
import GUI.VivaldiStartupDialog;
import GUIHelper.BBUHelper;
import KernelExceptions.VKInvalidOperationException;
import KernelExceptions.VKNotRespondingException;
import KernelExceptions.VKOperationFailedException;
import SASKernel.LibraryAPI.StoreLib.MR_BBU_DESIGN_INFO;
import SASKernel.LibraryAPI.StoreLib.MR_BBU_STATUS;
import SASKernel.Operations.OperationDetails;
import SASKernel.SASAdapter.SASBatteryBackUp;
import Utils.CustomMsgBox;
import Utils.Resource;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JDialog;
import javax.swing.JOptionPane;

public class BBUMenuListener
implements ActionListener {
    private BBUHelper bbu;

    public BBUMenuListener(BBUHelper bBUHelper) {
        this.bbu = bBUHelper;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        int n = -1;
        try {
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        switch (n) {
            case 1168: {
                try {
                    boolean bl;
                    OperationDetails operationDetails = new OperationDetails(3, "", "", null);
                    MR_BBU_DESIGN_INFO mR_BBU_DESIGN_INFO = null;
                    try {
                        mR_BBU_DESIGN_INFO = ((SASBatteryBackUp)this.bbu.getDeviceObject()).getDesignInfo();
                    }
                    catch (VKInvalidOperationException vKInvalidOperationException) {
                    }
                    catch (VKOperationFailedException vKOperationFailedException) {
                    }
                    catch (VKNotRespondingException vKNotRespondingException) {
                        // empty catch block
                    }
                    MR_BBU_STATUS mR_BBU_STATUS = ((SASBatteryBackUp)this.bbu.getDeviceObject()).getInformation().getStatus();
                    boolean bl2 = bl = mR_BBU_DESIGN_INFO.gettransparentLearns() == '\u0001' && mR_BBU_STATUS.getbatteryType() == '\u0006';
                    if (bl) {
                        String string2 = Resource.getString("SUPERCAP_MANUAL_LEARN_TITLE", "Manual Learn Cycle");
                        JOptionPane jOptionPane = new JOptionPane(Resource.getString("SUPERCAP_MANUAL_LEARN", "A battery learn cycle may take few minutes to complete."), 1);
                        this.createDialog(jOptionPane, string2);
                    } else {
                        StringBuffer stringBuffer = new StringBuffer(Resource.getString("CONFIRM_MANUAL_LEARN_CYCLE", "<html>A battery learn cycle may take up to 8 hours to complete and this may<br>affect the system performance.<br><br>Are you sure you want to start the manual learn cycle now?"));
                        if (!CustomMsgBox.confirmWithCheck(VivaldiStartupDialog.mainScreen, Resource.getString("CONFIRM_START_LEARN_CYCLE_TITLE", "Start Manual Learn Cycle"), stringBuffer.toString())) {
                            return;
                        }
                    }
                    this.bbu.issueOperation(operationDetails);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                break;
            }
            case 1167: {
                try {
                    new BBUPropDialog(this.bbu, this.bbu.getBBUInfo().getProperties());
                    break;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }

    private void createDialog(JOptionPane jOptionPane, String string) {
        JDialog jDialog = jOptionPane.createDialog(string);
        Image image = Toolkit.getDefaultToolkit().getImage(Resource.getString("LSI_PROGRAM_ICON_16", "16_prg_icon.png"));
        jDialog.setIconImage(image);
        jDialog.setVisible(true);
    }
}

