/*
 * Decompiled with CFR 0.152.
 */
package GUI;

import GUI.VivaldiBaseDialog;
import GUIHelper.AdapterHelper;
import GUIHelper.BBUHelper;
import KernelExceptions.VKInvalidOperationException;
import KernelExceptions.VKNotRespondingException;
import KernelExceptions.VKOperationFailedException;
import KernelServices.NotifyObject;
import SASKernel.LibraryAPI.StoreLib.MR_BBU_DESIGN_INFO;
import SASKernel.LibraryAPI.StoreLib.MR_BBU_PROPERTIES;
import SASKernel.LibraryAPI.StoreLib.MR_BBU_STATE;
import SASKernel.LibraryAPI.StoreLib.MR_BBU_STATUS;
import SASKernel.LibraryAPI.StoreLib.MR_EVT_DETAIL;
import SASKernel.Operations.OperationDetails;
import SASKernel.SASAdapter.SASBBUInformation;
import SASKernel.SASAdapter.SASBatteryBackUp;
import Services.NetworkToJavaConverter;
import Utils.CustomMsgBox;
import Utils.GUIUtils;
import Utils.Resource;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Observable;
import java.util.Observer;
import java.util.TimeZone;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class BBUPropDialog
extends VivaldiBaseDialog
implements Observer {
    private BBUHelper m_bbu;
    private MR_BBU_PROPERTIES m_bbuProp;
    private JCheckBox remindStartLearnCheckBox = new JCheckBox();
    private JLabel comboLabel = null;
    private JComboBox opModeCombo = null;
    private JPanel comboPanel = null;
    private JSpinner delayLearnCycle = null;
    private JLabel hours = null;
    private JButton m_okButton = new JButton();
    private JButton m_apply = new JButton();
    private JButton cancelButton = new JButton();
    private JComboBox bbuTime = null;
    private JPanel starttimepanel = null;
    private JPanel delayNLCPanel = null;
    private JPanel mainPanel = null;
    private JPanel autoPanel = null;
    private JLabel startOnLabel = null;
    private JComboBox scheduleDay = null;
    private JLabel delayTextLabel = null;
    private JComboBox delayLearnCycleDays = null;
    private JLabel daysTextLabel = null;
    private SASBBUInformation BBUInfo;
    private int iAutoLearnMode = 0;
    private int dayDelay = 0;
    private int hourDelay = 0;
    SimpleDateFormat nextScheduleDateFormat = null;
    SimpleDateFormat nextScheduleDayOfTheWeekFormat = null;
    SimpleDateFormat nextScheduleHourMinuteFormat = null;
    String strNextLearnText = null;
    private JLabel objNextLearnLabel = null;
    GridBagConstraints gbcbbuautoPanel = null;
    GridBagConstraints gbcBbuComboPanel = null;
    OperationDetails od = null;
    JLabel autolearndescLable = new JLabel();

    public BBUPropDialog(BBUHelper bBUHelper, MR_BBU_PROPERTIES mR_BBU_PROPERTIES) {
        JComponent jComponent;
        boolean bl;
        this.m_bbu = bBUHelper;
        this.BBUInfo = this.m_bbu.getBBUInfo();
        this.m_bbuProp = this.BBUInfo.getProperties();
        this.m_bbu.addObserver(this);
        MR_BBU_DESIGN_INFO mR_BBU_DESIGN_INFO = null;
        try {
            mR_BBU_DESIGN_INFO = ((SASBatteryBackUp)this.m_bbu.getDeviceObject()).getDesignInfo();
        }
        catch (VKInvalidOperationException vKInvalidOperationException) {
        }
        catch (VKOperationFailedException vKOperationFailedException) {
        }
        catch (VKNotRespondingException vKNotRespondingException) {
            // empty catch block
        }
        String[] stringArray = null;
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        MR_BBU_STATUS mR_BBU_STATUS = ((SASBatteryBackUp)this.m_bbu.getDeviceObject()).getInformation().getStatus();
        boolean bl2 = bl = mR_BBU_DESIGN_INFO.gettransparentLearns() == '\u0001' && mR_BBU_STATUS.getbatteryType() == '\u0006';
        if (bl) {
            jComponent = new JLabel(Resource.getString("AUTO_TRANSPARENT_TEXT", "You cannot set the battery learn cycle properties because, the battery is under transparent learn cycle mode."));
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.insets = new Insets(10, 15, 30, 15);
            this.mainPanel.add((Component)jComponent, gridBagConstraints);
        } else {
            int n;
            boolean bl3;
            TimeZone timeZone;
            long l;
            GregorianCalendar gregorianCalendar;
            long l2;
            try {
                ((SASBatteryBackUp)this.m_bbu.getDeviceObject()).refresh();
            }
            catch (VKNotRespondingException vKNotRespondingException) {
                vKNotRespondingException.printStackTrace();
            }
            catch (VKOperationFailedException vKOperationFailedException) {
                vKOperationFailedException.printStackTrace();
            }
            this.m_bbuProp = ((SASBatteryBackUp)this.m_bbu.getDeviceObject()).getInformation().getProperties();
            stringArray = Resource.getResourceMnemonic(Resource.getString("BBU_LEARN_DESC", "Description: Sets the learn cycle properties for the battery backup unit"));
            jComponent = new JLabel(stringArray[0]);
            if (stringArray.length == 2) {
                ((JLabel)jComponent).setDisplayedMnemonic(stringArray[1].charAt(0));
            }
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.insets = new Insets(10, 15, 10, 0);
            gridBagConstraints.weighty = 10.0;
            this.mainPanel.add((Component)jComponent, gridBagConstraints);
            this.autoPanel = new JPanel(new GridBagLayout());
            this.gbcbbuautoPanel = new GridBagConstraints();
            stringArray = Resource.getResourceMnemonic(Resource.getString("AUTO_LEARN_CYCLE", "Automatic (L)earn Mode:"));
            this.comboLabel = new JLabel(stringArray[0]);
            if (stringArray.length == 2) {
                this.comboLabel.setDisplayedMnemonic(stringArray[1].charAt(0));
            }
            String[] stringArray2 = new String[]{Resource.getString("TEXT_BBUAUTO_ENABLE", "Enable"), Resource.getString("TEXT_BBUAUTO_DISABLE", "Disable"), Resource.getString("AUTO_LEARN_WARN", "Warn Via Event")};
            this.opModeCombo = new JComboBox<String>(stringArray2);
            this.opModeCombo.setSelectedIndex(0);
            this.comboLabel.setLabelFor(this.opModeCombo);
            if (mR_BBU_DESIGN_INFO.gettransparentLearns() == '\u0001') {
                this.opModeCombo.setEnabled(false);
            } else {
                this.opModeCombo.setEnabled(true);
            }
            this.comboPanel = new JPanel(new GridBagLayout());
            this.gbcBbuComboPanel = new GridBagConstraints();
            this.gbcBbuComboPanel.anchor = 17;
            this.gbcBbuComboPanel.gridx = 0;
            this.gbcBbuComboPanel.gridy = 0;
            this.gbcBbuComboPanel.insets = new Insets(5, 5, 5, 0);
            this.comboPanel.add((Component)this.comboLabel, this.gbcBbuComboPanel);
            this.gbcBbuComboPanel.gridx = 1;
            this.gbcBbuComboPanel.gridy = 0;
            this.comboPanel.add((Component)this.opModeCombo, this.gbcBbuComboPanel);
            this.gbcBbuComboPanel.gridx = 2;
            this.gbcBbuComboPanel.gridy = 0;
            this.gbcBbuComboPanel.insets = new Insets(5, 25, 5, 0);
            this.iAutoLearnMode = this.BBUInfo.getProperties().getautoLearnMode();
            this.autolearndescLable.setText(this.getLearnClycleDescription(this.iAutoLearnMode));
            this.comboPanel.add((Component)this.autolearndescLable, this.gbcBbuComboPanel);
            this.gbcbbuautoPanel.anchor = 17;
            this.gbcbbuautoPanel.gridx = 0;
            this.gbcbbuautoPanel.gridy = 0;
            this.gbcbbuautoPanel.insets = new Insets(5, 5, 5, 0);
            this.autoPanel.add((Component)this.comboPanel, this.gbcbbuautoPanel);
            short s = NetworkToJavaConverter.getUnsignedVal(this.m_bbuProp.getLeanDelayInterval());
            this.dayDelay = s / 24;
            this.hourDelay = s % 24;
            if (this.iAutoLearnMode == 2) {
                this.strNextLearnText = Resource.getString("BBU_NEXTEVENT_GENERATION", "Next Event Generation Time:");
            } else if (this.iAutoLearnMode == 0) {
                this.strNextLearnText = Resource.getString("BBU_NEXTLEARN_CYCLE", "Next Learn Cycle Time");
            }
            long l3 = this.m_bbuProp.getnextLeanTime();
            byte by = this.m_bbuProp.getautoLearnMode();
            Date date = null;
            try {
                l2 = l3 * 1000L;
                if (by != 1 && l2 != 0L) {
                    gregorianCalendar = new GregorianCalendar(2000, 0, 1, 0, 0, 0);
                    l = gregorianCalendar.getTimeInMillis();
                    timeZone = TimeZone.getDefault();
                    gregorianCalendar.setTimeInMillis(l + l2);
                    bl3 = timeZone.inDaylightTime(gregorianCalendar.getTime());
                    System.out.println("dstSavings:" + bl3);
                    if (bl3) {
                        n = timeZone.getDSTSavings();
                        gregorianCalendar.setTimeInMillis(l + l2 - (long)n + (long)(s * 60 * 60 * 1000));
                    } else {
                        gregorianCalendar.setTimeInMillis(l + l2 + (long)(s * 60 * 60 * 1000));
                    }
                    date = gregorianCalendar.getTime();
                }
            }
            catch (Exception exception) {
                System.out.println(exception.getMessage());
            }
            this.nextScheduleDayOfTheWeekFormat = new SimpleDateFormat("EEEE,");
            this.nextScheduleDateFormat = new SimpleDateFormat("MMMM dd,yyyy");
            this.nextScheduleHourMinuteFormat = new SimpleDateFormat("h:mm a");
            if (this.iAutoLearnMode == 0) {
                this.objNextLearnLabel = date == null ? new JLabel(Resource.getString("NEXT_LEARN_CYCLE_TIME", this.strNextLearnText) + " " + Resource.getString("COER_MODE_NONE", "None")) : (this.dayDelay == 0 && this.hourDelay == 0 ? new JLabel(Resource.getString("NEXT_LEARN_CYCLE_TIME", this.strNextLearnText) + " " + this.nextScheduleDayOfTheWeekFormat.format(date) + " " + this.nextScheduleDateFormat.format(date) + " " + Resource.getString("BBU_AT", "At") + " " + this.nextScheduleHourMinuteFormat.format(date)) : (this.dayDelay != 0 && this.hourDelay == 0 ? new JLabel(Resource.getString("NEXT_LEARN_CYCLE_TIME", this.strNextLearnText) + " " + this.nextScheduleDayOfTheWeekFormat.format(date) + " " + this.nextScheduleDateFormat.format(date) + " " + Resource.getString("BBU_AT", "At") + " " + this.nextScheduleHourMinuteFormat.format(date) + " " + Resource.getString("INCLUDING", "(including") + " " + this.dayDelay + " " + Resource.getString("BBU_DAYS", "day(s)") + " " + Resource.getString("BBU_DELAY", "delay)")) : (this.dayDelay == 0 && this.hourDelay != 0 ? new JLabel(Resource.getString("NEXT_LEARN_CYCLE_TIME", this.strNextLearnText) + " " + this.nextScheduleDayOfTheWeekFormat.format(date) + " " + this.nextScheduleDateFormat.format(date) + " " + Resource.getString("BBU_AT", "At") + " " + this.nextScheduleHourMinuteFormat.format(date) + " " + Resource.getString("INCLUDING", "(including") + " " + " " + this.hourDelay + " " + Resource.getString("DELAY_HOURS", "hour(s)") + " " + Resource.getString("BBU_DELAY", "delay)")) : new JLabel(Resource.getString("NEXT_LEARN_CYCLE_TIME", this.strNextLearnText) + " " + this.nextScheduleDayOfTheWeekFormat.format(date) + " " + this.nextScheduleDateFormat.format(date) + " " + Resource.getString("BBU_AT", "At") + " " + this.nextScheduleHourMinuteFormat.format(date) + " " + Resource.getString("INCLUDING", "(including") + " " + this.dayDelay + " " + Resource.getString("BBU_DAYS", "day(s)") + " " + Resource.getString("BBU_AND", "and") + " " + this.hourDelay + " " + Resource.getString("DELAY_HOURS", "hour(s)") + " " + Resource.getString("BBU_DELAY", "delay)")))));
            } else if (this.iAutoLearnMode == 2) {
                this.objNextLearnLabel = date == null ? new JLabel(Resource.getString("BBU_NEXTEVENT_GENERATION_TIME", this.strNextLearnText) + " " + Resource.getString("COER_MODE_NONE", "None")) : (this.dayDelay == 0 && this.hourDelay == 0 ? new JLabel(Resource.getString("BBU_NEXTEVENT_GENERATION_TIME", this.strNextLearnText) + " " + this.nextScheduleDayOfTheWeekFormat.format(date) + " " + this.nextScheduleDateFormat.format(date) + " " + Resource.getString("BBU_AT", "At") + " " + this.nextScheduleHourMinuteFormat.format(date)) : (this.dayDelay != 0 && this.hourDelay == 0 ? new JLabel(Resource.getString("BBU_NEXTEVENT_GENERATION_TIME", this.strNextLearnText) + " " + this.nextScheduleDayOfTheWeekFormat.format(date) + " " + this.nextScheduleDateFormat.format(date) + " " + Resource.getString("BBU_AT", "At") + " " + this.nextScheduleHourMinuteFormat.format(date) + " " + Resource.getString("INCLUDING", "(including") + " " + this.dayDelay + " " + Resource.getString("BBU_DAYS", "day(s)") + " " + Resource.getString("BBU_DELAY", "delay)")) : (this.dayDelay == 0 && this.hourDelay != 0 ? new JLabel(Resource.getString("BBU_NEXTEVENT_GENERATION_TIME", this.strNextLearnText) + " " + this.nextScheduleDayOfTheWeekFormat.format(date) + " " + this.nextScheduleDateFormat.format(date) + " " + Resource.getString("BBU_AT", "At") + " " + this.nextScheduleHourMinuteFormat.format(date) + " " + Resource.getString("INCLUDING", "(including") + " " + " " + this.hourDelay + " " + Resource.getString("DELAY_HOURS", "hour(s)") + " " + Resource.getString("BBU_DELAY", "delay)")) : new JLabel(Resource.getString("BBU_NEXTEVENT_GENERATION_TIME", this.strNextLearnText) + " " + this.nextScheduleDayOfTheWeekFormat.format(date) + " " + this.nextScheduleDateFormat.format(date) + " " + Resource.getString("BBU_AT", "At") + " " + this.nextScheduleHourMinuteFormat.format(date) + " " + Resource.getString("INCLUDING", "(including") + " " + this.dayDelay + " " + Resource.getString("BBU_DAYS", "day(s)") + " " + Resource.getString("BBU_AND", "and") + " " + this.hourDelay + " " + Resource.getString("DELAY_HOURS", "hour(s)") + " " + Resource.getString("BBU_DELAY", "delay)")))));
            } else if (this.iAutoLearnMode == 1) {
                this.objNextLearnLabel = new JLabel(Resource.getString("NEXT_LEARN_CYCLE_TIME", this.strNextLearnText) + " " + Resource.getString("COER_MODE_NONE", "None"));
            }
            if (this.gbcbbuautoPanel != null || this.objNextLearnLabel != null) {
                this.gbcbbuautoPanel.gridx = 0;
                this.gbcbbuautoPanel.gridy = 1;
                this.gbcbbuautoPanel.insets = new Insets(5, 5, 5, 0);
                this.autoPanel.add((Component)this.objNextLearnLabel, this.gbcbbuautoPanel);
            }
            if (this.getRealTimeScheduler() == 1) {
                int n2;
                l2 = l3 * 1000L;
                gregorianCalendar = new GregorianCalendar(2000, 0, 1, 0, 0, 0);
                l = gregorianCalendar.getTimeInMillis();
                timeZone = TimeZone.getDefault();
                gregorianCalendar.setTimeInMillis(l + l2);
                bl3 = timeZone.inDaylightTime(gregorianCalendar.getTime());
                if (bl3) {
                    n = timeZone.getDSTSavings();
                    gregorianCalendar.setTimeInMillis(l + l2 - (long)n);
                } else {
                    gregorianCalendar.setTimeInMillis(l + l2);
                }
                stringArray = Resource.getResourceMnemonic(Resource.getString("START_ON", "(S)tart on:"));
                this.startOnLabel = new JLabel(stringArray[0]);
                if (stringArray.length == 2) {
                    this.startOnLabel.setDisplayedMnemonic(stringArray[1].charAt(0));
                }
                String[] stringArray3 = new String[]{Resource.getString("DAY_SUNDAY_TEXT", "Sunday"), Resource.getString("DAY_MONDAY_TEXT", "Monday"), Resource.getString("DAY_TUESDAY_TEXT", "Tuesday"), Resource.getString("DAY_WEDNESDAY_TEXT", "Wednesday"), Resource.getString("DAY_THURSDAY_TEXT", "Thursday"), Resource.getString("DAY_FRIDAY_TEXT", "Friday"), Resource.getString("DAY_SATURDAY_TEXT", "Saturday")};
                this.scheduleDay = new JComboBox<String>(stringArray3);
                this.startOnLabel.setLabelFor(this.scheduleDay);
                int n3 = gregorianCalendar.get(7) - 1;
                this.scheduleDay.setSelectedIndex(n3);
                this.bbuTime = new JComboBox();
                String[] stringArray4 = new String[]{"12:00", "01:00", "02:00", "03:00", "04:00", "05:00", "06:00", "07:00", "08:00", "09:00", "10:00", "11:00"};
                for (n2 = 0; n2 < stringArray4.length; ++n2) {
                    this.bbuTime.addItem(stringArray4[n2] + " " + Resource.getString("TIME_AM_TEXT", "AM"));
                }
                for (n2 = 0; n2 < stringArray4.length; ++n2) {
                    this.bbuTime.addItem(stringArray4[n2] + " " + Resource.getString("TIME_PM_TEXT", "PM"));
                }
                String string = (gregorianCalendar.get(10) < 10 ? "0" : "") + new Integer(gregorianCalendar.get(10)).toString() + ":00 " + (gregorianCalendar.get(9) == 0 ? Resource.getString("TIME_AM_TEXT", "AM") : Resource.getString("TIME_PM_TEXT", "PM"));
                if (string.equals("00:00 PM")) {
                    string = "12:00 PM";
                }
                this.bbuTime.setSelectedItem(string);
                this.starttimepanel = new JPanel(new FlowLayout(0));
                this.starttimepanel.add(this.startOnLabel);
                this.starttimepanel.add(this.scheduleDay);
                this.starttimepanel.add(this.bbuTime);
                this.gbcbbuautoPanel.gridy = 4;
                this.gbcbbuautoPanel.insets = new Insets(5, 0, 5, 0);
                this.autoPanel.add((Component)this.starttimepanel, this.gbcbbuautoPanel);
            }
            stringArray = Resource.getResourceMnemonic(Resource.getString("DELAY_NEXT_LEARN_CYCLE", "(D)elay next learn cycle by"));
            this.delayTextLabel = new JLabel(stringArray[0]);
            if (stringArray.length == 2) {
                this.delayTextLabel.setDisplayedMnemonic(stringArray[1].charAt(0));
            }
            String[] stringArray5 = new String[]{"0", "1", "2", "3", "4", "5", "6", "7"};
            this.delayLearnCycleDays = new JComboBox<String>(stringArray5);
            this.delayTextLabel.setLabelFor(this.delayLearnCycleDays);
            this.delayLearnCycleDays.setSelectedIndex(this.dayDelay);
            this.daysTextLabel = new JLabel(Resource.getString("DAYS_TEXT", "day(s)"));
            this.delayLearnCycle = new JSpinner(new SpinnerNumberModel(this.hourDelay, 0, 23, 1));
            this.delayLearnCycle.setValue(this.hourDelay);
            this.hours = new JLabel(Resource.getString("DELAY_HOURS", "hour(s)") + " " + Resource.getString("BBU_NOTE_TEXT", "(Note: Please enter a value between 0 to 23 hours.)"));
            this.delayNLCPanel = new JPanel(new FlowLayout(0));
            this.delayNLCPanel.add(this.delayTextLabel);
            this.delayNLCPanel.add(this.delayLearnCycleDays);
            this.delayNLCPanel.add(this.daysTextLabel);
            this.delayNLCPanel.add(this.delayLearnCycle);
            this.delayNLCPanel.add(this.hours);
            this.delayLearnCycleDays.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    BBUPropDialog.this.m_apply.setEnabled(true);
                    if (BBUPropDialog.this.delayLearnCycleDays.getSelectedIndex() == 7) {
                        BBUPropDialog.this.delayLearnCycle.setEnabled(false);
                    } else {
                        BBUPropDialog.this.delayLearnCycle.setEnabled(true);
                    }
                }
            });
            this.gbcbbuautoPanel.gridx = 0;
            this.gbcbbuautoPanel.gridy = 6;
            this.gbcbbuautoPanel.insets = new Insets(0, 0, 5, 0);
            this.autoPanel.add((Component)this.delayNLCPanel, this.gbcbbuautoPanel);
            this.BBUInfo = this.m_bbu.getBBUInfo();
            this.iAutoLearnMode = this.BBUInfo.getProperties().getautoLearnMode();
            if (this.iAutoLearnMode == 1) {
                this.opModeCombo.setSelectedIndex(1);
                this.opModeComboDisabled();
            } else if (this.iAutoLearnMode == 2) {
                this.opModeCombo.setSelectedIndex(2);
                this.opModeComboDisabled();
            } else if (this.iAutoLearnMode == 0) {
                this.opModeCombo.setSelectedIndex(0);
                this.opModeComboEnabled();
                if (this.dayDelay == 7) {
                    this.delayLearnCycle.setEnabled(false);
                }
            }
            this.opModeCombo.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n = BBUPropDialog.this.opModeCombo.getSelectedIndex();
                    BBUPropDialog.this.m_apply.setEnabled(true);
                    BBUPropDialog.this.autolearndescLable.setText(BBUPropDialog.this.getLearnClycleDescription(n));
                    if (BBUPropDialog.this.opModeCombo.getSelectedIndex() == 0) {
                        BBUPropDialog.this.opModeComboEnabled();
                    } else if (BBUPropDialog.this.opModeCombo.getSelectedIndex() == 1) {
                        BBUPropDialog.this.opModeComboDisabled();
                    } else if (BBUPropDialog.this.opModeCombo.getSelectedIndex() == 2) {
                        BBUPropDialog.this.opModeWarnEnabled();
                    }
                }
            });
            if (this.getRealTimeScheduler() == 1) {
                if (this.scheduleDay != null) {
                    this.scheduleDay.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            BBUPropDialog.this.m_apply.setEnabled(true);
                        }
                    });
                }
                if (this.bbuTime != null) {
                    this.bbuTime.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            BBUPropDialog.this.m_apply.setEnabled(true);
                        }
                    });
                }
            }
            this.delayLearnCycle.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    BBUPropDialog.this.m_apply.setEnabled(true);
                }
            });
            gridBagConstraints.gridy = 3;
            gridBagConstraints.insets = new Insets(0, 15, 0, 15);
            gridBagConstraints.weighty = 350.0;
            this.mainPanel.add((Component)this.autoPanel, gridBagConstraints);
        }
        jComponent = new JPanel(new GridLayout(1, 0, 10, 10));
        stringArray = Resource.getResourceMnemonic(Resource.getString("BBU_APPLY", "(A)pply"));
        this.m_apply = new JButton(stringArray[0]);
        if (stringArray.length == 2) {
            this.m_apply.setMnemonic(stringArray[1].charAt(0));
        }
        this.getRootPane().setDefaultButton(this.m_apply);
        stringArray = Resource.getResourceMnemonic(Resource.getString("ABOUT_OKBUTTON_TEXT", "OK"));
        this.m_okButton = new JButton(stringArray[0]);
        this.getRootPane().setDefaultButton(this.m_okButton);
        stringArray = Resource.getResourceMnemonic(Resource.getString("BUTTON_CLOSE", "Cancel"));
        this.cancelButton = new JButton(stringArray[0]);
        jComponent.add(this.m_apply);
        jComponent.add(this.m_okButton);
        jComponent.add(this.cancelButton);
        gridBagConstraints.gridy = 5;
        gridBagConstraints.insets = new Insets(0, 0, 10, 15);
        gridBagConstraints.anchor = 26;
        this.mainPanel.add((Component)jComponent, gridBagConstraints);
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BBUPropDialog.this.windowClosingOption();
            }
        });
        this.m_apply.setEnabled(false);
        this.m_apply.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BBUPropDialog.this.performOperations();
                try {
                    ((SASBatteryBackUp)BBUPropDialog.this.m_bbu.getDeviceObject()).refresh();
                }
                catch (VKNotRespondingException vKNotRespondingException) {
                    vKNotRespondingException.printStackTrace();
                }
                catch (VKOperationFailedException vKOperationFailedException) {
                    vKOperationFailedException.printStackTrace();
                }
                BBUPropDialog.this.m_bbuProp = ((SASBatteryBackUp)BBUPropDialog.this.m_bbu.getDeviceObject()).getInformation().getProperties();
            }
        });
        this.m_okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (BBUPropDialog.this.m_apply.isEnabled()) {
                    BBUPropDialog.this.performOperations();
                }
                BBUPropDialog.this.dispose();
            }
        });
        this.add((Component)this.mainPanel, "West");
        this.setTitle(Resource.getString("BBU_OPERATION_SET_LEARN_PROP_TITLE", "Set Learn Cycle Properties"));
        this.setModal(true);
        this.setResizable(false);
        this.pack();
        GUIUtils.centerDialogOnScreen(this);
        this.setVisible(true);
    }

    private void windowClosingOption() {
        if (CustomMsgBox.confirm(this.mainPanel, Resource.getString("BBU_CLOSE", "Do you want to close the wizard ?"))) {
            this.m_bbu.deleteObserver(this);
            this.dispose();
        }
    }

    private int getRealTimeScheduler() {
        return ((AdapterHelper)this.m_bbu.getParent()).getAdapterInfo().getadapterOperationsEx_MR_CTRL_INFO().getRealTimeScheduler();
    }

    private void createDialog(JOptionPane jOptionPane, String string) {
        JDialog jDialog = jOptionPane.createDialog(this, string);
        Image image = Toolkit.getDefaultToolkit().getImage(Resource.getString("LSI_PROGRAM_ICON_16", "16_prg_icon.png"));
        jDialog.setIconImage(image);
        jDialog.setVisible(true);
    }

    private void performOperations() {
        boolean bl;
        this.od = new OperationDetails(5, "", "", null);
        MR_BBU_STATE mR_BBU_STATE = null;
        try {
            mR_BBU_STATE = ((SASBatteryBackUp)this.m_bbu.getDeviceObject()).getStatus().getMr_bbu_status_detail().getMR_BBU_STATE();
        }
        catch (VKInvalidOperationException vKInvalidOperationException) {
        }
        catch (VKOperationFailedException vKOperationFailedException) {
        }
        catch (VKNotRespondingException vKNotRespondingException) {
            // empty catch block
        }
        MR_BBU_STATUS mR_BBU_STATUS = ((SASBatteryBackUp)this.m_bbu.getDeviceObject()).getInformation().getStatus();
        MR_BBU_DESIGN_INFO mR_BBU_DESIGN_INFO = ((SASBatteryBackUp)this.m_bbu.getDeviceObject()).getInformation().getDesignInfo();
        boolean bl2 = bl = mR_BBU_DESIGN_INFO.gettransparentLearns() == '\u0001' && mR_BBU_STATUS.getbatteryType() == '\u0006';
        if (bl) {
            this.dispose();
            return;
        }
        if (mR_BBU_STATE != null && mR_BBU_STATE.getAutoLearnModeSupport() == '\u0000') {
            this.dispose();
            return;
        }
        if (this.opModeCombo.getSelectedIndex() == 2) {
            this.m_bbuProp.setautoLearnMode((byte)2);
            this.od.setParameter(this.m_bbuProp);
            this.m_bbu.issueOperation(this.od);
            this.m_apply.setEnabled(false);
            String string = Resource.getString("BBU_REMIND_LEARN_INFO_MESSAGE_TITLE", "Information - Alert mode");
            JOptionPane jOptionPane = new JOptionPane(Resource.getString("BBU_REMIND_LEARN_INFO_MESAGE", "<html>An event will be generated to notify you when to start the manual learn<br>cycle. Manual Learn Cycle can be started using Start Manual Learn<br>Cycle option on BBU node in the physical view.<br><br></html>"), 1);
            this.createDialog(jOptionPane, string);
        } else if (this.opModeCombo.getSelectedIndex() == 0) {
            int n;
            this.m_bbuProp.setautoLearnMode((byte)0);
            if (this.getRealTimeScheduler() == 1) {
                boolean bl3;
                String string = this.bbuTime.getSelectedItem().toString();
                n = new Integer(string.substring(0, 2));
                boolean bl4 = bl3 = this.bbuTime.getSelectedIndex() > 11;
                if (bl3 && n != 12) {
                    n += 12;
                }
                if (!bl3 && n == 12) {
                    n -= 12;
                }
                System.out.println("selHour:" + n);
                int n2 = this.scheduleDay.getSelectedIndex();
                System.out.println("seldayofweek:" + n2);
                Calendar calendar = GregorianCalendar.getInstance();
                ++n2;
                int n3 = calendar.get(7);
                int n4 = calendar.get(11);
                System.out.println("presentHour:" + n4);
                long l = n4 * 60 * 60;
                int n5 = calendar.get(12);
                System.out.println("presentMin:" + n5);
                int n6 = calendar.get(13);
                System.out.println("presentSec:" + n6);
                int n7 = 60 - n6;
                int n8 = n;
                long l2 = n8 * 60 * 60;
                int n9 = 0;
                long l3 = 0L;
                long l4 = (24 - (n4 + 1)) * 60 * 60;
                long l5 = (60 - (n5 + 1)) * 60;
                long l6 = (n4 + 1) * 60 * 60;
                if (n2 == n3 && n8 > n4) {
                    n9 = 0;
                    long l7 = l2 - l6;
                    long l8 = l2 - l;
                    l3 = n6 > 0 ? (n5 > 0 ? l7 + l5 + (long)n7 : l7 + (long)n7) : (n5 > 0 ? l7 + l5 : l8);
                } else {
                    if (n3 == 7) {
                        n3 = 0;
                    }
                    while (n3 + 1 != n2) {
                        ++n9;
                        if (++n3 != 7) continue;
                        n3 = 0;
                    }
                    l3 = n6 > 0 ? (n5 > 0 ? l4 + l5 + (long)n7 + l2 : l4 + (long)n7 + l2) : (n5 > 0 ? l4 + l5 + l2 : l4 + l2);
                }
                System.out.println("dayCount:" + n9);
                System.out.println("noofHoursToSet:" + l3);
                GregorianCalendar gregorianCalendar = new GregorianCalendar(2000, 0, 1, 0, 0, 0);
                TimeZone timeZone = TimeZone.getDefault();
                Date date = calendar.getTime();
                long l9 = gregorianCalendar.getTimeInMillis() / 1000L;
                long l10 = calendar.getTimeInMillis() / 1000L;
                System.out.println("timeTillNow:" + l10);
                long l11 = l10 + (long)(n9 * 24 * 60 * 60) + l3;
                System.out.println("timeTillNextExec:" + l11);
                System.out.println("difference:" + (l11 - l10));
                boolean bl5 = timeZone.inDaylightTime(date);
                System.out.println("dstSavings:" + bl5);
                if (bl5) {
                    int n10 = timeZone.getDSTSavings();
                    this.m_bbuProp.setnextLeanTime((int)(l11 - l9 + (long)(n10 / 1000)));
                } else {
                    this.m_bbuProp.setnextLeanTime((int)(l11 - l9));
                }
            }
            int n11 = 0;
            n = 0;
            if (this.delayLearnCycleDays.getSelectedIndex() >= 0 && this.delayLearnCycle.getValue() != null) {
                if (this.delayLearnCycle.isEnabled()) {
                    n = Integer.parseInt(this.delayLearnCycle.getValue().toString());
                }
                if ((n11 = this.delayLearnCycleDays.getSelectedIndex() * 24 + n) > 168) {
                    new CustomMsgBox(Resource.getString("MSG_MAX_LEARN_DELAY_EXCEEDED", "Learn Delay Interval must not be greater than 7 Days !"));
                    return;
                }
                if (n11 < 0) {
                    new CustomMsgBox(Resource.getString("MSG_MAX_LEARN_DELAY_INVALID_NUMBER", "Invalid Learn Delay. Postpone Learn Delay Interval cannot be negative."));
                    return;
                }
            }
            this.m_bbuProp.setLearnDelayInterval((byte)n11);
            this.od.setParameter(this.m_bbuProp);
            this.m_bbu.issueOperation(this.od);
            this.m_apply.setEnabled(false);
        } else if (this.opModeCombo.getSelectedIndex() == 1) {
            this.m_bbuProp.setautoLearnMode((byte)1);
            this.od.setParameter(this.m_bbuProp);
            StringBuffer stringBuffer = new StringBuffer(Resource.getString("DISABLE_AUTO_LEARN_WARNING_MESSAGE", "<html>You have chosen to disable the automatic learn cycle. In order to <br>determine the accurate value of BBU retention time, it is recommended <br>to perform the battery learn cycle periodically.<br><br>Are you sure you want to disable the automatic learn cycle?</html>"));
            if (!CustomMsgBox.confirmWithCheck(this.mainPanel, Resource.getString("DISABLE_AUTO_LEARN_WARNING_TITLE", "Warning - Disable Automatic Learn Cycle"), stringBuffer.toString())) {
                return;
            }
            this.m_bbu.issueOperation(this.od);
            this.m_apply.setEnabled(false);
        }
    }

    private void opModeWarnEnabled() {
        if (this.getRealTimeScheduler() == 1) {
            this.startOnLabel.setEnabled(false);
            this.scheduleDay.setEnabled(false);
            this.bbuTime.setEnabled(false);
        }
        this.delayTextLabel.setEnabled(false);
        this.delayLearnCycleDays.setEnabled(false);
        this.daysTextLabel.setEnabled(false);
        this.delayLearnCycle.setEnabled(false);
        this.hours.setEnabled(false);
    }

    private void opModeComboEnabled() {
        if (this.getRealTimeScheduler() == 1) {
            this.startOnLabel.setEnabled(true);
            this.scheduleDay.setEnabled(true);
            this.bbuTime.setEnabled(true);
        }
        this.delayTextLabel.setEnabled(true);
        this.delayLearnCycleDays.setEnabled(true);
        this.daysTextLabel.setEnabled(true);
        this.delayLearnCycle.setEnabled(true);
        this.hours.setEnabled(true);
    }

    private void opModeComboDisabled() {
        if (this.getRealTimeScheduler() == 1) {
            this.startOnLabel.setEnabled(false);
            this.scheduleDay.setEnabled(false);
            this.bbuTime.setEnabled(false);
        }
        this.delayTextLabel.setEnabled(false);
        this.delayLearnCycleDays.setEnabled(false);
        this.daysTextLabel.setEnabled(false);
        this.delayLearnCycle.setEnabled(false);
        this.hours.setEnabled(false);
    }

    private void nextLearnRefresh() {
        this.BBUInfo = this.m_bbu.getBBUInfo();
        this.iAutoLearnMode = this.BBUInfo.getProperties().getautoLearnMode();
        if (this.BBUInfo.getDesignInfo().gettransparentLearns() == '\u0001') {
            this.opModeCombo.setEnabled(false);
        } else {
            this.opModeCombo.setEnabled(true);
        }
        if (this.iAutoLearnMode == 1) {
            this.opModeCombo.setSelectedIndex(1);
            this.opModeComboDisabled();
        } else if (this.iAutoLearnMode == 2) {
            this.opModeCombo.setSelectedIndex(2);
            this.opModeComboDisabled();
        } else {
            this.opModeCombo.setSelectedIndex(0);
            this.opModeComboEnabled();
        }
        this.autoPanel.remove(this.objNextLearnLabel);
        this.autoPanel.repaint();
        this.autoPanel.revalidate();
        short s = NetworkToJavaConverter.getUnsignedVal(this.m_bbuProp.getLeanDelayInterval());
        this.dayDelay = s / 24;
        this.hourDelay = s % 24;
        if (this.dayDelay == 7) {
            this.delayLearnCycle.setEnabled(false);
        }
        this.strNextLearnText = Resource.getString("NEXT_LEARN_CYCLE_TIME", "Next learn cycle time:");
        long l = this.m_bbuProp.getnextLeanTime();
        byte by = this.m_bbuProp.getautoLearnMode();
        Date date = null;
        try {
            long l2 = l * 1000L;
            if (by != 1 && l2 != 0L) {
                GregorianCalendar gregorianCalendar = new GregorianCalendar(2000, 0, 1, 0, 0, 0);
                long l3 = gregorianCalendar.getTimeInMillis();
                TimeZone timeZone = TimeZone.getDefault();
                gregorianCalendar.setTimeInMillis(l3 + l2);
                boolean bl = timeZone.inDaylightTime(gregorianCalendar.getTime());
                System.out.println("dstSavings:" + bl);
                if (bl) {
                    int n = timeZone.getDSTSavings();
                    gregorianCalendar.setTimeInMillis(l3 + l2 - (long)n + (long)(s * 60 * 60 * 1000));
                } else {
                    gregorianCalendar.setTimeInMillis(l3 + l2 + (long)(s * 60 * 60 * 1000));
                }
                date = gregorianCalendar.getTime();
            } else {
                date = null;
            }
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
        }
        if (this.iAutoLearnMode == 0) {
            this.objNextLearnLabel = date == null ? new JLabel(Resource.getString("NEXT_LEARN_CYCLE_TIME", this.strNextLearnText) + " " + Resource.getString("COER_MODE_NONE", "None")) : (this.dayDelay == 0 && this.hourDelay == 0 ? new JLabel(Resource.getString("NEXT_LEARN_CYCLE_TIME", this.strNextLearnText) + " " + this.nextScheduleDayOfTheWeekFormat.format(date) + " " + this.nextScheduleDateFormat.format(date) + " " + Resource.getString("BBU_AT", "At") + " " + this.nextScheduleHourMinuteFormat.format(date)) : (this.dayDelay != 0 && this.hourDelay == 0 ? new JLabel(Resource.getString("NEXT_LEARN_CYCLE_TIME", this.strNextLearnText) + " " + this.nextScheduleDayOfTheWeekFormat.format(date) + " " + this.nextScheduleDateFormat.format(date) + " " + Resource.getString("BBU_AT", "At") + " " + this.nextScheduleHourMinuteFormat.format(date) + " " + Resource.getString("INCLUDING", "(including") + " " + this.dayDelay + " " + Resource.getString("BBU_DAYS", "day(s)") + " " + Resource.getString("BBU_DELAY", "delay)")) : (this.dayDelay == 0 && this.hourDelay != 0 ? new JLabel(Resource.getString("NEXT_LEARN_CYCLE_TIME", this.strNextLearnText) + " " + this.nextScheduleDayOfTheWeekFormat.format(date) + " " + this.nextScheduleDateFormat.format(date) + " " + Resource.getString("BBU_AT", "At") + " " + this.nextScheduleHourMinuteFormat.format(date) + " " + Resource.getString("INCLUDING", "(including") + " " + " " + this.hourDelay + " " + Resource.getString("DELAY_HOURS", "hour(s)") + " " + Resource.getString("BBU_DELAY", "delay)")) : new JLabel(Resource.getString("NEXT_LEARN_CYCLE_TIME", this.strNextLearnText) + " " + this.nextScheduleDayOfTheWeekFormat.format(date) + " " + this.nextScheduleDateFormat.format(date) + " " + Resource.getString("BBU_AT", "At") + " " + this.nextScheduleHourMinuteFormat.format(date) + " " + Resource.getString("INCLUDING", "(including") + " " + this.dayDelay + " " + Resource.getString("BBU_DAYS", "day(s)") + " " + Resource.getString("BBU_AND", "and") + " " + this.hourDelay + " " + Resource.getString("DELAY_HOURS", "hour(s)") + " " + Resource.getString("BBU_DELAY", "delay)")))));
        } else if (this.iAutoLearnMode == 2) {
            this.objNextLearnLabel = date == null ? new JLabel(Resource.getString("BBU_NEXTEVENT_GENERATION_TIME", this.strNextLearnText) + " " + Resource.getString("COER_MODE_NONE", "None")) : (this.dayDelay == 0 && this.hourDelay == 0 ? new JLabel(Resource.getString("BBU_NEXTEVENT_GENERATION_TIME", this.strNextLearnText) + " " + this.nextScheduleDayOfTheWeekFormat.format(date) + " " + this.nextScheduleDateFormat.format(date) + " " + Resource.getString("BBU_AT", "At") + " " + this.nextScheduleHourMinuteFormat.format(date)) : (this.dayDelay != 0 && this.hourDelay == 0 ? new JLabel(Resource.getString("BBU_NEXTEVENT_GENERATION_TIME", this.strNextLearnText) + " " + this.nextScheduleDayOfTheWeekFormat.format(date) + " " + this.nextScheduleDateFormat.format(date) + " " + Resource.getString("BBU_AT", "At") + " " + this.nextScheduleHourMinuteFormat.format(date) + " " + Resource.getString("INCLUDING", "(including") + " " + this.dayDelay + " " + Resource.getString("BBU_DAYS", "day(s)") + " " + Resource.getString("BBU_DELAY", "delay)")) : (this.dayDelay == 0 && this.hourDelay != 0 ? new JLabel(Resource.getString("BBU_NEXTEVENT_GENERATION_TIME", this.strNextLearnText) + " " + this.nextScheduleDayOfTheWeekFormat.format(date) + " " + this.nextScheduleDateFormat.format(date) + " " + Resource.getString("BBU_AT", "At") + " " + this.nextScheduleHourMinuteFormat.format(date) + " " + Resource.getString("INCLUDING", "(including") + " " + " " + this.hourDelay + " " + Resource.getString("DELAY_HOURS", "hour(s)") + " " + Resource.getString("BBU_DELAY", "delay)")) : new JLabel(Resource.getString("BBU_NEXTEVENT_GENERATION_TIME", this.strNextLearnText) + " " + this.nextScheduleDayOfTheWeekFormat.format(date) + " " + this.nextScheduleDateFormat.format(date) + " " + Resource.getString("BBU_AT", "At") + " " + this.nextScheduleHourMinuteFormat.format(date) + " " + Resource.getString("INCLUDING", "(including") + " " + this.dayDelay + " " + Resource.getString("BBU_DAYS", "day(s)") + " " + Resource.getString("BBU_AND", "and") + " " + this.hourDelay + " " + Resource.getString("DELAY_HOURS", "hour(s)") + " " + Resource.getString("BBU_DELAY", "delay)")))));
        } else if (this.iAutoLearnMode == 1) {
            this.objNextLearnLabel = new JLabel(Resource.getString("NEXT_LEARN_CYCLE_TIME", this.strNextLearnText) + " " + Resource.getString("COER_MODE_NONE", "None"));
        }
        this.gbcbbuautoPanel.gridx = 0;
        this.gbcbbuautoPanel.gridy = 1;
        this.gbcbbuautoPanel.insets = new Insets(5, 5, 5, 0);
        this.autoPanel.add((Component)this.objNextLearnLabel, this.gbcbbuautoPanel);
        this.m_apply.setEnabled(false);
    }

    @Override
    public void update(Observable observable, Object object) {
        NotifyObject notifyObject = (NotifyObject)object;
        int n = notifyObject.getNotifyCode() - 0x102000;
        MR_EVT_DETAIL mR_EVT_DETAIL = (MR_EVT_DETAIL)notifyObject.getNotifyObject();
        n = mR_EVT_DETAIL.getcode();
        switch (n) {
            case 151: 
            case 152: 
            case 153: 
            case 306: 
            case 449: {
                this.m_bbuProp = this.m_bbu.getBBUInfo().getProperties();
                this.nextLearnRefresh();
                break;
            }
        }
    }

    private String getLearnClycleDescription(int n) {
        switch (n) {
            case 2: {
                return Resource.getString("BBU_AUTO_DESC_WARN", "This option generates an event to notify you when to start a <br>learn cycle manually.");
            }
            case 1: {
                return Resource.getString("BBU_AUTO_DESC_DISABLE", "This option allows you to disable the automatic battery <br>learn cycle");
            }
            case 0: {
                return Resource.getString("BBU_AUTO_DESC_ENABLE", "This option allows you to start a battery learn cycle automatically You can either schedule a learn cycle or delay an existing scheduled learn cycle");
            }
        }
        return "";
    }
}

