/*
 * Decompiled with CFR 0.152.
 */
package GUI.CCOH;

import Framework.Configurator.ConfiguratorManager;
import GUI.CCOH.CCOHCacheGroupPanel;
import GUI.CCOH.CCOHCachedVirtualDrivesPanel;
import GUI.CCOH.CCOHConfigurationEngine;
import GUI.CCOH.CCOHModeSelectionPanel;
import GUI.CCOH.CCOHPreviewPanel;
import GUI.DefaultNoOptionDialog;
import GUI.VivaldiBaseDialog;
import GUI.VivaldiStartupDialog;
import GUIHelper.CCOHVirtualAdapterHelper;
import KernelExceptions.VKInvalidOperationException;
import KernelExceptions.VKNotRespondingException;
import KernelExceptions.VKObjectNotPresentException;
import KernelExceptions.VKOperationFailedException;
import SASKernel.LibraryAPI.StoreLib.SL_CCOH_DEV_T;
import SASKernel.VirtualAdapter;
import Utils.CustomMsgBox;
import Utils.GUIUtils;
import Utils.HelpContext;
import Utils.HelpContextResourse;
import Utils.Resource;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;

public class CCOHBaseDialog
extends VivaldiBaseDialog {
    private JButton m_btnNext = null;
    private JButton m_btnBack = null;
    private JButton m_btnCancel = null;
    private JButton m_btnHelp = null;
    public static final byte MODE_SELECTION_PANEL = 1;
    public static final byte CACHE_GROUP_PANEL = 2;
    public static final byte CACHED_VIRTUAL_DRIVES_PANEL = 3;
    public static final byte PREVIEW_PANEL = 4;
    private JPanel m_navigationPanel = null;
    private CCOHModeSelectionPanel m_modeselectionpanel = null;
    private CCOHCacheGroupPanel m_cachegrouppanel = null;
    private CCOHCachedVirtualDrivesPanel m_cachedvirtualdrivespanel = null;
    private CCOHPreviewPanel m_previewpanel = null;
    private byte m_currentpageid = 1;
    private CCOHConfigurationEngine m_ccohConfigEngine = null;
    private CCOHVirtualAdapterHelper m_virtualAdapterHelper = null;

    public CCOHBaseDialog(CCOHVirtualAdapterHelper cCOHVirtualAdapterHelper) {
        this.m_virtualAdapterHelper = cCOHVirtualAdapterHelper;
        this.m_ccohConfigEngine = new CCOHConfigurationEngine(this.m_virtualAdapterHelper, true, true);
        this.initialise();
    }

    public void initialise() {
        this.initialiseNavigationPanel();
        if (this.m_currentpageid == 1 && this.m_modeselectionpanel == null) {
            this.m_modeselectionpanel = new CCOHModeSelectionPanel(this);
        }
        this.contentPane.add((Component)this.m_modeselectionpanel, "Center");
        this.m_currentpageid = 1;
        this.contentPane.add((Component)this.m_navigationPanel, "South");
        this.setTitle(Resource.getString("CREATE_CACHE_GROUP", "Create Cache Group"));
        this.setResizable(false);
        this.setModal(true);
        this.pack();
        GUIUtils.centerDialogOnScreen(this);
        this.setVisible(true);
    }

    public void initialiseNavigationPanel() {
        String[] stringArray = null;
        this.m_navigationPanel = new JPanel(new FlowLayout(2));
        stringArray = Resource.getResourceMnemonic(Resource.getString("MENU_HELP_TEXT", "(H)elp"));
        this.m_btnHelp = new JButton(stringArray[0]);
        if (stringArray.length == 2) {
            this.m_btnHelp.setMnemonic(stringArray[1].charAt(0));
        }
        this.m_btnCancel = new JButton(Resource.getString("BUTTON_CANCEL_TEXT", "Cancel"));
        stringArray = Resource.getResourceMnemonic(Resource.getString("BUTTON_BACK_TEXT", "< (B)ack"));
        this.m_btnBack = new JButton(stringArray[0]);
        if (stringArray.length == 2) {
            this.m_btnBack.setMnemonic(stringArray[1].charAt(0));
        }
        stringArray = this.m_currentpageid == 4 ? Resource.getResourceMnemonic(Resource.getString("BUTTON_FINISH_TEXT", "(F)inish")) : Resource.getResourceMnemonic(Resource.getString("BUTTON_NEXT_TEXT", "(N)ext >"));
        this.m_btnNext = new JButton(stringArray[0]);
        if (stringArray.length == 2) {
            this.m_btnNext.setMnemonic(stringArray[1].charAt(0));
        }
        this.m_navigationPanel.add(this.m_btnHelp);
        this.m_navigationPanel.add(this.m_btnCancel);
        if (this.m_currentpageid != 1) {
            this.m_navigationPanel.add(this.m_btnBack);
        }
        this.m_navigationPanel.add(this.m_btnNext);
        this.getRootPane().setDefaultButton(this.m_btnNext);
        this.m_btnNext.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                block3 : switch (CCOHBaseDialog.this.m_currentpageid) {
                    case 1: {
                        CCOHBaseDialog.this.contentPane.remove(CCOHBaseDialog.this.m_modeselectionpanel);
                        CCOHBaseDialog.this.pack();
                        if (CCOHBaseDialog.this.m_modeselectionpanel.isAutomaticRadioButtonSelected()) {
                            CCOHBaseDialog.this.m_ccohConfigEngine.setSelectedmode((byte)1);
                            if (CCOHBaseDialog.this.m_ccohConfigEngine.getpreviouslySelectedmode() != 1) {
                                CCOHBaseDialog.this.m_ccohConfigEngine.clearAddedDevices();
                            }
                            CCOHBaseDialog.this.m_ccohConfigEngine.initCCOHEngineForAutomaticMode(CCOHBaseDialog.this.m_modeselectionpanel.getSelectedComboBoxOption());
                            if (CCOHBaseDialog.this.m_previewpanel == null) {
                                CCOHBaseDialog.this.m_previewpanel = new CCOHPreviewPanel(CCOHBaseDialog.this);
                            } else {
                                CCOHBaseDialog.this.m_previewpanel.update();
                            }
                            CCOHBaseDialog.this.contentPane.add((Component)CCOHBaseDialog.this.m_previewpanel, "Center");
                            CCOHBaseDialog.this.m_currentpageid = (byte)4;
                        } else {
                            CCOHBaseDialog.this.m_ccohConfigEngine.setSelectedmode((byte)2);
                            if (CCOHBaseDialog.this.m_ccohConfigEngine.getpreviouslySelectedmode() != 2) {
                                CCOHBaseDialog.this.m_ccohConfigEngine.clearAddedDevices();
                                CCOHBaseDialog.this.m_ccohConfigEngine.reinitDevicesToBeAdded();
                            }
                            if (CCOHBaseDialog.this.m_cachegrouppanel == null) {
                                CCOHBaseDialog.this.m_cachegrouppanel = new CCOHCacheGroupPanel(CCOHBaseDialog.this);
                            } else if (CCOHBaseDialog.this.m_ccohConfigEngine.getpreviouslySelectedmode() != 2) {
                                CCOHBaseDialog.this.m_cachegrouppanel.reset();
                            }
                            CCOHBaseDialog.this.contentPane.add((Component)CCOHBaseDialog.this.m_cachegrouppanel, "Center");
                            CCOHBaseDialog.this.m_currentpageid = (byte)2;
                        }
                        CCOHBaseDialog.this.reinitialiseNavigationPanel();
                        CCOHBaseDialog.this.pack();
                        break;
                    }
                    case 2: {
                        CCOHBaseDialog.this.contentPane.remove(CCOHBaseDialog.this.m_cachegrouppanel);
                        CCOHBaseDialog.this.pack();
                        if (CCOHBaseDialog.this.m_cachedvirtualdrivespanel == null) {
                            CCOHBaseDialog.this.m_cachedvirtualdrivespanel = new CCOHCachedVirtualDrivesPanel(CCOHBaseDialog.this);
                        } else if (CCOHBaseDialog.this.m_ccohConfigEngine.getpreviouslySelectedmode() != 2) {
                            CCOHBaseDialog.this.m_cachedvirtualdrivespanel.reset();
                        }
                        CCOHBaseDialog.this.contentPane.add((Component)CCOHBaseDialog.this.m_cachedvirtualdrivespanel, "Center");
                        CCOHBaseDialog.this.m_currentpageid = (byte)3;
                        CCOHBaseDialog.this.reinitialiseNavigationPanel();
                        CCOHBaseDialog.this.pack();
                        break;
                    }
                    case 3: {
                        if (CCOHBaseDialog.this.m_ccohConfigEngine.getVirtualDrivesAdded().size() <= 0 && !CCOHBaseDialog.this.noVDsSelectedDialog()) break;
                        CCOHBaseDialog.this.contentPane.remove(CCOHBaseDialog.this.m_cachedvirtualdrivespanel);
                        CCOHBaseDialog.this.pack();
                        if (CCOHBaseDialog.this.m_previewpanel == null) {
                            CCOHBaseDialog.this.m_previewpanel = new CCOHPreviewPanel(CCOHBaseDialog.this);
                        } else {
                            CCOHBaseDialog.this.m_previewpanel.update();
                        }
                        CCOHBaseDialog.this.contentPane.add((Component)CCOHBaseDialog.this.m_previewpanel, "Center");
                        CCOHBaseDialog.this.m_currentpageid = (byte)4;
                        CCOHBaseDialog.this.reinitialiseNavigationPanel();
                        CCOHBaseDialog.this.pack();
                        break;
                    }
                    case 4: {
                        int n;
                        CCOHBaseDialog.this.dispose();
                        VirtualAdapter virtualAdapter = (VirtualAdapter)CCOHBaseDialog.this.m_virtualAdapterHelper.getDeviceObject();
                        SL_CCOH_DEV_T[] sL_CCOH_DEV_TArray = CCOHBaseDialog.this.m_ccohConfigEngine.getFinalArrOfCDsToBeAdded();
                        int n2 = 0;
                        if (sL_CCOH_DEV_TArray != null) {
                            n2 = sL_CCOH_DEV_TArray.length;
                            for (n = 0; n < n2; ++n) {
                                try {
                                    virtualAdapter.addCDtoCG(sL_CCOH_DEV_TArray[n]);
                                    continue;
                                }
                                catch (VKOperationFailedException vKOperationFailedException) {
                                    CustomMsgBox.errorMsg(vKOperationFailedException);
                                }
                            }
                        }
                        if ((sL_CCOH_DEV_TArray = CCOHBaseDialog.this.m_ccohConfigEngine.getFinalArrOfVDsToBeAdded()) != null) {
                            n2 = sL_CCOH_DEV_TArray.length;
                            for (n = 0; n < n2; ++n) {
                                try {
                                    virtualAdapter.addVDtoCG(sL_CCOH_DEV_TArray[n]);
                                    continue;
                                }
                                catch (VKOperationFailedException vKOperationFailedException) {
                                    CustomMsgBox.errorMsg(vKOperationFailedException);
                                }
                            }
                        }
                        if (!CCOHBaseDialog.this.showmessageonfinish()) break;
                        ConfiguratorManager configuratorManager = ConfiguratorManager.getInstance(VivaldiStartupDialog.mainScreen);
                        JMenu jMenu = VivaldiStartupDialog.mainScreen.getToolsMenu();
                        int n3 = jMenu.getItemCount();
                        for (int i = 0; i < n3; ++i) {
                            JMenuItem jMenuItem = jMenu.getItem(i);
                            if (!jMenuItem.isVisible()) continue;
                            try {
                                configuratorManager.invokeConfigurator(jMenuItem.getAccessibleContext().getAccessibleName());
                            }
                            catch (VKObjectNotPresentException vKObjectNotPresentException) {
                                new CustomMsgBox(Resource.getString("MSG_COMPONENT_NOT_RUNNING_ERROR", "Error : One or more target component is not running."));
                            }
                            catch (VKNotRespondingException vKNotRespondingException) {
                                new CustomMsgBox(Resource.getString("MSG_CONFIGURATOR_NOT_RESPONDING_ERROR", "Error : Configurator not responding."));
                            }
                            catch (VKInvalidOperationException vKInvalidOperationException) {
                                new CustomMsgBox(Resource.getString("MSG_CONFIGURATOR_INVALID_OPERATION_ERROR", "Error : Invalid operation."));
                            }
                            catch (VKOperationFailedException vKOperationFailedException) {
                                new CustomMsgBox(Resource.getString("MSG_CONFIGURATOR_OPERATION_FAILED_ERROR", "Error : Operation failed."));
                            }
                            catch (Exception exception) {
                                new CustomMsgBox(Resource.getString("MSG_CONFIGURATOR_EXCEPTION_ERROR", "Error : Unknown exception."));
                            }
                            break block3;
                        }
                        break;
                    }
                }
            }
        });
        this.m_btnBack.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                switch (CCOHBaseDialog.this.m_currentpageid) {
                    case 2: {
                        CCOHBaseDialog.this.contentPane.remove(CCOHBaseDialog.this.m_cachegrouppanel);
                        CCOHBaseDialog.this.pack();
                        CCOHBaseDialog.this.contentPane.add((Component)CCOHBaseDialog.this.m_modeselectionpanel, "Center");
                        CCOHBaseDialog.this.m_currentpageid = (byte)1;
                        CCOHBaseDialog.this.reinitialiseNavigationPanel();
                        CCOHBaseDialog.this.pack();
                        break;
                    }
                    case 3: {
                        CCOHBaseDialog.this.contentPane.remove(CCOHBaseDialog.this.m_cachedvirtualdrivespanel);
                        CCOHBaseDialog.this.pack();
                        CCOHBaseDialog.this.contentPane.add((Component)CCOHBaseDialog.this.m_cachegrouppanel, "Center");
                        CCOHBaseDialog.this.m_currentpageid = (byte)2;
                        CCOHBaseDialog.this.reinitialiseNavigationPanel();
                        CCOHBaseDialog.this.pack();
                        break;
                    }
                    case 4: {
                        if (CCOHBaseDialog.this.m_ccohConfigEngine.getSelectedmode() == 1) {
                            CCOHBaseDialog.this.contentPane.remove(CCOHBaseDialog.this.m_previewpanel);
                            CCOHBaseDialog.this.pack();
                            CCOHBaseDialog.this.contentPane.add((Component)CCOHBaseDialog.this.m_modeselectionpanel, "Center");
                            CCOHBaseDialog.this.m_currentpageid = (byte)1;
                        } else {
                            CCOHBaseDialog.this.contentPane.remove(CCOHBaseDialog.this.m_previewpanel);
                            CCOHBaseDialog.this.pack();
                            CCOHBaseDialog.this.contentPane.add((Component)CCOHBaseDialog.this.m_cachedvirtualdrivespanel, "Center");
                            CCOHBaseDialog.this.m_currentpageid = (byte)3;
                        }
                        CCOHBaseDialog.this.reinitialiseNavigationPanel();
                        CCOHBaseDialog.this.pack();
                    }
                }
            }
        });
        this.m_btnHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HelpContext.executeHelpProcess(CCOHBaseDialog.this.getHelpPage());
            }
        });
        this.m_btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (CCOHBaseDialog.this.isChanged()) {
                    if (CCOHBaseDialog.this.warningDialog()) {
                        CCOHBaseDialog.this.dispose();
                    }
                } else {
                    CCOHBaseDialog.this.dispose();
                }
            }
        });
    }

    public void reinitialiseNavigationPanel() {
        this.m_navigationPanel.removeAll();
        String[] stringArray = null;
        stringArray = this.m_currentpageid == 4 ? Resource.getResourceMnemonic(Resource.getString("BUTTON_FINISH_TEXT", "(F)inish")) : Resource.getResourceMnemonic(Resource.getString("BUTTON_NEXT_TEXT", "(N)ext >"));
        this.m_btnNext.setText(stringArray[0]);
        if (stringArray.length == 2) {
            this.m_btnNext.setMnemonic(stringArray[1].charAt(0));
        }
        this.m_navigationPanel.add(this.m_btnHelp);
        this.m_navigationPanel.add(this.m_btnCancel);
        if (this.m_currentpageid != 1) {
            this.m_navigationPanel.add(this.m_btnBack);
        }
        this.m_navigationPanel.add(this.m_btnNext);
        if (this.getDefaultButton() != null) {
            this.getRootPane().setDefaultButton(this.getDefaultButton());
        }
        if (this.m_currentpageid == 2) {
            this.m_btnNext.setEnabled(this.m_cachegrouppanel.isNextButtonEnabled());
        } else if (this.m_currentpageid == 4) {
            this.m_btnNext.setEnabled(this.m_previewpanel.isNextButtonEnabled());
        } else {
            this.m_btnNext.setEnabled(true);
        }
    }

    public void setNextButtonEnabled(boolean bl) {
        this.m_btnNext.setEnabled(bl);
    }

    public void setBackButtonEnabled(boolean bl) {
        this.m_btnBack.setEnabled(bl);
    }

    @Override
    protected boolean warningDialog() {
        if (this.isChanged()) {
            DefaultNoOptionDialog defaultNoOptionDialog = new DefaultNoOptionDialog(Resource.getString("CCOH_CONFIRMATION", "Confirmation"), Resource.getString("CONFIG_CANCEL_MSG"), 3);
            return defaultNoOptionDialog.getOptionPaneValue();
        }
        return true;
    }

    public void onHelp() {
        HelpContext.executeHelpProcess(HelpContextResourse.getHelpPageName(this.getHelpPage()));
    }

    public void onCancel() {
    }

    public JButton getNextButton() {
        return this.m_btnNext;
    }

    public JButton getBackButton() {
        return this.m_btnBack;
    }

    public JButton getCancelButton() {
        return this.m_btnCancel;
    }

    public JButton getHelpButton() {
        return this.m_btnHelp;
    }

    public CCOHConfigurationEngine getCCOHConfigEngine() {
        return this.m_ccohConfigEngine;
    }

    @Override
    public String getHelpPage() {
        switch (this.m_currentpageid) {
            case 1: {
                return this.m_modeselectionpanel.getHelpPage();
            }
            case 2: {
                return this.m_cachegrouppanel.getHelpPage();
            }
            case 3: {
                return this.m_cachedvirtualdrivespanel.getHelpPage();
            }
            case 4: {
                return this.m_previewpanel.getHelpPage();
            }
        }
        return "";
    }

    public JButton getDefaultButton() {
        switch (this.m_currentpageid) {
            case 1: {
                return this.m_modeselectionpanel.getDefaultButton();
            }
            case 2: {
                return this.m_cachegrouppanel.getDefaultButton();
            }
            case 3: {
                return this.m_cachedvirtualdrivespanel.getDefaultButton();
            }
            case 4: {
                return this.m_previewpanel.getDefaultButton();
            }
        }
        return this.m_modeselectionpanel.getDefaultButton();
    }

    public boolean isChanged() {
        switch (this.m_currentpageid) {
            case 1: {
                return this.m_modeselectionpanel.isChanged();
            }
            case 2: {
                return this.m_cachegrouppanel.isChanged();
            }
            case 3: {
                return this.m_cachedvirtualdrivespanel.isChanged();
            }
            case 4: {
                return this.m_previewpanel.isChanged();
            }
        }
        return false;
    }

    public boolean noVDsSelectedDialog() {
        if (this.m_ccohConfigEngine.getVirtualDrivesInSystem().size() == 0) {
            return true;
        }
        DefaultNoOptionDialog defaultNoOptionDialog = new DefaultNoOptionDialog(Resource.getString("VIRTUAL_DRIVES_PANEL_NO_CACHED_VDS_TITLE", "No Cached Virtual Drives"), Resource.getString("VIRTUAL_DRIVES_PANEL_WARNING_MSG"), 2);
        return defaultNoOptionDialog.getOptionPaneValue();
    }

    public boolean showmessageonfinish() {
        return CustomMsgBox.confirm(VivaldiStartupDialog.mainScreen, Resource.getString("CACHE_GROUP_CONFIGURED_MSG"), Resource.getString("CACHE_GROUP_CONFIGURED_TITLE", "Cache Group Configured"), 1);
    }

    public CCOHVirtualAdapterHelper getVirtualAdapterHelper() {
        return this.m_virtualAdapterHelper;
    }
}

