/*
 * Decompiled with CFR 0.152.
 */
package GUI.CCOH;

import GUI.CCOH.CCOHCacheGroupHelper;
import GUI.CCOH.CCOHCacheGroupPerformanceTab;
import GUI.CCOH.CCOHMakeVDsOnlineDialog;
import GUI.CCOH.CCOHManageCacheDevicesDialog;
import GUI.CCOH.CCOHManageVirtualDrivesDialog;
import GUI.CCOH.CCOHRemoveOfflineDevicesDialog;
import GUI.DetailPanel;
import GUI.MainFrame;
import GUI.PropertyViewPanel;
import GUIHelper.CCOHVirtualAdapterHelper;
import GUIHelper.ServerObjectHelper;
import SASKernel.LibraryAPI.StoreLib.SL_CCOH_DEV_LIST_T;
import SASKernel.LibraryAPI.StoreLib.SL_CCOH_DEV_T;
import SASKernel.Operations.OperationDetails;
import SASKernel.SASServer;
import SASKernel.VirtualAdapter;
import Utils.CustomTabbedPane;
import Utils.Resource;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class CCOHCacheGroupDetailPanel
extends DetailPanel {
    private CustomTabbedPane tabbedPane = new CustomTabbedPane();
    private CCOHCacheGroupHelper m_objCacheGroupHelper;
    private boolean viewOnly = false;
    private ServerObjectHelper m_objServerObjectHelper;
    private CCOHVirtualAdapterHelper m_objCCOHVirtAdapHelper;
    private VirtualAdapter m_objCCOHVirtAdap;

    public CCOHCacheGroupDetailPanel(CCOHCacheGroupHelper cCOHCacheGroupHelper, MainFrame mainFrame) {
        super(cCOHCacheGroupHelper, mainFrame);
        this.m_objCacheGroupHelper = cCOHCacheGroupHelper;
        this.m_objCCOHVirtAdapHelper = this.m_objCacheGroupHelper.getCCOHVirtualAdapterHelper();
        this.m_objCCOHVirtAdap = (VirtualAdapter)this.m_objCCOHVirtAdapHelper.getDeviceObject();
        this.m_objServerObjectHelper = (ServerObjectHelper)this.m_objCacheGroupHelper.getParent();
        this.init();
        this.m_objCacheGroupHelper.addObserver(this);
    }

    @Override
    public void init() {
        this.viewOnly = ((SASServer)this.m_objServerObjectHelper.getDeviceObject()).getAccMode() == 1;
        this.removeAll();
        this.tabbedPane.removeAll();
        PropertyViewPanel propertyViewPanel = new PropertyViewPanel(this.m_objCacheGroupHelper.getPropertyList());
        JPanel jPanel = new JPanel(new BorderLayout());
        this.tabbedPane.addTab(Resource.getString("PROPERTY_TAB_TEXT", "Properties"), null, new JScrollPane(jPanel), Resource.getString("PROPERTY_TAB_TEXT", "Properties"));
        jPanel.add((Component)propertyViewPanel, "North");
        CCOHCacheGroupPerformanceTab cCOHCacheGroupPerformanceTab = new CCOHCacheGroupPerformanceTab(this.m_objCacheGroupHelper);
        this.tabbedPane.addTab(Resource.getString("PERFORMANCE_TAB_TEXT", "Performance"), null, new JScrollPane(cCOHCacheGroupPerformanceTab), Resource.getString("PERFORMANCE_TAB_TEXT", "Performance"));
        this.add((Component)this.tabbedPane, "Center");
    }

    @Override
    public JMenu getSubMenu(JMenu jMenu) {
        int n = jMenu.getItemCount();
        JMenu jMenu2 = null;
        for (int i = 0; i < n; ++i) {
            jMenu2 = (JMenu)jMenu.getItem(i);
            if (!jMenu2.getName().trim().equals("Cache Group")) continue;
            return jMenu2;
        }
        return jMenu2;
    }

    @Override
    public void populateOperationMenu(JMenu jMenu, OperationDetails operationDetails) {
        if (jMenu == null) {
            return;
        }
        boolean bl = this.m_objCacheGroupHelper.isCacheGroupActive();
        String[] stringArray = null;
        if (!this.viewOnly) {
            switch (operationDetails.getOpcode()) {
                case 1166: {
                    stringArray = Resource.getResourceMnemonic(Resource.getString("OPERATION_MANAGE_CCOH_CDS", "Manage (C)ache Devices"));
                    JMenuItem jMenuItem = new JMenuItem(stringArray[0]);
                    if (stringArray.length == 2) {
                        jMenuItem.setMnemonic(stringArray[1].charAt(0));
                    }
                    jMenu.add(jMenuItem);
                    jMenuItem.setEnabled(bl);
                    jMenuItem.setActionCommand("1166");
                    jMenuItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            new CCOHManageCacheDevicesDialog(CCOHCacheGroupDetailPanel.this.m_objCCOHVirtAdapHelper);
                        }
                    });
                    break;
                }
                case 1167: {
                    Object object;
                    SL_CCOH_DEV_LIST_T sL_CCOH_DEV_LIST_T = this.m_objCCOHVirtAdap.getCCOHVDs();
                    boolean bl2 = false;
                    if (sL_CCOH_DEV_LIST_T != null && sL_CCOH_DEV_LIST_T.getCount() > 0) {
                        object = sL_CCOH_DEV_LIST_T.getDeviceList();
                        for (int i = 0; i < ((SL_CCOH_DEV_T[])object).length; ++i) {
                            if (object[i].getDevState() == '\u0001') continue;
                            bl2 = true;
                            break;
                        }
                    }
                    stringArray = Resource.getResourceMnemonic(Resource.getString("OPERATION_MANAGE_CCOH_VDS", "Manage Cached (V)irtual Drives"));
                    object = new JMenuItem(stringArray[0]);
                    if (stringArray.length == 2) {
                        ((AbstractButton)object).setMnemonic(stringArray[1].charAt(0));
                    }
                    jMenu.add((JMenuItem)object);
                    if (bl2) {
                        ((JMenuItem)object).setEnabled(bl);
                        ((AbstractButton)object).setActionCommand("1167");
                        ((AbstractButton)object).addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent actionEvent) {
                                new CCOHManageVirtualDrivesDialog(CCOHCacheGroupDetailPanel.this.m_objCCOHVirtAdapHelper);
                            }
                        });
                        break;
                    }
                    ((JMenuItem)object).setEnabled(false);
                    break;
                }
                case 1168: {
                    if (!this.m_objCacheGroupHelper.isVDReadyForOnline()) break;
                    stringArray = Resource.getResourceMnemonic(Resource.getString("OPERATION_MAKE_CCOH_VDS_ONLINE", "Make Cached Virtual Drives (O)nline"));
                    JMenuItem jMenuItem = new JMenuItem(stringArray[0]);
                    if (stringArray.length == 2) {
                        jMenuItem.setMnemonic(stringArray[1].charAt(0));
                    }
                    jMenu.add(jMenuItem);
                    jMenuItem.setEnabled(bl);
                    jMenuItem.setActionCommand("1168");
                    jMenuItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            new CCOHMakeVDsOnlineDialog(CCOHCacheGroupDetailPanel.this.m_objCCOHVirtAdap, CCOHCacheGroupDetailPanel.this.m_objCacheGroupHelper.getReadyForOnlineVDsList());
                        }
                    });
                    break;
                }
                case 1170: {
                    if (!this.m_objCacheGroupHelper.isCDOffline()) break;
                    stringArray = Resource.getResourceMnemonic(Resource.getString("OPERATION_REMOVE_OFFLINE_CCOH_CDS", "(R)emove Offline Cache Devices"));
                    JMenuItem jMenuItem = new JMenuItem(stringArray[0]);
                    if (stringArray.length == 2) {
                        jMenuItem.setMnemonic(stringArray[1].charAt(0));
                    }
                    jMenu.add(jMenuItem);
                    jMenuItem.setEnabled(bl);
                    jMenuItem.setActionCommand("1170");
                    jMenuItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            new CCOHRemoveOfflineDevicesDialog(CCOHCacheGroupDetailPanel.this.m_objCCOHVirtAdap, CCOHCacheGroupDetailPanel.this.m_objCacheGroupHelper.getOfflineCDHelperList(), 0);
                        }
                    });
                    break;
                }
                case 1171: {
                    if (!this.m_objCacheGroupHelper.isVDOffline()) break;
                    stringArray = Resource.getResourceMnemonic(Resource.getString("OPERATION_REMOVE_OFFLINE_CCOH_VDS", "Re(m)ove Offline Cached Virtual Drives"));
                    JMenuItem jMenuItem = new JMenuItem(stringArray[0]);
                    if (stringArray.length == 2) {
                        jMenuItem.setMnemonic(stringArray[1].charAt(0));
                    }
                    jMenu.add(jMenuItem);
                    jMenuItem.setEnabled(bl);
                    jMenuItem.setActionCommand("1171");
                    jMenuItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            new CCOHRemoveOfflineDevicesDialog(CCOHCacheGroupDetailPanel.this.m_objCCOHVirtAdap, CCOHCacheGroupDetailPanel.this.m_objCacheGroupHelper.getOfflineVDHelperList(), 1);
                        }
                    });
                }
            }
        }
    }

    @Override
    public boolean canClose() {
        return true;
    }
}

