/*
 * Decompiled with CFR 0.152.
 */
package GUI.CCOH;

import GUI.CCOH.CCOHDeviceHelper;
import GUIHelper.AdapterHelper;
import GUIHelper.CCOHVirtualAdapterHelper;
import GUIHelper.GUIHelperInterface;
import GUIHelper.LogicalDriveHelper;
import GUIHelper.ProgressInfo;
import GUIHelper.PropertyInfo;
import GUIHelper.ServerObjectHelper;
import KernelServices.NotifyObject;
import SASKernel.CCOHCacheGroup;
import SASKernel.ISASObject;
import SASKernel.LibraryAPI.StoreLib.MR_EVT_CCOH_DETAIL;
import SASKernel.LibraryAPI.StoreLib.SL_CCOH_CG_LIMITS_T;
import SASKernel.LibraryAPI.StoreLib.SL_CCOH_CG_STATS_T;
import SASKernel.LibraryAPI.StoreLib.SL_CCOH_CONFIG_T;
import SASKernel.LibraryAPI.StoreLib.SL_CCOH_DEV_T;
import SASKernel.Operations.OperationDetails;
import SASKernel.VirtualAdapter;
import Services.KernelConstants;
import Utils.DoubleIcons;
import Utils.MenuItemObj;
import Utils.Parser;
import Utils.Resource;
import java.awt.Toolkit;
import java.util.ArrayList;
import java.util.Observable;
import java.util.Observer;
import javax.swing.ImageIcon;

public class CCOHCacheGroupHelper
extends Observable
implements GUIHelperInterface,
Observer {
    private CCOHCacheGroup m_ccohCacheGroup = new CCOHCacheGroup();
    private CCOHVirtualAdapterHelper m_ccohVirtualAdapterHelper;
    private ServerObjectHelper m_objServerObjectHelper;
    private SL_CCOH_CONFIG_T m_CCOHConfig = null;
    private VirtualAdapter m_virtualAdapter;
    private AdapterHelper[] m_adapHelpers = null;
    private String m_strCacheGroupName;
    private CCOHDeviceHelper[] m_objCacheDeviceHelpers = null;
    private CCOHDeviceHelper[] m_objCachedVdHelpers = null;
    private SL_CCOH_CG_STATS_T m_objCGStats = null;
    private boolean m_isVDReadyForOnline = false;
    private boolean m_isCDOffline = false;
    private boolean m_isVDOffline = false;
    private boolean m_CacheGroupNeedsAttention = false;
    private boolean m_isCacheGroupActive = true;
    private static ArrayList<MenuItemObj> m_arrayMenuItem = Parser.getInstance().getSubMenuList("Cache Group");

    public CCOHCacheGroupHelper(CCOHVirtualAdapterHelper cCOHVirtualAdapterHelper, ServerObjectHelper serverObjectHelper, SL_CCOH_CONFIG_T sL_CCOH_CONFIG_T) {
        this.updateCacheGroupHelper(cCOHVirtualAdapterHelper, serverObjectHelper, sL_CCOH_CONFIG_T);
    }

    public void updateCacheGroupHelper(CCOHVirtualAdapterHelper cCOHVirtualAdapterHelper, ServerObjectHelper serverObjectHelper, SL_CCOH_CONFIG_T sL_CCOH_CONFIG_T) {
        this.m_ccohVirtualAdapterHelper = cCOHVirtualAdapterHelper;
        this.m_objServerObjectHelper = serverObjectHelper;
        this.m_CCOHConfig = sL_CCOH_CONFIG_T;
        this.m_virtualAdapter = (VirtualAdapter)this.m_ccohVirtualAdapterHelper.getDeviceObject();
        this.m_adapHelpers = this.m_objServerObjectHelper.getAdapterHelpers();
        this.m_strCacheGroupName = this.m_CCOHConfig.getCacheGroupNameText();
        this.m_ccohVirtualAdapterHelper.addObserver(this);
        this.m_isCacheGroupActive = this.m_CCOHConfig.isConfigActive();
        this.initializeDeviceHelpers();
    }

    private void initializeDeviceHelpers() {
        int n;
        this.m_isVDReadyForOnline = false;
        this.m_isCDOffline = false;
        this.m_isVDOffline = false;
        this.m_CacheGroupNeedsAttention = false;
        SL_CCOH_DEV_T[] sL_CCOH_DEV_TArray = this.m_CCOHConfig.getCacheDeviceList().getDeviceList();
        this.m_objCacheDeviceHelpers = new CCOHDeviceHelper[sL_CCOH_DEV_TArray.length];
        for (int i = 0; i < sL_CCOH_DEV_TArray.length; ++i) {
            this.m_objCacheDeviceHelpers[i] = new CCOHDeviceHelper(sL_CCOH_DEV_TArray[i]);
            if (!this.m_CacheGroupNeedsAttention && sL_CCOH_DEV_TArray[i].getDevState() != '\u0000') {
                this.m_CacheGroupNeedsAttention = true;
            }
            if (!this.m_isCDOffline && sL_CCOH_DEV_TArray[i].getDevState() == '\u0001') {
                this.m_isCDOffline = true;
            }
            for (n = 0; n < this.m_adapHelpers.length; ++n) {
                LogicalDriveHelper[] logicalDriveHelperArray;
                if (!this.m_adapHelpers[n].isWarhawk() || (logicalDriveHelperArray = this.m_adapHelpers[n].getLogicalDrives()) == null || !sL_CCOH_DEV_TArray[i].getDevIdText().toLowerCase().contains(logicalDriveHelperArray[0].getWWID().toLowerCase())) continue;
                this.m_objCacheDeviceHelpers[i].setAdapterHelper(this.m_adapHelpers[n]);
            }
        }
        SL_CCOH_DEV_T[] sL_CCOH_DEV_TArray2 = this.m_CCOHConfig.getVirtualDriveList().getDeviceList();
        this.m_objCachedVdHelpers = new CCOHDeviceHelper[sL_CCOH_DEV_TArray2.length];
        for (n = 0; n < sL_CCOH_DEV_TArray2.length; ++n) {
            this.m_objCachedVdHelpers[n] = new CCOHDeviceHelper(sL_CCOH_DEV_TArray2[n]);
            if (!this.m_CacheGroupNeedsAttention && sL_CCOH_DEV_TArray2[n].getDevState() != '\u0000') {
                this.m_CacheGroupNeedsAttention = true;
            }
            if (!this.m_isVDReadyForOnline && sL_CCOH_DEV_TArray2[n].getDevState() == '\u0002') {
                this.m_isVDReadyForOnline = true;
            }
            if (this.m_isVDOffline || sL_CCOH_DEV_TArray2[n].getDevState() != '\u0001') continue;
            this.m_isVDOffline = true;
        }
    }

    @Override
    public String getDescription() {
        return this.getText();
    }

    @Override
    public ISASObject getDeviceObject() {
        return this.m_ccohCacheGroup;
    }

    @Override
    public ImageIcon getIcon() {
        if (!this.m_isCacheGroupActive) {
            return new DoubleIcons(this.getImageIcon(Resource.getString("SSCD_VD_IMAGE", "sscd_vd.png")), this.getImageIcon(Resource.getString("EXPIRED_ICON", "Expired.png")), 1);
        }
        if (this.m_CacheGroupNeedsAttention) {
            return new DoubleIcons(this.getImageIcon(Resource.getString("SSCD_VD_IMAGE", "sscd_vd.png")), this.getImageIcon(Resource.getString("NEEDS_ATTENTION_ICON", "NeedAtten.png")), 1);
        }
        return this.getImageIcon(Resource.getString("SSCD_VD_IMAGE", "sscd_vd.png"));
    }

    @Override
    public ArrayList getOperationList() {
        ArrayList<OperationDetails> arrayList = new ArrayList<OperationDetails>();
        if (m_arrayMenuItem == null) {
            System.out.println("/**********Xml is not populated correctly****************/");
            return null;
        }
        MenuItemObj menuItemObj2 = new MenuItemObj();
        for (MenuItemObj menuItemObj2 : m_arrayMenuItem) {
            String string = menuItemObj2.getMenuItemName();
            String string2 = menuItemObj2.getDescKey();
            OperationDetails operationDetails = null;
            if (string.equals("---")) {
                operationDetails = new OperationDetails(0, "---", "separator", null);
                arrayList.add(operationDetails);
                continue;
            }
            String string3 = Resource.getString(string, string);
            String string4 = Resource.getString(string2, string2);
            String[] stringArray = Resource.getResourceMnemonic(string3);
            Boolean bl = menuItemObj2.getParamKey().equals("NOVALUE") ? null : Boolean.TRUE;
            operationDetails = new OperationDetails(menuItemObj2.getSLCmdInt(), stringArray[0], string4, bl);
            if (menuItemObj2.isSLCmd()) {
                arrayList.add(operationDetails);
            } else {
                operationDetails.setDummyCmd(true);
                arrayList.add(operationDetails);
            }
            if (stringArray.length != 2) continue;
            operationDetails.setMnemonics(stringArray[1].charAt(0));
        }
        return arrayList;
    }

    @Override
    public GUIHelperInterface getParent() {
        return this.m_objServerObjectHelper;
    }

    @Override
    public ProgressInfo getProgressInfo() {
        return null;
    }

    @Override
    public ArrayList getPropertyList() {
        ArrayList<CCOHDeviceHelper> arrayList;
        int n;
        Object object;
        int n2;
        Object object2;
        int n3;
        Object object3;
        Object object4;
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        PropertyInfo propertyInfo = new PropertyInfo();
        propertyInfo.name = Resource.getString("PROP_GENERAL", "<html><b>General:</b></html>");
        arrayList2.add(propertyInfo);
        PropertyInfo propertyInfo2 = new PropertyInfo();
        propertyInfo2.description = propertyInfo2.name = Resource.getString("PROP_CACHEGROUP_STATUS", "Status");
        if (!this.m_isCacheGroupActive) {
            propertyInfo2.value = Resource.getString("STATUS_INACTIVE", "Inactive");
            propertyInfo2.hasTooltip = true;
            propertyInfo2.tooltipValue = "?";
            propertyInfo2.tooltip = Resource.getString("STATUS_INACTIVE_TOOLTIP", "LSI Nytro XD license not found");
        } else if (this.m_CacheGroupNeedsAttention) {
            propertyInfo2.value = Resource.getString("STATUS_NEEDS_ATTENTION", "Needs Attention");
            propertyInfo2.hasTooltip = true;
            propertyInfo2.tooltipValue = "?";
            propertyInfo2.tooltip = Resource.getString("STATUS_NEEDS_ATTENTION_TOOLTIP", "Some of the devices are not Online");
        } else {
            propertyInfo2.value = Resource.getString("STATUS_ACTIVE", "Active");
        }
        arrayList2.add(propertyInfo2);
        this.m_objCGStats = this.m_virtualAdapter.getCacheGroupStats();
        if (this.m_objCGStats != null) {
            object4 = new PropertyInfo();
            ((PropertyInfo)object4).name = Resource.getString("PROP_TOTAL_CACHEGROUP_CAPACITY", "Total cache group capacity");
            ((PropertyInfo)object4).description = Resource.getString("PROP_TOTAL_CACHEGROUP_CAPACITY", "Total cache group capacity");
            ((PropertyInfo)object4).value = KernelConstants.getConvertedSize(this.m_objCGStats.getTotalCacheSize());
            arrayList2.add(object4);
            SL_CCOH_CG_LIMITS_T sL_CCOH_CG_LIMITS_T = null;
            sL_CCOH_CG_LIMITS_T = this.m_virtualAdapter.getCacheGroupLimits();
            if (sL_CCOH_CG_LIMITS_T != null) {
                object3 = new PropertyInfo();
                ((PropertyInfo)object3).name = Resource.getString("PROP_MAX_ALLOWED_CAPACITY", "Maximum allowed capacity");
                ((PropertyInfo)object3).description = Resource.getString("PROP_MAX_ALLOWED_CAPACITY", "Maximum allowed capacity");
                ((PropertyInfo)object3).value = KernelConstants.getConvertedSize(sL_CCOH_CG_LIMITS_T.getMaxCacheCapacitySupported());
                arrayList2.add(object3);
            }
        }
        if ((n3 = ((ArrayList)(object4 = this.getNonOfflineVDHelperList())).size()) > 0) {
            object3 = new PropertyInfo();
            StringBuffer stringBuffer = new StringBuffer("<html><b>");
            stringBuffer.append(Resource.getString("PROP_CACHED_VIRTUAL_DRIVES", "Cached Virtual Drives"));
            stringBuffer.append(" (").append(n3).append(")</b></html>");
            ((PropertyInfo)object3).name = stringBuffer.toString();
            ((PropertyInfo)object3).setGuiHelperObj(this);
            ((PropertyInfo)object3).value = Resource.getString("VIEW_PROPERTIES", "View properties");
            ((PropertyInfo)object3).isValueHyperLink = true;
            arrayList2.add(object3);
            for (int i = 0; i < n3; ++i) {
                object2 = new PropertyInfo();
                ((PropertyInfo)object2).name = ((CCOHDeviceHelper)((ArrayList)object4).get(i)).getText();
                arrayList2.add(object2);
            }
        }
        if ((n2 = ((ArrayList)(object3 = this.getOfflineCDHelperList())).size()) > 0) {
            PropertyInfo propertyInfo3 = new PropertyInfo();
            object2 = new StringBuffer("<html><b>");
            ((StringBuffer)object2).append(Resource.getString("PROP_OFFLINE_CACHE_DEVICES", "Offline Cache Devices"));
            ((StringBuffer)object2).append(" (").append(n2).append(")</b></html>");
            propertyInfo3.name = ((StringBuffer)object2).toString();
            arrayList2.add(propertyInfo3);
            for (int i = 0; i < n2; ++i) {
                object = new PropertyInfo();
                ((PropertyInfo)object).name = ((CCOHDeviceHelper)((ArrayList)object3).get(i)).getText();
                arrayList2.add(object);
            }
        }
        if ((n = (arrayList = this.getOfflineVDHelperList()).size()) > 0) {
            PropertyInfo propertyInfo4 = new PropertyInfo();
            object = new StringBuffer("<html><b>");
            ((StringBuffer)object).append(Resource.getString("PROP_OFFLINE_CACHED_VIRTUAL_DRIVES", "Offline Cached Virtual Drives"));
            ((StringBuffer)object).append(" (").append(n).append(")</b></html>");
            propertyInfo4.name = ((StringBuffer)object).toString();
            arrayList2.add(propertyInfo4);
            for (int i = 0; i < n; ++i) {
                PropertyInfo propertyInfo5 = new PropertyInfo();
                propertyInfo5.name = arrayList.get(i).getText();
                arrayList2.add(propertyInfo5);
            }
        }
        return arrayList2;
    }

    @Override
    public int getStatus() {
        return 0;
    }

    @Override
    public ImageIcon getStatusIcon() {
        return null;
    }

    @Override
    public String getText() {
        return Resource.getString("CACHE_GROUP_TEXT", "Cache Group");
    }

    @Override
    public byte getType() {
        return 14;
    }

    @Override
    public boolean isOperationAllowed(int n) {
        return false;
    }

    @Override
    public void issueOperation(OperationDetails operationDetails) {
    }

    @Override
    public void setStatus(int n) {
    }

    @Override
    public void update(Observable observable, Object object) {
        if (object == null) {
            return;
        }
        NotifyObject notifyObject = (NotifyObject)object;
        if (!(notifyObject.getNotifyObject() instanceof MR_EVT_CCOH_DETAIL)) {
            return;
        }
        this.setChanged();
        this.notifyObservers(notifyObject);
    }

    public String getCacheGroupName() {
        return this.m_strCacheGroupName;
    }

    public CCOHDeviceHelper[] getCacheDevices() {
        return this.m_objCacheDeviceHelpers;
    }

    public CCOHDeviceHelper[] getCachedVds() {
        return this.m_objCachedVdHelpers;
    }

    public SL_CCOH_CG_STATS_T getCacheGroupStats() {
        return this.m_objCGStats;
    }

    public ImageIcon getImageIcon(String string) {
        try {
            return new ImageIcon(Toolkit.getDefaultToolkit().getImage(ClassLoader.getSystemResource(string)));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public CCOHVirtualAdapterHelper getCCOHVirtualAdapterHelper() {
        return this.m_ccohVirtualAdapterHelper;
    }

    public boolean isVDReadyForOnline() {
        return this.m_isVDReadyForOnline;
    }

    public boolean isCDOffline() {
        return this.m_isCDOffline;
    }

    public boolean isVDOffline() {
        return this.m_isVDOffline;
    }

    public boolean isCacheGroupNeedsAttention() {
        return this.m_CacheGroupNeedsAttention;
    }

    public boolean isCacheGroupActive() {
        return this.m_isCacheGroupActive;
    }

    public ArrayList<SL_CCOH_DEV_T> getReadyForOnlineVDsList() {
        ArrayList<SL_CCOH_DEV_T> arrayList = new ArrayList<SL_CCOH_DEV_T>();
        for (int i = 0; i < this.m_objCachedVdHelpers.length; ++i) {
            SL_CCOH_DEV_T sL_CCOH_DEV_T = this.m_objCachedVdHelpers[i].getDeviceObject();
            if (sL_CCOH_DEV_T.getDevState() != '\u0002') continue;
            arrayList.add(sL_CCOH_DEV_T);
        }
        return arrayList;
    }

    public ArrayList<SL_CCOH_DEV_T> getNonOfflineVDsList() {
        ArrayList<SL_CCOH_DEV_T> arrayList = new ArrayList<SL_CCOH_DEV_T>();
        for (int i = 0; i < this.m_objCachedVdHelpers.length; ++i) {
            SL_CCOH_DEV_T sL_CCOH_DEV_T = this.m_objCachedVdHelpers[i].getDeviceObject();
            if (sL_CCOH_DEV_T.getDevState() == '\u0001') continue;
            arrayList.add(sL_CCOH_DEV_T);
        }
        return arrayList;
    }

    public ArrayList<CCOHDeviceHelper> getNonOfflineVDHelperList() {
        ArrayList<CCOHDeviceHelper> arrayList = new ArrayList<CCOHDeviceHelper>();
        for (int i = 0; i < this.m_objCachedVdHelpers.length; ++i) {
            if (this.m_objCachedVdHelpers[i].getDeviceObject().getDevState() == '\u0001') continue;
            arrayList.add(this.m_objCachedVdHelpers[i]);
        }
        return arrayList;
    }

    public ArrayList<CCOHDeviceHelper> getOfflineVDHelperList() {
        ArrayList<CCOHDeviceHelper> arrayList = new ArrayList<CCOHDeviceHelper>();
        for (int i = 0; i < this.m_objCachedVdHelpers.length; ++i) {
            if (this.m_objCachedVdHelpers[i].getDeviceObject().getDevState() != '\u0001') continue;
            arrayList.add(this.m_objCachedVdHelpers[i]);
        }
        return arrayList;
    }

    public ArrayList<CCOHDeviceHelper> getNonOfflineCDHelperList() {
        ArrayList<CCOHDeviceHelper> arrayList = new ArrayList<CCOHDeviceHelper>();
        for (int i = 0; i < this.m_objCacheDeviceHelpers.length; ++i) {
            if (this.m_objCacheDeviceHelpers[i].getDeviceObject().getDevState() == '\u0001') continue;
            arrayList.add(this.m_objCacheDeviceHelpers[i]);
        }
        return arrayList;
    }

    public ArrayList<CCOHDeviceHelper> getOfflineCDHelperList() {
        ArrayList<CCOHDeviceHelper> arrayList = new ArrayList<CCOHDeviceHelper>();
        for (int i = 0; i < this.m_objCacheDeviceHelpers.length; ++i) {
            if (this.m_objCacheDeviceHelpers[i].getDeviceObject().getDevState() != '\u0001') continue;
            arrayList.add(this.m_objCacheDeviceHelpers[i]);
        }
        return arrayList;
    }
}

