/*
 * Decompiled with CFR 0.152.
 */
package GUI.CCOH;

import GUI.CCOH.CCOHBaseDialog;
import GUI.CCOH.CCOHCacheDevicesTableModel;
import GUI.CCOH.CCOHConfigurationEngine;
import GUI.CCOH.CCOHTableRenderer;
import GUI.DefaultNoOptionDialog;
import GUIHelper.AdapterHelper;
import SASKernel.LibraryAPI.StoreLib.Constants.SL_CCOH_DEV_CONTENT;
import SASKernel.LibraryAPI.StoreLib.SL_CCOH_CG_LIMITS_T;
import SASKernel.LibraryAPI.StoreLib.SL_CCOH_DEV_T;
import Services.KernelConstants;
import Utils.HelpContextResourse;
import Utils.HelpInterface;
import Utils.Resource;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class CCOHCacheGroupPanel
extends JPanel
implements HelpInterface {
    private CCOHBaseDialog m_ccohBaseDialog = null;
    private CCOHConfigurationEngine m_ccohConfigEngine = null;
    private boolean m_isChanged = false;
    private boolean m_isNextButtonEnabled = false;
    private CCOHCacheDevicesTableModel m_cacheDevicesTableModel = null;
    private CCOHCacheDevicesTableModel m_cacheGroupTableModel = null;
    private JTable m_cacheDevicesTable = new JTable();
    private JTable m_cacheGroupTable = new JTable();
    private ArrayList<AdapterHelper> m_cacheDevicesList = null;
    private ArrayList<AdapterHelper> m_cacheGroupList = null;
    private JButton m_addButton = new JButton();
    private JButton m_removeButton = new JButton();
    private JLabel m_totalcachedeviceslabel = new JLabel();
    private JLabel m_totalcgcapacitylabel = new JLabel();
    private JLabel m_maxallowedcapacitylabel = new JLabel();
    private int m_MaxCacheDevicesSupported = 0;
    private long m_MaxCacheCapacitySupported = 0L;
    private int m_totalcachedevices = 0;
    private long m_totalcgcapacity = 0L;

    public CCOHCacheGroupPanel(CCOHBaseDialog cCOHBaseDialog) {
        this.m_ccohBaseDialog = cCOHBaseDialog;
        this.m_ccohConfigEngine = this.m_ccohBaseDialog.getCCOHConfigEngine();
        this.m_cacheDevicesList = this.m_ccohConfigEngine.getHelpersForCacheDevsToBeAdded();
        this.m_cacheGroupList = this.m_ccohConfigEngine.getHelpersForCacheDevsAdded();
        SL_CCOH_CG_LIMITS_T sL_CCOH_CG_LIMITS_T = this.m_ccohBaseDialog.getVirtualAdapterHelper().getCacheGroupLimits();
        this.m_MaxCacheCapacitySupported = sL_CCOH_CG_LIMITS_T.getMaxCacheCapacitySupported();
        this.m_MaxCacheDevicesSupported = sL_CCOH_CG_LIMITS_T.getMaxCacheDevicesSupported();
        this.buildpanel();
    }

    private void buildpanel() {
        this.setLayout(new GridBagLayout());
        this.m_ccohBaseDialog.setNextButtonEnabled(false);
        this.m_isNextButtonEnabled = false;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 21;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.insets = new Insets(10, 15, 20, 15);
        this.add((Component)new JLabel(Resource.getString("CACHE_GROUP_PANEL_MSG", "Select the cache devices to include in the cache group.")), gridBagConstraints);
        String[] stringArray = null;
        stringArray = Resource.getResourceMnemonic(Resource.getString("CACHE_GROUP_PANEL_CACHE_DEVICES", "(C)ache devices:"));
        JLabel jLabel = new JLabel(stringArray[0]);
        if (stringArray.length == 2) {
            jLabel.setDisplayedMnemonic(stringArray[1].charAt(0));
        }
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 15, 0, 0);
        this.add((Component)jLabel, gridBagConstraints);
        stringArray = Resource.getResourceMnemonic(Resource.getString("CACHE_GROUP_PANEL_CACHE_GROUP", "Cache gr(o)up:"));
        JLabel jLabel2 = new JLabel(stringArray[0]);
        if (stringArray.length == 2) {
            jLabel2.setDisplayedMnemonic(stringArray[1].charAt(0));
        }
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)jLabel2, gridBagConstraints);
        this.m_cacheDevicesTableModel = new CCOHCacheDevicesTableModel(this.m_cacheDevicesList);
        if (this.m_cacheDevicesTableModel != null) {
            this.m_cacheDevicesTable.setModel(this.m_cacheDevicesTableModel);
        }
        this.m_cacheDevicesTable.setShowGrid(false);
        this.m_cacheDevicesTable.setCellSelectionEnabled(false);
        this.m_cacheDevicesTable.setRowSelectionAllowed(true);
        this.m_cacheDevicesTable.setColumnSelectionAllowed(false);
        this.m_cacheDevicesTable.setSelectionMode(2);
        this.m_cacheDevicesTable.setAutoResizeMode(0);
        this.m_cacheDevicesTable.setAutoCreateRowSorter(true);
        this.m_cacheDevicesTable.getTableHeader().setResizingAllowed(true);
        this.m_cacheDevicesTable.getColumnModel().getColumn(0).setPreferredWidth(298);
        this.m_cacheDevicesTable.setAutoscrolls(true);
        this.m_cacheDevicesTable.getTableHeader().setReorderingAllowed(false);
        this.m_cacheDevicesTable.changeSelection(0, 0, true, false);
        CCOHTableRenderer cCOHTableRenderer = new CCOHTableRenderer(this.m_ccohConfigEngine);
        this.m_cacheDevicesTable.setDefaultRenderer(AdapterHelper.class, cCOHTableRenderer);
        this.m_cacheDevicesTable.getSelectionModel().addListSelectionListener(new cacheDevicesTableListSelectionListener());
        jLabel.setLabelFor(this.m_cacheDevicesTable);
        JScrollPane jScrollPane = new JScrollPane(this.m_cacheDevicesTable, 20, 30);
        jScrollPane.setPreferredSize(new Dimension(300, 125));
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.insets = new Insets(0, 15, 5, 10);
        this.add((Component)jScrollPane, gridBagConstraints);
        this.m_cacheGroupTableModel = new CCOHCacheDevicesTableModel(this.m_cacheGroupList);
        if (this.m_cacheGroupTableModel != null) {
            this.m_cacheGroupTable.setModel(this.m_cacheGroupTableModel);
        }
        this.m_cacheGroupTable.setShowGrid(false);
        this.m_cacheGroupTable.setCellSelectionEnabled(false);
        this.m_cacheGroupTable.setRowSelectionAllowed(true);
        this.m_cacheGroupTable.setColumnSelectionAllowed(false);
        this.m_cacheGroupTable.setSelectionMode(2);
        this.m_cacheGroupTable.setAutoResizeMode(0);
        this.m_cacheGroupTable.setAutoCreateRowSorter(true);
        this.m_cacheGroupTable.getTableHeader().setResizingAllowed(true);
        this.m_cacheGroupTable.getColumnModel().getColumn(0).setPreferredWidth(298);
        this.m_cacheGroupTable.setAutoscrolls(true);
        this.m_cacheGroupTable.getTableHeader().setReorderingAllowed(false);
        this.m_cacheGroupTable.changeSelection(0, 0, true, false);
        this.m_cacheGroupTable.setDefaultRenderer(AdapterHelper.class, cCOHTableRenderer);
        this.m_cacheGroupTable.getSelectionModel().addListSelectionListener(new cacheGroupTableListSelectionListener());
        jLabel2.setLabelFor(this.m_cacheGroupTable);
        JScrollPane jScrollPane2 = new JScrollPane(this.m_cacheGroupTable, 20, 30);
        jScrollPane2.setPreferredSize(new Dimension(300, 125));
        this.m_cacheGroupTable.setBackground(Color.WHITE);
        jScrollPane2.setBackground(Color.WHITE);
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridx = 3;
        gridBagConstraints.insets = new Insets(0, 0, 5, 15);
        this.add((Component)jScrollPane2, gridBagConstraints);
        gridBagConstraints.anchor = 10;
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        stringArray = Resource.getResourceMnemonic(Resource.getString("CCOH_ADD_BUTTON", "(A)dd >"));
        this.m_addButton.setText(stringArray[0]);
        if (stringArray.length == 2) {
            this.m_addButton.setMnemonic(stringArray[1].charAt(0));
        }
        this.m_addButton.setEnabled(this.m_cacheDevicesTable.getSelectedRowCount() > 0);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints2.gridx = 2;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.insets = new Insets(0, 25, 0, 10);
        jPanel.add((Component)this.m_addButton, gridBagConstraints2);
        stringArray = Resource.getResourceMnemonic(Resource.getString("CCOH_REMOVE_BUTTON", "< (R)emove"));
        this.m_removeButton.setText(stringArray[0]);
        if (stringArray.length == 2) {
            this.m_removeButton.setMnemonic(stringArray[1].charAt(0));
        }
        this.m_removeButton.setEnabled(false);
        gridBagConstraints2.gridx = 3;
        gridBagConstraints2.insets = new Insets(0, 0, 0, 20);
        jPanel.add((Component)this.m_removeButton, gridBagConstraints2);
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.insets = new Insets(0, 15, 10, 0);
        this.add((Component)jPanel, gridBagConstraints);
        gridBagConstraints.anchor = 21;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridx = 3;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)new JLabel(Resource.getString("CACHE_GROUP_PANEL_TOTAL_CACHE_DEVICES", "Total cache devices:")), gridBagConstraints);
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridx = 4;
        gridBagConstraints.insets = new Insets(0, 0, 0, 15);
        this.m_totalcachedeviceslabel.setText(" " + this.m_totalcachedevices);
        this.add((Component)this.m_totalcachedeviceslabel, gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridx = 3;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)new JLabel(Resource.getString("CACHE_GROUP_PANEL_MSG_TOTAL_CG_CAPACITY", "Total cache group capacity:")), gridBagConstraints);
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridx = 4;
        gridBagConstraints.insets = new Insets(0, 0, 0, 15);
        this.m_totalcgcapacitylabel.setText(" " + KernelConstants.getConvertedSize(this.m_totalcgcapacity));
        this.add((Component)this.m_totalcgcapacitylabel, gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridx = 3;
        gridBagConstraints.insets = new Insets(0, 0, 30, 0);
        this.add((Component)new JLabel(Resource.getString("CACHE_GROUP_PANEL_MAX_ALLOWED_CAPACITY", "Maximum allowed capacity:")), gridBagConstraints);
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridx = 4;
        gridBagConstraints.insets = new Insets(0, 0, 30, 15);
        this.m_maxallowedcapacitylabel.setText(" " + KernelConstants.getConvertedSize(this.m_MaxCacheCapacitySupported));
        this.add((Component)this.m_maxallowedcapacitylabel, gridBagConstraints);
        this.m_addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int[] nArray = CCOHCacheGroupPanel.this.m_cacheDevicesTable.getSelectedRows();
                int n = nArray.length;
                ArrayList arrayList = new ArrayList();
                for (int i = 0; i < n; ++i) {
                    nArray[i] = CCOHCacheGroupPanel.this.m_cacheDevicesTable.convertRowIndexToModel(nArray[i]);
                    arrayList.add(CCOHCacheGroupPanel.this.m_cacheDevicesList.get(nArray[i]));
                }
                if (CCOHCacheGroupPanel.this.checkAndShowMaxCapExcdedDlg(arrayList) && CCOHCacheGroupPanel.this.checkAndShowFileSystemDlg(arrayList)) {
                    CCOHCacheGroupPanel.this.m_cacheGroupList.addAll(arrayList);
                    CCOHCacheGroupPanel.this.m_cacheDevicesList.removeAll(arrayList);
                    CCOHCacheGroupPanel.this.m_cacheDevicesTableModel.updateModel(CCOHCacheGroupPanel.this.m_cacheDevicesList);
                    CCOHCacheGroupPanel.this.m_cacheGroupTableModel.updateModel(CCOHCacheGroupPanel.this.m_cacheGroupList);
                    CCOHCacheGroupPanel.this.m_isChanged = true;
                    CCOHCacheGroupPanel.this.m_addButton.setEnabled(false);
                    CCOHCacheGroupPanel.this.m_removeButton.setEnabled(false);
                    CCOHCacheGroupPanel.this.m_ccohBaseDialog.setNextButtonEnabled(true);
                    CCOHCacheGroupPanel.this.m_isNextButtonEnabled = true;
                    CCOHCacheGroupPanel.this.m_ccohConfigEngine.setCacheDevsAdded(CCOHCacheGroupPanel.this.m_ccohConfigEngine.getCDListForHelpers(CCOHCacheGroupPanel.this.m_cacheGroupList));
                    CCOHCacheGroupPanel.this.m_ccohConfigEngine.setCacheDevsToBeAdded(CCOHCacheGroupPanel.this.m_ccohConfigEngine.getCDListForHelpers(CCOHCacheGroupPanel.this.m_cacheDevicesList));
                    CCOHCacheGroupPanel.this.updateCGdata();
                    CCOHCacheGroupPanel.this.updateCapacityLabels();
                }
            }
        });
        this.m_removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int[] nArray = CCOHCacheGroupPanel.this.m_cacheGroupTable.getSelectedRows();
                int n = nArray.length;
                ArrayList arrayList = new ArrayList();
                for (int i = 0; i < n; ++i) {
                    nArray[i] = CCOHCacheGroupPanel.this.m_cacheGroupTable.convertRowIndexToModel(nArray[i]);
                    arrayList.add(CCOHCacheGroupPanel.this.m_cacheGroupList.get(nArray[i]));
                }
                CCOHCacheGroupPanel.this.m_cacheDevicesList.addAll(arrayList);
                CCOHCacheGroupPanel.this.m_cacheGroupList.removeAll(arrayList);
                CCOHCacheGroupPanel.this.m_cacheDevicesTableModel.updateModel(CCOHCacheGroupPanel.this.m_cacheDevicesList);
                CCOHCacheGroupPanel.this.m_cacheGroupTableModel.updateModel(CCOHCacheGroupPanel.this.m_cacheGroupList);
                if (CCOHCacheGroupPanel.this.m_cacheGroupList.size() == 0) {
                    CCOHCacheGroupPanel.this.m_ccohBaseDialog.setNextButtonEnabled(false);
                    CCOHCacheGroupPanel.this.m_isNextButtonEnabled = false;
                }
                CCOHCacheGroupPanel.this.m_removeButton.setEnabled(false);
                CCOHCacheGroupPanel.this.m_addButton.setEnabled(false);
                CCOHCacheGroupPanel.this.m_ccohConfigEngine.setCacheDevsAdded(CCOHCacheGroupPanel.this.m_ccohConfigEngine.getCDListForHelpers(CCOHCacheGroupPanel.this.m_cacheGroupList));
                CCOHCacheGroupPanel.this.m_ccohConfigEngine.setCacheDevsToBeAdded(CCOHCacheGroupPanel.this.m_ccohConfigEngine.getCDListForHelpers(CCOHCacheGroupPanel.this.m_cacheDevicesList));
                CCOHCacheGroupPanel.this.updateCGdata();
                CCOHCacheGroupPanel.this.updateCapacityLabels();
            }
        });
        this.m_cacheGroupTable.clearSelection();
        if (this.m_cacheDevicesList.size() > 0) {
            this.m_cacheDevicesTable.setRowSelectionInterval(0, 0);
        }
    }

    private boolean checkAndShowMaxCapExcdedDlg(ArrayList<AdapterHelper> arrayList) {
        long l = this.m_totalcgcapacity + this.m_ccohConfigEngine.getTotalCapacity(this.m_ccohConfigEngine.getCDListForHelpers(arrayList));
        if (l <= this.m_MaxCacheCapacitySupported) {
            return true;
        }
        Object[] objectArray = new Object[2];
        StringBuffer stringBuffer = new StringBuffer();
        objectArray[0] = stringBuffer.append(KernelConstants.getConvertedSize(this.m_MaxCacheCapacitySupported));
        objectArray[1] = stringBuffer.append(KernelConstants.getConvertedSize(l));
        String string = MessageFormat.format(Resource.getString("CACHE_GROUP_PANEL_WARNING_MSG_NEW"), objectArray);
        DefaultNoOptionDialog defaultNoOptionDialog = new DefaultNoOptionDialog(Resource.getString("CACHE_GROUP_PANEL_WARNING_TITLE1", "Maximum Capacity Exceeded"), string, 2);
        return defaultNoOptionDialog.getOptionPaneValue();
    }

    private boolean checkAndShowFileSystemDlg(ArrayList<AdapterHelper> arrayList) {
        ArrayList<SL_CCOH_DEV_T> arrayList2 = this.m_ccohConfigEngine.getCDListForHelpers(arrayList);
        int n = arrayList2.size();
        boolean bl = false;
        boolean bl2 = false;
        SL_CCOH_DEV_T sL_CCOH_DEV_T = null;
        SL_CCOH_DEV_CONTENT sL_CCOH_DEV_CONTENT = null;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<html>");
        for (int i = 0; i < n; ++i) {
            bl2 = false;
            sL_CCOH_DEV_T = arrayList2.get(i);
            sL_CCOH_DEV_CONTENT = sL_CCOH_DEV_T.getDevContent();
            if (sL_CCOH_DEV_T.getDevState() == '\u0001' || sL_CCOH_DEV_CONTENT.isNoContentDetected()) continue;
            bl = true;
            stringBuffer.append(this.m_ccohConfigEngine.getHelperCDText(arrayList.get(i)));
            stringBuffer.append("<br>");
            stringBuffer.append("Contains: ");
            if (sL_CCOH_DEV_CONTENT.isForeign()) {
                if (bl2) {
                    stringBuffer.append(", ");
                } else {
                    bl2 = true;
                }
                stringBuffer.append("<b>");
                stringBuffer.append(Resource.getString("CCOH_DEV_FOREIGN", "Foreign configuration"));
                stringBuffer.append("</b>");
            }
            if (sL_CCOH_DEV_CONTENT.isMbr()) {
                if (bl2) {
                    stringBuffer.append(", ");
                } else {
                    bl2 = true;
                }
                stringBuffer.append(Resource.getString("CCOH_DEV_MBR", "Boot data"));
            }
            if (sL_CCOH_DEV_CONTENT.isSwap()) {
                if (bl2) {
                    stringBuffer.append(", ");
                } else {
                    bl2 = true;
                }
                stringBuffer.append(Resource.getString("CCOH_DEV_SWAP", "Swap data"));
            }
            if (sL_CCOH_DEV_CONTENT.isLvm2Member()) {
                if (bl2) {
                    stringBuffer.append(", ");
                } else {
                    bl2 = true;
                }
                stringBuffer.append(Resource.getString("CCOH_DEV_LVM2_MEMBER", "LVM2 member"));
            }
            if (sL_CCOH_DEV_CONTENT.isFileSystem()) {
                if (bl2) {
                    stringBuffer.append(", ");
                } else {
                    bl2 = true;
                }
                stringBuffer.append(Resource.getString("CCOH_DEV_FILE_SYSTEM", "File system"));
            }
            if (sL_CCOH_DEV_CONTENT.isContentUnknown()) {
                if (bl2) {
                    stringBuffer.append(", ");
                } else {
                    bl2 = true;
                }
                stringBuffer.append(Resource.getString("CCOH_DEV_UNKNOWN", "Unknown data"));
            }
            stringBuffer.append("<br><br>");
        }
        if (bl) {
            stringBuffer.append(Resource.getString("CACHE_GROUP_PANEL_WARNING_MSG4", "All data on the selected cache device(s) will be permanently deleted.<br><br>Are you sure you want to permanently delete all the data on the<br>selected cache device(s)?<br><br></html>"));
            DefaultNoOptionDialog defaultNoOptionDialog = new DefaultNoOptionDialog(Resource.getString("CACHE_GROUP_PANEL_WARNING_TITLE2", "Data Detected"), stringBuffer.toString(), 2);
            return defaultNoOptionDialog.getOptionPaneValue();
        }
        return true;
    }

    @Override
    public String getHelpPage() {
        return HelpContextResourse.getHelpPageName("NYTRO_XD_ADDING_THE_CACHE_DEVICES");
    }

    public JButton getDefaultButton() {
        return null;
    }

    public byte getPageId() {
        return 2;
    }

    public boolean isChanged() {
        return this.m_isChanged;
    }

    private void updateCGdata() {
        this.m_totalcachedevices = this.m_cacheGroupList.size();
        this.m_totalcgcapacity = this.m_ccohConfigEngine.getTotalCapacity(this.m_ccohConfigEngine.getCacheDevsAdded());
    }

    private void updateCapacityLabels() {
        this.m_totalcachedeviceslabel.setText(" " + this.m_totalcachedevices);
        this.m_totalcgcapacitylabel.setText(" " + KernelConstants.getConvertedSize(this.m_totalcgcapacity));
    }

    private boolean canCDsBeAdded(int n) {
        return this.m_totalcgcapacity < this.m_MaxCacheCapacitySupported && this.m_totalcachedevices + n <= this.m_MaxCacheDevicesSupported;
    }

    public boolean isNextButtonEnabled() {
        return this.m_isNextButtonEnabled;
    }

    public void reset() {
        this.m_isNextButtonEnabled = false;
        this.m_isChanged = false;
        this.updateCGdata();
        this.updateCapacityLabels();
        this.m_cacheGroupTable.clearSelection();
        if (this.m_cacheDevicesList.size() > 0) {
            this.m_cacheDevicesTable.setRowSelectionInterval(0, 0);
        }
    }

    class cacheGroupTableListSelectionListener
    implements ListSelectionListener {
        cacheGroupTableListSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            CCOHCacheGroupPanel.this.m_addButton.setEnabled(false);
            CCOHCacheGroupPanel.this.m_removeButton.setEnabled(CCOHCacheGroupPanel.this.m_cacheGroupTable.getSelectedRows().length > 0);
            CCOHCacheGroupPanel.this.m_cacheDevicesTable.clearSelection();
        }
    }

    class cacheDevicesTableListSelectionListener
    implements ListSelectionListener {
        cacheDevicesTableListSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            int n = CCOHCacheGroupPanel.this.m_cacheDevicesTable.getSelectedRows().length;
            CCOHCacheGroupPanel.this.m_addButton.setEnabled(n > 0 && CCOHCacheGroupPanel.this.canCDsBeAdded(n));
            CCOHCacheGroupPanel.this.m_removeButton.setEnabled(false);
            CCOHCacheGroupPanel.this.m_cacheGroupTable.clearSelection();
        }
    }
}

