/*
 * Decompiled with CFR 0.152.
 */
package GUI.CCOH;

import GUI.CCOH.CCOHCacheGroupHelper;
import GUI.CCOH.CCOHCacheHitAndMissChart;
import GUI.CCOH.CCOHCacheSizeChart;
import SASKernel.LibraryAPI.StoreLib.SL_CCOH_CG_STATS_T;
import SASKernel.VirtualAdapter;
import Utils.Resource;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;

public class CCOHCacheGroupPerformanceTab
extends JPanel {
    CCOHCacheGroupHelper m_objCacheGroupHelper = null;
    SL_CCOH_CG_STATS_T m_objCGStats = null;
    JPanel m_objCacheSizePanel = new JPanel();
    JPanel m_objHitAndMissPanel = new JPanel();
    JButton m_refreshButton = new JButton();
    long m_iUsedCache = 0L;
    long m_iTotalCache = 0L;
    long m_iCacheHit = 0L;
    long m_iCacheMiss = 0L;

    public CCOHCacheGroupPerformanceTab(CCOHCacheGroupHelper cCOHCacheGroupHelper) {
        this.m_objCacheGroupHelper = cCOHCacheGroupHelper;
        String[] stringArray = null;
        stringArray = Resource.getResourceMnemonic(Resource.getString("REFRESH_PROPERTIES", "(R)efresh"));
        this.m_refreshButton.setText(stringArray[0]);
        this.m_refreshButton.setIcon(this.getImageIcon(Resource.getString("REFRESHIMAGE", "Refresh.png")));
        if (stringArray.length == 2) {
            this.m_refreshButton.setMnemonic(stringArray[1].charAt(0));
        }
        this.m_refreshButton.setEnabled(true);
        this.m_refreshButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CCOHCacheGroupPerformanceTab.this.updatePanel();
            }
        });
        this.updatePanel();
    }

    public void updatePanel() {
        this.m_objCGStats = ((VirtualAdapter)this.m_objCacheGroupHelper.getCCOHVirtualAdapterHelper().getDeviceObject()).getCacheGroupStats();
        this.initConstants();
        this.m_objCacheSizePanel.removeAll();
        this.buildCacheSizePanel();
        this.m_objHitAndMissPanel.removeAll();
        this.buildCacheHitAndMissPanel();
        this.buildUI();
    }

    private void buildCacheSizePanel() {
        int n = 0;
        int n2 = 0;
        try {
            n = (int)(this.m_iUsedCache * 100L / this.m_iTotalCache);
        }
        catch (ArithmeticException arithmeticException) {
            System.out.println("Total Cache is 0 - Divide by 0 Exception");
        }
        n2 = 100 - n;
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        jPanel.setLayout(new BorderLayout());
        TitledBorder titledBorder = new TitledBorder(new LineBorder(Color.LIGHT_GRAY, 1, true), Resource.getString("LABEL_CACHE_SIZE", "Cache Size "));
        titledBorder.setTitleColor(Color.BLACK);
        this.m_objCacheSizePanel.setBorder(titledBorder);
        this.m_objCacheSizePanel.setPreferredSize(new Dimension(350, 190));
        jPanel.add((Component)new CCOHCacheSizeChart(n), "Center");
        jPanel.setPreferredSize(new Dimension(150, 150));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 10, 5, 0);
        jPanel2.setLayout(new GridBagLayout());
        JLabel jLabel = new JLabel(Resource.getString("LABEL_USED_CACHE ", "Used Cache : ") + n + " %");
        jLabel.setIcon(this.getImageIcon(Resource.getString("DARKBLUE_ICON", "darkbluepattern.png")));
        jPanel2.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        JLabel jLabel2 = new JLabel(Resource.getString("LABEL_REMAINING_CACHE", "Remaining Cache : ") + n2 + " %");
        jLabel2.setIcon(this.getImageIcon(Resource.getString("LIGHTBLUE_ICON", "lightbluepattern.png")));
        jPanel2.add((Component)jLabel2, gridBagConstraints);
        this.m_objCacheSizePanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        this.m_objCacheSizePanel.add((Component)jPanel, gridBagConstraints2);
        gridBagConstraints2.gridx = 1;
        this.m_objCacheSizePanel.add((Component)jPanel2, gridBagConstraints2);
    }

    private void buildCacheHitAndMissPanel() {
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        jPanel.setLayout(new BorderLayout());
        TitledBorder titledBorder = new TitledBorder(new LineBorder(Color.LIGHT_GRAY, 1, true), Resource.getString("LABEL_CACHE_HIT_AND_MISS", "Cache Hit And Miss"));
        titledBorder.setTitleColor(Color.BLACK);
        this.m_objHitAndMissPanel.setBorder(titledBorder);
        this.m_objHitAndMissPanel.setPreferredSize(new Dimension(350, 190));
        jPanel.add((Component)new CCOHCacheHitAndMissChart(this.m_iCacheHit, this.m_iCacheMiss), "Center");
        jPanel.setPreferredSize(new Dimension(150, 150));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 10, 5, 0);
        jPanel2.setLayout(new GridBagLayout());
        JLabel jLabel = new JLabel(Resource.getString("LABEL_CACHE_HIT", "Cache Hit: ") + this.m_iCacheHit);
        jLabel.setIcon(this.getImageIcon(Resource.getString("DARKBLUE_ICON", "darkbluepattern.png")));
        jPanel2.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        JLabel jLabel2 = new JLabel(Resource.getString("LABEL_CACHE_MISS", "Cache Miss: ") + this.m_iCacheMiss);
        jLabel2.setIcon(this.getImageIcon(Resource.getString("LIGHTBLUE_ICON", "lightbluepattern.png")));
        jPanel2.add((Component)jLabel2, gridBagConstraints);
        this.m_objHitAndMissPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        this.m_objHitAndMissPanel.add((Component)jPanel, gridBagConstraints2);
        gridBagConstraints2.gridx = 1;
        this.m_objHitAndMissPanel.add((Component)jPanel2, gridBagConstraints2);
    }

    private void buildUI() {
        this.removeAll();
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 12;
        gridBagConstraints.gridy = 0;
        this.add((Component)this.m_refreshButton, gridBagConstraints);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridy = 1;
        this.add((Component)this.m_objCacheSizePanel, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        this.add((Component)this.m_objHitAndMissPanel, gridBagConstraints);
        this.validate();
        this.repaint();
    }

    private void initConstants() {
        if (this.m_objCGStats != null) {
            this.m_iUsedCache = this.m_objCGStats.getCacheSizeInUse();
            this.m_iTotalCache = this.m_objCGStats.getTotalCacheSize();
            this.m_iCacheHit = this.m_objCGStats.getCacheHits();
            this.m_iCacheMiss = this.m_objCGStats.getCacheMisses();
        }
    }

    public ImageIcon getImageIcon(String string) {
        try {
            return new ImageIcon(Toolkit.getDefaultToolkit().getImage(ClassLoader.getSystemResource(string)));
        }
        catch (Exception exception) {
            return null;
        }
    }
}

