/*
 * Decompiled with CFR 0.152.
 */
package GUI.CCOH;

import GUI.CCOH.CCOHBaseDialog;
import GUI.CCOH.CCOHConfigurationEngine;
import GUI.CCOH.CCOHTableRenderer;
import GUI.CCOH.CCOHVirtualDrivesTableModel;
import SASKernel.LibraryAPI.StoreLib.SL_CCOH_CG_LIMITS_T;
import SASKernel.LibraryAPI.StoreLib.SL_CCOH_DEV_T;
import Utils.HelpContextResourse;
import Utils.HelpInterface;
import Utils.Resource;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class CCOHCachedVirtualDrivesPanel
extends JPanel
implements HelpInterface {
    private CCOHBaseDialog m_ccohBaseDialog = null;
    private CCOHConfigurationEngine m_ccohConfigEngine = null;
    private boolean m_isChanged = false;
    private CCOHVirtualDrivesTableModel m_cachableVirtualDrivesTableModel = null;
    private CCOHVirtualDrivesTableModel m_cachedVirtualDrivesTableModel = null;
    private JTable m_cachableVirtualDrivesTable = new JTable();
    private JTable m_cachedVirtualDrivesTable = new JTable();
    private ArrayList<SL_CCOH_DEV_T> m_cachableVirtualDrivesList = null;
    private ArrayList<SL_CCOH_DEV_T> m_cachedVirtualDrivesList = null;
    private JButton m_addButton = new JButton();
    private JButton m_addAllButton = new JButton();
    private JButton m_removeButton = new JButton();
    private JButton m_removeAllButton = new JButton();
    private int m_MaxVirtualDrivesSupported = 0;
    private boolean m_addAllButtonEnabled = false;

    public CCOHCachedVirtualDrivesPanel(CCOHBaseDialog cCOHBaseDialog) {
        this.m_ccohBaseDialog = cCOHBaseDialog;
        this.m_ccohConfigEngine = this.m_ccohBaseDialog.getCCOHConfigEngine();
        this.m_cachableVirtualDrivesList = this.m_ccohConfigEngine.getVirtualDrivesToBeAdded();
        this.m_cachedVirtualDrivesList = this.m_ccohConfigEngine.getVirtualDrivesAdded();
        SL_CCOH_CG_LIMITS_T sL_CCOH_CG_LIMITS_T = this.m_ccohBaseDialog.getVirtualAdapterHelper().getCacheGroupLimits();
        this.m_MaxVirtualDrivesSupported = sL_CCOH_CG_LIMITS_T.getMaxVirtualDrivesSupported();
        this.m_addAllButtonEnabled = this.m_cachableVirtualDrivesList.size() > 0 && this.m_ccohConfigEngine.getVirtualDrivesInSystem().size() <= this.m_MaxVirtualDrivesSupported;
        this.buildpanel();
    }

    private void buildpanel() {
        this.setLayout(new GridBagLayout());
        this.m_ccohBaseDialog.setNextButtonEnabled(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 21;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.insets = new Insets(10, 15, 20, 15);
        if (this.m_cachableVirtualDrivesList.size() > 0) {
            this.add((Component)new JLabel(Resource.getString("VIRTUAL_DRIVES_PANEL_MSG1", "Now, select the virtual drives to cache from the eligible virtual drives listed below.")), gridBagConstraints);
        } else {
            this.add((Component)new JLabel(Resource.getString("VIRTUAL_DRIVES_PANEL_MSG2", "No eligible virtual drives detected. You can add virtual drives later using the Manage Cached Virtual Drives dialog.")), gridBagConstraints);
        }
        String[] stringArray = null;
        stringArray = Resource.getResourceMnemonic(Resource.getString("VIRTUAL_DRIVES_PANEL_VDS", "(V)irtual drives:"));
        JLabel jLabel = new JLabel(stringArray[0]);
        if (stringArray.length == 2) {
            jLabel.setDisplayedMnemonic(stringArray[1].charAt(0));
        }
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 15, 0, 0);
        this.add((Component)jLabel, gridBagConstraints);
        stringArray = Resource.getResourceMnemonic(Resource.getString("VIRTUAL_DRIVES_PANEL_CACHED_VDS", "(C)ached virtual drives:"));
        JLabel jLabel2 = new JLabel(stringArray[0]);
        if (stringArray.length == 2) {
            jLabel2.setDisplayedMnemonic(stringArray[1].charAt(0));
        }
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)jLabel2, gridBagConstraints);
        this.m_cachableVirtualDrivesTableModel = new CCOHVirtualDrivesTableModel(this.m_cachableVirtualDrivesList);
        if (this.m_cachableVirtualDrivesTableModel != null) {
            this.m_cachableVirtualDrivesTable.setModel(this.m_cachableVirtualDrivesTableModel);
        }
        this.m_cachableVirtualDrivesTable.setShowGrid(false);
        this.m_cachableVirtualDrivesTable.setCellSelectionEnabled(false);
        this.m_cachableVirtualDrivesTable.setRowSelectionAllowed(true);
        this.m_cachableVirtualDrivesTable.setColumnSelectionAllowed(false);
        this.m_cachableVirtualDrivesTable.setSelectionMode(2);
        this.m_cachableVirtualDrivesTable.setAutoResizeMode(0);
        this.m_cachableVirtualDrivesTable.setAutoCreateRowSorter(true);
        this.m_cachableVirtualDrivesTable.getTableHeader().setResizingAllowed(true);
        this.m_cachableVirtualDrivesTable.getColumnModel().getColumn(0).setPreferredWidth(298);
        this.m_cachableVirtualDrivesTable.setAutoscrolls(true);
        this.m_cachableVirtualDrivesTable.getTableHeader().setReorderingAllowed(false);
        this.m_cachableVirtualDrivesTable.changeSelection(0, 0, true, false);
        CCOHTableRenderer cCOHTableRenderer = new CCOHTableRenderer(this.m_ccohConfigEngine);
        this.m_cachableVirtualDrivesTable.setDefaultRenderer(SL_CCOH_DEV_T.class, cCOHTableRenderer);
        this.m_cachableVirtualDrivesTable.getSelectionModel().addListSelectionListener(new cachableVirtualDrivesTableListSelectionListener());
        jLabel.setLabelFor(this.m_cachableVirtualDrivesTable);
        JScrollPane jScrollPane = new JScrollPane(this.m_cachableVirtualDrivesTable, 20, 30);
        jScrollPane.setPreferredSize(new Dimension(300, 125));
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.insets = new Insets(0, 15, 5, 10);
        this.add((Component)jScrollPane, gridBagConstraints);
        this.m_cachedVirtualDrivesTableModel = new CCOHVirtualDrivesTableModel(this.m_cachedVirtualDrivesList);
        if (this.m_cachedVirtualDrivesTableModel != null) {
            this.m_cachedVirtualDrivesTable.setModel(this.m_cachedVirtualDrivesTableModel);
        }
        this.m_cachedVirtualDrivesTable.setShowGrid(false);
        this.m_cachedVirtualDrivesTable.setCellSelectionEnabled(false);
        this.m_cachedVirtualDrivesTable.setRowSelectionAllowed(true);
        this.m_cachedVirtualDrivesTable.setColumnSelectionAllowed(false);
        this.m_cachedVirtualDrivesTable.setSelectionMode(2);
        this.m_cachedVirtualDrivesTable.setAutoResizeMode(0);
        this.m_cachedVirtualDrivesTable.setAutoCreateRowSorter(true);
        this.m_cachedVirtualDrivesTable.getTableHeader().setResizingAllowed(true);
        this.m_cachedVirtualDrivesTable.getColumnModel().getColumn(0).setPreferredWidth(298);
        this.m_cachedVirtualDrivesTable.setAutoscrolls(true);
        this.m_cachedVirtualDrivesTable.getTableHeader().setReorderingAllowed(false);
        this.m_cachedVirtualDrivesTable.changeSelection(0, 0, true, false);
        this.m_cachedVirtualDrivesTable.setDefaultRenderer(SL_CCOH_DEV_T.class, cCOHTableRenderer);
        this.m_cachedVirtualDrivesTable.getSelectionModel().addListSelectionListener(new cachedVirtualDrivesTableListSelectionListener());
        jLabel2.setLabelFor(this.m_cachedVirtualDrivesTable);
        JScrollPane jScrollPane2 = new JScrollPane(this.m_cachedVirtualDrivesTable, 20, 30);
        jScrollPane2.setPreferredSize(new Dimension(300, 125));
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridx = 3;
        gridBagConstraints.insets = new Insets(0, 0, 5, 15);
        this.add((Component)jScrollPane2, gridBagConstraints);
        gridBagConstraints.anchor = 10;
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        stringArray = Resource.getResourceMnemonic(Resource.getString("CCOH_ADD_BUTTON", "(A)dd >"));
        this.m_addButton.setText(stringArray[0]);
        if (stringArray.length == 2) {
            this.m_addButton.setMnemonic(stringArray[1].charAt(0));
        }
        this.m_addButton.setEnabled(this.m_cachableVirtualDrivesTable.getSelectedRowCount() > 0);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.insets = new Insets(0, 25, 0, 5);
        jPanel.add((Component)this.m_addButton, gridBagConstraints2);
        stringArray = Resource.getResourceMnemonic(Resource.getString("CCOH_ADD_ALL_BUTTON", "A(d)d All >>"));
        this.m_addAllButton.setText(stringArray[0]);
        if (stringArray.length == 2) {
            this.m_addAllButton.setMnemonic(stringArray[1].charAt(0));
        }
        this.m_addAllButton.setEnabled(this.m_addAllButtonEnabled);
        gridBagConstraints2.gridx = 2;
        gridBagConstraints2.insets = new Insets(0, 0, 0, 10);
        jPanel.add((Component)this.m_addAllButton, gridBagConstraints2);
        stringArray = Resource.getResourceMnemonic(Resource.getString("CCOH_REMOVE_ALL_BUTTON", "<< Re(m)ove All"));
        this.m_removeAllButton.setText(stringArray[0]);
        if (stringArray.length == 2) {
            this.m_removeAllButton.setMnemonic(stringArray[1].charAt(0));
        }
        gridBagConstraints2.gridx = 3;
        gridBagConstraints2.insets = new Insets(0, 0, 0, 5);
        jPanel.add((Component)this.m_removeAllButton, gridBagConstraints2);
        this.m_removeAllButton.setEnabled(false);
        stringArray = Resource.getResourceMnemonic(Resource.getString("CCOH_REMOVE_BUTTON", "< (R)emove"));
        this.m_removeButton.setText(stringArray[0]);
        if (stringArray.length == 2) {
            this.m_removeButton.setMnemonic(stringArray[1].charAt(0));
        }
        this.m_removeButton.setEnabled(false);
        gridBagConstraints2.gridx = 4;
        gridBagConstraints2.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)this.m_removeButton, gridBagConstraints2);
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.insets = new Insets(0, 15, 40, 0);
        this.add((Component)jPanel, gridBagConstraints);
        this.m_addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int[] nArray = CCOHCachedVirtualDrivesPanel.this.m_cachableVirtualDrivesTable.getSelectedRows();
                int n = nArray.length;
                ArrayList arrayList = new ArrayList();
                for (int i = 0; i < n; ++i) {
                    nArray[i] = CCOHCachedVirtualDrivesPanel.this.m_cachableVirtualDrivesTable.convertRowIndexToModel(nArray[i]);
                    arrayList.add(CCOHCachedVirtualDrivesPanel.this.m_cachableVirtualDrivesList.get(nArray[i]));
                }
                CCOHCachedVirtualDrivesPanel.this.m_cachedVirtualDrivesList.addAll(arrayList);
                CCOHCachedVirtualDrivesPanel.this.m_cachableVirtualDrivesList.removeAll(arrayList);
                CCOHCachedVirtualDrivesPanel.this.m_cachableVirtualDrivesTableModel.updateModel(CCOHCachedVirtualDrivesPanel.this.m_cachableVirtualDrivesList);
                CCOHCachedVirtualDrivesPanel.this.m_cachedVirtualDrivesTableModel.updateModel(CCOHCachedVirtualDrivesPanel.this.m_cachedVirtualDrivesList);
                CCOHCachedVirtualDrivesPanel.this.m_isChanged = true;
                CCOHCachedVirtualDrivesPanel.this.m_addButton.setEnabled(false);
                CCOHCachedVirtualDrivesPanel.this.m_addAllButton.setEnabled(CCOHCachedVirtualDrivesPanel.this.m_addAllButtonEnabled && CCOHCachedVirtualDrivesPanel.this.m_cachableVirtualDrivesList.size() > 0);
                CCOHCachedVirtualDrivesPanel.this.m_removeButton.setEnabled(false);
                CCOHCachedVirtualDrivesPanel.this.m_removeAllButton.setEnabled(true);
            }
        });
        this.m_addAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = CCOHCachedVirtualDrivesPanel.this.m_cachableVirtualDrivesList.size();
                for (int i = 0; i < n; ++i) {
                    CCOHCachedVirtualDrivesPanel.this.m_cachedVirtualDrivesList.add(CCOHCachedVirtualDrivesPanel.this.m_cachableVirtualDrivesList.get(i));
                }
                CCOHCachedVirtualDrivesPanel.this.m_cachableVirtualDrivesList.removeAll(CCOHCachedVirtualDrivesPanel.this.m_cachedVirtualDrivesList);
                CCOHCachedVirtualDrivesPanel.this.m_cachableVirtualDrivesTableModel.updateModel(CCOHCachedVirtualDrivesPanel.this.m_cachableVirtualDrivesList);
                CCOHCachedVirtualDrivesPanel.this.m_cachedVirtualDrivesTableModel.updateModel(CCOHCachedVirtualDrivesPanel.this.m_cachedVirtualDrivesList);
                CCOHCachedVirtualDrivesPanel.this.m_isChanged = true;
                CCOHCachedVirtualDrivesPanel.this.m_addButton.setEnabled(false);
                CCOHCachedVirtualDrivesPanel.this.m_addAllButton.setEnabled(false);
                CCOHCachedVirtualDrivesPanel.this.m_removeButton.setEnabled(false);
                CCOHCachedVirtualDrivesPanel.this.m_removeAllButton.setEnabled(true);
            }
        });
        this.m_removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int[] nArray = CCOHCachedVirtualDrivesPanel.this.m_cachedVirtualDrivesTable.getSelectedRows();
                int n = nArray.length;
                ArrayList arrayList = new ArrayList();
                for (int i = 0; i < n; ++i) {
                    nArray[i] = CCOHCachedVirtualDrivesPanel.this.m_cachedVirtualDrivesTable.convertRowIndexToModel(nArray[i]);
                    arrayList.add(CCOHCachedVirtualDrivesPanel.this.m_cachedVirtualDrivesList.get(nArray[i]));
                }
                CCOHCachedVirtualDrivesPanel.this.m_cachableVirtualDrivesList.addAll(arrayList);
                CCOHCachedVirtualDrivesPanel.this.m_cachedVirtualDrivesList.removeAll(arrayList);
                CCOHCachedVirtualDrivesPanel.this.m_cachableVirtualDrivesTableModel.updateModel(CCOHCachedVirtualDrivesPanel.this.m_cachableVirtualDrivesList);
                CCOHCachedVirtualDrivesPanel.this.m_cachedVirtualDrivesTableModel.updateModel(CCOHCachedVirtualDrivesPanel.this.m_cachedVirtualDrivesList);
                CCOHCachedVirtualDrivesPanel.this.m_addButton.setEnabled(false);
                CCOHCachedVirtualDrivesPanel.this.m_addAllButton.setEnabled(CCOHCachedVirtualDrivesPanel.this.m_addAllButtonEnabled);
                CCOHCachedVirtualDrivesPanel.this.m_removeButton.setEnabled(false);
                CCOHCachedVirtualDrivesPanel.this.m_removeAllButton.setEnabled(CCOHCachedVirtualDrivesPanel.this.m_cachedVirtualDrivesList.size() > 0);
            }
        });
        this.m_removeAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = CCOHCachedVirtualDrivesPanel.this.m_cachedVirtualDrivesList.size();
                for (int i = 0; i < n; ++i) {
                    CCOHCachedVirtualDrivesPanel.this.m_cachableVirtualDrivesList.add(CCOHCachedVirtualDrivesPanel.this.m_cachedVirtualDrivesList.get(i));
                }
                CCOHCachedVirtualDrivesPanel.this.m_cachedVirtualDrivesList.removeAll(CCOHCachedVirtualDrivesPanel.this.m_cachableVirtualDrivesList);
                CCOHCachedVirtualDrivesPanel.this.m_cachableVirtualDrivesTableModel.updateModel(CCOHCachedVirtualDrivesPanel.this.m_cachableVirtualDrivesList);
                CCOHCachedVirtualDrivesPanel.this.m_cachedVirtualDrivesTableModel.updateModel(CCOHCachedVirtualDrivesPanel.this.m_cachedVirtualDrivesList);
                CCOHCachedVirtualDrivesPanel.this.m_addButton.setEnabled(false);
                CCOHCachedVirtualDrivesPanel.this.m_addAllButton.setEnabled(CCOHCachedVirtualDrivesPanel.this.m_addAllButtonEnabled);
                CCOHCachedVirtualDrivesPanel.this.m_removeButton.setEnabled(false);
                CCOHCachedVirtualDrivesPanel.this.m_removeAllButton.setEnabled(false);
            }
        });
        this.m_cachedVirtualDrivesTable.clearSelection();
        if (this.m_cachableVirtualDrivesList.size() > 0) {
            this.m_cachableVirtualDrivesTable.setRowSelectionInterval(0, 0);
        }
    }

    @Override
    public String getHelpPage() {
        return HelpContextResourse.getHelpPageName("NYTRO_XD_SELECTING_THE_VIRTUAL_DRIVES");
    }

    public JButton getDefaultButton() {
        return null;
    }

    public byte getPageId() {
        return 3;
    }

    public boolean isChanged() {
        return this.m_isChanged;
    }

    private boolean canVDsBeAdded(int n) {
        return this.m_cachedVirtualDrivesList.size() + n <= this.m_MaxVirtualDrivesSupported;
    }

    public void reset() {
        this.m_cachedVirtualDrivesTable.clearSelection();
        if (this.m_cachableVirtualDrivesList.size() > 0) {
            this.m_cachableVirtualDrivesTable.setRowSelectionInterval(0, 0);
        }
    }

    class cachedVirtualDrivesTableListSelectionListener
    implements ListSelectionListener {
        cachedVirtualDrivesTableListSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            CCOHCachedVirtualDrivesPanel.this.m_addButton.setEnabled(false);
            CCOHCachedVirtualDrivesPanel.this.m_removeButton.setEnabled(CCOHCachedVirtualDrivesPanel.this.m_cachedVirtualDrivesTable.getSelectedRows().length > 0);
            CCOHCachedVirtualDrivesPanel.this.m_cachableVirtualDrivesTable.clearSelection();
        }
    }

    class cachableVirtualDrivesTableListSelectionListener
    implements ListSelectionListener {
        cachableVirtualDrivesTableListSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            int n = CCOHCachedVirtualDrivesPanel.this.m_cachableVirtualDrivesTable.getSelectedRows().length;
            CCOHCachedVirtualDrivesPanel.this.m_addButton.setEnabled(n > 0 && CCOHCachedVirtualDrivesPanel.this.canVDsBeAdded(n));
            CCOHCachedVirtualDrivesPanel.this.m_removeButton.setEnabled(false);
            CCOHCachedVirtualDrivesPanel.this.m_cachedVirtualDrivesTable.clearSelection();
        }
    }
}

