/*
 * Decompiled with CFR 0.152.
 */
package GUI.CCOH;

import GUIHelper.AdapterHelper;
import GUIHelper.CCOHVirtualAdapterHelper;
import GUIHelper.LogicalDriveHelper;
import GUIHelper.ServerObjectHelper;
import SASKernel.LibraryAPI.StoreLib.SL_CCOH_CG_LIMITS_T;
import SASKernel.LibraryAPI.StoreLib.SL_CCOH_CONFIG_T;
import SASKernel.LibraryAPI.StoreLib.SL_CCOH_DEV_LIST_T;
import SASKernel.LibraryAPI.StoreLib.SL_CCOH_DEV_T;
import SASKernel.VirtualAdapter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;

public class CCOHConfigurationEngine {
    public static final byte AUTOMATIC_MODE = 1;
    public static final byte MANUAL_MODE = 2;
    private CCOHVirtualAdapterHelper m_ccohVirtualAdapterHelper = null;
    private SL_CCOH_CONFIG_T m_CCOHConfig = null;
    private VirtualAdapter m_virtualAdapter = null;
    byte m_selectedmode = 1;
    byte m_previouslySelectedmode = 1;
    ArrayList<SL_CCOH_DEV_T> m_CacheDevsInSystem = new ArrayList();
    ArrayList<SL_CCOH_DEV_T> m_CacheDevsToBeAdded = new ArrayList();
    ArrayList<SL_CCOH_DEV_T> m_CacheDevsAdded = new ArrayList();
    ArrayList<AdapterHelper> m_HelpersForCacheDevsInSystem = new ArrayList();
    ArrayList<AdapterHelper> m_HelpersForCacheDevsToBeAdded = new ArrayList();
    ArrayList<AdapterHelper> m_HelpersForCacheDevsAdded = new ArrayList();
    ArrayList<SL_CCOH_DEV_T> m_VirtualDrivesInSystem = new ArrayList();
    ArrayList<SL_CCOH_DEV_T> m_VirtualDrivesToBeAdded = new ArrayList();
    ArrayList<SL_CCOH_DEV_T> m_VirtualDrivesAdded = new ArrayList();
    HashMap<AdapterHelper, SL_CCOH_DEV_T> m_adapHelprCacheDevMap = new HashMap();
    HashMap<SL_CCOH_DEV_T, AdapterHelper> m_cacheDevAdapHelprMap = new HashMap();

    public CCOHConfigurationEngine(CCOHVirtualAdapterHelper cCOHVirtualAdapterHelper, boolean bl, boolean bl2) {
        this.m_ccohVirtualAdapterHelper = cCOHVirtualAdapterHelper;
        this.m_virtualAdapter = (VirtualAdapter)this.m_ccohVirtualAdapterHelper.getDeviceObject();
        this.m_CCOHConfig = this.m_ccohVirtualAdapterHelper.getCCOHConfig();
        if (bl) {
            this.initialiseCacheDevicesInSystem();
            this.initialiseCDMapsAndHelpers();
        }
        if (bl2) {
            this.initialiseVirtualDrivesInSystem();
        }
    }

    public void initialiseCacheDevicesInSystem() {
        this.m_CacheDevsInSystem.clear();
        this.m_CacheDevsToBeAdded.clear();
        this.m_CacheDevsAdded.clear();
        SL_CCOH_DEV_LIST_T sL_CCOH_DEV_LIST_T = this.m_virtualAdapter.getCCOHCDs();
        SL_CCOH_DEV_T[] sL_CCOH_DEV_TArray = sL_CCOH_DEV_LIST_T.getDeviceList();
        for (int i = 0; i < sL_CCOH_DEV_TArray.length; ++i) {
            if (sL_CCOH_DEV_TArray[i].getDevState() == '\u0001') continue;
            this.m_CacheDevsInSystem.add(sL_CCOH_DEV_TArray[i]);
            if (sL_CCOH_DEV_TArray[i].isPartOfConfig()) {
                this.m_CacheDevsAdded.add(sL_CCOH_DEV_TArray[i]);
                continue;
            }
            this.m_CacheDevsToBeAdded.add(sL_CCOH_DEV_TArray[i]);
        }
    }

    public void initialiseVirtualDrivesInSystem() {
        this.m_VirtualDrivesInSystem.clear();
        this.m_VirtualDrivesToBeAdded.clear();
        this.m_VirtualDrivesAdded.clear();
        SL_CCOH_DEV_LIST_T sL_CCOH_DEV_LIST_T = this.m_virtualAdapter.getCCOHVDs();
        SL_CCOH_DEV_T[] sL_CCOH_DEV_TArray = sL_CCOH_DEV_LIST_T.getDeviceList();
        for (int i = 0; i < sL_CCOH_DEV_TArray.length; ++i) {
            if (sL_CCOH_DEV_TArray[i].getDevState() == '\u0001') continue;
            this.m_VirtualDrivesInSystem.add(sL_CCOH_DEV_TArray[i]);
            if (sL_CCOH_DEV_TArray[i].isPartOfConfig()) {
                this.m_VirtualDrivesAdded.add(sL_CCOH_DEV_TArray[i]);
                continue;
            }
            this.m_VirtualDrivesToBeAdded.add(sL_CCOH_DEV_TArray[i]);
        }
    }

    public void initialiseCDMapsAndHelpers() {
        this.m_adapHelprCacheDevMap.clear();
        this.m_cacheDevAdapHelprMap.clear();
        AdapterHelper[] adapterHelperArray = ((ServerObjectHelper)this.m_ccohVirtualAdapterHelper.getParent()).getAdapterHelpers();
        int n = this.m_CacheDevsInSystem.size();
        for (int i = 0; i < adapterHelperArray.length; ++i) {
            if (!adapterHelperArray[i].isWarhawk()) continue;
            for (int j = 0; j < n; ++j) {
                LogicalDriveHelper[] logicalDriveHelperArray = adapterHelperArray[i].getLogicalDrives();
                if (logicalDriveHelperArray == null || !this.m_CacheDevsInSystem.get(j).getDevIdText().toLowerCase().contains(logicalDriveHelperArray[0].getWWID().toLowerCase())) continue;
                this.m_adapHelprCacheDevMap.put(adapterHelperArray[i], this.m_CacheDevsInSystem.get(j));
                this.m_cacheDevAdapHelprMap.put(this.m_CacheDevsInSystem.get(j), adapterHelperArray[i]);
            }
        }
        this.m_HelpersForCacheDevsInSystem.clear();
        this.m_HelpersForCacheDevsInSystem.addAll(this.getHelpersForCDList(this.m_CacheDevsInSystem));
        this.m_HelpersForCacheDevsAdded.clear();
        this.m_HelpersForCacheDevsAdded.addAll(this.getHelpersForCDList(this.m_CacheDevsAdded));
        this.m_HelpersForCacheDevsToBeAdded.clear();
        this.m_HelpersForCacheDevsToBeAdded.addAll(this.getHelpersForCDList(this.m_CacheDevsToBeAdded));
    }

    public void clearAddedDevices() {
        this.m_HelpersForCacheDevsAdded.clear();
        this.m_CacheDevsAdded.clear();
        this.m_VirtualDrivesAdded.clear();
    }

    public void reinitDevicesToBeAdded() {
        this.m_HelpersForCacheDevsToBeAdded.clear();
        this.m_VirtualDrivesToBeAdded.clear();
        this.m_HelpersForCacheDevsToBeAdded.addAll(this.m_HelpersForCacheDevsInSystem);
        this.m_VirtualDrivesToBeAdded.addAll(this.m_VirtualDrivesInSystem);
    }

    public ArrayList<SL_CCOH_DEV_T> getSANVirtualDrives() {
        ArrayList<SL_CCOH_DEV_T> arrayList = new ArrayList<SL_CCOH_DEV_T>();
        int n = this.m_VirtualDrivesInSystem.size();
        for (int i = 0; i < n; ++i) {
            if (this.m_VirtualDrivesInSystem.get(i).getDevTopology() != '\u0000') continue;
            arrayList.add(this.m_VirtualDrivesInSystem.get(i));
        }
        return arrayList;
    }

    public ArrayList<SL_CCOH_DEV_T> getDASVirtualDrives() {
        ArrayList<SL_CCOH_DEV_T> arrayList = new ArrayList<SL_CCOH_DEV_T>();
        int n = this.m_VirtualDrivesInSystem.size();
        for (int i = 0; i < n; ++i) {
            if (this.m_VirtualDrivesInSystem.get(i).getDevTopology() != '\u0001') continue;
            arrayList.add(this.m_VirtualDrivesInSystem.get(i));
        }
        return arrayList;
    }

    public SL_CCOH_DEV_T[] getFinalArrOfCDsToBeAdded() {
        SL_CCOH_DEV_T[] sL_CCOH_DEV_TArray = null;
        int n = this.m_CacheDevsAdded.size();
        if (this.m_CCOHConfig == null) {
            if (n == 0) {
                return null;
            }
            sL_CCOH_DEV_TArray = new SL_CCOH_DEV_T[n];
            for (int i = 0; i < n; ++i) {
                sL_CCOH_DEV_TArray[i] = this.m_CacheDevsAdded.get(i);
            }
        } else {
            int n2;
            ArrayList<SL_CCOH_DEV_T> arrayList = new ArrayList<SL_CCOH_DEV_T>();
            SL_CCOH_DEV_T sL_CCOH_DEV_T = null;
            for (n2 = 0; n2 < n; ++n2) {
                sL_CCOH_DEV_T = this.m_CacheDevsAdded.get(n2);
                if (sL_CCOH_DEV_T.isPartOfConfig()) continue;
                arrayList.add(sL_CCOH_DEV_T);
            }
            n2 = arrayList.size();
            if (n2 == 0) {
                return null;
            }
            sL_CCOH_DEV_TArray = new SL_CCOH_DEV_T[n2];
            for (int i = 0; i < n2; ++i) {
                sL_CCOH_DEV_TArray[i] = (SL_CCOH_DEV_T)arrayList.get(i);
            }
        }
        return sL_CCOH_DEV_TArray;
    }

    public SL_CCOH_DEV_T[] getFinalArrOfVDsToBeAdded() {
        SL_CCOH_DEV_T[] sL_CCOH_DEV_TArray = null;
        int n = this.m_VirtualDrivesAdded.size();
        if (this.m_CCOHConfig == null) {
            if (n == 0) {
                return null;
            }
            sL_CCOH_DEV_TArray = new SL_CCOH_DEV_T[n];
            for (int i = 0; i < n; ++i) {
                sL_CCOH_DEV_TArray[i] = this.m_VirtualDrivesAdded.get(i);
            }
        } else {
            int n2;
            ArrayList<SL_CCOH_DEV_T> arrayList = new ArrayList<SL_CCOH_DEV_T>();
            SL_CCOH_DEV_T sL_CCOH_DEV_T = null;
            for (n2 = 0; n2 < n; ++n2) {
                sL_CCOH_DEV_T = this.m_VirtualDrivesAdded.get(n2);
                if (sL_CCOH_DEV_T.isPartOfConfig()) continue;
                arrayList.add(sL_CCOH_DEV_T);
            }
            n2 = arrayList.size();
            if (n2 == 0) {
                return null;
            }
            sL_CCOH_DEV_TArray = new SL_CCOH_DEV_T[n2];
            for (int i = 0; i < n2; ++i) {
                sL_CCOH_DEV_TArray[i] = (SL_CCOH_DEV_T)arrayList.get(i);
            }
        }
        return sL_CCOH_DEV_TArray;
    }

    public SL_CCOH_DEV_T[] getFinalArrOfCDsToBeRemoved() {
        int n;
        SL_CCOH_DEV_T[] sL_CCOH_DEV_TArray = null;
        ArrayList<SL_CCOH_DEV_T> arrayList = new ArrayList<SL_CCOH_DEV_T>();
        SL_CCOH_DEV_T sL_CCOH_DEV_T = null;
        int n2 = this.m_CacheDevsToBeAdded.size();
        for (n = 0; n < n2; ++n) {
            sL_CCOH_DEV_T = this.m_CacheDevsToBeAdded.get(n);
            if (!sL_CCOH_DEV_T.isPartOfConfig()) continue;
            arrayList.add(sL_CCOH_DEV_T);
        }
        n = arrayList.size();
        if (n == 0) {
            return null;
        }
        sL_CCOH_DEV_TArray = new SL_CCOH_DEV_T[n];
        for (int i = 0; i < n; ++i) {
            sL_CCOH_DEV_TArray[i] = (SL_CCOH_DEV_T)arrayList.get(i);
        }
        return sL_CCOH_DEV_TArray;
    }

    public SL_CCOH_DEV_T[] getFinalArrOfVDsToBeRemoved() {
        int n;
        SL_CCOH_DEV_T[] sL_CCOH_DEV_TArray = null;
        ArrayList<SL_CCOH_DEV_T> arrayList = new ArrayList<SL_CCOH_DEV_T>();
        SL_CCOH_DEV_T sL_CCOH_DEV_T = null;
        int n2 = this.m_VirtualDrivesToBeAdded.size();
        for (n = 0; n < n2; ++n) {
            sL_CCOH_DEV_T = this.m_VirtualDrivesToBeAdded.get(n);
            if (!sL_CCOH_DEV_T.isPartOfConfig()) continue;
            arrayList.add(sL_CCOH_DEV_T);
        }
        n = arrayList.size();
        if (n == 0) {
            return null;
        }
        sL_CCOH_DEV_TArray = new SL_CCOH_DEV_T[n];
        for (int i = 0; i < n; ++i) {
            sL_CCOH_DEV_TArray[i] = (SL_CCOH_DEV_T)arrayList.get(i);
        }
        return sL_CCOH_DEV_TArray;
    }

    public byte getSelectedmode() {
        return this.m_selectedmode;
    }

    public void setSelectedmode(byte by) {
        this.m_previouslySelectedmode = this.m_selectedmode;
        this.m_selectedmode = by;
    }

    public byte getpreviouslySelectedmode() {
        return this.m_previouslySelectedmode;
    }

    public void setpreviouslySelectedmode(byte by) {
        this.m_previouslySelectedmode = by;
    }

    public ArrayList<SL_CCOH_DEV_T> getCacheDevsInSystem() {
        return this.m_CacheDevsInSystem;
    }

    public void setCacheDevsInSystem(ArrayList<SL_CCOH_DEV_T> arrayList) {
        this.m_CacheDevsInSystem = arrayList;
    }

    public ArrayList<AdapterHelper> getHelpersForCacheDevsInSystem() {
        return this.m_HelpersForCacheDevsInSystem;
    }

    public void setHelpersForCacheDevsInSystem(ArrayList<AdapterHelper> arrayList) {
        this.m_HelpersForCacheDevsInSystem = arrayList;
    }

    public ArrayList<AdapterHelper> getHelpersForCacheDevsToBeAdded() {
        return this.m_HelpersForCacheDevsToBeAdded;
    }

    public void setHelpersForCacheDevsToBeAdded(ArrayList<AdapterHelper> arrayList) {
        this.m_HelpersForCacheDevsToBeAdded = arrayList;
    }

    public ArrayList<AdapterHelper> getHelpersForCacheDevsAdded() {
        return this.m_HelpersForCacheDevsAdded;
    }

    public void setHelpersForCacheDevsAdded(ArrayList<AdapterHelper> arrayList) {
        this.m_HelpersForCacheDevsAdded = arrayList;
    }

    public ArrayList<SL_CCOH_DEV_T> getCacheDevsAdded() {
        return this.m_CacheDevsAdded;
    }

    public void setCacheDevsAdded(ArrayList<SL_CCOH_DEV_T> arrayList) {
        this.m_CacheDevsAdded = arrayList;
    }

    public ArrayList<SL_CCOH_DEV_T> getCacheDevsToBeAdded() {
        return this.m_CacheDevsToBeAdded;
    }

    public void setCacheDevsToBeAdded(ArrayList<SL_CCOH_DEV_T> arrayList) {
        this.m_CacheDevsToBeAdded = arrayList;
    }

    public ArrayList<SL_CCOH_DEV_T> getVirtualDrivesInSystem() {
        return this.m_VirtualDrivesInSystem;
    }

    public void setVirtualDrivesInSystem(ArrayList<SL_CCOH_DEV_T> arrayList) {
        this.m_VirtualDrivesInSystem = arrayList;
    }

    public ArrayList<SL_CCOH_DEV_T> getVirtualDrivesToBeAdded() {
        return this.m_VirtualDrivesToBeAdded;
    }

    public void setVirtualDrivesToBeAdded(ArrayList<SL_CCOH_DEV_T> arrayList) {
        this.m_VirtualDrivesToBeAdded = arrayList;
    }

    public ArrayList<SL_CCOH_DEV_T> getVirtualDrivesAdded() {
        return this.m_VirtualDrivesAdded;
    }

    public void setVirtualDrivesAdded(ArrayList<SL_CCOH_DEV_T> arrayList) {
        this.m_VirtualDrivesAdded = arrayList;
    }

    public long getTotalCapacity(ArrayList<SL_CCOH_DEV_T> arrayList) {
        long l = 0L;
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            l += arrayList.get(i).getCapacity();
        }
        return l;
    }

    public ArrayList<SL_CCOH_DEV_T> getCDListForHelpers(ArrayList<AdapterHelper> arrayList) {
        ArrayList<SL_CCOH_DEV_T> arrayList2 = new ArrayList<SL_CCOH_DEV_T>();
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            arrayList2.add(this.m_adapHelprCacheDevMap.get(arrayList.get(i)));
        }
        return arrayList2;
    }

    public ArrayList<AdapterHelper> getHelpersForCDList(ArrayList<SL_CCOH_DEV_T> arrayList) {
        ArrayList<AdapterHelper> arrayList2 = new ArrayList<AdapterHelper>();
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            arrayList2.add(this.m_cacheDevAdapHelprMap.get(arrayList.get(i)));
        }
        return arrayList2;
    }

    public String getHelperCDText(AdapterHelper adapterHelper) {
        SL_CCOH_DEV_T sL_CCOH_DEV_T = this.m_adapHelprCacheDevMap.get(adapterHelper);
        return adapterHelper.getText() + ", " + sL_CCOH_DEV_T.getCapacityText() + ", " + sL_CCOH_DEV_T.getDevStateText();
    }

    public void initCCOHEngineForAutomaticMode(byte by) {
        SL_CCOH_CG_LIMITS_T sL_CCOH_CG_LIMITS_T = this.m_ccohVirtualAdapterHelper.getCacheGroupLimits();
        if (this.m_CacheDevsAdded.size() == 0) {
            this.m_CacheDevsAdded.clear();
            this.initCDsAutomatic(sL_CCOH_CG_LIMITS_T);
            this.m_HelpersForCacheDevsAdded.clear();
            this.m_HelpersForCacheDevsAdded.addAll(this.getHelpersForCDList(this.m_CacheDevsAdded));
        }
        this.m_VirtualDrivesAdded.clear();
        this.initVDsAutomatic(sL_CCOH_CG_LIMITS_T, by);
    }

    public void initVDsAutomatic(SL_CCOH_CG_LIMITS_T sL_CCOH_CG_LIMITS_T, byte by) {
        int n = sL_CCOH_CG_LIMITS_T.getMaxVirtualDrivesSupported();
        ArrayList<Object> arrayList = new ArrayList();
        if (by == 0) {
            return;
        }
        if (by == 1) {
            arrayList = this.m_VirtualDrivesInSystem;
        } else if (by == 2) {
            arrayList = this.getDASVirtualDrives();
        } else if (by == 3) {
            arrayList = this.getSANVirtualDrives();
        }
        int n2 = arrayList.size();
        if (n2 <= n) {
            this.m_VirtualDrivesAdded.addAll(arrayList);
        } else {
            for (int i = 0; i < n; ++i) {
                this.m_VirtualDrivesAdded.add((SL_CCOH_DEV_T)arrayList.get(i));
            }
        }
    }

    private ArrayList<SL_CCOH_DEV_T> getNonForeignCDList() {
        ArrayList<SL_CCOH_DEV_T> arrayList = new ArrayList<SL_CCOH_DEV_T>();
        int n = this.m_CacheDevsInSystem.size();
        SL_CCOH_DEV_T sL_CCOH_DEV_T = null;
        for (int i = 0; i < n; ++i) {
            sL_CCOH_DEV_T = this.m_CacheDevsInSystem.get(i);
            if (sL_CCOH_DEV_T.getDevContent().isForeign()) continue;
            arrayList.add(sL_CCOH_DEV_T);
        }
        return arrayList;
    }

    public void initCDsAutomatic(SL_CCOH_CG_LIMITS_T sL_CCOH_CG_LIMITS_T) {
        ArrayList<SL_CCOH_DEV_T> arrayList = this.getNonForeignCDList();
        int n = arrayList.size();
        for (int i = 0; i < n - 1; ++i) {
            for (int j = 0; j < n - 1 - i; ++j) {
                if (arrayList.get(j).getDevContent().getPriorityValue() <= arrayList.get(j + 1).getDevContent().getPriorityValue()) continue;
                Collections.swap(arrayList, j, j + 1);
            }
        }
        long l = sL_CCOH_CG_LIMITS_T.getMaxCacheCapacitySupported();
        int n2 = sL_CCOH_CG_LIMITS_T.getMaxCacheDevicesSupported();
        long l2 = 0L;
        int n3 = 0;
        SL_CCOH_DEV_T sL_CCOH_DEV_T = null;
        for (int i = 0; i < n && l2 < l && n3 < n2; l2 += sL_CCOH_DEV_T.getCapacity(), ++n3, ++i) {
            sL_CCOH_DEV_T = arrayList.get(i);
            this.m_CacheDevsAdded.add(sL_CCOH_DEV_T);
        }
    }

    public boolean isAutomaticConfigAllowed() {
        return this.getNonForeignCDList().size() > 0;
    }
}

