/*
 * Decompiled with CFR 0.152.
 */
package GUI.CCOH;

import GUI.VivaldiBaseDialog;
import KernelExceptions.VKOperationFailedException;
import SASKernel.LibraryAPI.StoreLib.SL_CCOH_DEV_T;
import SASKernel.VirtualAdapter;
import Utils.CustomMsgBox;
import Utils.GUIUtils;
import Utils.Resource;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;

public class CCOHMakeVDsOnlineDialog
extends VivaldiBaseDialog {
    private JTable m_readyForOnlineVDsTable = new JTable();
    private ReadyForOnlineVDsTableModel m_readyForOnlineVDsTableModel = null;
    private JCheckBox m_checkAll = new JCheckBox();
    private ArrayList<SL_CCOH_DEV_T> m_readyForOnlineVDsList = new ArrayList();
    private VirtualAdapter m_virtualAdapter = null;
    private String m_title = "";
    private String m_description = "";
    private String m_okButton = "";
    private String m_cancelButton = "";

    public CCOHMakeVDsOnlineDialog(VirtualAdapter virtualAdapter, ArrayList<SL_CCOH_DEV_T> arrayList) {
        this.m_virtualAdapter = virtualAdapter;
        this.m_readyForOnlineVDsList = arrayList;
        this.buildPanel();
    }

    public void buildPanel() {
        String[] stringArray = null;
        this.m_title = Resource.getString("MAKE_CACHED_VDS_ONLINE_TITLE", "Make Cached Virtual Drives Online");
        this.m_description = Resource.getString("MAKE_CACHED_VDS_ONLINE_DESC", "<html>Select from the list of cached virtual drives in Ready For Online state that you would like<br>to make online.</html>");
        this.m_okButton = Resource.getString("BUTTON_LABEL_OK", "OK");
        this.m_cancelButton = Resource.getString("BUTTON_LABEL_CANCEL", "Cancel");
        this.setTitle(this.m_title);
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 11;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 5, 25, 5);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 6;
        jPanel.add((Component)new JLabel(this.m_description), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        this.m_readyForOnlineVDsTableModel = new ReadyForOnlineVDsTableModel(this.m_readyForOnlineVDsList);
        this.m_readyForOnlineVDsTableModel.addTableModelListener(new ReadyForOnlineVDsTableModelListener());
        this.m_readyForOnlineVDsTable = new JTable(this.m_readyForOnlineVDsTableModel);
        this.m_readyForOnlineVDsTable.setCellSelectionEnabled(false);
        this.m_readyForOnlineVDsTable.setColumnSelectionAllowed(false);
        this.m_readyForOnlineVDsTable.setRowSelectionAllowed(true);
        this.m_readyForOnlineVDsTable.setSelectionMode(0);
        this.m_readyForOnlineVDsTable.getTableHeader().setReorderingAllowed(false);
        this.m_readyForOnlineVDsTable.getTableHeader().setResizingAllowed(true);
        this.m_readyForOnlineVDsTable.setAutoResizeMode(0);
        TableColumn tableColumn = this.m_readyForOnlineVDsTable.getColumnModel().getColumn(0);
        tableColumn.setPreferredWidth(60);
        tableColumn = this.m_readyForOnlineVDsTable.getColumnModel().getColumn(1);
        tableColumn.setPreferredWidth(this.getPreferredSize().width - 54);
        JScrollPane jScrollPane = new JScrollPane(this.m_readyForOnlineVDsTable, 20, 30);
        jScrollPane.setPreferredSize(new Dimension(this.getPreferredSize().width, 200));
        jPanel.add((Component)jScrollPane, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        stringArray = Resource.getResourceMnemonic(Resource.getString("VIRTUAL_DRIVES_PANEL_CACHED_VDS", "(C)ached virtual drives:"));
        JLabel jLabel = new JLabel(stringArray[0]);
        if (stringArray.length == 2) {
            jLabel.setDisplayedMnemonic(stringArray[1].charAt(0));
            jLabel.setLabelFor(this.m_readyForOnlineVDsTable);
        }
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(0, 5, 15, 5);
        stringArray = Resource.getResourceMnemonic(Resource.getString("CHECK_BOX_TEXT_ALL", "(A)ll"));
        this.m_checkAll.setText(stringArray[0]);
        if (stringArray.length == 2) {
            this.m_checkAll.setMnemonic(stringArray[1].charAt(0));
        }
        this.m_checkAll.setSelected(this.m_readyForOnlineVDsTableModel.getSelectedRowCount() == this.m_readyForOnlineVDsList.size());
        this.m_checkAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = CCOHMakeVDsOnlineDialog.this.m_readyForOnlineVDsTableModel.getRowCount();
                if (CCOHMakeVDsOnlineDialog.this.m_checkAll.isSelected()) {
                    for (int i = 0; i < n; ++i) {
                        CCOHMakeVDsOnlineDialog.this.m_readyForOnlineVDsTableModel.setValueAt(true, i, 0);
                    }
                    CCOHMakeVDsOnlineDialog.this.m_checkAll.setSelected(true);
                } else if (!CCOHMakeVDsOnlineDialog.this.m_checkAll.isSelected()) {
                    for (int i = 0; i < n; ++i) {
                        CCOHMakeVDsOnlineDialog.this.m_readyForOnlineVDsTableModel.setValueAt(false, i, 0);
                    }
                    CCOHMakeVDsOnlineDialog.this.m_checkAll.setSelected(false);
                }
            }
        });
        jPanel.add((Component)this.m_checkAll, gridBagConstraints);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        JPanel jPanel3 = new JPanel(new GridLayout(1, 2));
        stringArray = Resource.getResourceMnemonic(this.m_okButton);
        JButton jButton = new JButton(stringArray[0]);
        if (stringArray.length == 2) {
            jButton.setMnemonic(stringArray[1].charAt(0));
        }
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CCOHMakeVDsOnlineDialog.this.performEnterAction();
            }
        });
        jPanel3.add(jButton);
        stringArray = Resource.getResourceMnemonic(this.m_cancelButton);
        JButton jButton2 = new JButton(stringArray[0]);
        if (stringArray.length == 2) {
            jButton2.setMnemonic(stringArray[1].charAt(0));
        }
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CCOHMakeVDsOnlineDialog.this.dispose();
            }
        });
        jPanel3.add(jButton2);
        jPanel2.add((Component)jPanel3, "Center");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 0;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        this.getContentPane().add((Component)jPanel, "South");
        this.setResizable(false);
        this.setModal(true);
        this.pack();
        this.getRootPane().setDefaultButton(jButton);
        jButton.requestFocusInWindow();
        GUIUtils.centerDialogOnScreen(this);
        this.setVisible(true);
    }

    @Override
    protected void performEnterAction() {
        this.dispose();
        ArrayList<SL_CCOH_DEV_T> arrayList = this.m_readyForOnlineVDsTableModel.getSelectedVDs();
        int n = arrayList.size();
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                try {
                    this.m_virtualAdapter.makeVDOnline(arrayList.get(i));
                    continue;
                }
                catch (VKOperationFailedException vKOperationFailedException) {
                    CustomMsgBox.errorMsg(vKOperationFailedException);
                }
            }
        }
    }

    class ReadyForOnlineVDsTableModel
    extends AbstractTableModel {
        private ArrayList<SL_CCOH_DEV_T> l_readyForOnlineVDsList = null;
        private boolean[] l_selectedRows = null;

        public ReadyForOnlineVDsTableModel(ArrayList<SL_CCOH_DEV_T> arrayList) {
            this.l_readyForOnlineVDsList = arrayList;
            int n = this.l_readyForOnlineVDsList.size();
            this.l_selectedRows = new boolean[n];
            for (int i = 0; i < n; ++i) {
                this.l_selectedRows[i] = true;
            }
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return this.l_readyForOnlineVDsList.size();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            Object object = null;
            if (n2 == 0) {
                object = new Boolean(this.l_selectedRows[n]);
            }
            if (n2 == 1) {
                object = this.l_readyForOnlineVDsList.get(n).getText();
            }
            return object;
        }

        @Override
        public Class<?> getColumnClass(int n) {
            if (n == 0) {
                return Boolean.class;
            }
            return super.getColumnClass(n);
        }

        @Override
        public String getColumnName(int n) {
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 == 0;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (n2 == 0) {
                this.l_selectedRows[n] = (Boolean)object;
                this.fireTableCellUpdated(n, n2);
            }
        }

        public int getSelectedRowCount() {
            int n = 0;
            int n2 = this.l_selectedRows.length;
            for (int i = 0; i < n2; ++i) {
                if (!this.l_selectedRows[i]) continue;
                ++n;
            }
            return n;
        }

        public ArrayList<SL_CCOH_DEV_T> getSelectedVDs() {
            ArrayList<SL_CCOH_DEV_T> arrayList = new ArrayList<SL_CCOH_DEV_T>();
            int n = this.l_selectedRows.length;
            for (int i = 0; i < n; ++i) {
                if (!this.l_selectedRows[i]) continue;
                arrayList.add(this.l_readyForOnlineVDsList.get(i));
            }
            return arrayList;
        }
    }

    class ReadyForOnlineVDsTableModelListener
    implements TableModelListener {
        ReadyForOnlineVDsTableModelListener() {
        }

        @Override
        public void tableChanged(TableModelEvent tableModelEvent) {
            if (CCOHMakeVDsOnlineDialog.this.m_readyForOnlineVDsTableModel.getSelectedRowCount() == CCOHMakeVDsOnlineDialog.this.m_readyForOnlineVDsTableModel.getRowCount()) {
                CCOHMakeVDsOnlineDialog.this.m_checkAll.setSelected(true);
            } else {
                CCOHMakeVDsOnlineDialog.this.m_checkAll.setSelected(false);
            }
        }
    }
}

