/*
 * Decompiled with CFR 0.152.
 */
package GUI.CCOH;

import GUI.CCOH.CCOHCacheDevicesTableModel;
import GUI.CCOH.CCOHConfigurationEngine;
import GUI.CCOH.CCOHTableRenderer;
import GUI.DefaultNoOptionDialog;
import GUI.VivaldiBaseDialog;
import GUIHelper.AdapterHelper;
import GUIHelper.CCOHVirtualAdapterHelper;
import KernelExceptions.VKOperationFailedException;
import SASKernel.LibraryAPI.StoreLib.Constants.SL_CCOH_DEV_CONTENT;
import SASKernel.LibraryAPI.StoreLib.SL_CCOH_CG_LIMITS_T;
import SASKernel.LibraryAPI.StoreLib.SL_CCOH_DEV_T;
import SASKernel.VirtualAdapter;
import Services.KernelConstants;
import Utils.CustomMsgBox;
import Utils.GUIUtils;
import Utils.HelpContext;
import Utils.HelpContextResourse;
import Utils.Resource;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class CCOHManageCacheDevicesDialog
extends VivaldiBaseDialog {
    private JButton m_btnSave = null;
    private JButton m_btnCancel = null;
    private JButton m_btnHelp = null;
    private JPanel m_navigationPanel = null;
    private JPanel m_CacheGroupPanel = null;
    private VirtualAdapter m_virtualAdapter = null;
    private boolean m_isChanged = false;
    private CCOHCacheDevicesTableModel m_cacheDevicesTableModel = null;
    private CCOHCacheDevicesTableModel m_cacheGroupTableModel = null;
    private JTable m_cacheDevicesTable = new JTable();
    private JTable m_cacheGroupTable = new JTable();
    private ArrayList<AdapterHelper> m_cacheDevicesList = null;
    private ArrayList<AdapterHelper> m_cacheGroupList = null;
    private JButton m_addButton = new JButton();
    private JButton m_removeButton = new JButton();
    private JLabel m_totalcachedeviceslabel = new JLabel();
    private JLabel m_totalcgcapacitylabel = new JLabel();
    private JLabel m_maxallowedcapacitylabel = new JLabel();
    private int m_MaxCacheDevicesSupported = 0;
    private long m_MaxCacheCapacitySupported = 0L;
    private int m_totalcachedevices = 0;
    private long m_totalcgcapacity = 0L;
    private CCOHConfigurationEngine m_ccohConfigEngine = null;

    public CCOHManageCacheDevicesDialog(CCOHVirtualAdapterHelper cCOHVirtualAdapterHelper) {
        this.m_virtualAdapter = (VirtualAdapter)cCOHVirtualAdapterHelper.getDeviceObject();
        this.m_ccohConfigEngine = new CCOHConfigurationEngine(cCOHVirtualAdapterHelper, true, false);
        this.m_ccohConfigEngine.setSelectedmode((byte)2);
        this.m_cacheDevicesList = this.m_ccohConfigEngine.getHelpersForCacheDevsToBeAdded();
        this.m_cacheGroupList = this.m_ccohConfigEngine.getHelpersForCacheDevsAdded();
        SL_CCOH_CG_LIMITS_T sL_CCOH_CG_LIMITS_T = cCOHVirtualAdapterHelper.getCacheGroupLimits();
        this.m_MaxCacheCapacitySupported = sL_CCOH_CG_LIMITS_T.getMaxCacheCapacitySupported();
        this.m_MaxCacheDevicesSupported = sL_CCOH_CG_LIMITS_T.getMaxCacheDevicesSupported();
        this.initialise();
    }

    public CCOHManageCacheDevicesDialog(CCOHVirtualAdapterHelper cCOHVirtualAdapterHelper, CCOHConfigurationEngine cCOHConfigurationEngine) {
        this.m_virtualAdapter = (VirtualAdapter)cCOHVirtualAdapterHelper.getDeviceObject();
        this.m_ccohConfigEngine = cCOHConfigurationEngine;
        this.m_ccohConfigEngine.setSelectedmode((byte)2);
        this.m_cacheDevicesList = this.m_ccohConfigEngine.getHelpersForCacheDevsToBeAdded();
        this.m_cacheGroupList = this.m_ccohConfigEngine.getHelpersForCacheDevsAdded();
        SL_CCOH_CG_LIMITS_T sL_CCOH_CG_LIMITS_T = cCOHVirtualAdapterHelper.getCacheGroupLimits();
        this.m_MaxCacheCapacitySupported = sL_CCOH_CG_LIMITS_T.getMaxCacheCapacitySupported();
        this.m_MaxCacheDevicesSupported = sL_CCOH_CG_LIMITS_T.getMaxCacheDevicesSupported();
        this.initialise();
    }

    public void initialise() {
        this.initialiseCacheGroupPanel();
        this.contentPane.add((Component)this.m_CacheGroupPanel, "Center");
        this.initialiseNavigationPanel();
        this.contentPane.add((Component)this.m_navigationPanel, "South");
        this.setTitle(Resource.getString("MANAGE_CACHE_DEVICES", "Manage Cache Devices"));
        this.setResizable(false);
        this.setModal(true);
        this.getRootPane().setDefaultButton(this.m_btnSave);
        this.pack();
        GUIUtils.centerDialogOnScreen(this);
        this.setVisible(true);
    }

    private void initialiseCacheGroupPanel() {
        this.updateCGdata();
        this.m_CacheGroupPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 21;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.insets = new Insets(10, 15, 20, 15);
        this.m_CacheGroupPanel.add((Component)new JLabel(Resource.getString("CACHE_GROUP_PANEL_MSG", "Select the cache devices to include in the cache group.")), gridBagConstraints);
        String[] stringArray = null;
        stringArray = Resource.getResourceMnemonic(Resource.getString("CACHE_GROUP_PANEL_CACHE_DEVICES", "(C)ache devices:"));
        JLabel jLabel = new JLabel(stringArray[0]);
        if (stringArray.length == 2) {
            jLabel.setDisplayedMnemonic(stringArray[1].charAt(0));
        }
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 15, 0, 0);
        this.m_CacheGroupPanel.add((Component)jLabel, gridBagConstraints);
        stringArray = Resource.getResourceMnemonic(Resource.getString("CACHE_GROUP_PANEL_CACHE_GROUP", "Cache gr(o)up:"));
        JLabel jLabel2 = new JLabel(stringArray[0]);
        if (stringArray.length == 2) {
            jLabel2.setDisplayedMnemonic(stringArray[1].charAt(0));
        }
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.m_CacheGroupPanel.add((Component)jLabel2, gridBagConstraints);
        this.m_cacheDevicesTableModel = new CCOHCacheDevicesTableModel(this.m_cacheDevicesList);
        if (this.m_cacheDevicesTableModel != null) {
            this.m_cacheDevicesTable.setModel(this.m_cacheDevicesTableModel);
        }
        this.m_cacheDevicesTable.setShowGrid(false);
        this.m_cacheDevicesTable.setCellSelectionEnabled(false);
        this.m_cacheDevicesTable.setRowSelectionAllowed(true);
        this.m_cacheDevicesTable.setColumnSelectionAllowed(false);
        this.m_cacheDevicesTable.setSelectionMode(2);
        this.m_cacheDevicesTable.setAutoResizeMode(0);
        this.m_cacheDevicesTable.setAutoCreateRowSorter(true);
        this.m_cacheDevicesTable.getTableHeader().setResizingAllowed(true);
        this.m_cacheDevicesTable.getColumnModel().getColumn(0).setPreferredWidth(298);
        this.m_cacheDevicesTable.setAutoscrolls(true);
        this.m_cacheDevicesTable.getTableHeader().setReorderingAllowed(false);
        this.m_cacheDevicesTable.changeSelection(0, 0, true, false);
        CCOHTableRenderer cCOHTableRenderer = new CCOHTableRenderer(this.m_ccohConfigEngine);
        this.m_cacheDevicesTable.setDefaultRenderer(AdapterHelper.class, cCOHTableRenderer);
        this.m_cacheDevicesTable.getSelectionModel().addListSelectionListener(new cacheDevicesTableListSelectionListener());
        jLabel.setLabelFor(this.m_cacheDevicesTable);
        JScrollPane jScrollPane = new JScrollPane(this.m_cacheDevicesTable, 20, 30);
        jScrollPane.setPreferredSize(new Dimension(300, 125));
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.insets = new Insets(0, 15, 5, 10);
        this.m_CacheGroupPanel.add((Component)jScrollPane, gridBagConstraints);
        this.m_cacheGroupTableModel = new CCOHCacheDevicesTableModel(this.m_cacheGroupList);
        if (this.m_cacheGroupTableModel != null) {
            this.m_cacheGroupTable.setModel(this.m_cacheGroupTableModel);
        }
        this.m_cacheGroupTable.setShowGrid(false);
        this.m_cacheGroupTable.setCellSelectionEnabled(false);
        this.m_cacheGroupTable.setRowSelectionAllowed(true);
        this.m_cacheGroupTable.setColumnSelectionAllowed(false);
        this.m_cacheGroupTable.setSelectionMode(2);
        this.m_cacheGroupTable.setAutoResizeMode(0);
        this.m_cacheGroupTable.setAutoCreateRowSorter(true);
        this.m_cacheGroupTable.getTableHeader().setResizingAllowed(true);
        this.m_cacheGroupTable.getColumnModel().getColumn(0).setPreferredWidth(298);
        this.m_cacheGroupTable.setAutoscrolls(true);
        this.m_cacheGroupTable.getTableHeader().setReorderingAllowed(false);
        this.m_cacheGroupTable.changeSelection(0, 0, true, false);
        this.m_cacheGroupTable.setDefaultRenderer(AdapterHelper.class, cCOHTableRenderer);
        this.m_cacheGroupTable.getSelectionModel().addListSelectionListener(new cacheGroupTableListSelectionListener());
        jLabel2.setLabelFor(this.m_cacheGroupTable);
        JScrollPane jScrollPane2 = new JScrollPane(this.m_cacheGroupTable, 20, 30);
        jScrollPane2.setPreferredSize(new Dimension(300, 125));
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridx = 3;
        gridBagConstraints.insets = new Insets(0, 0, 5, 15);
        this.m_CacheGroupPanel.add((Component)jScrollPane2, gridBagConstraints);
        gridBagConstraints.anchor = 10;
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        stringArray = Resource.getResourceMnemonic(Resource.getString("CCOH_ADD_BUTTON", "(A)dd >"));
        this.m_addButton.setText(stringArray[0]);
        if (stringArray.length == 2) {
            this.m_addButton.setMnemonic(stringArray[1].charAt(0));
        }
        this.m_addButton.setEnabled(this.m_cacheDevicesTable.getSelectedRowCount() > 0);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints2.gridx = 2;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.insets = new Insets(0, 25, 0, 10);
        jPanel.add((Component)this.m_addButton, gridBagConstraints2);
        stringArray = Resource.getResourceMnemonic(Resource.getString("CCOH_REMOVE_BUTTON", "< (R)emove"));
        this.m_removeButton.setText(stringArray[0]);
        if (stringArray.length == 2) {
            this.m_removeButton.setMnemonic(stringArray[1].charAt(0));
        }
        this.m_removeButton.setEnabled(false);
        gridBagConstraints2.gridx = 3;
        gridBagConstraints2.insets = new Insets(0, 0, 0, 20);
        jPanel.add((Component)this.m_removeButton, gridBagConstraints2);
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.insets = new Insets(0, 15, 10, 0);
        this.m_CacheGroupPanel.add((Component)jPanel, gridBagConstraints);
        gridBagConstraints.anchor = 21;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridx = 3;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.m_CacheGroupPanel.add((Component)new JLabel(Resource.getString("CACHE_GROUP_PANEL_TOTAL_CACHE_DEVICES", "Total cache devices:")), gridBagConstraints);
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridx = 4;
        gridBagConstraints.insets = new Insets(0, 0, 0, 15);
        this.m_totalcachedeviceslabel.setText(" " + this.m_totalcachedevices);
        this.m_CacheGroupPanel.add((Component)this.m_totalcachedeviceslabel, gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridx = 3;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.m_CacheGroupPanel.add((Component)new JLabel(Resource.getString("CACHE_GROUP_PANEL_MSG_TOTAL_CG_CAPACITY", "Total cache group capacity:")), gridBagConstraints);
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridx = 4;
        gridBagConstraints.insets = new Insets(0, 0, 0, 15);
        this.m_totalcgcapacitylabel.setText(" " + KernelConstants.getConvertedSize(this.m_totalcgcapacity));
        this.m_CacheGroupPanel.add((Component)this.m_totalcgcapacitylabel, gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridx = 3;
        gridBagConstraints.insets = new Insets(0, 0, 10, 0);
        this.m_CacheGroupPanel.add((Component)new JLabel(Resource.getString("CACHE_GROUP_PANEL_MAX_ALLOWED_CAPACITY", "Maximum allowed capacity:")), gridBagConstraints);
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridx = 4;
        gridBagConstraints.insets = new Insets(0, 0, 10, 15);
        this.m_maxallowedcapacitylabel.setText(" " + KernelConstants.getConvertedSize(this.m_MaxCacheCapacitySupported));
        this.m_CacheGroupPanel.add((Component)this.m_maxallowedcapacitylabel, gridBagConstraints);
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.insets = new Insets(0, 15, 20, 15);
        this.m_CacheGroupPanel.add((Component)new JLabel(Resource.getString("PREVIEW_PANEL_MSG2", "Important Note: Any data that currently resides on the listed cache devices will be permanently deleted."), this.getImageIcon(Resource.getString("NEEDS_ATTENTION_ICON", "NeedAtten.png")), 2), gridBagConstraints);
        this.m_addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int[] nArray = CCOHManageCacheDevicesDialog.this.m_cacheDevicesTable.getSelectedRows();
                int n = nArray.length;
                ArrayList arrayList = new ArrayList();
                for (int i = 0; i < n; ++i) {
                    nArray[i] = CCOHManageCacheDevicesDialog.this.m_cacheDevicesTable.convertRowIndexToModel(nArray[i]);
                    arrayList.add(CCOHManageCacheDevicesDialog.this.m_cacheDevicesList.get(nArray[i]));
                }
                if (CCOHManageCacheDevicesDialog.this.checkAndShowMaxCapExcdedDlg(arrayList) && CCOHManageCacheDevicesDialog.this.checkAndShowFileSystemDlg(arrayList)) {
                    CCOHManageCacheDevicesDialog.this.m_cacheGroupList.addAll(arrayList);
                    CCOHManageCacheDevicesDialog.this.m_cacheDevicesList.removeAll(arrayList);
                    CCOHManageCacheDevicesDialog.this.m_cacheDevicesTableModel.updateModel(CCOHManageCacheDevicesDialog.this.m_cacheDevicesList);
                    CCOHManageCacheDevicesDialog.this.m_cacheGroupTableModel.updateModel(CCOHManageCacheDevicesDialog.this.m_cacheGroupList);
                    CCOHManageCacheDevicesDialog.this.m_addButton.setEnabled(false);
                    CCOHManageCacheDevicesDialog.this.m_removeButton.setEnabled(false);
                    CCOHManageCacheDevicesDialog.this.m_ccohConfigEngine.setCacheDevsAdded(CCOHManageCacheDevicesDialog.this.m_ccohConfigEngine.getCDListForHelpers(CCOHManageCacheDevicesDialog.this.m_cacheGroupList));
                    CCOHManageCacheDevicesDialog.this.m_ccohConfigEngine.setCacheDevsToBeAdded(CCOHManageCacheDevicesDialog.this.m_ccohConfigEngine.getCDListForHelpers(CCOHManageCacheDevicesDialog.this.m_cacheDevicesList));
                    CCOHManageCacheDevicesDialog.this.updateCGdata();
                    CCOHManageCacheDevicesDialog.this.updateCapacityLabels();
                    CCOHManageCacheDevicesDialog.this.m_isChanged = true;
                }
            }
        });
        this.m_removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int[] nArray = CCOHManageCacheDevicesDialog.this.m_cacheGroupTable.getSelectedRows();
                int n = nArray.length;
                ArrayList arrayList = new ArrayList();
                for (int i = 0; i < n; ++i) {
                    nArray[i] = CCOHManageCacheDevicesDialog.this.m_cacheGroupTable.convertRowIndexToModel(nArray[i]);
                    arrayList.add(CCOHManageCacheDevicesDialog.this.m_cacheGroupList.get(nArray[i]));
                }
                CCOHManageCacheDevicesDialog.this.m_cacheDevicesList.addAll(arrayList);
                CCOHManageCacheDevicesDialog.this.m_cacheGroupList.removeAll(arrayList);
                CCOHManageCacheDevicesDialog.this.m_cacheDevicesTableModel.updateModel(CCOHManageCacheDevicesDialog.this.m_cacheDevicesList);
                CCOHManageCacheDevicesDialog.this.m_cacheGroupTableModel.updateModel(CCOHManageCacheDevicesDialog.this.m_cacheGroupList);
                CCOHManageCacheDevicesDialog.this.m_removeButton.setEnabled(false);
                CCOHManageCacheDevicesDialog.this.m_addButton.setEnabled(false);
                CCOHManageCacheDevicesDialog.this.m_ccohConfigEngine.setCacheDevsAdded(CCOHManageCacheDevicesDialog.this.m_ccohConfigEngine.getCDListForHelpers(CCOHManageCacheDevicesDialog.this.m_cacheGroupList));
                CCOHManageCacheDevicesDialog.this.m_ccohConfigEngine.setCacheDevsToBeAdded(CCOHManageCacheDevicesDialog.this.m_ccohConfigEngine.getCDListForHelpers(CCOHManageCacheDevicesDialog.this.m_cacheDevicesList));
                CCOHManageCacheDevicesDialog.this.updateCGdata();
                CCOHManageCacheDevicesDialog.this.updateCapacityLabels();
                CCOHManageCacheDevicesDialog.this.m_isChanged = true;
            }
        });
        this.m_cacheGroupTable.clearSelection();
        if (this.m_cacheDevicesList.size() > 0) {
            this.m_cacheDevicesTable.setRowSelectionInterval(0, 0);
        }
    }

    public void initialiseNavigationPanel() {
        String[] stringArray = null;
        this.m_navigationPanel = new JPanel(new FlowLayout(2));
        stringArray = Resource.getResourceMnemonic(Resource.getString("MENU_HELP_TEXT", "(H)elp"));
        this.m_btnHelp = new JButton(stringArray[0]);
        if (stringArray.length == 2) {
            this.m_btnHelp.setMnemonic(stringArray[1].charAt(0));
        }
        this.m_btnCancel = new JButton(Resource.getString("BUTTON_CANCEL_TEXT", "Cancel"));
        stringArray = Resource.getResourceMnemonic(Resource.getString("BUTTON_SAVE_TEXT", "(S)ave"));
        this.m_btnSave = new JButton(stringArray[0]);
        if (stringArray.length == 2) {
            this.m_btnSave.setMnemonic(stringArray[1].charAt(0));
        }
        this.m_navigationPanel.add(this.m_btnHelp);
        this.m_navigationPanel.add(this.m_btnCancel);
        this.m_navigationPanel.add(this.m_btnSave);
        this.m_btnSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (CCOHManageCacheDevicesDialog.this.m_cacheGroupList.size() != 0 || CCOHManageCacheDevicesDialog.this.m_cacheGroupList.size() == 0 && CCOHManageCacheDevicesDialog.this.deleteCacheGroupDialog()) {
                    int n;
                    CCOHManageCacheDevicesDialog.this.dispose();
                    SL_CCOH_DEV_T[] sL_CCOH_DEV_TArray = null;
                    int n2 = 0;
                    if (CCOHManageCacheDevicesDialog.this.m_cacheGroupList.size() == 0) {
                        sL_CCOH_DEV_TArray = CCOHManageCacheDevicesDialog.this.m_virtualAdapter.getCCOHConfig().getVirtualDriveList().getDeviceList();
                        if (sL_CCOH_DEV_TArray != null) {
                            n2 = sL_CCOH_DEV_TArray.length;
                            for (n = 0; n < n2; ++n) {
                                try {
                                    CCOHManageCacheDevicesDialog.this.m_virtualAdapter.removeVDfromCG(sL_CCOH_DEV_TArray[n]);
                                    continue;
                                }
                                catch (VKOperationFailedException vKOperationFailedException) {
                                    CustomMsgBox.errorMsg(vKOperationFailedException);
                                    System.out.println("CCOHManageCacheDevicesDialog -> Failed to remove a VD, so removal of all the CDs failed.");
                                    return;
                                }
                            }
                        }
                    } else {
                        sL_CCOH_DEV_TArray = CCOHManageCacheDevicesDialog.this.m_ccohConfigEngine.getFinalArrOfCDsToBeAdded();
                        if (sL_CCOH_DEV_TArray != null) {
                            n2 = sL_CCOH_DEV_TArray.length;
                            for (n = 0; n < n2; ++n) {
                                try {
                                    CCOHManageCacheDevicesDialog.this.m_virtualAdapter.addCDtoCG(sL_CCOH_DEV_TArray[n]);
                                    continue;
                                }
                                catch (VKOperationFailedException vKOperationFailedException) {
                                    CustomMsgBox.errorMsg(vKOperationFailedException);
                                }
                            }
                        }
                    }
                    if ((sL_CCOH_DEV_TArray = CCOHManageCacheDevicesDialog.this.m_ccohConfigEngine.getFinalArrOfCDsToBeRemoved()) != null) {
                        n2 = sL_CCOH_DEV_TArray.length;
                        for (n = 0; n < n2; ++n) {
                            try {
                                CCOHManageCacheDevicesDialog.this.m_virtualAdapter.removeCDfromCG(sL_CCOH_DEV_TArray[n]);
                                continue;
                            }
                            catch (VKOperationFailedException vKOperationFailedException) {
                                CustomMsgBox.errorMsg(vKOperationFailedException);
                            }
                        }
                    }
                }
            }
        });
        this.m_btnHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HelpContext.executeHelpProcess(CCOHManageCacheDevicesDialog.this.getHelpPage());
            }
        });
        this.m_btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (CCOHManageCacheDevicesDialog.this.m_isChanged) {
                    if (CCOHManageCacheDevicesDialog.this.warningDialog()) {
                        CCOHManageCacheDevicesDialog.this.dispose();
                    }
                } else {
                    CCOHManageCacheDevicesDialog.this.dispose();
                }
            }
        });
    }

    @Override
    public String getHelpPage() {
        return HelpContextResourse.getHelpPageName("NYTRO_XD_MANAGING_THE_CACHE_DEVICES");
    }

    private boolean checkAndShowMaxCapExcdedDlg(ArrayList<AdapterHelper> arrayList) {
        long l = this.m_totalcgcapacity + this.m_ccohConfigEngine.getTotalCapacity(this.m_ccohConfigEngine.getCDListForHelpers(arrayList));
        if (l <= this.m_MaxCacheCapacitySupported) {
            return true;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(Resource.getString("CACHE_GROUP_PANEL_WARNING_MSG1", "<html>The cache group's maximum allowed capacity is") + " ");
        stringBuffer.append(KernelConstants.getConvertedSize(this.m_MaxCacheCapacitySupported));
        stringBuffer.append(Resource.getString("CACHE_GROUP_PANEL_WARNING_MSG2", "<br>and your cache group is now") + " ");
        stringBuffer.append(KernelConstants.getConvertedSize(l));
        stringBuffer.append(Resource.getString("CACHE_GROUP_PANEL_WARNING_MSG3", ". The capacity in<br>excess of the maximum allowed capacity will not be used.<br><br>Are you sure you want to exceed the maximum capacity?<br><br></html>"));
        DefaultNoOptionDialog defaultNoOptionDialog = new DefaultNoOptionDialog(Resource.getString("CACHE_GROUP_PANEL_WARNING_TITLE1", "Maximum Capacity Exceeded"), stringBuffer.toString(), 2);
        return defaultNoOptionDialog.getOptionPaneValue();
    }

    private boolean checkAndShowFileSystemDlg(ArrayList<AdapterHelper> arrayList) {
        ArrayList<SL_CCOH_DEV_T> arrayList2 = this.m_ccohConfigEngine.getCDListForHelpers(arrayList);
        int n = arrayList2.size();
        boolean bl = false;
        boolean bl2 = false;
        SL_CCOH_DEV_T sL_CCOH_DEV_T = null;
        SL_CCOH_DEV_CONTENT sL_CCOH_DEV_CONTENT = null;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<html>");
        for (int i = 0; i < n; ++i) {
            bl2 = false;
            sL_CCOH_DEV_T = arrayList2.get(i);
            sL_CCOH_DEV_CONTENT = sL_CCOH_DEV_T.getDevContent();
            if (sL_CCOH_DEV_T.getDevState() == '\u0001' || sL_CCOH_DEV_CONTENT.isNoContentDetected()) continue;
            bl = true;
            stringBuffer.append(this.m_ccohConfigEngine.getHelperCDText(arrayList.get(i)));
            stringBuffer.append("<br>");
            stringBuffer.append("Contains: ");
            if (sL_CCOH_DEV_CONTENT.isForeign()) {
                if (bl2) {
                    stringBuffer.append(", ");
                } else {
                    bl2 = true;
                }
                stringBuffer.append("<b>");
                stringBuffer.append(Resource.getString("CCOH_DEV_FOREIGN", "Foreign configuration"));
                stringBuffer.append("</b>");
            }
            if (sL_CCOH_DEV_CONTENT.isMbr()) {
                if (bl2) {
                    stringBuffer.append(", ");
                } else {
                    bl2 = true;
                }
                stringBuffer.append(Resource.getString("CCOH_DEV_MBR", "Boot data"));
            }
            if (sL_CCOH_DEV_CONTENT.isSwap()) {
                if (bl2) {
                    stringBuffer.append(", ");
                } else {
                    bl2 = true;
                }
                stringBuffer.append(Resource.getString("CCOH_DEV_SWAP", "Swap data"));
            }
            if (sL_CCOH_DEV_CONTENT.isLvm2Member()) {
                if (bl2) {
                    stringBuffer.append(", ");
                } else {
                    bl2 = true;
                }
                stringBuffer.append(Resource.getString("CCOH_DEV_LVM2_MEMBER", "LVM2 member"));
            }
            if (sL_CCOH_DEV_CONTENT.isFileSystem()) {
                if (bl2) {
                    stringBuffer.append(", ");
                } else {
                    bl2 = true;
                }
                stringBuffer.append(Resource.getString("CCOH_DEV_FILE_SYSTEM", "File system"));
            }
            if (sL_CCOH_DEV_CONTENT.isContentUnknown()) {
                if (bl2) {
                    stringBuffer.append(", ");
                } else {
                    bl2 = true;
                }
                stringBuffer.append(Resource.getString("CCOH_DEV_UNKNOWN", "Unknown data"));
            }
            stringBuffer.append("<br><br>");
        }
        if (bl) {
            stringBuffer.append(Resource.getString("CACHE_GROUP_PANEL_WARNING_MSG4", "All data on the selected cache device(s) will be permanently deleted.<br><br>Are you sure you want to permanently delete all the data on the<br>selected cache device(s)?<br><br></html>"));
            DefaultNoOptionDialog defaultNoOptionDialog = new DefaultNoOptionDialog(Resource.getString("CACHE_GROUP_PANEL_WARNING_TITLE2", "Data Detected"), stringBuffer.toString(), 2);
            return defaultNoOptionDialog.getOptionPaneValue();
        }
        return true;
    }

    private ImageIcon getImageIcon(String string) {
        try {
            return new ImageIcon(Toolkit.getDefaultToolkit().getImage(ClassLoader.getSystemResource(string)));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public boolean deleteCacheGroupDialog() {
        DefaultNoOptionDialog defaultNoOptionDialog = new DefaultNoOptionDialog(Resource.getString("MANAGE_CACHE_DEVICES_WARNING_TITLE", "Confirm Delete Cache Group"), Resource.getString("MANAGE_CACHE_DEVICES_WARNING_MSG"), 2);
        return defaultNoOptionDialog.getOptionPaneValue();
    }

    @Override
    protected boolean warningDialog() {
        if (this.m_isChanged) {
            DefaultNoOptionDialog defaultNoOptionDialog = new DefaultNoOptionDialog(Resource.getString("CCOH_CONFIRMATION", "Confirmation"), Resource.getString("CONFIG_CANCEL_MSG"), 3);
            return defaultNoOptionDialog.getOptionPaneValue();
        }
        return true;
    }

    private void updateCGdata() {
        this.m_totalcachedevices = this.m_cacheGroupList.size();
        this.m_totalcgcapacity = this.m_ccohConfigEngine.getTotalCapacity(this.m_ccohConfigEngine.getCacheDevsAdded());
    }

    private void updateCapacityLabels() {
        this.m_totalcachedeviceslabel.setText(" " + this.m_totalcachedevices);
        this.m_totalcgcapacitylabel.setText(" " + KernelConstants.getConvertedSize(this.m_totalcgcapacity));
    }

    private boolean canCDsBeAdded(int n) {
        return this.m_totalcgcapacity < this.m_MaxCacheCapacitySupported && this.m_totalcachedevices + n <= this.m_MaxCacheDevicesSupported;
    }

    class cacheGroupTableListSelectionListener
    implements ListSelectionListener {
        cacheGroupTableListSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            CCOHManageCacheDevicesDialog.this.m_addButton.setEnabled(false);
            CCOHManageCacheDevicesDialog.this.m_removeButton.setEnabled(CCOHManageCacheDevicesDialog.this.m_cacheGroupTable.getSelectedRows().length > 0);
            CCOHManageCacheDevicesDialog.this.m_cacheDevicesTable.clearSelection();
        }
    }

    class cacheDevicesTableListSelectionListener
    implements ListSelectionListener {
        cacheDevicesTableListSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            int n = CCOHManageCacheDevicesDialog.this.m_cacheDevicesTable.getSelectedRows().length;
            CCOHManageCacheDevicesDialog.this.m_addButton.setEnabled(n > 0 && CCOHManageCacheDevicesDialog.this.canCDsBeAdded(n));
            CCOHManageCacheDevicesDialog.this.m_removeButton.setEnabled(false);
            CCOHManageCacheDevicesDialog.this.m_cacheGroupTable.clearSelection();
        }
    }
}

