/*
 * Decompiled with CFR 0.152.
 */
package GUI.CCOH;

import GUI.CCOH.CCOHConfigurationEngine;
import GUI.CCOH.CCOHTableRenderer;
import GUI.CCOH.CCOHVirtualDrivesTableModel;
import GUI.DefaultNoOptionDialog;
import GUI.VivaldiBaseDialog;
import GUIHelper.CCOHVirtualAdapterHelper;
import KernelExceptions.VKOperationFailedException;
import SASKernel.LibraryAPI.StoreLib.SL_CCOH_CG_LIMITS_T;
import SASKernel.LibraryAPI.StoreLib.SL_CCOH_DEV_T;
import SASKernel.VirtualAdapter;
import Utils.CustomMsgBox;
import Utils.GUIUtils;
import Utils.HelpContext;
import Utils.HelpContextResourse;
import Utils.Resource;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class CCOHManageVirtualDrivesDialog
extends VivaldiBaseDialog {
    private JButton m_btnSave = null;
    private JButton m_btnCancel = null;
    private JButton m_btnHelp = null;
    private JPanel m_navigationPanel = null;
    private JPanel m_VirtualDrivesPanel = null;
    private VirtualAdapter m_virtualAdapter = null;
    private boolean m_isChanged = false;
    private CCOHVirtualDrivesTableModel m_cachableVirtualDrivesTableModel = null;
    private CCOHVirtualDrivesTableModel m_cachedVirtualDrivesTableModel = null;
    private JTable m_cachableVirtualDrivesTable = new JTable();
    private JTable m_cachedVirtualDrivesTable = new JTable();
    private ArrayList<SL_CCOH_DEV_T> m_cachableVirtualDrivesList = null;
    private ArrayList<SL_CCOH_DEV_T> m_cachedVirtualDrivesList = null;
    private JButton m_addButton = new JButton();
    private JButton m_addAllButton = new JButton();
    private JButton m_removeButton = new JButton();
    private JButton m_removeAllButton = new JButton();
    private CCOHConfigurationEngine m_ccohConfigEngine = null;
    private int m_MaxVirtualDrivesSupported = 0;
    private boolean m_addAllButtonEnabled = false;

    public CCOHManageVirtualDrivesDialog(CCOHVirtualAdapterHelper cCOHVirtualAdapterHelper) {
        this.m_virtualAdapter = (VirtualAdapter)cCOHVirtualAdapterHelper.getDeviceObject();
        this.m_ccohConfigEngine = new CCOHConfigurationEngine(cCOHVirtualAdapterHelper, false, true);
        this.m_ccohConfigEngine.setSelectedmode((byte)2);
        this.m_cachableVirtualDrivesList = this.m_ccohConfigEngine.getVirtualDrivesToBeAdded();
        this.m_cachedVirtualDrivesList = this.m_ccohConfigEngine.getVirtualDrivesAdded();
        SL_CCOH_CG_LIMITS_T sL_CCOH_CG_LIMITS_T = cCOHVirtualAdapterHelper.getCacheGroupLimits();
        this.m_MaxVirtualDrivesSupported = sL_CCOH_CG_LIMITS_T.getMaxVirtualDrivesSupported();
        this.m_addAllButtonEnabled = this.m_ccohConfigEngine.getVirtualDrivesInSystem().size() <= this.m_MaxVirtualDrivesSupported;
        this.initialise();
    }

    public void initialise() {
        this.initialiseVirtualDrivesPanel();
        this.contentPane.add((Component)this.m_VirtualDrivesPanel, "Center");
        this.initialiseNavigationPanel();
        this.contentPane.add((Component)this.m_navigationPanel, "South");
        this.setTitle(Resource.getString("MANAGE_CACHED_VIRTUAL_DRIVES", "Manage Cached Virtual Drives"));
        this.setResizable(false);
        this.setModal(true);
        this.getRootPane().setDefaultButton(this.m_btnSave);
        this.pack();
        GUIUtils.centerDialogOnScreen(this);
        this.setVisible(true);
    }

    private void initialiseVirtualDrivesPanel() {
        this.m_VirtualDrivesPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 21;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.insets = new Insets(10, 15, 20, 15);
        this.m_VirtualDrivesPanel.add((Component)new JLabel(Resource.getString("MANAGE_CACHED_VIRTUAL_DRIVES_MSG1", "Add or remove cached virtual drives.")), gridBagConstraints);
        String[] stringArray = null;
        stringArray = Resource.getResourceMnemonic(Resource.getString("VIRTUAL_DRIVES_PANEL_VDS", "(V)irtual drives:"));
        JLabel jLabel = new JLabel(stringArray[0]);
        if (stringArray.length == 2) {
            jLabel.setDisplayedMnemonic(stringArray[1].charAt(0));
        }
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 15, 0, 0);
        this.m_VirtualDrivesPanel.add((Component)jLabel, gridBagConstraints);
        stringArray = Resource.getResourceMnemonic(Resource.getString("VIRTUAL_DRIVES_PANEL_CACHED_VDS", "(C)ached virtual drives:"));
        JLabel jLabel2 = new JLabel(stringArray[0]);
        if (stringArray.length == 2) {
            jLabel2.setDisplayedMnemonic(stringArray[1].charAt(0));
        }
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.m_VirtualDrivesPanel.add((Component)jLabel2, gridBagConstraints);
        this.m_cachableVirtualDrivesTableModel = new CCOHVirtualDrivesTableModel(this.m_cachableVirtualDrivesList);
        if (this.m_cachableVirtualDrivesTableModel != null) {
            this.m_cachableVirtualDrivesTable.setModel(this.m_cachableVirtualDrivesTableModel);
        }
        this.m_cachableVirtualDrivesTable.setShowGrid(false);
        this.m_cachableVirtualDrivesTable.setCellSelectionEnabled(false);
        this.m_cachableVirtualDrivesTable.setRowSelectionAllowed(true);
        this.m_cachableVirtualDrivesTable.setColumnSelectionAllowed(false);
        this.m_cachableVirtualDrivesTable.setSelectionMode(2);
        this.m_cachableVirtualDrivesTable.setAutoResizeMode(0);
        this.m_cachableVirtualDrivesTable.setAutoCreateRowSorter(true);
        this.m_cachableVirtualDrivesTable.getTableHeader().setResizingAllowed(true);
        this.m_cachableVirtualDrivesTable.getColumnModel().getColumn(0).setPreferredWidth(298);
        this.m_cachableVirtualDrivesTable.setAutoscrolls(true);
        this.m_cachableVirtualDrivesTable.getTableHeader().setReorderingAllowed(false);
        this.m_cachableVirtualDrivesTable.changeSelection(0, 0, true, false);
        CCOHTableRenderer cCOHTableRenderer = new CCOHTableRenderer(this.m_ccohConfigEngine);
        this.m_cachableVirtualDrivesTable.setDefaultRenderer(SL_CCOH_DEV_T.class, cCOHTableRenderer);
        this.m_cachableVirtualDrivesTable.getSelectionModel().addListSelectionListener(new cachableVirtualDrivesTableListSelectionListener());
        jLabel.setLabelFor(this.m_cachableVirtualDrivesTable);
        JScrollPane jScrollPane = new JScrollPane(this.m_cachableVirtualDrivesTable, 20, 30);
        jScrollPane.setPreferredSize(new Dimension(300, 125));
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.insets = new Insets(0, 15, 5, 10);
        this.m_VirtualDrivesPanel.add((Component)jScrollPane, gridBagConstraints);
        this.m_cachedVirtualDrivesTableModel = new CCOHVirtualDrivesTableModel(this.m_cachedVirtualDrivesList);
        if (this.m_cachedVirtualDrivesTableModel != null) {
            this.m_cachedVirtualDrivesTable.setModel(this.m_cachedVirtualDrivesTableModel);
        }
        this.m_cachedVirtualDrivesTable.setShowGrid(false);
        this.m_cachedVirtualDrivesTable.setCellSelectionEnabled(false);
        this.m_cachedVirtualDrivesTable.setRowSelectionAllowed(true);
        this.m_cachedVirtualDrivesTable.setColumnSelectionAllowed(false);
        this.m_cachedVirtualDrivesTable.setSelectionMode(2);
        this.m_cachedVirtualDrivesTable.setAutoResizeMode(0);
        this.m_cachedVirtualDrivesTable.setAutoCreateRowSorter(true);
        this.m_cachedVirtualDrivesTable.getTableHeader().setResizingAllowed(true);
        this.m_cachedVirtualDrivesTable.getColumnModel().getColumn(0).setPreferredWidth(298);
        this.m_cachedVirtualDrivesTable.setAutoscrolls(true);
        this.m_cachedVirtualDrivesTable.getTableHeader().setReorderingAllowed(false);
        this.m_cachedVirtualDrivesTable.changeSelection(0, 0, true, false);
        this.m_cachedVirtualDrivesTable.setDefaultRenderer(SL_CCOH_DEV_T.class, cCOHTableRenderer);
        this.m_cachedVirtualDrivesTable.getSelectionModel().addListSelectionListener(new cachedVirtualDrivesTableListSelectionListener());
        jLabel2.setLabelFor(this.m_cachedVirtualDrivesTable);
        JScrollPane jScrollPane2 = new JScrollPane(this.m_cachedVirtualDrivesTable, 20, 30);
        jScrollPane2.setPreferredSize(new Dimension(300, 125));
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridx = 3;
        gridBagConstraints.insets = new Insets(0, 0, 5, 15);
        this.m_VirtualDrivesPanel.add((Component)jScrollPane2, gridBagConstraints);
        gridBagConstraints.anchor = 10;
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        stringArray = Resource.getResourceMnemonic(Resource.getString("CCOH_ADD_BUTTON", "(A)dd >"));
        this.m_addButton.setText(stringArray[0]);
        if (stringArray.length == 2) {
            this.m_addButton.setMnemonic(stringArray[1].charAt(0));
        }
        this.m_addButton.setEnabled(this.m_cachableVirtualDrivesTable.getSelectedRowCount() > 0);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.insets = new Insets(0, 25, 0, 5);
        jPanel.add((Component)this.m_addButton, gridBagConstraints2);
        stringArray = Resource.getResourceMnemonic(Resource.getString("CCOH_ADD_ALL_BUTTON", "A(d)d All >>"));
        this.m_addAllButton.setText(stringArray[0]);
        if (stringArray.length == 2) {
            this.m_addAllButton.setMnemonic(stringArray[1].charAt(0));
        }
        this.m_addAllButton.setEnabled(this.m_addAllButtonEnabled && this.m_cachableVirtualDrivesList.size() > 0);
        gridBagConstraints2.gridx = 2;
        gridBagConstraints2.insets = new Insets(0, 0, 0, 10);
        jPanel.add((Component)this.m_addAllButton, gridBagConstraints2);
        stringArray = Resource.getResourceMnemonic(Resource.getString("CCOH_REMOVE_ALL_BUTTON", "<< Re(m)ove All"));
        this.m_removeAllButton.setText(stringArray[0]);
        if (stringArray.length == 2) {
            this.m_removeAllButton.setMnemonic(stringArray[1].charAt(0));
        }
        this.m_removeAllButton.setEnabled(this.m_cachedVirtualDrivesList.size() > 0);
        gridBagConstraints2.gridx = 3;
        gridBagConstraints2.insets = new Insets(0, 0, 0, 5);
        jPanel.add((Component)this.m_removeAllButton, gridBagConstraints2);
        stringArray = Resource.getResourceMnemonic(Resource.getString("CCOH_REMOVE_BUTTON", "< (R)emove"));
        this.m_removeButton.setText(stringArray[0]);
        if (stringArray.length == 2) {
            this.m_removeButton.setMnemonic(stringArray[1].charAt(0));
        }
        this.m_removeButton.setEnabled(false);
        gridBagConstraints2.gridx = 4;
        gridBagConstraints2.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)this.m_removeButton, gridBagConstraints2);
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.insets = new Insets(0, 15, 20, 0);
        this.m_VirtualDrivesPanel.add((Component)jPanel, gridBagConstraints);
        gridBagConstraints.anchor = 21;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.insets = new Insets(0, 15, 20, 15);
        this.m_VirtualDrivesPanel.add((Component)new JLabel(Resource.getString("MANAGE_CACHED_VIRTUAL_DRIVES_MSG2", "<html>Note: In the future, virtual drives will not be automatically cached. You will need to return to this dialog<br>to add any new virtual drives.</html>")), gridBagConstraints);
        this.m_addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int[] nArray = CCOHManageVirtualDrivesDialog.this.m_cachableVirtualDrivesTable.getSelectedRows();
                int n = nArray.length;
                ArrayList arrayList = new ArrayList();
                for (int i = 0; i < n; ++i) {
                    nArray[i] = CCOHManageVirtualDrivesDialog.this.m_cachableVirtualDrivesTable.convertRowIndexToModel(nArray[i]);
                    arrayList.add(CCOHManageVirtualDrivesDialog.this.m_cachableVirtualDrivesList.get(nArray[i]));
                }
                CCOHManageVirtualDrivesDialog.this.m_cachedVirtualDrivesList.addAll(arrayList);
                CCOHManageVirtualDrivesDialog.this.m_cachableVirtualDrivesList.removeAll(arrayList);
                CCOHManageVirtualDrivesDialog.this.m_cachableVirtualDrivesTableModel.updateModel(CCOHManageVirtualDrivesDialog.this.m_cachableVirtualDrivesList);
                CCOHManageVirtualDrivesDialog.this.m_cachedVirtualDrivesTableModel.updateModel(CCOHManageVirtualDrivesDialog.this.m_cachedVirtualDrivesList);
                CCOHManageVirtualDrivesDialog.this.m_addButton.setEnabled(false);
                CCOHManageVirtualDrivesDialog.this.m_addAllButton.setEnabled(CCOHManageVirtualDrivesDialog.this.m_addAllButtonEnabled && CCOHManageVirtualDrivesDialog.this.m_cachableVirtualDrivesList.size() > 0);
                CCOHManageVirtualDrivesDialog.this.m_removeButton.setEnabled(false);
                CCOHManageVirtualDrivesDialog.this.m_removeAllButton.setEnabled(true);
                CCOHManageVirtualDrivesDialog.this.m_isChanged = true;
            }
        });
        this.m_addAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = CCOHManageVirtualDrivesDialog.this.m_cachableVirtualDrivesList.size();
                for (int i = 0; i < n; ++i) {
                    CCOHManageVirtualDrivesDialog.this.m_cachedVirtualDrivesList.add(CCOHManageVirtualDrivesDialog.this.m_cachableVirtualDrivesList.get(i));
                }
                CCOHManageVirtualDrivesDialog.this.m_cachableVirtualDrivesList.removeAll(CCOHManageVirtualDrivesDialog.this.m_cachedVirtualDrivesList);
                CCOHManageVirtualDrivesDialog.this.m_cachableVirtualDrivesTableModel.updateModel(CCOHManageVirtualDrivesDialog.this.m_cachableVirtualDrivesList);
                CCOHManageVirtualDrivesDialog.this.m_cachedVirtualDrivesTableModel.updateModel(CCOHManageVirtualDrivesDialog.this.m_cachedVirtualDrivesList);
                CCOHManageVirtualDrivesDialog.this.m_addButton.setEnabled(false);
                CCOHManageVirtualDrivesDialog.this.m_addAllButton.setEnabled(false);
                CCOHManageVirtualDrivesDialog.this.m_removeButton.setEnabled(false);
                CCOHManageVirtualDrivesDialog.this.m_removeAllButton.setEnabled(true);
                CCOHManageVirtualDrivesDialog.this.m_isChanged = true;
            }
        });
        this.m_removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int[] nArray = CCOHManageVirtualDrivesDialog.this.m_cachedVirtualDrivesTable.getSelectedRows();
                int n = nArray.length;
                ArrayList arrayList = new ArrayList();
                for (int i = 0; i < n; ++i) {
                    nArray[i] = CCOHManageVirtualDrivesDialog.this.m_cachedVirtualDrivesTable.convertRowIndexToModel(nArray[i]);
                    arrayList.add(CCOHManageVirtualDrivesDialog.this.m_cachedVirtualDrivesList.get(nArray[i]));
                }
                CCOHManageVirtualDrivesDialog.this.m_cachableVirtualDrivesList.addAll(arrayList);
                CCOHManageVirtualDrivesDialog.this.m_cachedVirtualDrivesList.removeAll(arrayList);
                CCOHManageVirtualDrivesDialog.this.m_cachableVirtualDrivesTableModel.updateModel(CCOHManageVirtualDrivesDialog.this.m_cachableVirtualDrivesList);
                CCOHManageVirtualDrivesDialog.this.m_cachedVirtualDrivesTableModel.updateModel(CCOHManageVirtualDrivesDialog.this.m_cachedVirtualDrivesList);
                CCOHManageVirtualDrivesDialog.this.m_addButton.setEnabled(false);
                CCOHManageVirtualDrivesDialog.this.m_addAllButton.setEnabled(CCOHManageVirtualDrivesDialog.this.m_addAllButtonEnabled && CCOHManageVirtualDrivesDialog.this.m_cachableVirtualDrivesList.size() > 0);
                CCOHManageVirtualDrivesDialog.this.m_removeButton.setEnabled(false);
                CCOHManageVirtualDrivesDialog.this.m_removeAllButton.setEnabled(CCOHManageVirtualDrivesDialog.this.m_cachedVirtualDrivesList.size() > 0);
                CCOHManageVirtualDrivesDialog.this.m_isChanged = true;
            }
        });
        this.m_removeAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = CCOHManageVirtualDrivesDialog.this.m_cachedVirtualDrivesList.size();
                for (int i = 0; i < n; ++i) {
                    CCOHManageVirtualDrivesDialog.this.m_cachableVirtualDrivesList.add(CCOHManageVirtualDrivesDialog.this.m_cachedVirtualDrivesList.get(i));
                }
                CCOHManageVirtualDrivesDialog.this.m_cachedVirtualDrivesList.removeAll(CCOHManageVirtualDrivesDialog.this.m_cachableVirtualDrivesList);
                CCOHManageVirtualDrivesDialog.this.m_cachableVirtualDrivesTableModel.updateModel(CCOHManageVirtualDrivesDialog.this.m_cachableVirtualDrivesList);
                CCOHManageVirtualDrivesDialog.this.m_cachedVirtualDrivesTableModel.updateModel(CCOHManageVirtualDrivesDialog.this.m_cachedVirtualDrivesList);
                CCOHManageVirtualDrivesDialog.this.m_addButton.setEnabled(false);
                CCOHManageVirtualDrivesDialog.this.m_addAllButton.setEnabled(CCOHManageVirtualDrivesDialog.this.m_addAllButtonEnabled && CCOHManageVirtualDrivesDialog.this.m_cachableVirtualDrivesList.size() > 0);
                CCOHManageVirtualDrivesDialog.this.m_removeButton.setEnabled(false);
                CCOHManageVirtualDrivesDialog.this.m_removeAllButton.setEnabled(false);
                CCOHManageVirtualDrivesDialog.this.m_isChanged = true;
            }
        });
        this.m_cachedVirtualDrivesTable.clearSelection();
        if (this.m_cachableVirtualDrivesList.size() > 0) {
            this.m_cachableVirtualDrivesTable.setRowSelectionInterval(0, 0);
        }
    }

    public void initialiseNavigationPanel() {
        String[] stringArray = null;
        this.m_navigationPanel = new JPanel(new FlowLayout(2));
        stringArray = Resource.getResourceMnemonic(Resource.getString("MENU_HELP_TEXT", "(H)elp"));
        this.m_btnHelp = new JButton(stringArray[0]);
        if (stringArray.length == 2) {
            this.m_btnHelp.setMnemonic(stringArray[1].charAt(0));
        }
        this.m_btnCancel = new JButton(Resource.getString("BUTTON_CANCEL_TEXT", "Cancel"));
        stringArray = Resource.getResourceMnemonic(Resource.getString("BUTTON_SAVE_TEXT", "(S)ave"));
        this.m_btnSave = new JButton(stringArray[0]);
        if (stringArray.length == 2) {
            this.m_btnSave.setMnemonic(stringArray[1].charAt(0));
        }
        this.m_navigationPanel.add(this.m_btnHelp);
        this.m_navigationPanel.add(this.m_btnCancel);
        this.m_navigationPanel.add(this.m_btnSave);
        this.m_btnSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n;
                CCOHManageVirtualDrivesDialog.this.dispose();
                SL_CCOH_DEV_T[] sL_CCOH_DEV_TArray = CCOHManageVirtualDrivesDialog.this.m_ccohConfigEngine.getFinalArrOfVDsToBeAdded();
                int n2 = 0;
                if (sL_CCOH_DEV_TArray != null) {
                    n2 = sL_CCOH_DEV_TArray.length;
                    for (n = 0; n < n2; ++n) {
                        try {
                            CCOHManageVirtualDrivesDialog.this.m_virtualAdapter.addVDtoCG(sL_CCOH_DEV_TArray[n]);
                            continue;
                        }
                        catch (VKOperationFailedException vKOperationFailedException) {
                            CustomMsgBox.errorMsg(vKOperationFailedException);
                        }
                    }
                }
                if ((sL_CCOH_DEV_TArray = CCOHManageVirtualDrivesDialog.this.m_ccohConfigEngine.getFinalArrOfVDsToBeRemoved()) != null) {
                    n2 = sL_CCOH_DEV_TArray.length;
                    for (n = 0; n < n2; ++n) {
                        try {
                            CCOHManageVirtualDrivesDialog.this.m_virtualAdapter.removeVDfromCG(sL_CCOH_DEV_TArray[n]);
                            continue;
                        }
                        catch (VKOperationFailedException vKOperationFailedException) {
                            CustomMsgBox.errorMsg(vKOperationFailedException);
                        }
                    }
                }
            }
        });
        this.m_btnHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HelpContext.executeHelpProcess(CCOHManageVirtualDrivesDialog.this.getHelpPage());
            }
        });
        this.m_btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (CCOHManageVirtualDrivesDialog.this.m_isChanged) {
                    if (CCOHManageVirtualDrivesDialog.this.warningDialog()) {
                        CCOHManageVirtualDrivesDialog.this.dispose();
                    }
                } else {
                    CCOHManageVirtualDrivesDialog.this.dispose();
                }
            }
        });
    }

    @Override
    public String getHelpPage() {
        return HelpContextResourse.getHelpPageName("NYTRO_XD_MANAGING_THE_VIRTUAL_DRIVES");
    }

    @Override
    protected boolean warningDialog() {
        if (this.m_isChanged) {
            DefaultNoOptionDialog defaultNoOptionDialog = new DefaultNoOptionDialog(Resource.getString("CCOH_CONFIRMATION", "Confirmation"), Resource.getString("CONFIG_CANCEL_MSG"), 3);
            return defaultNoOptionDialog.getOptionPaneValue();
        }
        return true;
    }

    private boolean canVDsBeAdded(int n) {
        return this.m_cachedVirtualDrivesList.size() + n <= this.m_MaxVirtualDrivesSupported;
    }

    class cachedVirtualDrivesTableListSelectionListener
    implements ListSelectionListener {
        cachedVirtualDrivesTableListSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            CCOHManageVirtualDrivesDialog.this.m_addButton.setEnabled(false);
            CCOHManageVirtualDrivesDialog.this.m_removeButton.setEnabled(CCOHManageVirtualDrivesDialog.this.m_cachedVirtualDrivesTable.getSelectedRows().length > 0);
            CCOHManageVirtualDrivesDialog.this.m_cachableVirtualDrivesTable.clearSelection();
        }
    }

    class cachableVirtualDrivesTableListSelectionListener
    implements ListSelectionListener {
        cachableVirtualDrivesTableListSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            int n = CCOHManageVirtualDrivesDialog.this.m_cachableVirtualDrivesTable.getSelectedRows().length;
            CCOHManageVirtualDrivesDialog.this.m_addButton.setEnabled(n > 0 && CCOHManageVirtualDrivesDialog.this.canVDsBeAdded(n));
            CCOHManageVirtualDrivesDialog.this.m_removeButton.setEnabled(false);
            CCOHManageVirtualDrivesDialog.this.m_cachedVirtualDrivesTable.clearSelection();
        }
    }
}

