/*
 * Decompiled with CFR 0.152.
 */
package GUI.CCOH;

import GUI.CCOH.CCOHBaseDialog;
import GUI.CCOH.CCOHConfigurationEngine;
import GUI.CCOH.CCOHVDsToCacheRenderer;
import Utils.HelpContextResourse;
import Utils.HelpInterface;
import Utils.Resource;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class CCOHModeSelectionPanel
extends JPanel
implements HelpInterface {
    private CCOHBaseDialog m_ccohBaseDialog = null;
    private CCOHConfigurationEngine m_ccohConfigEngine = null;
    private boolean m_isChanged = false;
    private JRadioButton m_AutomaticRadioButton = null;
    private JLabel m_AutomaticLabel = null;
    private JComboBox m_VDsToCacheCombobox = null;
    private JRadioButton m_ManualRadioButton = null;
    private boolean m_isVDExists = false;
    private boolean m_isDASVDExists = false;
    private boolean m_isSANVDExists = false;
    private boolean m_isComboboxEnabled = false;
    public static final byte NONE = 0;
    public static final byte ALL = 1;
    public static final byte LOCAL_VDS = 2;
    public static final byte SAN_VDS = 3;
    private byte m_selectedComboBoxOption = 0;

    public CCOHModeSelectionPanel(CCOHBaseDialog cCOHBaseDialog) {
        this.m_ccohBaseDialog = cCOHBaseDialog;
        this.m_ccohConfigEngine = this.m_ccohBaseDialog.getCCOHConfigEngine();
        this.m_isVDExists = this.m_ccohConfigEngine.getVirtualDrivesInSystem().size() > 0;
        this.m_isDASVDExists = this.m_ccohConfigEngine.getDASVirtualDrives().size() > 0;
        this.m_isSANVDExists = this.m_ccohConfigEngine.getSANVirtualDrives().size() > 0;
        this.m_isComboboxEnabled = this.m_isVDExists && this.m_isDASVDExists && this.m_isSANVDExists;
        this.buildpanel();
    }

    private void buildpanel() {
        String[] stringArray = null;
        this.m_ccohBaseDialog.setNextButtonEnabled(true);
        ButtonGroup buttonGroup = new ButtonGroup();
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 15, 10, 0);
        this.add((Component)new JLabel(Resource.getString("MODE_SELECTION_PANEL_MSG1", "This wizard will create and configure a new cache group.")), gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets = new Insets(0, 15, 0, 0);
        this.add((Component)new JLabel(Resource.getString("MODE_SELECTION_PANEL_MSG2", "Select the configuration method:")), gridBagConstraints);
        stringArray = Resource.getResourceMnemonic(Resource.getString("MODE_SELECTION_PANEL_AUTOMATIC", "(A)utomatic (Recommended)"));
        this.m_AutomaticRadioButton = new JRadioButton(stringArray[0]);
        if (stringArray.length == 2) {
            this.m_AutomaticRadioButton.setMnemonic(stringArray[1].charAt(0));
        }
        this.m_AutomaticRadioButton.setToolTipText(stringArray[0]);
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets = new Insets(0, 15, 0, 0);
        this.add((Component)this.m_AutomaticRadioButton, gridBagConstraints);
        buttonGroup.add(this.m_AutomaticRadioButton);
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets = new Insets(0, 35, 5, 70);
        this.m_AutomaticLabel = new JLabel(Resource.getString("MODE_SELECTION_PANEL_AUTOMATIC_MSG1", "<html>Automatically creates the cache group. Pick the virtual drives to be cached from<br>the following categories of eligible virtual drives:</html>"));
        this.add((Component)this.m_AutomaticLabel, gridBagConstraints);
        this.m_VDsToCacheCombobox = new JComboBox();
        this.m_VDsToCacheCombobox.setRenderer(new CCOHVDsToCacheRenderer());
        if (this.m_isVDExists) {
            if (this.m_isComboboxEnabled) {
                this.m_VDsToCacheCombobox.addItem((byte)1);
                this.m_VDsToCacheCombobox.addItem((byte)2);
                this.m_VDsToCacheCombobox.addItem((byte)3);
                this.m_selectedComboBoxOption = 1;
            } else if (this.m_isDASVDExists) {
                this.m_VDsToCacheCombobox.addItem((byte)2);
                this.m_selectedComboBoxOption = (byte)2;
            } else if (this.m_isSANVDExists) {
                this.m_VDsToCacheCombobox.addItem((byte)3);
                this.m_selectedComboBoxOption = (byte)3;
            }
        } else {
            this.m_VDsToCacheCombobox.addItem((byte)0);
            this.m_selectedComboBoxOption = 0;
        }
        this.m_VDsToCacheCombobox.setEnabled(this.m_isComboboxEnabled);
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets = new Insets(0, 35, 20, 70);
        this.add((Component)this.m_VDsToCacheCombobox, gridBagConstraints);
        stringArray = Resource.getResourceMnemonic(Resource.getString("MODE_SELECTION_PANEL_MANUAL", "(M)anual"));
        this.m_ManualRadioButton = new JRadioButton(stringArray[0]);
        if (stringArray.length == 2) {
            this.m_ManualRadioButton.setMnemonic(stringArray[1].charAt(0));
        }
        this.m_ManualRadioButton.setToolTipText(stringArray[0]);
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets = new Insets(0, 15, 0, 0);
        this.add((Component)this.m_ManualRadioButton, gridBagConstraints);
        buttonGroup.add(this.m_ManualRadioButton);
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets = new Insets(0, 35, 120, 70);
        gridBagConstraints.gridwidth = 5;
        this.add((Component)new JLabel(Resource.getString("MODE_SELECTION_PANEL_MANUAL_MSG", "Manually create the cache group and choose the specific virtual drives to cache")), gridBagConstraints);
        if (this.m_ccohConfigEngine.isAutomaticConfigAllowed()) {
            this.m_AutomaticRadioButton.setSelected(true);
        } else {
            this.m_AutomaticRadioButton.setEnabled(false);
            this.m_VDsToCacheCombobox.setEnabled(false);
            this.m_AutomaticLabel.setText(Resource.getString("MODE_SELECTION_PANEL_AUTOMATIC_MSG2", "<html><font color=gray>Automatically creates the cache group. Pick the virtual drives to be cached from<br>the following categories of eligible virtual drives:</html>"));
            this.m_ManualRadioButton.setSelected(true);
        }
        this.m_isChanged = false;
        this.m_AutomaticRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CCOHModeSelectionPanel.this.m_VDsToCacheCombobox.setEnabled(CCOHModeSelectionPanel.this.m_isComboboxEnabled);
                if (CCOHModeSelectionPanel.this.m_isComboboxEnabled) {
                    CCOHModeSelectionPanel.this.m_VDsToCacheCombobox.requestFocusInWindow();
                }
                CCOHModeSelectionPanel.this.m_isChanged = true;
            }
        });
        this.m_AutomaticRadioButton.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
            }

            @Override
            public void focusGained(FocusEvent focusEvent) {
                if (CCOHModeSelectionPanel.this.m_AutomaticRadioButton.isSelected() && CCOHModeSelectionPanel.this.m_isComboboxEnabled) {
                    CCOHModeSelectionPanel.this.m_VDsToCacheCombobox.requestFocusInWindow();
                }
            }
        });
        this.m_ManualRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CCOHModeSelectionPanel.this.m_VDsToCacheCombobox.setEnabled(false);
                CCOHModeSelectionPanel.this.m_isChanged = true;
            }
        });
        this.m_VDsToCacheCombobox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (CCOHModeSelectionPanel.this.m_VDsToCacheCombobox.getSelectedIndex() != -1) {
                    CCOHModeSelectionPanel.this.m_isChanged = true;
                    CCOHModeSelectionPanel.this.m_selectedComboBoxOption = (Byte)itemEvent.getItem();
                }
            }
        });
    }

    public boolean isAutomaticRadioButtonSelected() {
        return this.m_AutomaticRadioButton.isSelected();
    }

    public boolean isManualRadioButtonSelected() {
        return this.m_ManualRadioButton.isSelected();
    }

    @Override
    public String getHelpPage() {
        return HelpContextResourse.getHelpPageName("NYTRO_XD_CREATING_A_CACHE_GROUP");
    }

    public JButton getDefaultButton() {
        return this.m_ccohBaseDialog.getNextButton();
    }

    public byte getPageId() {
        return 1;
    }

    public boolean isChanged() {
        return this.m_isChanged;
    }

    public byte getSelectedComboBoxOption() {
        return this.m_selectedComboBoxOption;
    }
}

