/*
 * Decompiled with CFR 0.152.
 */
package GUI.CCOH;

import GUI.CCOH.CCOHBaseDialog;
import GUI.CCOH.CCOHConfigurationEngine;
import GUIHelper.AdapterHelper;
import SASKernel.LibraryAPI.StoreLib.SL_CCOH_DEV_T;
import Services.KernelConstants;
import Utils.HelpContextResourse;
import Utils.HelpInterface;
import Utils.Resource;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class CCOHPreviewPanel
extends JPanel
implements HelpInterface {
    private static final String NEW_LINE = "\n";
    private CCOHBaseDialog m_ccohBaseDialog = null;
    private CCOHConfigurationEngine m_ccohConfigEngine = null;
    private boolean m_isChanged = true;
    private JTextArea m_taSummary = null;
    private boolean m_isNextButtonEnabled = false;
    private JCheckBox m_continueChkBox = null;

    public CCOHPreviewPanel(CCOHBaseDialog cCOHBaseDialog) {
        this.m_ccohBaseDialog = cCOHBaseDialog;
        this.m_ccohConfigEngine = this.m_ccohBaseDialog.getCCOHConfigEngine();
        this.buildPanel();
    }

    private void buildPanel() {
        String[] stringArray = null;
        this.m_ccohBaseDialog.setNextButtonEnabled(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(new GridBagLayout());
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(10, 15, 10, 0);
        this.m_taSummary = new JTextArea(14, 70);
        this.m_taSummary.setText(this.getConfigSummaryText());
        this.m_taSummary.setEditable(false);
        stringArray = Resource.getResourceMnemonic(Resource.getString("PREVIEW_PANEL_MSG1", "(P)review:"));
        JLabel jLabel = new JLabel(stringArray[0]);
        if (stringArray.length == 2) {
            jLabel.setDisplayedMnemonic(stringArray[1].charAt(0));
            jLabel.setLabelFor(this.m_taSummary);
        }
        this.add((Component)jLabel, gridBagConstraints);
        JScrollPane jScrollPane = new JScrollPane(this.m_taSummary, 20, 30);
        jScrollPane.setPreferredSize(new Dimension(600, 300));
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets = new Insets(0, 15, 5, 15);
        this.add((Component)jScrollPane, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets = new Insets(0, 15, 5, 15);
        this.add((Component)new JLabel(Resource.getString("PREVIEW_PANEL_MSG2", "Important Note: Any data that currently resides on the listed cache devices will be permanently deleted."), this.getImageIcon(Resource.getString("NEEDS_ATTENTION_ICON", "NeedAtten.png")), 2), gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets = new Insets(0, 15, 10, 15);
        stringArray = Resource.getResourceMnemonic(Resource.getString("PREVIEW_PANEL_MSG3", "(C)ontinue"));
        this.m_continueChkBox = new JCheckBox(stringArray[0]);
        if (stringArray.length == 2) {
            this.m_continueChkBox.setMnemonic(stringArray[1].charAt(0));
        }
        this.m_continueChkBox.setBackground(this.getBackground());
        this.add((Component)this.m_continueChkBox, gridBagConstraints);
        this.m_continueChkBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (CCOHPreviewPanel.this.m_continueChkBox.isSelected()) {
                    CCOHPreviewPanel.this.m_isNextButtonEnabled = true;
                    CCOHPreviewPanel.this.m_ccohBaseDialog.setNextButtonEnabled(true);
                } else {
                    CCOHPreviewPanel.this.m_isNextButtonEnabled = false;
                    CCOHPreviewPanel.this.m_ccohBaseDialog.setNextButtonEnabled(false);
                }
            }
        });
    }

    public void update() {
        this.m_taSummary.setText(this.getConfigSummaryText());
        this.m_continueChkBox.setSelected(false);
        this.m_isNextButtonEnabled = false;
    }

    public String getConfigSummaryText() {
        StringBuffer stringBuffer = new StringBuffer();
        ArrayList<AdapterHelper> arrayList = this.m_ccohConfigEngine.getHelpersForCacheDevsAdded();
        stringBuffer.append(Resource.getString("PREVIEW_PANEL_TOTAL_CG_CAPACITY", "Total cache group capacity:"));
        stringBuffer.append(" ");
        stringBuffer.append(KernelConstants.getConvertedSize(this.m_ccohConfigEngine.getTotalCapacity(this.m_ccohConfigEngine.getCDListForHelpers(arrayList))));
        stringBuffer.append(NEW_LINE);
        stringBuffer.append(Resource.getString("PREVIEW_PANEL_CONFIGURATION_METHOD", "Configuration method:"));
        stringBuffer.append(" ");
        if (this.m_ccohConfigEngine.getSelectedmode() == 1) {
            stringBuffer.append(Resource.getString("PREVIEW_PANEL_AUTOMATIC", "Automatic"));
        } else {
            stringBuffer.append(Resource.getString("PREVIEW_PANEL_MANUAL", "Manual"));
        }
        stringBuffer.append(NEW_LINE);
        stringBuffer.append(NEW_LINE);
        int n = arrayList.size();
        stringBuffer.append(Resource.getString("PREVIEW_PANEL_CACHE_DEVICES", "Cache devices") + " (" + n + "):");
        stringBuffer.append(NEW_LINE);
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(this.m_ccohConfigEngine.getHelperCDText(arrayList.get(i)));
            stringBuffer.append(NEW_LINE);
        }
        stringBuffer.append(NEW_LINE);
        ArrayList<SL_CCOH_DEV_T> arrayList2 = this.m_ccohConfigEngine.getVirtualDrivesAdded();
        n = arrayList2.size();
        stringBuffer.append(Resource.getString("PREVIEW_PANEL_CACHED_VDS", "Cached virtual drives") + " (" + n + "):");
        stringBuffer.append(NEW_LINE);
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(arrayList2.get(i).getText());
            stringBuffer.append(NEW_LINE);
        }
        return stringBuffer.toString();
    }

    private ImageIcon getImageIcon(String string) {
        try {
            return new ImageIcon(Toolkit.getDefaultToolkit().getImage(ClassLoader.getSystemResource(string)));
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public String getHelpPage() {
        if (this.m_ccohConfigEngine.getSelectedmode() == 1) {
            return HelpContextResourse.getHelpPageName("NYTRO_XD_PREVIEW_AUTOMATIC_MODE");
        }
        return HelpContextResourse.getHelpPageName("NYTRO_XD_PREVIEW_MANUAL_MODE");
    }

    public String getDescription() {
        return "This is PREVIEW_PANEL";
    }

    public JButton getDefaultButton() {
        return this.m_ccohBaseDialog.getNextButton();
    }

    public byte getPageId() {
        return 4;
    }

    public boolean isChanged() {
        return this.m_isChanged;
    }

    public boolean isNextButtonEnabled() {
        return this.m_isNextButtonEnabled;
    }
}

