/*
 * Decompiled with CFR 0.152.
 */
package GUI.CCOH;

import GUI.CCOH.CCOHDeviceHelper;
import GUI.VivaldiBaseDialog;
import KernelExceptions.VKOperationFailedException;
import SASKernel.VirtualAdapter;
import Utils.CustomMsgBox;
import Utils.GUIUtils;
import Utils.Resource;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;

public class CCOHRemoveOfflineDevicesDialog
extends VivaldiBaseDialog {
    public static final byte TYPE_CACHE_DEVICE = 0;
    public static final byte TYPE_CACHED_VIRTUAL_DRIVE = 1;
    private JTable m_offlineDevicesTable = new JTable();
    private OfflineDevicesTableModel m_offlineDevicesTableModel = null;
    private JCheckBox m_checkAll = new JCheckBox();
    private ArrayList<CCOHDeviceHelper> m_offlineDevicesList = new ArrayList();
    private VirtualAdapter m_virtualAdapter = null;
    private byte m_bdevType = 0;
    private String m_title = "";
    private String m_description = "";
    private String m_okButton = "";
    private String m_cancelButton = "";

    public CCOHRemoveOfflineDevicesDialog(VirtualAdapter virtualAdapter, ArrayList<CCOHDeviceHelper> arrayList, byte by) {
        this.m_virtualAdapter = virtualAdapter;
        this.m_offlineDevicesList = arrayList;
        this.m_bdevType = by;
        this.buildPanel();
    }

    public void buildPanel() {
        String[] stringArray = null;
        if (this.m_bdevType == 0) {
            this.m_title = Resource.getString("REMOVE_OFFLINE_CCOH_CDS_TITLE", "Remove Offline Cache Devices");
            this.m_description = Resource.getString("REMOVE_OFFLINE_CCOH_CDS_DESC", "<html>Select from the list of cache devices in Offline state that you would like to remove from<br>the Cache Group.</html>");
        } else {
            this.m_title = Resource.getString("REMOVE_OFFLINE_CCOH_VDS_TITLE", "Remove Offline Cached Virtual Drives");
            this.m_description = Resource.getString("REMOVE_OFFLINE_CCOH_VDS_DESC", "<html>Select from the list of cached virtual drives in Offline state that you would like to remove<br>from the Cache Group.</html>");
        }
        this.m_okButton = Resource.getString("BUTTON_LABEL_OK", "OK");
        this.m_cancelButton = Resource.getString("BUTTON_LABEL_CANCEL", "Cancel");
        this.setTitle(this.m_title);
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 11;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 5, 25, 5);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 6;
        jPanel.add((Component)new JLabel(this.m_description), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        this.m_offlineDevicesTableModel = new OfflineDevicesTableModel(this.m_offlineDevicesList);
        this.m_offlineDevicesTableModel.addTableModelListener(new OfflineDevicesTableModelListener());
        this.m_offlineDevicesTable = new JTable(this.m_offlineDevicesTableModel);
        this.m_offlineDevicesTable.setCellSelectionEnabled(false);
        this.m_offlineDevicesTable.setColumnSelectionAllowed(false);
        this.m_offlineDevicesTable.setRowSelectionAllowed(true);
        this.m_offlineDevicesTable.setSelectionMode(0);
        this.m_offlineDevicesTable.getTableHeader().setReorderingAllowed(false);
        this.m_offlineDevicesTable.getTableHeader().setResizingAllowed(true);
        this.m_offlineDevicesTable.setAutoResizeMode(0);
        TableColumn tableColumn = this.m_offlineDevicesTable.getColumnModel().getColumn(0);
        tableColumn.setPreferredWidth(60);
        tableColumn = this.m_offlineDevicesTable.getColumnModel().getColumn(1);
        tableColumn.setPreferredWidth(this.getPreferredSize().width - 54);
        JScrollPane jScrollPane = new JScrollPane(this.m_offlineDevicesTable, 20, 30);
        jScrollPane.setPreferredSize(new Dimension(this.getPreferredSize().width, 200));
        jPanel.add((Component)jScrollPane, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        stringArray = this.m_bdevType == 0 ? Resource.getResourceMnemonic(Resource.getString("CACHE_GROUP_PANEL_CACHE_DEVICES", "(C)ache devices:")) : Resource.getResourceMnemonic(Resource.getString("VIRTUAL_DRIVES_PANEL_CACHED_VDS", "(C)ached virtual drives:"));
        JLabel jLabel = new JLabel(stringArray[0]);
        if (stringArray.length == 2) {
            jLabel.setDisplayedMnemonic(stringArray[1].charAt(0));
            jLabel.setLabelFor(this.m_offlineDevicesTable);
        }
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(0, 5, 15, 5);
        stringArray = Resource.getResourceMnemonic(Resource.getString("CHECK_BOX_TEXT_ALL", "(A)ll"));
        this.m_checkAll.setText(stringArray[0]);
        if (stringArray.length == 2) {
            this.m_checkAll.setMnemonic(stringArray[1].charAt(0));
        }
        this.m_checkAll.setSelected(this.m_offlineDevicesTableModel.getSelectedRowCount() == this.m_offlineDevicesList.size());
        this.m_checkAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = CCOHRemoveOfflineDevicesDialog.this.m_offlineDevicesTableModel.getRowCount();
                if (CCOHRemoveOfflineDevicesDialog.this.m_checkAll.isSelected()) {
                    for (int i = 0; i < n; ++i) {
                        CCOHRemoveOfflineDevicesDialog.this.m_offlineDevicesTableModel.setValueAt(true, i, 0);
                    }
                    CCOHRemoveOfflineDevicesDialog.this.m_checkAll.setSelected(true);
                } else if (!CCOHRemoveOfflineDevicesDialog.this.m_checkAll.isSelected()) {
                    for (int i = 0; i < n; ++i) {
                        CCOHRemoveOfflineDevicesDialog.this.m_offlineDevicesTableModel.setValueAt(false, i, 0);
                    }
                    CCOHRemoveOfflineDevicesDialog.this.m_checkAll.setSelected(false);
                }
            }
        });
        jPanel.add((Component)this.m_checkAll, gridBagConstraints);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        JPanel jPanel3 = new JPanel(new GridLayout(1, 2));
        stringArray = Resource.getResourceMnemonic(this.m_okButton);
        JButton jButton = new JButton(stringArray[0]);
        if (stringArray.length == 2) {
            jButton.setMnemonic(stringArray[1].charAt(0));
        }
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CCOHRemoveOfflineDevicesDialog.this.performEnterAction();
            }
        });
        jPanel3.add(jButton);
        stringArray = Resource.getResourceMnemonic(this.m_cancelButton);
        JButton jButton2 = new JButton(stringArray[0]);
        if (stringArray.length == 2) {
            jButton2.setMnemonic(stringArray[1].charAt(0));
        }
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CCOHRemoveOfflineDevicesDialog.this.dispose();
            }
        });
        jPanel3.add(jButton2);
        jPanel2.add((Component)jPanel3, "Center");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 0;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        this.getContentPane().add((Component)jPanel, "South");
        this.setResizable(false);
        this.setModal(true);
        this.pack();
        this.getRootPane().setDefaultButton(jButton);
        jButton.requestFocusInWindow();
        GUIUtils.centerDialogOnScreen(this);
        this.setVisible(true);
    }

    @Override
    protected void performEnterAction() {
        block8: {
            this.dispose();
            ArrayList<CCOHDeviceHelper> arrayList = this.m_offlineDevicesTableModel.getSelectedOfflineDevices();
            int n = arrayList.size();
            if (n <= 0) break block8;
            if (this.m_bdevType == 0) {
                for (int i = 0; i < n; ++i) {
                    try {
                        this.m_virtualAdapter.removeCDfromCG(arrayList.get(i).getDeviceObject());
                        continue;
                    }
                    catch (VKOperationFailedException vKOperationFailedException) {
                        CustomMsgBox.errorMsg(vKOperationFailedException);
                    }
                }
            } else {
                for (int i = 0; i < n; ++i) {
                    try {
                        this.m_virtualAdapter.removeVDfromCG(arrayList.get(i).getDeviceObject());
                        continue;
                    }
                    catch (VKOperationFailedException vKOperationFailedException) {
                        CustomMsgBox.errorMsg(vKOperationFailedException);
                    }
                }
            }
        }
    }

    class OfflineDevicesTableModel
    extends AbstractTableModel {
        private ArrayList<CCOHDeviceHelper> l_offlineDevicesList = null;
        private boolean[] l_selectedRows = null;

        public OfflineDevicesTableModel(ArrayList<CCOHDeviceHelper> arrayList) {
            this.l_offlineDevicesList = arrayList;
            int n = this.l_offlineDevicesList.size();
            this.l_selectedRows = new boolean[n];
            for (int i = 0; i < n; ++i) {
                this.l_selectedRows[i] = true;
            }
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return this.l_offlineDevicesList.size();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            Object object = null;
            if (n2 == 0) {
                object = new Boolean(this.l_selectedRows[n]);
            }
            if (n2 == 1) {
                object = this.l_offlineDevicesList.get(n).getText();
            }
            return object;
        }

        @Override
        public Class<?> getColumnClass(int n) {
            if (n == 0) {
                return Boolean.class;
            }
            return super.getColumnClass(n);
        }

        @Override
        public String getColumnName(int n) {
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 == 0;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (n2 == 0) {
                this.l_selectedRows[n] = (Boolean)object;
                this.fireTableCellUpdated(n, n2);
            }
        }

        public int getSelectedRowCount() {
            int n = 0;
            int n2 = this.l_selectedRows.length;
            for (int i = 0; i < n2; ++i) {
                if (!this.l_selectedRows[i]) continue;
                ++n;
            }
            return n;
        }

        public ArrayList<CCOHDeviceHelper> getSelectedOfflineDevices() {
            ArrayList<CCOHDeviceHelper> arrayList = new ArrayList<CCOHDeviceHelper>();
            int n = this.l_selectedRows.length;
            for (int i = 0; i < n; ++i) {
                if (!this.l_selectedRows[i]) continue;
                arrayList.add(this.l_offlineDevicesList.get(i));
            }
            return arrayList;
        }
    }

    class OfflineDevicesTableModelListener
    implements TableModelListener {
        OfflineDevicesTableModelListener() {
        }

        @Override
        public void tableChanged(TableModelEvent tableModelEvent) {
            if (CCOHRemoveOfflineDevicesDialog.this.m_offlineDevicesTableModel.getSelectedRowCount() == CCOHRemoveOfflineDevicesDialog.this.m_offlineDevicesTableModel.getRowCount()) {
                CCOHRemoveOfflineDevicesDialog.this.m_checkAll.setSelected(true);
            } else {
                CCOHRemoveOfflineDevicesDialog.this.m_checkAll.setSelected(false);
            }
        }
    }
}

