/*
 * Decompiled with CFR 0.152.
 */
package GUI.CCOH;

import GUI.CCOH.CCOHCacheGroupHelper;
import GUI.VivaldiBaseDialog;
import SASKernel.LibraryAPI.StoreLib.SL_CCOH_DEV_T;
import Utils.GUIUtils;
import Utils.Resource;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class CCOHViewCachedVDProperties
extends VivaldiBaseDialog {
    private String m_strPropertyText = null;
    private JTextArea m_taProperty = null;
    private JScrollPane m_propertyJSP = null;
    private static final String TABS_1 = "\t";
    private static final String NEW_LINE = "\r\n";

    public CCOHViewCachedVDProperties(CCOHCacheGroupHelper cCOHCacheGroupHelper) {
        this.m_strPropertyText = this.getSummaryServerProfile(cCOHCacheGroupHelper);
        this.buildPanel();
    }

    private void buildPanel() {
        String[] stringArray = null;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(10, 15, 10, 0);
        this.m_taProperty = new JTextArea(25, 85);
        this.m_taProperty.setText(this.m_strPropertyText);
        this.m_taProperty.setEditable(false);
        stringArray = Resource.getResourceMnemonic(Resource.getString("CACHED_VD_PROPERTIES_LABEL", "Cached Virtual Drive (P)roperties:"));
        JLabel jLabel = new JLabel(stringArray[0]);
        if (stringArray.length == 2) {
            jLabel.setDisplayedMnemonic(stringArray[1].charAt(0));
            jLabel.setLabelFor(this.m_propertyJSP);
        }
        jPanel.add((Component)jLabel, gridBagConstraints);
        this.m_propertyJSP = new JScrollPane(this.m_taProperty, 20, 30);
        this.m_propertyJSP.setPreferredSize(new Dimension(600, 300));
        this.m_taProperty.setCaretPosition(0);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 15, 10, 15);
        jPanel.add((Component)this.m_propertyJSP, gridBagConstraints);
        stringArray = Resource.getResourceMnemonic(Resource.getString("CLOSE_TEXT", "(C)lose"));
        JButton jButton = new JButton(stringArray[0]);
        if (stringArray.length == 2) {
            jButton.setMnemonic(stringArray[1].charAt(0));
        }
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(0, 300, 20, 0);
        jPanel.add((Component)jButton, gridBagConstraints);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CCOHViewCachedVDProperties.this.dispose();
            }
        });
        this.add(jPanel);
        this.setTitle(Resource.getString("CACHED_VD_PROPERTIES_TITLE", "Cached Virtual Drive Properties"));
        this.setModal(true);
        this.setResizable(false);
        this.pack();
        GUIUtils.centerDialogOnScreen(this);
        this.setVisible(true);
    }

    public String getSummaryServerProfile(CCOHCacheGroupHelper cCOHCacheGroupHelper) {
        ArrayList<SL_CCOH_DEV_T> arrayList = cCOHCacheGroupHelper.getNonOfflineVDsList();
        int n = arrayList.size();
        StringBuffer stringBuffer = new StringBuffer();
        SL_CCOH_DEV_T sL_CCOH_DEV_T = null;
        for (int i = 0; i < n; ++i) {
            sL_CCOH_DEV_T = arrayList.get(i);
            stringBuffer.append(sL_CCOH_DEV_T.getText());
            stringBuffer.append(" --- ");
            stringBuffer.append(NEW_LINE);
            stringBuffer.append(TABS_1);
            stringBuffer.append(Resource.getString("PROP_MAPPED_DEV_ID", "Mapped Device ID:"));
            stringBuffer.append("  ");
            if (sL_CCOH_DEV_T.getDevState() == '\u0002') {
                stringBuffer.append(Resource.getString("MAPPER_PATH_UNASSIGNED", "Unassigned"));
            } else {
                stringBuffer.append(sL_CCOH_DEV_T.getDevMapperPathText());
            }
            stringBuffer.append(NEW_LINE);
            stringBuffer.append(TABS_1);
            stringBuffer.append(Resource.getString("PROP_VENDOR_ID", "Vendor ID:"));
            stringBuffer.append("  ");
            stringBuffer.append(sL_CCOH_DEV_T.getVendorText());
            stringBuffer.append(NEW_LINE);
            stringBuffer.append(TABS_1);
            stringBuffer.append(Resource.getString("PROP_MODEL", "Model:"));
            stringBuffer.append("  ");
            stringBuffer.append(sL_CCOH_DEV_T.getModelText());
            stringBuffer.append(NEW_LINE);
            stringBuffer.append(TABS_1);
            stringBuffer.append(Resource.getString("PROP_SCSI_ID", "SCSI ID:"));
            stringBuffer.append("  ");
            stringBuffer.append(sL_CCOH_DEV_T.getDevIdText());
            stringBuffer.append(NEW_LINE);
            stringBuffer.append(NEW_LINE);
        }
        return stringBuffer.toString();
    }
}

