/*
 * Decompiled with CFR 0.152.
 */
package GUI;

import GUI.DetailPanel;
import GUI.MainFrame;
import GUI.OperationViewPanel;
import GUI.PropertyViewPanel;
import GUIHelper.CDROMHelper;
import Utils.CustomTabbedPane;
import Utils.Resource;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Observable;
import javax.swing.JPanel;

public class CDROMDetailPanel
extends DetailPanel {
    private CustomTabbedPane tabbedPane = new CustomTabbedPane();
    private JPanel propertiesTab = new JPanel();
    private JPanel operationTab = new JPanel();
    private JPanel graphicalTab = new JPanel();
    private OperationViewPanel opView;
    private CDROMHelper cdrom;

    public CDROMDetailPanel(CDROMHelper cDROMHelper, MainFrame mainFrame) {
        super(cDROMHelper, mainFrame);
        this.cdrom = cDROMHelper;
        this.propertiesTab.setLayout(new BorderLayout());
        this.tabbedPane.addTab(Resource.getString("PROPERTY_TAB_TEXT", "Properties"), null, this.propertiesTab, Resource.getString("PROPERTY_TAB_TEXT", "Properties"));
        this.add((Component)this.tabbedPane, "Center");
        this.init();
        cDROMHelper.addObserver(this);
    }

    @Override
    public void init() {
        this.propertiesTab.removeAll();
        PropertyViewPanel propertyViewPanel = new PropertyViewPanel(this.cdrom.getPropertyList());
        this.propertiesTab.add((Component)propertyViewPanel, "North");
        this.validate();
        this.repaint();
    }

    @Override
    public boolean canClose() {
        this.cdrom.deleteObserver(this);
        return true;
    }

    @Override
    public void gotoTab(int n) {
        this.tabbedPane.setSelectedIndex(n);
    }

    @Override
    public int getTabIndex() {
        return this.tabbedPane.getSelectedIndex();
    }

    @Override
    public void update(Observable observable, Object object) {
    }
}

