/*
 * Decompiled with CFR 0.152.
 */
package GUI.CSA;

import GUI.CSA.CSADriveGroupsTreePanel;
import GUI.CSA.CSAPDTableToTreePanel;
import GUI.venus.configuration.advanced.AdvanceConfigEngine;
import GUI.venus.configuration.advanced.DriveGroup;
import GUI.venus.configuration.advanced.RaidLevelComboBoxModel;
import GUI.venus.configuration.advanced.RaidLevelRenderer;
import GUI.venus.configuration.advanced.Span;
import GUI.venus.wizard.DefaultWizardPage;
import GUIHelper.AdapterHelper;
import SASKernel.SASAdapter.SASAdapter;
import Utils.Resource;
import com.sun.java.swing.plaf.windows.WindowsLookAndFeel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;

public class CSAAdvancedDriveGroupSettings {
    public static final byte RAID_LEVEL_SELECT = -1;
    private AdapterHelper m_objAdapterHelper = null;
    private JComboBox m_objRaidLevelCombobox = new JComboBox();
    private DefaultWizardPage m_objDefWizardPage = null;
    private CSAPDTableToTreePanel m_objPDTableToTreePanel = null;
    private CSADriveGroupsTreePanel m_objDGTreePanel = null;
    private JPanel m_objContentPanel = null;
    private AdvanceConfigEngine m_objAdvConfigEngine = null;

    public CSAAdvancedDriveGroupSettings(AdvanceConfigEngine advanceConfigEngine, DefaultWizardPage defaultWizardPage) {
        this.m_objAdvConfigEngine = advanceConfigEngine;
        this.m_objAdapterHelper = advanceConfigEngine.getAdapterHelper();
        this.m_objDefWizardPage = defaultWizardPage;
        this.initialise();
    }

    public void initialise() {
        this.m_objDGTreePanel = new CSADriveGroupsTreePanel(this.m_objAdapterHelper, this.m_objRaidLevelCombobox, this.m_objDefWizardPage);
        this.m_objPDTableToTreePanel = new CSAPDTableToTreePanel(this.m_objAdvConfigEngine, this.m_objRaidLevelCombobox, this.m_objDGTreePanel, this.m_objDefWizardPage);
        this.m_objDGTreePanel.addDriveGroupNodeToTree();
        this.m_objContentPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Dimension dimension = new Dimension(230, 25);
        Dimension dimension2 = new Dimension(32, 32);
        final JLabel jLabel = new JLabel();
        RaidLevelComboBoxModel raidLevelComboBoxModel = new RaidLevelComboBoxModel(this.m_objAdapterHelper, this.m_objPDTableToTreePanel.getUnconfiguredGoodPdListSize(), true);
        try {
            UIManager.setLookAndFeel(WindowsLookAndFeel.class.getName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 20;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.m_objContentPanel.add((Component)new JLabel(Resource.getString("CREATE_CSA_DESC")), gridBagConstraints);
        JLabel jLabel2 = new JLabel();
        final JLabel jLabel3 = new JLabel();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        gridBagConstraints.gridwidth = 1;
        String[] stringArray = Resource.getResourceMnemonic(Resource.getString("LABEL_RAID_LEVEL_ADG", "(R)AID level:"));
        jLabel2.setText(stringArray[0]);
        jLabel2.setLabelFor(this.m_objRaidLevelCombobox);
        if (stringArray.length == 2) {
            jLabel2.setDisplayedMnemonic(stringArray[1].charAt(0));
        }
        this.m_objContentPanel.add((Component)jLabel2, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(0, 10, 10, 0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        this.m_objRaidLevelCombobox.setPreferredSize(dimension);
        this.m_objRaidLevelCombobox.setModel(raidLevelComboBoxModel);
        this.m_objRaidLevelCombobox.setRenderer(new RaidLevelRenderer(this.m_objAdapterHelper));
        this.m_objContentPanel.add((Component)this.m_objRaidLevelCombobox, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 1;
        jLabel3.setPreferredSize(dimension2);
        jLabel3.setIcon(Resource.getImage(""));
        this.m_objContentPanel.add((Component)jLabel3, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridwidth = 18;
        jLabel.setText(this.getRaidLevelDescription((byte)-1));
        this.m_objContentPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 8;
        this.m_objContentPanel.add((Component)this.m_objPDTableToTreePanel, gridBagConstraints);
        gridBagConstraints.gridx = 9;
        gridBagConstraints.gridwidth = 8;
        this.m_objContentPanel.add((Component)this.m_objDGTreePanel, gridBagConstraints);
        this.m_objRaidLevelCombobox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (CSAAdvancedDriveGroupSettings.this.m_objRaidLevelCombobox.getSelectedIndex() != -1) {
                    DefaultMutableTreeNode defaultMutableTreeNode;
                    Object object;
                    CSAAdvancedDriveGroupSettings.this.m_objPDTableToTreePanel.reset();
                    byte by = (Byte)itemEvent.getItem();
                    jLabel.setText(CSAAdvancedDriveGroupSettings.this.getRaidLevelDescription(by));
                    jLabel3.setIcon(CSAAdvancedDriveGroupSettings.this.getRaidLevelIcon(by));
                    DefaultMutableTreeNode defaultMutableTreeNode2 = CSAAdvancedDriveGroupSettings.this.m_objDGTreePanel.getLastDgNode();
                    DriveGroup driveGroup = (DriveGroup)defaultMutableTreeNode2.getUserObject();
                    if (!driveGroup.isCompleted() && by <= 17 && defaultMutableTreeNode2.getChildCount() == 1 && (object = (defaultMutableTreeNode = (DefaultMutableTreeNode)defaultMutableTreeNode2.getChildAt(0)).getUserObject()) instanceof Span && defaultMutableTreeNode.getChildCount() == 0) {
                        ((DefaultTreeModel)CSAAdvancedDriveGroupSettings.this.m_objDGTreePanel.getDriveGroupsTree().getModel()).removeNodeFromParent(defaultMutableTreeNode);
                    }
                    if (by == -1) {
                        CSAAdvancedDriveGroupSettings.this.m_objPDTableToTreePanel.setEnabledAddButton(false);
                        if (CSAAdvancedDriveGroupSettings.this.m_objDGTreePanel.getDgCount() > 0 && CSAAdvancedDriveGroupSettings.this.m_objDGTreePanel.isPreviousDgNodeCompleted()) {
                            CSAAdvancedDriveGroupSettings.this.m_objDGTreePanel.addDriveGroupNodeToTree();
                        }
                    } else if (by >= 0) {
                        Object object2;
                        if (!driveGroup.isCompleted()) {
                            driveGroup.setRaidLevel(by);
                        }
                        boolean bl = true;
                        object = CSAAdvancedDriveGroupSettings.this.m_objDGTreePanel.getSelectedNodeFromTree();
                        if (object != null && (object2 = ((DefaultMutableTreeNode)object).getUserObject()) instanceof DriveGroup && ((DriveGroup)object2).isCompleted()) {
                            bl = false;
                        }
                        if (CSAAdvancedDriveGroupSettings.this.m_objPDTableToTreePanel.isPdSelectedFromTable() && bl) {
                            CSAAdvancedDriveGroupSettings.this.m_objPDTableToTreePanel.setEnabledAddButton(true);
                        } else {
                            CSAAdvancedDriveGroupSettings.this.m_objPDTableToTreePanel.setEnabledAddButton(false);
                        }
                    }
                }
            }
        });
    }

    public JPanel getContentPanel() {
        return this.m_objContentPanel;
    }

    public CSADriveGroupsTreePanel getDgTreePanel() {
        return this.m_objDGTreePanel;
    }

    private String getRaidLevelDescription(byte by) {
        switch (by) {
            case -1: {
                return Resource.getString("CSA_RAID_DESC", "<html>Pick a RAID level to specify the amount of fault tolerance and performance <br> for the Nytro\u2122 Cache Drive.</html>");
            }
            case 0: {
                return Resource.getString("RAID0_DESC", "<html>This RAID level is suitable for high performance with zero<br> data redundancy.Choose this option only for non-critical data.</html>");
            }
            case 1: {
                return Resource.getString("RAID1_DESC", "<html>\"Disk mirroring\" This RAID level is suitable for high<br> redundancy and performance.</html>");
            }
            case 17: {
                if (((SASAdapter)this.m_objAdapterHelper.getDeviceObject()).getAdapterType() == 2) {
                    return Resource.getString("RAID1E_DESC", "<html>RAID level that combines RAID 0's striping capabilities with<br>RAID 1's mirroring protection.</html>");
                }
                return Resource.getString("RAID10_DESC", "<html>RAID level 10 is a stripe of mirrors.</html>");
            }
            case 5: {
                return Resource.getString("RAID5_DESC", "<html>This RAID level is suitable for multi-user environments(database <br>or file system) with large IO size and high proportion of read activity.</html>");
            }
            case 6: {
                return Resource.getString("RAID6_DESC", "<html>This RAID level is suitable for environments requiring redundancy<br> protection beyond RAID 5,but not requiring high write performance.</html>");
            }
            case 64: {
                return Resource.getString("RAID00_DESC", "<html>RAID level 00 is a stripe of stripes.</html>");
            }
            case 65: {
                return Resource.getString("RAID10_DESC", "<html>RAID level 10 is a stripe of mirrors.</html>");
            }
            case 69: {
                return Resource.getString("RAID50_DESC", "<html>Combines the straight block-level striping of RAID 0 with<br>distributed parity of RAID 5.</html>");
            }
            case 70: {
                return Resource.getString("RAID60_DESC", "<html>Combines the straight block-level striping of RAID 0 with<br>distributed double parity of RAID 6.</html>");
            }
            case 7: {
                return Resource.getString("RAID_LEVEL_EC_DESC", "This RAID level offers selective mirroring.");
            }
        }
        return "";
    }

    private ImageIcon getRaidLevelIcon(byte by) {
        switch (by) {
            case -1: {
                return Resource.getImage("");
            }
            case 0: {
                return Resource.getImage("RAID0_ICON");
            }
            case 1: {
                return Resource.getImage("RAID1_ICON");
            }
            case 17: {
                if (((SASAdapter)this.m_objAdapterHelper.getDeviceObject()).getAdapterType() == 2) {
                    return Resource.getImage("RAID1E_ICON");
                }
                return Resource.getImage("RAID10_ICON");
            }
            case 5: {
                return Resource.getImage("RAID5_ICON");
            }
            case 6: {
                return Resource.getImage("RAID6_ICON");
            }
            case 64: {
                return Resource.getImage("RAID00_ICON");
            }
            case 65: {
                return Resource.getImage("RAID10_ICON");
            }
            case 69: {
                return Resource.getImage("RAID50_ICON");
            }
            case 70: {
                return Resource.getImage("RAID60_ICON");
            }
        }
        return Resource.getImage("");
    }
}

