/*
 * Decompiled with CFR 0.152.
 */
package GUI.CSA;

import GUI.CSA.CSABootVolumeCreationPanel;
import GUI.venus.configuration.advanced.AdvanceConfigEngine;
import GUI.venus.configuration.simple.SimpleConfigParams;
import GUI.venus.wizard.DefaultWizardPage;
import GUIHelper.AdapterHelper;
import GUIHelper.PhysicalDriveHelper;
import SASKernel.SASPhysical.SASPhysicalDrive;
import Services.KernelConstants;
import Utils.HelpContext;
import Utils.HelpException;
import Utils.HelpInterface;
import Utils.Resource;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.JPanel;

public class CSABootVolumeCreationPage
extends DefaultWizardPage
implements HelpInterface {
    private CSABootVolumeCreationPanel m_bootVolumeCreationPanel = null;
    private AdapterHelper m_objAdapterHelper = null;
    private AdvanceConfigEngine m_objAdvConfigEngine = null;
    private ArrayList<PhysicalDriveHelper> pdHelperList = null;

    @Override
    public JPanel getContentPanel() {
        if (this.m_bootVolumeCreationPanel == null) {
            this.m_bootVolumeCreationPanel = new CSABootVolumeCreationPanel(this.m_objAdvConfigEngine, this.m_objAdapterHelper);
        }
        this.m_hmWizardData.put("CSABootVolumeCreationPage", false);
        this.calculateMaximumBootVolumeSize();
        this.m_bootVolumeCreationPanel.buildPanel();
        return this.m_bootVolumeCreationPanel;
    }

    @Override
    public String getPageID() {
        return "CSABootVolumeCreationPage";
    }

    @Override
    public String getTitle() {
        return Resource.getString("CSA_SPECIFY_SIZE_PAGE_TITLE", "Create Nytro Cache - Specify Boot Drive Size");
    }

    @Override
    protected void reinitialise() {
        this.m_objAdapterHelper = (AdapterHelper)this.m_hmWizardData.get("AdapterHelper");
        this.m_strHelpFileName = "MSM_CSA_CACHING_AND_BOOT_OPTION";
        this.m_objAdvConfigEngine = (AdvanceConfigEngine)this.m_hmWizardData.get("AdvanceConfigEngine");
        try {
            HelpContext.registerHelp(this);
        }
        catch (HelpException helpException) {
            helpException.printStackTrace();
        }
    }

    @Override
    public void onNext() {
        double d = Double.parseDouble(this.m_bootVolumeCreationPanel.getBootVolumeSize());
        long l = KernelConstants.getSizeInBlocks(d, 3, this.pdHelperList.get(0).getUserDataBlockSize());
        SimpleConfigParams simpleConfigParams = new SimpleConfigParams(1, 1, this.m_bootVolumeCreationPanel.iConfigurableSize, this.pdHelperList, l);
        this.m_hmWizardData.put("SimpleConfigParams", simpleConfigParams);
        this.m_iTrigger = 0;
        super.onNext();
    }

    public void calculateMaximumBootVolumeSize() {
        this.pdHelperList = new ArrayList();
        PhysicalDriveHelper[] physicalDriveHelperArray = this.m_objAdapterHelper.getUnconfiguredPhysicalDrives();
        if (physicalDriveHelperArray != null) {
            for (int i = 0; i < physicalDriveHelperArray.length; ++i) {
                if (physicalDriveHelperArray[i].getInformation().getproperties_MR_PD_INFO().getIneligibleForSSCD() != 0) continue;
                this.pdHelperList.add(physicalDriveHelperArray[i]);
            }
        }
        Collections.sort(this.pdHelperList, new PhysicalDriveSizeComparator());
        long l = ((SASPhysicalDrive)this.pdHelperList.get(0).getDeviceObject()).getcoercedSize();
        long l2 = (long)this.pdHelperList.size() * l;
        this.m_bootVolumeCreationPanel.iConfigurableSize = l2 / 2L;
        double d = this.m_bootVolumeCreationPanel.iConfigurableSize / 2L;
        if (l2 > 0L) {
            this.m_bootVolumeCreationPanel.m_maxSize = KernelConstants.getSizeInSpecifiedUnit(d, 999, 3, physicalDriveHelperArray[0].getUserDataBlockSize());
        }
    }

    class PhysicalDriveSizeComparator
    implements Comparator {
        PhysicalDriveSizeComparator() {
        }

        public int compare(Object object, Object object2) {
            long l;
            long l2 = ((PhysicalDriveHelper)object).getSize();
            if (l2 < (l = ((PhysicalDriveHelper)object2).getSize())) {
                return -1;
            }
            if (l2 > l) {
                return 1;
            }
            return 0;
        }
    }
}

