/*
 * Decompiled with CFR 0.152.
 */
package GUI.CSA;

import GUI.VivaldiStartupDialog;
import GUI.venus.configuration.advanced.AdvanceConfigEngine;
import GUI.venus.configuration.advanced.DriveGroup;
import GUI.venus.configuration.advanced.VirtualDrive;
import GUI.venus.configuration.simple.SimpleConfigEngine;
import GUI.venus.configuration.simple.SimpleConfigParams;
import GUIHelper.AdapterHelper;
import Services.KernelConstants;
import Utils.Resource;
import java.text.MessageFormat;
import java.util.List;

public class CSAConfigSummaryGenerator {
    private static final String TABS_5 = "\t\t\t\t\t";
    private static final String TABS_4 = "\t\t\t\t";
    private static final String TABS_3 = "\t\t\t";
    private static final String TABS_2 = "\t\t";
    private static final String TABS_1 = "\t";
    private static final String NEW_LINE = "\n";
    private AdvanceConfigEngine m_objAdvConfigEngine = null;
    private AdapterHelper m_objAdapterHelper = null;
    private SimpleConfigEngine m_objSimpleConfigEngine = null;
    private SimpleConfigParams m_simpleConfigParams = null;

    public CSAConfigSummaryGenerator(AdvanceConfigEngine advanceConfigEngine) {
        this.m_objAdvConfigEngine = advanceConfigEngine;
        CSAConfigSummaryGenerator cSAConfigSummaryGenerator = this;
        this.m_objAdapterHelper = cSAConfigSummaryGenerator.m_objAdvConfigEngine.getAdapterHelper();
    }

    public CSAConfigSummaryGenerator(SimpleConfigEngine simpleConfigEngine) {
        this.m_objSimpleConfigEngine = simpleConfigEngine;
        this.m_objAdapterHelper = this.m_objSimpleConfigEngine.getAdapterHelper();
        this.m_simpleConfigParams = simpleConfigEngine.getSimpleConfigParams();
    }

    public String getConfigSummaryText() {
        Object[] objectArray = null;
        StringBuffer stringBuffer = new StringBuffer();
        if (this.m_objSimpleConfigEngine != null) {
            stringBuffer.append(Resource.getString("SUMMARY_TEXT_RAID_LEVEL", "RAID Level:"));
            stringBuffer.append(TABS_4);
            stringBuffer.append("RAID 1");
            stringBuffer.append(NEW_LINE);
            stringBuffer.append(Resource.getString("NO_OF_VDRIVES", "Number of " + Resource.getString("VIRTUAL_DRIVES_TEXT", "virtual drives") + " : "));
            if (VivaldiStartupDialog.isWindows) {
                stringBuffer.append(TABS_2);
            } else {
                stringBuffer.append(TABS_3);
            }
            stringBuffer.append("2");
            stringBuffer.append(NEW_LINE);
            stringBuffer.append("Cache Volume Capacity");
            if (VivaldiStartupDialog.isWindows) {
                stringBuffer.append(TABS_2);
            } else {
                stringBuffer.append(TABS_3);
            }
            stringBuffer.append(KernelConstants.getConvertedSize(this.m_objSimpleConfigEngine.getCacheVolumeSize(), this.m_simpleConfigParams.getPDListForDriveGroup().get(0).getUserDataBlockSize()));
            stringBuffer.append(NEW_LINE);
            stringBuffer.append("Boot Volume Capacity");
            if (VivaldiStartupDialog.isWindows) {
                stringBuffer.append(TABS_2);
            } else {
                stringBuffer.append(TABS_3);
            }
            stringBuffer.append(KernelConstants.getConvertedSize(this.m_objSimpleConfigEngine.getBootVolumeSize(), this.m_simpleConfigParams.getPDListForDriveGroup().get(0).getUserDataBlockSize()));
            stringBuffer.append(NEW_LINE);
        } else {
            List<DriveGroup> list = this.m_objAdvConfigEngine.getNewlyCreatedDriveGroups();
            for (int n = 0; n < list.size(); n = (int)((byte)(n + 1))) {
                DriveGroup driveGroup = list.get(n);
                List<VirtualDrive> list2 = driveGroup.getVirtualDrives();
                if (list2 != null && !list2.isEmpty()) {
                    stringBuffer.append(Resource.getString("CSA_SUMMARY_TEXT_DG_NAME", "Nytro\u2122 drive group name:"));
                    stringBuffer.append(TABS_3);
                    stringBuffer.append(driveGroup.getDriveGroupName());
                    stringBuffer.append(NEW_LINE);
                    stringBuffer.append(Resource.getString("SUMMARY_TEXT_RAID_LEVEL", "RAID level:"));
                    stringBuffer.append(TABS_5);
                    stringBuffer.append(driveGroup.getRaidLevelString());
                    stringBuffer.append(NEW_LINE);
                    if (driveGroup.getRaidLevel() <= 17) {
                        stringBuffer.append(Resource.getString("SUMMARY_NO_OF_DRIVES_USED", "Number of drives used:"));
                        stringBuffer.append(TABS_4);
                        stringBuffer.append(driveGroup.getSpans().get(0).getNumberOfDrives());
                    }
                    stringBuffer.append(NEW_LINE);
                    stringBuffer.append(Resource.getString("SUMMARY_TEXT_TOTAL_CAPACITY", "Total capacity:"));
                    stringBuffer.append(TABS_5);
                    long l = driveGroup.getTotalCapacityInBlocks();
                    stringBuffer.append(KernelConstants.getConvertedSize(l));
                    stringBuffer.append(NEW_LINE);
                    stringBuffer.append(Resource.getString("SUMMARY_TEXT_FREE_CAPACITY", "Free capacity:"));
                    stringBuffer.append(TABS_5);
                    long l2 = driveGroup.getFreeSizeInBlocks();
                    stringBuffer.append(KernelConstants.getConvertedSize(l2));
                    stringBuffer.append(NEW_LINE);
                    for (int n2 = 0; n2 < list2.size(); n2 = (int)((byte)(n2 + 1))) {
                        stringBuffer.append(NEW_LINE);
                        VirtualDrive virtualDrive = list2.get(n2);
                        objectArray = new Object[]{n2 + 1};
                        stringBuffer.append(MessageFormat.format(Resource.getString("CSA_SUMMARY_TEXT_VD_NAME", "Nytro\u2122 Cache Drive {0} name:"), objectArray));
                        if (VivaldiStartupDialog.isSolaris) {
                            stringBuffer.append(TABS_4);
                        } else {
                            stringBuffer.append(TABS_3);
                        }
                        stringBuffer.append(virtualDrive.getName());
                        stringBuffer.append(NEW_LINE);
                        stringBuffer.append(Resource.getString("SUMMARY_TEXT_CAPACITY", "Capacity:"));
                        stringBuffer.append(TABS_5);
                        long l3 = virtualDrive.getSize();
                        stringBuffer.append(KernelConstants.getConvertedSize(l3));
                        stringBuffer.append(NEW_LINE);
                        stringBuffer.append(Resource.getResourceMnemonic(Resource.getString("LABEL_WRITE_POLICY", "(W)rite policy:"))[0]);
                        stringBuffer.append(TABS_5);
                        byte by = virtualDrive.getWritePolicy();
                        String string = "";
                        if (by == 0) {
                            string = Resource.getString("CACHECADE_WRITE_THROUGH", "Write Through");
                        } else if (by == 1) {
                            string = Resource.getString("CACHECADE_WRITE_BACK", "Write Back");
                        }
                        stringBuffer.append(string);
                    }
                }
                stringBuffer.append(NEW_LINE);
                stringBuffer.append(NEW_LINE);
            }
        }
        return stringBuffer.toString();
    }
}

