/*
 * Decompiled with CFR 0.152.
 */
package GUI.CSA;

import GUI.CSA.CSAConfigSummaryGenerator;
import GUI.CSA.CSAConfigurationSummaryPanel;
import GUI.venus.configuration.advanced.AdvanceConfigEngine;
import GUI.venus.configuration.simple.SimpleConfigEngine;
import GUI.venus.configuration.simple.SimpleConfigParams;
import GUI.venus.wizard.DefaultWizardPage;
import GUIHelper.AdapterHelper;
import KernelExceptions.VKOperationFailedException;
import Utils.HelpContext;
import Utils.HelpContextResourse;
import Utils.HelpException;
import Utils.HelpInterface;
import Utils.Resource;
import java.awt.Image;
import java.awt.Toolkit;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class CSAConfigurationSummaryPage
extends DefaultWizardPage
implements HelpInterface {
    private AdapterHelper m_objAdapterHelper = null;
    private CSAConfigurationSummaryPanel m_objSummaryPanel = null;
    private AdvanceConfigEngine m_objAdvConfigEngine = null;
    private SimpleConfigParams m_simpleParams = null;
    private SimpleConfigEngine m_objSimpleConfigEngine = null;
    private boolean m_isCacheAndBootOption = false;

    public CSAConfigurationSummaryPage() {
        this.m_isFinishWizardPage = true;
    }

    @Override
    protected void reinitialise() {
        CSAConfigSummaryGenerator cSAConfigSummaryGenerator;
        String string = null;
        this.m_strHelpFileName = "MSM_CSA_MANUAL_CONFIGURATION";
        this.m_objAdapterHelper = (AdapterHelper)this.m_hmWizardData.get("AdapterHelper");
        String string2 = (String)this.m_hmWizardData.get("SelectedMode");
        if (string2 != null) {
            this.m_isCacheAndBootOption = string2.equals("CacheAndBoot");
        }
        if (this.m_isCacheAndBootOption) {
            this.m_strHelpFileName = "MSM_CSA_CACHING_AND_BOOT_OPTION";
            cSAConfigSummaryGenerator = null;
            this.m_simpleParams = (SimpleConfigParams)this.m_hmWizardData.get("SimpleConfigParams");
            if (this.m_simpleParams != null) {
                this.m_objSimpleConfigEngine = new SimpleConfigEngine(this.m_objAdapterHelper);
                this.m_objSimpleConfigEngine.setSimpleConfigParams(this.m_simpleParams);
                this.m_objSimpleConfigEngine.setCacheAndBootVDSize();
                cSAConfigSummaryGenerator = new CSAConfigSummaryGenerator(this.m_objSimpleConfigEngine);
                string = cSAConfigSummaryGenerator.getConfigSummaryText();
            }
        } else {
            this.m_strHelpFileName = "MSM_CSA_ONLY_CACHING_OPTION";
            this.m_objAdvConfigEngine = (AdvanceConfigEngine)this.m_hmWizardData.get("AdvanceConfigEngine");
            cSAConfigSummaryGenerator = new CSAConfigSummaryGenerator(this.m_objAdvConfigEngine);
            string = cSAConfigSummaryGenerator.getConfigSummaryText();
        }
        if (this.m_objSummaryPanel == null) {
            this.m_objSummaryPanel = new CSAConfigurationSummaryPanel(string);
        } else {
            this.m_objSummaryPanel.setSummaryText(string);
        }
        try {
            HelpContext.registerHelp(this);
        }
        catch (HelpException helpException) {
            helpException.printStackTrace();
        }
    }

    @Override
    public JPanel getContentPanel() {
        return this.m_objSummaryPanel;
    }

    @Override
    public String getPageID() {
        return "CSAConfigurationSummaryPage";
    }

    @Override
    public String getTitle() {
        return Resource.getString("CSA_CREATE_VD_CONFIG_SUMMARY_TITLE", "Create Nytro\u2122 Cache Drive - Summary");
    }

    @Override
    public void onNext() {
        JDialog jDialog;
        Image image = Toolkit.getDefaultToolkit().getImage(Resource.getString("LSI_PROGRAM_ICON_16", "16_prg_icon.png"));
        JOptionPane jOptionPane = null;
        String string = null;
        boolean bl = false;
        try {
            if (this.m_objAdvConfigEngine != null) {
                this.m_objAdvConfigEngine.writeConfiguration();
            } else {
                this.m_objSimpleConfigEngine.fireConfigCommand();
            }
            jOptionPane = new JOptionPane(Resource.getString("CSA_CONFIG_SUCCESS_MSG", "The Nytro\u2122 Cache Drive(s) were successfully created."), 1);
            string = Resource.getString("CSA_CONFIG_SUCCESS_TITLE", "Create Nytro\u2122 Cache - Complete");
        }
        catch (VKOperationFailedException vKOperationFailedException) {
            jOptionPane = new JOptionPane("Cannot create configuration: " + Integer.toHexString(vKOperationFailedException.GetErrorCode()), 0);
            string = Resource.getString("CONFIG_FAILED_TITLE", "Create Configuration Failed.");
            vKOperationFailedException.printStackTrace();
            bl = true;
        }
        catch (Exception exception) {
            jOptionPane = new JOptionPane("Cannot create configuration: " + exception.getMessage(), 0);
            string = Resource.getString("CONFIG_FAILED_TITLE", " Create Configuration Failed.");
            exception.printStackTrace();
            bl = true;
        }
        if (bl) {
            jDialog = jOptionPane.createDialog(string);
            jDialog.setIconImage(image);
            jDialog.setVisible(true);
            this.dispose();
            super.onNext();
            return;
        }
        jDialog = jOptionPane.createDialog(string);
        jDialog.setIconImage(image);
        jDialog.setVisible(true);
        this.dispose();
        super.onNext();
    }

    @Override
    public String getHelpPage() {
        return HelpContextResourse.getHelpPageName(this.m_strHelpFileName);
    }
}

