/*
 * Decompiled with CFR 0.152.
 */
package GUI.CSA;

import GUI.CSA.CSAPDTableToTreePanel;
import GUI.VivaldiStartupDialog;
import GUI.venus.configuration.advanced.DriveGroup;
import GUI.venus.configuration.advanced.RaidLevelComboBoxModel;
import GUI.venus.configuration.advanced.Span;
import GUI.venus.configuration.advanced.UnconfiguredDrivesDisabler;
import GUI.venus.configuration.advanced.UnconfiguredDrivesTableModel;
import GUI.venus.wizard.DefaultWizardPage;
import GUIHelper.AdapterHelper;
import GUIHelper.ArrayHelper;
import GUIHelper.GUIHelperInterface;
import GUIHelper.PhysicalDriveHelper;
import SASKernel.LibraryAPI.StoreLib.MR_CTRL_INFO;
import SASKernel.LibraryAPI.StoreLib.MR_MFC_DEFAULTS;
import SASKernel.LibraryAPI.StoreLib.pdsForRaidLevels_MR_CTRL_INFO;
import SASKernel.SASAdapter.SASAdapter;
import SASKernel.SASPhysical.SASPhysicalDrive;
import Services.KernelConstants;
import Utils.Resource;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class CSADriveGroupsTreePanel
extends JPanel {
    public static byte MAX_SSD_ALLOWED_FOR_CACHEPOOL = (byte)32;
    private AdapterHelper m_objAdapterHelper = null;
    private pdsForRaidLevels_MR_CTRL_INFO m_pdsForRaidLevel = null;
    private String[] mnemonics;
    private int m_iUnconfGoodPdListSize = 0;
    private ArrayList<PhysicalDriveHelper> m_unconfGoodPdList = null;
    private JComboBox m_raidLevelComboBox = null;
    private JTree m_driveGroupsTree = null;
    private DefaultMutableTreeNode m_rootNode = null;
    private DefaultTreeModel m_driveGroupsTreeModel = null;
    private DefaultWizardPage m_DefWizardPage = null;
    private CSAPDTableToTreePanel m_pdTableToTreePanel = null;
    private UnconfiguredDrivesTableModel m_unconfGoodPdTableModel = null;
    private UnconfiguredDrivesDisabler m_unconfDrivesDisabler = null;
    private JButton m_createDriveGroupButton = null;
    protected DefaultTreeCellRenderer renderer = new DefaultTreeCellRenderer(){

        @Override
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            Object object2 = ((DefaultMutableTreeNode)object).getUserObject();
            if (object2 == null) {
                return this;
            }
            if (!VivaldiStartupDialog.isWindows) {
                this.setForeground(Color.black);
            }
            if (object2 instanceof GUIHelperInterface) {
                GUIHelperInterface gUIHelperInterface = (GUIHelperInterface)object2;
                if (gUIHelperInterface instanceof PhysicalDriveHelper) {
                    PhysicalDriveHelper physicalDriveHelper = (PhysicalDriveHelper)gUIHelperInterface;
                    this.setText(physicalDriveHelper.getTextForTable()[0] + ": " + physicalDriveHelper.getTextForTable()[1] + ": " + physicalDriveHelper.getTextForTable()[2]);
                    if (physicalDriveHelper.isDedicatedHotSpare()) {
                        this.setIcon(new ImageIcon(Toolkit.getDefaultToolkit().getImage(ClassLoader.getSystemResource(Resource.getString("HOTSPARE_IMAGE", "hotspare.png")))));
                    } else {
                        this.setIcon(gUIHelperInterface.getIcon());
                    }
                } else if (gUIHelperInterface instanceof AdapterHelper) {
                    this.setIcon(gUIHelperInterface.getIcon());
                }
            } else {
                if (object2 instanceof DriveGroup) {
                    this.setText(((DriveGroup)object2).getCSACacheCadeText());
                    try {
                        this.setIcon(new ImageIcon(Toolkit.getDefaultToolkit().getImage(ClassLoader.getSystemResource(((DriveGroup)object2).getSSCDIcon()))));
                    }
                    catch (Exception exception) {
                        System.out.println(".getTreeCellRendererComponent()");
                        return null;
                    }
                }
                if (object2 instanceof Span) {
                    this.setText(((Span)object2).getText());
                    try {
                        this.setIcon(new ImageIcon(Toolkit.getDefaultToolkit().getImage(ClassLoader.getSystemResource(((Span)object2).getIcon()))));
                    }
                    catch (Exception exception) {
                        System.out.println(".getTreeCellRendererComponent()");
                        return null;
                    }
                }
            }
            return this;
        }
    };

    public CSADriveGroupsTreePanel(AdapterHelper adapterHelper, JComboBox jComboBox, DefaultWizardPage defaultWizardPage) {
        this.m_objAdapterHelper = adapterHelper;
        this.m_raidLevelComboBox = jComboBox;
        this.m_pdsForRaidLevel = this.m_objAdapterHelper.getAdapterInfo().getpdsForRaidLevels_MR_CTRL_INFO();
        this.m_DefWizardPage = defaultWizardPage;
        this.buildPanel();
    }

    private void buildPanel() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.m_rootNode = new DefaultMutableTreeNode(this.m_objAdapterHelper);
        this.m_driveGroupsTreeModel = new DefaultTreeModel(this.m_rootNode);
        this.m_driveGroupsTree = new JTree(this.m_driveGroupsTreeModel);
        this.m_driveGroupsTree.getSelectionModel().setSelectionMode(1);
        JScrollPane jScrollPane = new JScrollPane(this.m_driveGroupsTree, 20, 30);
        jScrollPane.setPreferredSize(new Dimension(250, 250));
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.insets = new Insets(20, 10, 0, 10);
        gridBagConstraints.gridwidth = 3;
        this.mnemonics = Resource.getResourceMnemonic(Resource.getString("CSA_LABEL_DRIVE_GROUPS", "Nytro\u2122 Drive (g)roups:"));
        JLabel jLabel = new JLabel(this.mnemonics[0]);
        if (this.mnemonics.length == 2) {
            jLabel.setDisplayedMnemonic(this.mnemonics[1].charAt(0));
            jLabel.setLabelFor(jScrollPane);
        }
        this.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridheight = 5;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.insets = new Insets(0, 10, 10, 10);
        this.m_driveGroupsTree.setCellRenderer(this.renderer);
        CSADriveGroupsTreePanel.expandTree(this.m_driveGroupsTree);
        this.add((Component)jScrollPane, gridBagConstraints);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.mnemonics = Resource.getResourceMnemonic(Resource.getString("BUTTON_CREATE_DG", "(C)reate Drive Group"));
        this.m_createDriveGroupButton = new JButton(this.mnemonics[0]);
        if (this.mnemonics.length == 2) {
            this.m_createDriveGroupButton.setMnemonic(this.mnemonics[1].charAt(0));
        }
        this.m_createDriveGroupButton.setEnabled(false);
        this.add((Component)this.m_createDriveGroupButton, gridBagConstraints);
        this.m_createDriveGroupButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = CSADriveGroupsTreePanel.this.m_rootNode.getChildCount();
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)CSADriveGroupsTreePanel.this.m_rootNode.getChildAt(n - 1);
                Object object = defaultMutableTreeNode.getUserObject();
                if (object instanceof DriveGroup) {
                    DriveGroup driveGroup = (DriveGroup)object;
                    driveGroup.setTotalCapacityInBlocks(CSADriveGroupsTreePanel.this.getTotalCapacityInBlocks(defaultMutableTreeNode));
                    driveGroup.setAsCompleted(true);
                    defaultMutableTreeNode.setUserObject(driveGroup);
                    CSADriveGroupsTreePanel.this.m_driveGroupsTreeModel.nodeChanged(defaultMutableTreeNode);
                    if (driveGroup.getRaidLevel() > 17) {
                        // empty if block
                    }
                    if (CSADriveGroupsTreePanel.this.m_pdTableToTreePanel != null) {
                        ((RaidLevelComboBoxModel)CSADriveGroupsTreePanel.this.m_raidLevelComboBox.getModel()).updateRaidLevelModel(CSADriveGroupsTreePanel.this.m_pdTableToTreePanel.getUnconfiguredGoodPdListSize());
                    }
                    if (CSADriveGroupsTreePanel.this.m_iUnconfGoodPdListSize == 0 || !CSADriveGroupsTreePanel.this.canMoreDgsBeCreated()) {
                        CSADriveGroupsTreePanel.this.m_raidLevelComboBox.setEnabled(false);
                    } else {
                        CSADriveGroupsTreePanel.this.m_raidLevelComboBox.setEnabled(true);
                    }
                    if (CSADriveGroupsTreePanel.this.getDgCount() > 0 && CSADriveGroupsTreePanel.this.isPreviousDgNodeCompleted()) {
                        CSADriveGroupsTreePanel.this.addDriveGroupNodeToTree();
                    }
                } else {
                    System.out.println("m_createDriveGroupButton.actionPerformed()");
                }
                CSADriveGroupsTreePanel.this.m_createDriveGroupButton.setEnabled(false);
                CSADriveGroupsTreePanel.this.m_DefWizardPage.setNextButtonStatus(true);
            }
        });
    }

    public void setUnconfiguredDrivesDisabler(UnconfiguredDrivesDisabler unconfiguredDrivesDisabler) {
        this.m_unconfDrivesDisabler = unconfiguredDrivesDisabler;
    }

    public void addPdNodeToTree(PhysicalDriveHelper physicalDriveHelper) {
        this.m_DefWizardPage.setNextButtonStatus(false);
        DefaultMutableTreeNode defaultMutableTreeNode = this.getLastDgNode();
        DriveGroup driveGroup = (DriveGroup)defaultMutableTreeNode.getUserObject();
        byte by = driveGroup.getRaidLevel();
        if (by <= 17) {
            this.addPdNodeToTree(physicalDriveHelper, defaultMutableTreeNode);
            this.m_createDriveGroupButton.setEnabled(this.isCreateDgForPrlEnabled(defaultMutableTreeNode));
        }
    }

    public void addDriveGroupNodeToTree() {
        DriveGroup driveGroup = new DriveGroup((byte)this.m_rootNode.getChildCount(), false);
        this.addDriveGroupNodeToTree(driveGroup);
    }

    public void addDriveGroupNodeToTree(DriveGroup driveGroup) {
        driveGroup.setAdapterHelper(this.m_objAdapterHelper);
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(driveGroup);
        this.m_driveGroupsTreeModel.insertNodeInto(defaultMutableTreeNode, this.m_rootNode, this.m_rootNode.getChildCount());
        this.m_driveGroupsTree.setSelectionPath(new TreePath(defaultMutableTreeNode.getPath()));
        CSADriveGroupsTreePanel.expandTree(this.m_driveGroupsTree);
    }

    public void addSpanNodeToTree() {
        DefaultMutableTreeNode defaultMutableTreeNode = this.getLastDgNode();
        DriveGroup driveGroup = (DriveGroup)defaultMutableTreeNode.getUserObject();
        Span span = new Span(driveGroup, (byte)defaultMutableTreeNode.getChildCount());
        this.addSpanNodeToTree(span, defaultMutableTreeNode);
    }

    public void addSpanNodeToTree(Span span, DefaultMutableTreeNode defaultMutableTreeNode) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(span);
        this.m_driveGroupsTreeModel.insertNodeInto(defaultMutableTreeNode2, defaultMutableTreeNode, defaultMutableTreeNode.getChildCount());
        this.m_driveGroupsTree.setSelectionPath(new TreePath(defaultMutableTreeNode2.getPath()));
        CSADriveGroupsTreePanel.expandTree(this.m_driveGroupsTree);
    }

    public void addPdNodeToTree(PhysicalDriveHelper physicalDriveHelper, DefaultMutableTreeNode defaultMutableTreeNode) {
        this.m_driveGroupsTreeModel.insertNodeInto(new DefaultMutableTreeNode(physicalDriveHelper), defaultMutableTreeNode, defaultMutableTreeNode.getChildCount());
        CSADriveGroupsTreePanel.expandTree(this.m_driveGroupsTree);
    }

    public void setEnabledCreateDriveGroupButton(boolean bl) {
        this.m_createDriveGroupButton.setEnabled(bl);
    }

    public int getDgCount() {
        return this.m_rootNode.getChildCount();
    }

    public JTree getDriveGroupsTree() {
        return this.m_driveGroupsTree;
    }

    public DefaultMutableTreeNode getRootNode() {
        return this.m_rootNode;
    }

    public DefaultMutableTreeNode getSelectedNodeFromTree() {
        TreePath treePath = this.m_driveGroupsTree.getLeadSelectionPath();
        if (treePath == null) {
            return null;
        }
        return (DefaultMutableTreeNode)treePath.getLastPathComponent();
    }

    public DefaultMutableTreeNode getLastDgNode() {
        return (DefaultMutableTreeNode)this.m_rootNode.getChildAt(this.m_rootNode.getChildCount() - 1);
    }

    public DriveGroup getLastDgObject() {
        return (DriveGroup)this.getLastDgNode().getUserObject();
    }

    public DefaultMutableTreeNode getLastSpanNode() {
        DefaultMutableTreeNode defaultMutableTreeNode = this.getLastDgNode();
        return (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(defaultMutableTreeNode.getChildCount() - 1);
    }

    public Span getLastSpanObject() {
        return (Span)this.getLastSpanNode().getUserObject();
    }

    public DefaultMutableTreeNode getLastPdNode() {
        DefaultMutableTreeNode defaultMutableTreeNode = this.getLastDgNode();
        if (this.getLastDgObject().getRaidLevel() <= 17) {
            return (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(defaultMutableTreeNode.getChildCount() - 1);
        }
        DefaultMutableTreeNode defaultMutableTreeNode2 = this.getLastSpanNode();
        return (DefaultMutableTreeNode)defaultMutableTreeNode2.getChildAt(defaultMutableTreeNode2.getChildCount() - 1);
    }

    public PhysicalDriveHelper getLastPdObject() {
        return (PhysicalDriveHelper)this.getLastPdNode().getUserObject();
    }

    public boolean isPreviousDgNodeCompleted() {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.m_rootNode.getChildAt(this.m_rootNode.getChildCount() - 1);
        DriveGroup driveGroup = (DriveGroup)defaultMutableTreeNode.getUserObject();
        return driveGroup.isCompleted();
    }

    public boolean canPdsBeAdded(int[] nArray) {
        int n;
        Object object;
        MR_CTRL_INFO mR_CTRL_INFO = this.m_objAdapterHelper.getAdapterInfo();
        int n2 = 0;
        ArrayHelper[] arrayHelperArray = this.m_objAdapterHelper.getArrays();
        if (arrayHelperArray != null) {
            for (ArrayHelper arrayHelper : arrayHelperArray) {
                if (!arrayHelper.isSSCD()) continue;
                n2 += arrayHelper.getPhysicalDrives().length;
            }
        }
        double d = 0.0;
        int n3 = 0;
        int n4 = this.m_rootNode.getChildCount();
        if (!this.getLastDgObject().isCompleted()) {
            --n4;
        }
        for (int i = 0; i < n4; ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.m_rootNode.getChildAt(i);
            object = (DriveGroup)defaultMutableTreeNode.getUserObject();
            d += (double)((DriveGroup)object).getTotalCapacityInBlocks();
            n3 += defaultMutableTreeNode.getChildCount();
        }
        d = KernelConstants.getSizeInSpecifiedUnit(d, 999, 3);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < nArray.length; ++i) {
            object = this.m_unconfGoodPdList.get(nArray[i]);
            if (arrayList.contains(object)) continue;
            arrayList.add(object);
        }
        DefaultMutableTreeNode defaultMutableTreeNode = this.getLastDgNode();
        int n5 = defaultMutableTreeNode.getChildCount();
        DefaultMutableTreeNode[] defaultMutableTreeNodeArray = new DefaultMutableTreeNode[n5];
        for (n = 0; n < n5; ++n) {
            defaultMutableTreeNodeArray[n] = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(n);
            PhysicalDriveHelper physicalDriveHelper = (PhysicalDriveHelper)defaultMutableTreeNodeArray[n].getUserObject();
            if (arrayList.contains(physicalDriveHelper)) continue;
            arrayList.add(physicalDriveHelper);
        }
        n = arrayList.size();
        if (n2 + n3 + n > MAX_SSD_ALLOWED_FOR_CACHEPOOL) {
            return false;
        }
        double d2 = mR_CTRL_INFO.getMaxSSCsize() - mR_CTRL_INFO.getcurrentSSCsize();
        return d < d2;
    }

    public long getTotalCapacityInBlocks(DefaultMutableTreeNode defaultMutableTreeNode) {
        DriveGroup driveGroup = (DriveGroup)defaultMutableTreeNode.getUserObject();
        byte by = driveGroup.getRaidLevel();
        long l = -1L;
        if (by <= 17) {
            int n = defaultMutableTreeNode.getChildCount();
            for (int i = 0; i < n; ++i) {
                PhysicalDriveHelper physicalDriveHelper = (PhysicalDriveHelper)((DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i)).getUserObject();
                long l2 = ((SASPhysicalDrive)physicalDriveHelper.getDeviceObject()).getInformation().getcoercedSize();
                if (l >= 0L && l2 >= l) continue;
                l = l2;
            }
            switch (by) {
                case 0: 
                case 7: {
                    return l * (long)n;
                }
                case 1: 
                case 17: {
                    return l * (long)n / 2L;
                }
                case 5: {
                    return l * (long)(n - 1);
                }
                case 6: {
                    return l * (long)(n - 2);
                }
            }
        }
        return 0L;
    }

    public static void expandTree(JTree jTree) {
        int n = 0;
        do {
            jTree.expandRow(n);
        } while (++n < jTree.getRowCount());
    }

    public void addTreeSelectionListener(TreeSelectionListener treeSelectionListener) {
        this.m_driveGroupsTree.addTreeSelectionListener(treeSelectionListener);
    }

    public void setUnconfGoodPdListSize(int n) {
        this.m_iUnconfGoodPdListSize = n;
    }

    public void setUnconfGoodPdList(ArrayList<PhysicalDriveHelper> arrayList) {
        this.m_unconfGoodPdList = arrayList;
        this.setUnconfGoodPdListSize(this.m_unconfGoodPdList.size());
    }

    public void setUnconfGoodPdTableModel(UnconfiguredDrivesTableModel unconfiguredDrivesTableModel) {
        this.m_unconfGoodPdTableModel = unconfiguredDrivesTableModel;
    }

    public boolean canMoreDgsBeCreated() {
        MR_CTRL_INFO mR_CTRL_INFO = this.m_objAdapterHelper.getAdapterInfo();
        char c = mR_CTRL_INFO.getmaxArrays();
        int n = this.m_objAdapterHelper.getArrays().length;
        int n2 = 0;
        int n3 = this.m_rootNode.getChildCount();
        if (!this.getLastDgObject().isCompleted()) {
            --n3;
        }
        double d = 0.0;
        for (int i = 0; i < n3; ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.m_rootNode.getChildAt(i);
            DriveGroup driveGroup = (DriveGroup)defaultMutableTreeNode.getUserObject();
            d += (double)driveGroup.getTotalCapacityInBlocks();
            if (driveGroup.getRaidLevel() > 17) continue;
            ++n2;
        }
        d = KernelConstants.getSizeInSpecifiedUnit(d, 999, 3);
        double d2 = mR_CTRL_INFO.getMaxSSCsize() - mR_CTRL_INFO.getcurrentSSCsize();
        return n2 + n < c && d < d2;
    }

    public ArrayList<PhysicalDriveHelper> getPdListForSpanNode(DefaultMutableTreeNode defaultMutableTreeNode) {
        int n = defaultMutableTreeNode.getChildCount();
        ArrayList<PhysicalDriveHelper> arrayList = new ArrayList<PhysicalDriveHelper>();
        for (int i = 0; i < n; ++i) {
            arrayList.add((PhysicalDriveHelper)((DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i)).getUserObject());
        }
        return arrayList;
    }

    public void setPdTableToTreePanel(CSAPDTableToTreePanel cSAPDTableToTreePanel) {
        this.m_pdTableToTreePanel = cSAPDTableToTreePanel;
    }

    public boolean isCreateDgForPrlEnabled(DefaultMutableTreeNode defaultMutableTreeNode) {
        int n = defaultMutableTreeNode.getChildCount();
        DriveGroup driveGroup = (DriveGroup)defaultMutableTreeNode.getUserObject();
        switch (driveGroup.getRaidLevel()) {
            case 0: {
                if (n < this.m_pdsForRaidLevel.getMinPdRAIDLevel_0() || n > this.m_pdsForRaidLevel.getMaxPdRAIDLevel_0()) break;
                return true;
            }
            case 1: 
            case 7: {
                MR_MFC_DEFAULTS mR_MFC_DEFAULTS;
                if (((SASAdapter)this.m_objAdapterHelper.getDeviceObject()).getAdapterType() == 3) {
                    if (!this.m_objAdapterHelper.getAdapterInfo().getadapterOperations_MR_CTRL_INFO().isSupportOddEvenIn1E() && n % 2 == 1) {
                        return false;
                    }
                    try {
                        mR_MFC_DEFAULTS = ((SASAdapter)this.m_objAdapterHelper.getDeviceObject()).getMFCDefaults();
                        if (mR_MFC_DEFAULTS.gettreatR1EAsR10() == 0 ? n >= this.m_pdsForRaidLevel.getMinPdRaidLevel_1E_RLQ0() && n <= this.m_pdsForRaidLevel.getMaxPdRaidLevel_1E_RLQ0() : n >= this.m_pdsForRaidLevel.getMinPdRAIDLevel_1() && n <= this.m_pdsForRaidLevel.getMaxPdRAIDLevel_1()) {
                            return true;
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                if (VivaldiStartupDialog.OEM_TYPE == 2561) {
                    try {
                        mR_MFC_DEFAULTS = ((SASAdapter)this.m_objAdapterHelper.getDeviceObject()).getMFCDefaults();
                        if (mR_MFC_DEFAULTS.gettreatR1EAsR10() == 1 && (n == 22 || n == 26)) {
                            return true;
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    if (n < this.m_pdsForRaidLevel.getMinPdRAIDLevel_1() || n > this.m_pdsForRaidLevel.getMaxPdRAIDLevel_1()) break;
                    return true;
                }
                if ((n < this.m_pdsForRaidLevel.getMinPdRAIDLevel_1() || n > this.m_pdsForRaidLevel.getMaxPdRAIDLevel_1()) && (n < this.m_pdsForRaidLevel.getMinPdRaidLevel_1E_RLQ0() || n > this.m_pdsForRaidLevel.getMaxPdRaidLevel_1E_RLQ0()) || n % 2 != 0) break;
                return true;
            }
            case 17: {
                if (((SASAdapter)this.m_objAdapterHelper.getDeviceObject()).getAdapterType() == 3) {
                    if (!this.m_objAdapterHelper.getAdapterInfo().getadapterOperations_MR_CTRL_INFO().isSupportOddEvenIn1E() && n % 2 == 1) {
                        return false;
                    }
                    if (n < this.m_pdsForRaidLevel.getMinPdRaidLevel_1E_RLQ0() || n > this.m_pdsForRaidLevel.getMaxPdRaidLevel_1E_RLQ0()) break;
                    return true;
                }
                if (n < this.m_pdsForRaidLevel.getMinPdRAIDLevel_1E() || n > this.m_pdsForRaidLevel.getMaxPdRAIDLevel_1E()) break;
                return true;
            }
            case 5: {
                if (n < this.m_pdsForRaidLevel.getMinPdRAIDLevel_5()) break;
                return true;
            }
            case 6: {
                if (!(VivaldiStartupDialog.OEM_TYPE == 2561 ? n >= 4 : n >= this.m_pdsForRaidLevel.getMinPdRaidLevel_6())) break;
                return true;
            }
        }
        return false;
    }
}

