/*
 * Decompiled with CFR 0.152.
 */
package GUI.CSA;

import GUI.CSA.CSADriveGroupSelectionPanel;
import GUI.venus.configuration.advanced.AdvanceConfigEngine;
import GUI.venus.configuration.advanced.DGHoleTableModel;
import GUI.venus.configuration.advanced.DriveGroup;
import GUI.venus.configuration.advanced.SpanHole;
import GUI.venus.configuration.advanced.VirtualDrive;
import GUI.venus.wizard.DefaultWizardPage;
import GUIHelper.AdapterHelper;
import GUIHelper.PhysicalDriveHelper;
import Utils.HelpContext;
import Utils.HelpContextResourse;
import Utils.HelpException;
import Utils.HelpInterface;
import Utils.Resource;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class CSAHolesUnconfigPdSelectionPage
extends DefaultWizardPage
implements HelpInterface {
    private AdapterHelper m_adapterHelper = null;
    private CSADriveGroupSelectionPanel m_driveGroupSelectionPanel = null;
    private int holeCount;
    private int rowCount;
    private AdvanceConfigEngine m_engine = null;
    private SpanHole m_currentlySelectedSpanHole = null;
    private DriveGroup m_currentlySelectedDG = null;
    private DGHoleTableModel m_dgHoleTableModel = null;

    @Override
    protected void reinitialise() {
        this.m_adapterHelper = (AdapterHelper)this.m_hmWizardData.get("AdapterHelper");
        this.m_strHelpFileName = "MSM_CSA_MANUAL_CONFIGURATION";
        if (this.m_driveGroupSelectionPanel != null) {
            if (this.m_dgHoleTableModel == null) {
                this.constructArrayHoleTableModelForCSA();
            }
            this.m_driveGroupSelectionPanel.initData(this.m_dgHoleTableModel);
        }
        try {
            HelpContext.registerHelp(this);
        }
        catch (HelpException helpException) {
            helpException.printStackTrace();
        }
    }

    @Override
    public JPanel getContentPanel() {
        if (this.m_driveGroupSelectionPanel == null) {
            this.constructArrayHoleTableModelForCSA();
            this.m_driveGroupSelectionPanel = new CSADriveGroupSelectionPanel(this.m_dgHoleTableModel);
        }
        this.m_hmWizardData.put("HoleAndGDVisited", false);
        this.setUnconfiguredButton();
        this.m_driveGroupSelectionPanel.buildPanel();
        this.m_driveGroupSelectionPanel.addItemListener(new RadioButtonItemListener());
        this.m_driveGroupSelectionPanel.addListSelectionListener(new ArrayTableListListener());
        return this.m_driveGroupSelectionPanel;
    }

    @Override
    public String getPageID() {
        return "CSAHolesUnconfigPdSelectionPage";
    }

    @Override
    public String getTitle() {
        return Resource.getString("CSA_HOLE_UNCONFIGPD_SELECTION_PAGE_TITLE", "Create Nytro\u2122 Cache Drive - Allocate capacity");
    }

    public void setUnconfiguredButton() {
        if (this.m_adapterHelper.getUnconfiguredGoodSSDDrives() != null) {
            this.m_driveGroupSelectionPanel.m_unconfigPds = true;
        }
    }

    @Override
    public void onNext() {
        this.m_iTrigger = this.m_driveGroupSelectionPanel.getSelectionOption();
        if (this.m_iTrigger == 0) {
            SpanHole spanHole = this.m_driveGroupSelectionPanel.getSelectedSpanHole();
            List<DriveGroup> list = this.m_engine.getNewlyCreatedDriveGroups();
            if (list != null && ((Boolean)this.m_hmWizardData.get("HoleAndGDVisited")).booleanValue()) {
                int n = list.size();
                for (int i = 0; i < n; ++i) {
                    this.m_engine.removeDriveGroup(list.get(0));
                }
                this.m_hmWizardData.put("HoleAndGDVisited", false);
                this.m_hmWizardData.put("HoleSelectionChanged", true);
            }
            if (this.m_currentlySelectedSpanHole == null) {
                this.m_currentlySelectedSpanHole = spanHole;
                this.m_currentlySelectedDG = spanHole.getSpan().getDriveGroup();
                this.m_currentlySelectedDG.setSelectedSpanHoleIndex(spanHole.getFreeCapacityIndex());
                List<DriveGroup> list2 = this.m_engine.getNewlyCreatedDriveGroups();
                if (list2 == null || list2.isEmpty()) {
                    this.m_engine.addNewDriveGroup(this.m_currentlySelectedDG);
                    this.m_currentlySelectedDG.setisSSC(true);
                }
                this.m_hmWizardData.put("SelectedSpanHole", this.m_currentlySelectedSpanHole);
            } else {
                DriveGroup driveGroup = spanHole.getSpan().getDriveGroup();
                if (this.m_currentlySelectedDG.equals(driveGroup)) {
                    if (this.m_currentlySelectedSpanHole.equals(spanHole)) {
                        this.m_hmWizardData.put("HoleSelectionChanged", false);
                    } else {
                        this.m_currentlySelectedDG.setSelectedSpanHoleIndex(spanHole.getFreeCapacityIndex());
                        this.m_currentlySelectedSpanHole = spanHole;
                        this.m_hmWizardData.put("HoleSelectionChanged", true);
                        this.m_hmWizardData.put("SelectedSpanHole", spanHole);
                        List<VirtualDrive> list3 = driveGroup.getVirtualDrives();
                        if (list3 != null && !list3.isEmpty()) {
                            for (int i = 0; i < list3.size(); ++i) {
                                this.m_engine.returnLDTargetId(list3.get(i).getTargetId());
                            }
                            list3.clear();
                        }
                    }
                } else {
                    this.m_engine.removeDriveGroup(this.m_currentlySelectedDG);
                    this.m_currentlySelectedDG = driveGroup;
                    this.m_currentlySelectedSpanHole = spanHole;
                    this.m_hmWizardData.put("HoleSelectionChanged", true);
                    this.m_hmWizardData.put("SelectedSpanHole", spanHole);
                    this.m_currentlySelectedDG.setSelectedSpanHoleIndex(spanHole.getFreeCapacityIndex());
                    this.m_engine.addNewDriveGroup(driveGroup);
                    this.m_currentlySelectedDG.setisSSC(true);
                }
            }
            this.m_iTrigger = 2;
        } else if (this.m_iTrigger == 1) {
            this.m_hmWizardData.remove("SelectedSpanHole");
            this.m_currentlySelectedSpanHole = null;
            this.m_hmWizardData.put("HoleAndGDVisited", true);
            if (this.m_currentlySelectedDG != null) {
                this.m_engine.removeDriveGroup(this.m_currentlySelectedDG);
            }
            this.m_hmWizardData.put("DGsModified", true);
            this.m_iTrigger = 3;
        }
        super.onNext();
    }

    public void constructArrayHoleTableModelForCSA() {
        ArrayList<SpanHole> arrayList = new ArrayList<SpanHole>();
        this.m_engine = (AdvanceConfigEngine)this.m_hmWizardData.get("AdvanceConfigEngine");
        List<DriveGroup> list = this.m_engine.getExistingDriveGroups();
        if (list != null && !list.isEmpty()) {
            for (int n = 0; n < list.size(); n = (int)((byte)(n + 1))) {
                List<SpanHole> list2;
                if (list.get(n).getSpanDepth() != 1 || (list2 = list.get(n).getSpanHoles()) == null || list2.isEmpty()) continue;
                int n2 = 0;
                int n3 = 0;
                for (int i = 0; i < list2.size(); ++i) {
                    List<PhysicalDriveHelper> list3 = list2.get(i).getSpan().getPhysicalDrivesList();
                    n3 += list3.size();
                    for (int j = 0; j < list3.size(); ++j) {
                        if (!list3.get(j).isSSDDrive()) continue;
                        ++n2;
                    }
                }
                if (n2 != n3) continue;
                arrayList.addAll(list2);
            }
        }
        this.m_dgHoleTableModel = new DGHoleTableModel(arrayList);
    }

    @Override
    public String getHelpPage() {
        return HelpContextResourse.getHelpPageName(this.m_strHelpFileName);
    }

    class ArrayTableListListener
    implements ListSelectionListener {
        ArrayTableListListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            JTable jTable = CSAHolesUnconfigPdSelectionPage.this.m_driveGroupSelectionPanel.getDriveGroupTable();
            CSAHolesUnconfigPdSelectionPage.this.setNextButtonStatus(jTable.getSelectedRow() != -1);
        }
    }

    class RadioButtonItemListener
    implements ItemListener {
        RadioButtonItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            JRadioButton jRadioButton = (JRadioButton)itemEvent.getSource();
            JTable jTable = CSAHolesUnconfigPdSelectionPage.this.m_driveGroupSelectionPanel.getDriveGroupTable();
            if (jRadioButton.isSelected()) {
                jTable.setEnabled(true);
                CSAHolesUnconfigPdSelectionPage.this.setNextButtonStatus(false);
            } else {
                jTable.clearSelection();
                jTable.setEnabled(false);
                CSAHolesUnconfigPdSelectionPage.this.setNextButtonStatus(true);
            }
        }
    }
}

