/*
 * Decompiled with CFR 0.152.
 */
package GUI.CSA;

import GUI.CSA.CSADriveGroupsTreePanel;
import GUI.venus.configuration.advanced.AdvanceConfigEngine;
import GUI.venus.configuration.advanced.DriveGroup;
import GUI.venus.configuration.advanced.RaidLevelComboBoxModel;
import GUI.venus.configuration.advanced.Span;
import GUI.venus.configuration.advanced.UnconfiguredDrivesDisabler;
import GUI.venus.configuration.advanced.UnconfiguredDrivesTableModel;
import GUI.venus.configuration.advanced.UnconfiguredPdTableCellRender;
import GUI.venus.wizard.DefaultWizardPage;
import GUIHelper.AdapterHelper;
import GUIHelper.PhysicalDriveHelper;
import Services.KernelConstants;
import Utils.Resource;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.TableRowSorter;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class CSAPDTableToTreePanel
extends JPanel {
    private AdapterHelper m_objAdapterHelper = null;
    private ArrayList<PhysicalDriveHelper> m_unconfiguredGoodPdList = new ArrayList();
    private ArrayList<PhysicalDriveHelper> m_pdListForThisDriveGroup = new ArrayList();
    private AdvanceConfigEngine m_objAdvConfigengine = null;
    public JTable m_unconfiguredDrivesTable = null;
    private JComboBox m_raidLevelComboBox = null;
    private JButton m_addButton = new JButton();
    private JButton m_removeButton = new JButton();
    private CSADriveGroupsTreePanel m_dgTreePanel = null;
    private UnconfiguredDrivesTableModel m_unconfGoodPdTableModel = null;
    private DefaultWizardPage m_defWizardPage = null;
    private boolean m_isPdSelected = false;
    private String[] mnemonics;
    private UnconfiguredDrivesDisabler m_unconfDriveDisabler = null;

    public CSAPDTableToTreePanel(AdvanceConfigEngine advanceConfigEngine, JComboBox jComboBox, CSADriveGroupsTreePanel cSADriveGroupsTreePanel, DefaultWizardPage defaultWizardPage) {
        this.m_objAdvConfigengine = advanceConfigEngine;
        this.m_objAdapterHelper = advanceConfigEngine.getAdapterHelper();
        this.m_raidLevelComboBox = jComboBox;
        this.m_dgTreePanel = cSADriveGroupsTreePanel;
        this.m_defWizardPage = defaultWizardPage;
        this.m_dgTreePanel.addTreeSelectionListener(new DriveGroupTreeSelectionListener());
        PhysicalDriveHelper[] physicalDriveHelperArray = this.m_objAdapterHelper.getUnconfiguredPhysicalDrives();
        for (int i = 0; i < physicalDriveHelperArray.length; ++i) {
            if (physicalDriveHelperArray[i].getInformation().getproperties_MR_PD_INFO().getIneligibleForSSCD() != 0) continue;
            this.m_unconfiguredGoodPdList.add(physicalDriveHelperArray[i]);
        }
        this.m_dgTreePanel.setUnconfGoodPdList(this.m_unconfiguredGoodPdList);
        this.m_unconfGoodPdTableModel = new UnconfiguredDrivesTableModel(this.m_unconfiguredGoodPdList);
        cSADriveGroupsTreePanel.setUnconfGoodPdTableModel(this.m_unconfGoodPdTableModel);
        this.buildPanel();
        this.m_dgTreePanel.setPdTableToTreePanel(this);
    }

    public void buildPanel() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 18;
        this.m_unconfiguredDrivesTable = new JTable(this.m_unconfGoodPdTableModel){

            @Override
            public String getToolTipText(MouseEvent mouseEvent) {
                Point point = mouseEvent.getPoint();
                int n = this.rowAtPoint(point);
                int n2 = this.columnAtPoint(point);
                if (n2 == 0) {
                    return ((PhysicalDriveHelper)this.getValueAt(n, n2)).getTextForTable()[0];
                }
                if (n2 == 1) {
                    return this.getValueAt(n, n2).toString();
                }
                if (n2 == 2) {
                    return KernelConstants.getConvertedSize(((Long)this.getValueAt(n, n2)).longValue());
                }
                return "";
            }
        };
        JScrollPane jScrollPane = new JScrollPane(this.m_unconfiguredDrivesTable, 20, 30);
        jScrollPane.setPreferredSize(new Dimension(250, 250));
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.insets = new Insets(20, 10, 0, 10);
        gridBagConstraints.gridwidth = 3;
        this.mnemonics = Resource.getResourceMnemonic(Resource.getString("CSA_LABEL_SELECT_UG_DRIVES", "Select (U)nconfigured Flash Modules:"));
        JLabel jLabel = new JLabel(this.mnemonics[0]);
        if (this.mnemonics.length == 2) {
            jLabel.setDisplayedMnemonic(this.mnemonics[1].charAt(0));
            jLabel.setLabelFor(jScrollPane);
        }
        this.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridheight = 5;
        gridBagConstraints.insets = new Insets(0, 10, 10, 10);
        gridBagConstraints.gridwidth = 3;
        this.add((Component)jScrollPane, gridBagConstraints);
        this.m_unconfDriveDisabler = new UnconfiguredDrivesDisabler(this.m_unconfiguredDrivesTable, this.m_objAdapterHelper);
        this.m_dgTreePanel.setUnconfiguredDrivesDisabler(this.m_unconfDriveDisabler);
        this.m_unconfiguredDrivesTable.setShowGrid(false);
        this.m_unconfiguredDrivesTable.setCellSelectionEnabled(false);
        this.m_unconfiguredDrivesTable.setSelectionMode(2);
        this.m_unconfiguredDrivesTable.setRowSelectionAllowed(true);
        this.m_unconfiguredDrivesTable.setAutoResizeMode(0);
        this.m_unconfiguredDrivesTable.setAutoscrolls(true);
        this.m_unconfiguredDrivesTable.setColumnSelectionAllowed(false);
        this.m_unconfiguredDrivesTable.getTableHeader().setReorderingAllowed(false);
        this.m_unconfiguredDrivesTable.getTableHeader().setResizingAllowed(true);
        this.m_unconfiguredDrivesTable.setAutoCreateRowSorter(true);
        ((TableRowSorter)this.m_unconfiguredDrivesTable.getRowSorter()).setSortable(0, false);
        this.m_unconfiguredDrivesTable.getColumnModel().getColumn(0).setPreferredWidth(150);
        this.m_unconfiguredDrivesTable.getColumnModel().getColumn(1).setPreferredWidth(50);
        this.m_unconfiguredDrivesTable.getColumnModel().getColumn(2).setPreferredWidth(50);
        UnconfiguredPdTableCellRender unconfiguredPdTableCellRender = new UnconfiguredPdTableCellRender();
        this.m_unconfiguredDrivesTable.setDefaultRenderer(PhysicalDriveHelper.class, unconfiguredPdTableCellRender);
        this.m_unconfiguredDrivesTable.setDefaultRenderer(String.class, unconfiguredPdTableCellRender);
        this.m_unconfiguredDrivesTable.setDefaultRenderer(Long.class, unconfiguredPdTableCellRender);
        class UnconfDrivesTableListSelectionListener
        implements ListSelectionListener {
            UnconfDrivesTableListSelectionListener() {
            }

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                CSAPDTableToTreePanel.this.m_addButton.setEnabled(true);
                CSAPDTableToTreePanel.this.m_isPdSelected = true;
                int[] nArray = CSAPDTableToTreePanel.this.m_unconfiguredDrivesTable.getSelectedRows();
                int n = nArray.length;
                int n2 = 0;
                ArrayList<Integer> arrayList = CSAPDTableToTreePanel.this.m_unconfGoodPdTableModel.getDisableRows();
                for (int i = 0; i < n; ++i) {
                    if (arrayList != null && arrayList.contains(nArray[i])) {
                        ++n2;
                    }
                    nArray[i] = CSAPDTableToTreePanel.this.m_unconfiguredDrivesTable.convertRowIndexToModel(nArray[i]);
                }
                if (nArray.length == 0) {
                    CSAPDTableToTreePanel.this.m_addButton.setEnabled(false);
                } else if ((Byte)CSAPDTableToTreePanel.this.m_raidLevelComboBox.getSelectedItem() >= 0 && CSAPDTableToTreePanel.this.m_dgTreePanel.canPdsBeAdded(nArray) && n2 != n) {
                    CSAPDTableToTreePanel.this.m_addButton.setEnabled(true);
                } else {
                    CSAPDTableToTreePanel.this.m_addButton.setEnabled(false);
                }
            }
        }
        this.m_unconfiguredDrivesTable.getSelectionModel().addListSelectionListener(new UnconfDrivesTableListSelectionListener());
        JPanel jPanel = new JPanel(new GridLayout(2, 1, 5, 5));
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(0, 10, 0, 10);
        this.mnemonics = Resource.getResourceMnemonic(Resource.getString("BUTTON_ADD_DRIVE", "(A)dd >"));
        this.m_addButton.setText(this.mnemonics[0]);
        if (this.mnemonics.length == 2) {
            this.m_addButton.setMnemonic(this.mnemonics[1].charAt(0));
        }
        this.m_addButton.setEnabled(false);
        jPanel.add(this.m_addButton);
        this.mnemonics = Resource.getResourceMnemonic(Resource.getString("BUTTON_REMOVE_DRIVE", "< Remo(v)e"));
        this.m_removeButton.setText(this.mnemonics[0]);
        if (this.mnemonics.length == 2) {
            this.m_removeButton.setMnemonic(this.mnemonics[1].charAt(0));
        }
        this.m_removeButton.setEnabled(false);
        jPanel.add(this.m_removeButton);
        this.add((Component)jPanel, gridBagConstraints);
        this.m_addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n;
                CSAPDTableToTreePanel.this.m_defWizardPage.setNextButtonStatus(false);
                int[] nArray = CSAPDTableToTreePanel.this.m_unconfiguredDrivesTable.getSelectedRows();
                int n2 = nArray.length;
                ArrayList<Integer> arrayList = CSAPDTableToTreePanel.this.m_unconfGoodPdTableModel.getDisableRows();
                boolean bl = false;
                for (n = 0; n < n2; ++n) {
                    bl = arrayList != null && arrayList.contains(nArray[n]);
                    nArray[n] = CSAPDTableToTreePanel.this.m_unconfiguredDrivesTable.convertRowIndexToModel(nArray[n]);
                    if (bl) continue;
                    CSAPDTableToTreePanel.this.m_pdListForThisDriveGroup.add(CSAPDTableToTreePanel.this.m_unconfiguredGoodPdList.get(nArray[n]));
                }
                if (CSAPDTableToTreePanel.this.m_unconfiguredGoodPdList.size() == 0) {
                    for (n = 0; n < n2; ++n) {
                        CSAPDTableToTreePanel.this.m_pdListForThisDriveGroup.add(CSAPDTableToTreePanel.this.m_unconfiguredGoodPdList.get(nArray[n]));
                    }
                }
                for (n = 0; n < CSAPDTableToTreePanel.this.m_pdListForThisDriveGroup.size(); ++n) {
                    CSAPDTableToTreePanel.this.m_dgTreePanel.addPdNodeToTree((PhysicalDriveHelper)CSAPDTableToTreePanel.this.m_pdListForThisDriveGroup.get(n));
                }
                CSAPDTableToTreePanel.this.m_unconfiguredGoodPdList.removeAll(CSAPDTableToTreePanel.this.m_pdListForThisDriveGroup);
                CSAPDTableToTreePanel.this.m_dgTreePanel.setUnconfGoodPdList(CSAPDTableToTreePanel.this.m_unconfiguredGoodPdList);
                CSAPDTableToTreePanel.this.m_unconfGoodPdTableModel.updateModel(CSAPDTableToTreePanel.this.m_unconfiguredGoodPdList);
                CSAPDTableToTreePanel.this.m_pdListForThisDriveGroup.clear();
                CSAPDTableToTreePanel.this.m_raidLevelComboBox.setEnabled(false);
                CSAPDTableToTreePanel.this.m_addButton.setEnabled(false);
                CSAPDTableToTreePanel.this.m_isPdSelected = false;
            }
        });
        this.m_removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CSAPDTableToTreePanel.this.m_removeButton.setEnabled(false);
                JTree jTree = CSAPDTableToTreePanel.this.m_dgTreePanel.getDriveGroupsTree();
                DefaultTreeModel defaultTreeModel = (DefaultTreeModel)jTree.getModel();
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)jTree.getLeadSelectionPath().getLastPathComponent();
                Object object = defaultMutableTreeNode.getUserObject();
                if (object instanceof DriveGroup) {
                    DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(0);
                    Object object2 = defaultMutableTreeNode2.getUserObject();
                    DriveGroup driveGroup = (DriveGroup)object;
                    if (object2 instanceof PhysicalDriveHelper) {
                        int n;
                        int n2 = defaultMutableTreeNode.getChildCount();
                        DefaultMutableTreeNode[] defaultMutableTreeNodeArray = new DefaultMutableTreeNode[n2];
                        for (n = 0; n < n2; ++n) {
                            defaultMutableTreeNodeArray[n] = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(n);
                            PhysicalDriveHelper physicalDriveHelper = (PhysicalDriveHelper)defaultMutableTreeNodeArray[n].getUserObject();
                            if (CSAPDTableToTreePanel.this.m_pdListForThisDriveGroup.contains(physicalDriveHelper)) continue;
                            CSAPDTableToTreePanel.this.m_pdListForThisDriveGroup.add(physicalDriveHelper);
                        }
                        CSAPDTableToTreePanel.this.m_unconfiguredGoodPdList.addAll(CSAPDTableToTreePanel.this.m_pdListForThisDriveGroup);
                        CSAPDTableToTreePanel.this.m_dgTreePanel.setUnconfGoodPdList(CSAPDTableToTreePanel.this.m_unconfiguredGoodPdList);
                        CSAPDTableToTreePanel.this.m_unconfGoodPdTableModel.updateModel(CSAPDTableToTreePanel.this.m_unconfiguredGoodPdList);
                        if (!((DriveGroup)object).isCompleted()) {
                            for (n = 0; n < n2; ++n) {
                                defaultTreeModel.removeNodeFromParent(defaultMutableTreeNodeArray[n]);
                            }
                            CSAPDTableToTreePanel.this.m_raidLevelComboBox.setEnabled(true);
                            ((RaidLevelComboBoxModel)CSAPDTableToTreePanel.this.m_raidLevelComboBox.getModel()).updateRaidLevelModel(CSAPDTableToTreePanel.this.getUnconfiguredGoodPdListSize());
                            CSAPDTableToTreePanel.this.m_raidLevelComboBox.setSelectedIndex(0);
                            CSAPDTableToTreePanel.this.m_defWizardPage.setNextButtonStatus(false);
                        } else if (((DriveGroup)object).isCompleted()) {
                            DefaultMutableTreeNode defaultMutableTreeNode3 = CSAPDTableToTreePanel.this.m_dgTreePanel.getLastDgNode();
                            byte by = -1;
                            if (((DriveGroup)defaultMutableTreeNode3.getUserObject()).isCompleted()) {
                                CSAPDTableToTreePanel.this.m_raidLevelComboBox.setEnabled(true);
                                ((RaidLevelComboBoxModel)CSAPDTableToTreePanel.this.m_raidLevelComboBox.getModel()).updateRaidLevelModel(CSAPDTableToTreePanel.this.getUnconfiguredGoodPdListSize());
                                CSAPDTableToTreePanel.this.m_defWizardPage.setNextButtonStatus(true);
                                by = -1;
                            } else {
                                by = CSAPDTableToTreePanel.this.m_dgTreePanel.getLastDgObject().getRaidLevel();
                                if (defaultMutableTreeNode3.getChildCount() == 0) {
                                    CSAPDTableToTreePanel.this.m_raidLevelComboBox.setEnabled(true);
                                    ((RaidLevelComboBoxModel)CSAPDTableToTreePanel.this.m_raidLevelComboBox.getModel()).updateRaidLevelModel(CSAPDTableToTreePanel.this.getUnconfiguredGoodPdListSize());
                                    CSAPDTableToTreePanel.this.m_defWizardPage.setNextButtonStatus(true);
                                } else {
                                    CSAPDTableToTreePanel.this.m_raidLevelComboBox.setEnabled(false);
                                    CSAPDTableToTreePanel.this.m_defWizardPage.setNextButtonStatus(false);
                                }
                            }
                            CSAPDTableToTreePanel.this.m_raidLevelComboBox.setSelectedItem(by);
                            defaultTreeModel.removeNodeFromParent(defaultMutableTreeNode);
                        }
                    } else if (object2 instanceof Span) {
                        // empty if block
                    }
                    DefaultMutableTreeNode defaultMutableTreeNode4 = CSAPDTableToTreePanel.this.m_dgTreePanel.getRootNode();
                    int n = defaultMutableTreeNode4.getChildCount();
                    for (int i = 0; i < n; ++i) {
                        DefaultMutableTreeNode defaultMutableTreeNode5 = (DefaultMutableTreeNode)defaultMutableTreeNode4.getChildAt(i);
                        DriveGroup driveGroup2 = (DriveGroup)defaultMutableTreeNode5.getUserObject();
                        driveGroup2.setDriveGroupId(i);
                    }
                    CSAPDTableToTreePanel.this.m_dgTreePanel.getDriveGroupsTree().setSelectionPath(new TreePath(CSAPDTableToTreePanel.this.m_dgTreePanel.getLastDgNode().getPath()));
                    CSAPDTableToTreePanel.this.m_objAdvConfigengine.removeDriveGroup((DriveGroup)object);
                    if (CSAPDTableToTreePanel.this.m_dgTreePanel.getRootNode().getChildCount() == 1 && CSAPDTableToTreePanel.this.m_dgTreePanel.getLastDgNode().getChildCount() == 0) {
                        CSAPDTableToTreePanel.this.m_defWizardPage.setNextButtonStatus(false);
                    }
                } else if (!(object instanceof Span) && object instanceof PhysicalDriveHelper) {
                    CSAPDTableToTreePanel.this.m_unconfiguredGoodPdList.add((PhysicalDriveHelper)object);
                    CSAPDTableToTreePanel.this.m_dgTreePanel.setUnconfGoodPdList(CSAPDTableToTreePanel.this.m_unconfiguredGoodPdList);
                    CSAPDTableToTreePanel.this.m_unconfGoodPdTableModel.updateModel(CSAPDTableToTreePanel.this.m_unconfiguredGoodPdList);
                    byte by = CSAPDTableToTreePanel.this.m_dgTreePanel.getLastDgObject().getRaidLevel();
                    DefaultMutableTreeNode defaultMutableTreeNode6 = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
                    Object object3 = defaultMutableTreeNode6.getUserObject();
                    defaultTreeModel.removeNodeFromParent(defaultMutableTreeNode);
                    if (object3 instanceof DriveGroup) {
                        CSAPDTableToTreePanel.this.m_dgTreePanel.setEnabledCreateDriveGroupButton(CSAPDTableToTreePanel.this.m_dgTreePanel.isCreateDgForPrlEnabled(defaultMutableTreeNode6));
                        CSAPDTableToTreePanel.this.m_raidLevelComboBox.setSelectedItem(((DriveGroup)object3).getRaidLevel());
                        if (defaultMutableTreeNode6.getChildCount() == 0) {
                            CSAPDTableToTreePanel.this.m_raidLevelComboBox.setEnabled(true);
                            ((RaidLevelComboBoxModel)CSAPDTableToTreePanel.this.m_raidLevelComboBox.getModel()).updateRaidLevelModel(CSAPDTableToTreePanel.this.getUnconfiguredGoodPdListSize());
                            if (CSAPDTableToTreePanel.this.m_dgTreePanel.getRootNode().getChildCount() == 0) {
                                CSAPDTableToTreePanel.this.m_defWizardPage.setNextButtonStatus(false);
                            } else {
                                CSAPDTableToTreePanel.this.m_defWizardPage.setNextButtonStatus(true);
                            }
                        }
                    } else if (object3 instanceof Span) {
                        // empty if block
                    }
                    CSAPDTableToTreePanel.this.m_dgTreePanel.getDriveGroupsTree().setSelectionPath(new TreePath(defaultMutableTreeNode6.getPath()));
                    CSAPDTableToTreePanel.this.m_raidLevelComboBox.setSelectedItem(by);
                }
                CSAPDTableToTreePanel.this.m_pdListForThisDriveGroup.clear();
            }
        });
    }

    public int getUnconfiguredGoodPdListSize() {
        return this.m_unconfiguredGoodPdList.size();
    }

    public ArrayList<PhysicalDriveHelper> getUnconfiguredGoodPdList() {
        return this.m_unconfiguredGoodPdList;
    }

    public UnconfiguredDrivesDisabler getUnconfiguredDrivesDisabler() {
        return this.m_unconfDriveDisabler;
    }

    public void setEnabledAddButton(boolean bl) {
        this.m_addButton.setEnabled(bl);
    }

    public void setEnabledRemoveButton(boolean bl) {
        this.m_removeButton.setEnabled(bl);
    }

    public boolean isPdSelectedFromTable() {
        return this.m_isPdSelected;
    }

    public void reset() {
        this.m_unconfiguredDrivesTable.clearSelection();
        this.m_isPdSelected = false;
    }

    class DriveGroupTreeSelectionListener
    implements TreeSelectionListener {
        DriveGroupTreeSelectionListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            DefaultMutableTreeNode defaultMutableTreeNode;
            Object object;
            Serializable serializable;
            Object object2;
            if (CSAPDTableToTreePanel.this.m_dgTreePanel.getRootNode().getChildCount() == 1 && !((DriveGroup)(object2 = (DriveGroup)((DefaultMutableTreeNode)(serializable = (DefaultMutableTreeNode)CSAPDTableToTreePanel.this.m_dgTreePanel.getRootNode().getChildAt(0))).getUserObject())).isCompleted()) {
                CSAPDTableToTreePanel.this.m_defWizardPage.setNextButtonStatus(false);
            }
            if ((object = ((DefaultMutableTreeNode)(object2 = (DefaultMutableTreeNode)((TreePath)(serializable = treeSelectionEvent.getPath())).getLastPathComponent())).getUserObject()) instanceof AdapterHelper) {
                CSAPDTableToTreePanel.this.m_removeButton.setEnabled(false);
            } else if (object instanceof DriveGroup) {
                int n = ((DefaultMutableTreeNode)object2).getChildCount();
                if (n == 0) {
                    CSAPDTableToTreePanel.this.m_removeButton.setEnabled(false);
                } else {
                    CSAPDTableToTreePanel.this.m_removeButton.setEnabled(true);
                }
                int[] nArray = CSAPDTableToTreePanel.this.m_unconfiguredDrivesTable.getSelectedRows();
                int n2 = nArray.length;
                for (int i = 0; i < n2; ++i) {
                    nArray[i] = CSAPDTableToTreePanel.this.m_unconfiguredDrivesTable.convertRowIndexToModel(nArray[i]);
                }
                if (CSAPDTableToTreePanel.this.m_raidLevelComboBox.getSelectedIndex() != -1) {
                    if (((DriveGroup)object).isCompleted()) {
                        CSAPDTableToTreePanel.this.m_addButton.setEnabled(false);
                        CSAPDTableToTreePanel.this.m_raidLevelComboBox.setEnabled(false);
                    } else if (!((DriveGroup)object).isCompleted()) {
                        if (((DriveGroup)object).getRaidLevel() <= 17) {
                            if (n == 0) {
                                CSAPDTableToTreePanel.this.m_raidLevelComboBox.setEnabled(true);
                            } else {
                                CSAPDTableToTreePanel.this.m_raidLevelComboBox.setEnabled(false);
                            }
                        }
                        if ((Byte)CSAPDTableToTreePanel.this.m_raidLevelComboBox.getSelectedItem() >= 0 && CSAPDTableToTreePanel.this.m_dgTreePanel.canPdsBeAdded(nArray)) {
                            CSAPDTableToTreePanel.this.m_addButton.setEnabled(true);
                        } else {
                            CSAPDTableToTreePanel.this.m_addButton.setEnabled(false);
                        }
                    }
                }
                if (CSAPDTableToTreePanel.this.m_unconfiguredGoodPdList.size() == 0 || !CSAPDTableToTreePanel.this.m_dgTreePanel.canMoreDgsBeCreated()) {
                    CSAPDTableToTreePanel.this.m_raidLevelComboBox.setEnabled(false);
                }
            } else if (!(object instanceof Span) && object instanceof PhysicalDriveHelper && (defaultMutableTreeNode = (DefaultMutableTreeNode)((DefaultMutableTreeNode)object2).getParent()) != null) {
                Object object3 = defaultMutableTreeNode.getUserObject();
                if (object3 instanceof DriveGroup) {
                    if (!((DriveGroup)object3).isCompleted()) {
                        CSAPDTableToTreePanel.this.m_removeButton.setEnabled(true);
                    } else {
                        CSAPDTableToTreePanel.this.m_removeButton.setEnabled(false);
                    }
                } else if (object3 instanceof Span) {
                    // empty if block
                }
            }
        }
    }
}

