/*
 * Decompiled with CFR 0.152.
 */
package GUI.CSA;

import GUI.venus.configuration.advanced.AdvanceConfigEngine;
import GUI.venus.configuration.advanced.Capacity;
import GUI.venus.configuration.advanced.DGVDTreePanel;
import GUI.venus.configuration.advanced.DriveGroup;
import GUI.venus.configuration.advanced.VirtualDrive;
import GUIHelper.AdapterHelper;
import SASKernel.LibraryAPI.StoreLib.MR_MFC_DEFAULTS;
import SASKernel.SASAdapter.SASAdapter;
import Services.KernelConstants;
import Utils.Resource;
import Wizard.UnitsComboBoxModel;
import Wizard.UnitsRenderer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class CSAVDCreationPanel
extends JPanel
implements AncestorListener {
    private AdapterHelper m_objAdapterHelper = null;
    private AdvanceConfigEngine m_objAdvConfigEngine = null;
    private DriveGroup m_objSelDriveGroup = null;
    private MR_MFC_DEFAULTS m_objMFCDefaults = null;
    private DGVDTreePanel m_dgTreePanel = null;
    private SpinnerNumberModel m_capacitySpinnerModel = null;
    private JSpinner m_capacitySpinner = null;
    private JTextField m_tfVDName = null;
    private UnitsComboBoxModel m_unitsComboModel = null;
    private JComboBox m_cmbBxUnits = null;
    private JComboBox m_cmbBxWritePolicy = null;
    private JLabel m_cmbBxWritePolicyDesc = new JLabel();
    private JButton m_btnCreateVirtualDrive = null;
    private JButton m_btnUpdateVirtualDrive = null;
    private JButton m_btnRemoveVirtualDrive = null;
    private JLabel m_capacityValueLbl = null;
    private JPanel vdInfoPanel = new JPanel();
    private GridBagConstraints vdInfoPanelGBC = new GridBagConstraints();
    private Object[] m_cmbObjs = null;
    private String m_strSuggestedVDName = null;
    private int m_iCurrentUnit = 3;
    private boolean m_isWritebackSupported = false;
    private List<ChangeListener> m_changeListeners = null;
    private DriveGroupTreeSelectionListener m_dgTreeSelectionListener = null;
    private double[] m_dMaxSizeAndUnit = null;
    private double[] m_dMinSizeAndUnit = null;
    private byte m_cStripeSize = 0;

    public CSAVDCreationPanel(AdvanceConfigEngine advanceConfigEngine, AdapterHelper adapterHelper) {
        this.m_objAdvConfigEngine = advanceConfigEngine;
        this.m_objAdapterHelper = adapterHelper;
        this.m_isWritebackSupported = adapterHelper.getAdapterInfo().getldOperations_MR_CTRL_INFO().isSupportSSCWriteBack();
        this.m_cmbObjs = !this.m_isWritebackSupported ? new Object[]{new Byte(0)} : new Object[]{new Byte(0), new Byte(1)};
        byte by = this.m_objAdvConfigEngine.getLDTargetId();
        this.m_strSuggestedVDName = "Nytro_Cache_" + by;
        this.m_objAdvConfigEngine.returnLDTargetId(by);
        List<DriveGroup> list = this.m_objAdvConfigEngine.getNewlyCreatedDriveGroups();
        this.m_objSelDriveGroup = list.get(0);
        this.m_dgTreePanel = new DGVDTreePanel(this.m_objAdapterHelper, list, true);
        this.m_dgTreePanel.scrollPane.setPreferredSize(new Dimension(250, 250));
        this.m_dgTreePanel.getDriveGroupTree().getModel().addTreeModelListener(new DriveGroupTreeModelListener());
        this.m_dgTreeSelectionListener = new DriveGroupTreeSelectionListener();
        this.m_dgTreePanel.addTreeSelectionListener(this.m_dgTreeSelectionListener);
        SASAdapter sASAdapter = (SASAdapter)this.m_objAdapterHelper.getDeviceObject();
        try {
            this.m_objMFCDefaults = sASAdapter.getMFCDefaults();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.m_cStripeSize = this.m_objMFCDefaults.getstripeSize();
        this.buildPanel();
    }

    public void initDriveGroups() {
        this.m_dgTreePanel.removeTreeSelectionListener(this.m_dgTreeSelectionListener);
        List<DriveGroup> list = this.m_objAdvConfigEngine.getNewlyCreatedDriveGroups();
        this.m_dgTreePanel.initData(list);
        this.m_dgTreePanel.addTreeSelectionListener(this.m_dgTreeSelectionListener);
        this.m_objSelDriveGroup = list.get(0);
        this.m_dgTreePanel.selectFirstFreeDGNode();
    }

    private void buildPanel() {
        String[] stringArray = null;
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 0, 10);
        this.add((Component)new JLabel(Resource.getString("CSA_LABEL_SPECIFY_PARAMS")), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        stringArray = Resource.getResourceMnemonic(Resource.getString("CSA_LABEL_DRIVE_GROUPS", "Nytro\u2122 Drive (g)roups:"));
        JLabel jLabel = new JLabel(stringArray[0]);
        if (stringArray.length == 2) {
            jLabel.setDisplayedMnemonic(stringArray[1].charAt(0));
            jLabel.setLabelFor(this.m_dgTreePanel.getDriveGroupTree());
        }
        this.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        this.add((Component)this.getVDParamPanel(), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        this.add((Component)this.m_dgTreePanel, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        JPanel jPanel = new JPanel(new FlowLayout(2));
        stringArray = Resource.getResourceMnemonic(Resource.getString("BUTTON_CREATE_VD", "(C)reate Virtual Drive"));
        this.m_btnCreateVirtualDrive = new JButton(stringArray[0]);
        if (stringArray.length == 2) {
            this.m_btnCreateVirtualDrive.setMnemonic(stringArray[1].charAt(0));
        }
        stringArray = Resource.getResourceMnemonic(Resource.getString("BUTTON_UPDATE_VD", "(U)pdate Virtual Drive"));
        this.m_btnUpdateVirtualDrive = new JButton(stringArray[0]);
        if (stringArray.length == 2) {
            this.m_btnUpdateVirtualDrive.setMnemonic(stringArray[1].charAt(0));
        }
        jPanel.add(this.m_btnUpdateVirtualDrive);
        jPanel.add(this.m_btnCreateVirtualDrive);
        this.m_btnCreateVirtualDrive.addActionListener(new CreateVDAction());
        this.m_btnUpdateVirtualDrive.addActionListener(new UpdateVDAction());
        this.add((Component)jPanel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 0;
        stringArray = Resource.getResourceMnemonic(Resource.getString("BUTTON_REMOVE_VD", "(R)emove Virtual Drive"));
        this.m_btnRemoveVirtualDrive = new JButton(stringArray[0]);
        if (stringArray.length == 2) {
            this.m_btnRemoveVirtualDrive.setMnemonic(stringArray[1].charAt(0));
        }
        this.m_btnRemoveVirtualDrive.addActionListener(new DeleteVDAction());
        this.add((Component)this.m_btnRemoveVirtualDrive, gridBagConstraints);
        JTree jTree = this.m_dgTreePanel.getDriveGroupTree();
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)jTree.getLeadSelectionPath().getLastPathComponent();
        Object object = defaultMutableTreeNode.getUserObject();
        if (object instanceof DriveGroup && ((DriveGroup)object).canAddVD()) {
            this.m_btnRemoveVirtualDrive.setEnabled(false);
            this.m_btnCreateVirtualDrive.setEnabled(true);
            this.m_btnUpdateVirtualDrive.setEnabled(false);
        } else {
            this.m_btnRemoveVirtualDrive.setEnabled(false);
            this.m_btnCreateVirtualDrive.setEnabled(false);
            this.m_btnUpdateVirtualDrive.setEnabled(false);
        }
        this.m_btnCreateVirtualDrive.addAncestorListener(this);
    }

    @Override
    public void ancestorAdded(AncestorEvent ancestorEvent) {
        if (this.m_btnCreateVirtualDrive.isEnabled()) {
            this.m_btnCreateVirtualDrive.requestFocusInWindow();
        } else {
            this.m_tfVDName.requestFocusInWindow();
        }
    }

    @Override
    public void ancestorMoved(AncestorEvent ancestorEvent) {
    }

    @Override
    public void ancestorRemoved(AncestorEvent ancestorEvent) {
    }

    private JPanel getVDParamPanel() {
        String[] stringArray = null;
        byte by = this.m_objSelDriveGroup.getRaidLevel();
        this.m_tfVDName = new JTextField(15);
        this.m_tfVDName.setText(this.m_strSuggestedVDName);
        stringArray = Resource.getResourceMnemonic(Resource.getString("LABEL_CSA_VD_NAME", "Nytro\u2122 Cac(h)e Drive name:"));
        JLabel jLabel = new JLabel(stringArray[0]);
        if (stringArray.length == 2) {
            jLabel.setDisplayedMnemonic(stringArray[1].charAt(0));
            jLabel.setLabelFor(this.m_tfVDName);
        }
        JPanel jPanel = new JPanel(new FlowLayout(3));
        Capacity capacity = this.m_objSelDriveGroup.getCapacity();
        this.m_dMaxSizeAndUnit = KernelConstants.getSizeAndUnit(capacity.getMaxSizeInBlocks());
        this.m_dMinSizeAndUnit = KernelConstants.getSizeAndUnit(capacity.getMinSizeInBlocks());
        if (this.m_dMaxSizeAndUnit[1] != this.m_dMinSizeAndUnit[1]) {
            this.m_dMinSizeAndUnit[0] = KernelConstants.getSizeInSpecifiedUnit(this.m_dMinSizeAndUnit[0], (int)this.m_dMinSizeAndUnit[1], (int)this.m_dMaxSizeAndUnit[1]);
            this.m_dMinSizeAndUnit[1] = this.m_dMaxSizeAndUnit[1];
        }
        this.m_iCurrentUnit = (int)this.m_dMaxSizeAndUnit[1];
        this.m_unitsComboModel = new UnitsComboBoxModel((int)this.m_dMaxSizeAndUnit[1]);
        this.m_capacitySpinnerModel = new SpinnerNumberModel(this.m_dMaxSizeAndUnit[0], this.m_dMinSizeAndUnit[0], this.m_dMaxSizeAndUnit[0], 1.0);
        this.m_capacitySpinner = new JSpinner(this.m_capacitySpinnerModel);
        this.m_capacitySpinner.setEnabled(false);
        stringArray = Resource.getResourceMnemonic(Resource.getString("LABEL_CAPACITY", "Capacit(y):"));
        JLabel jLabel2 = new JLabel(stringArray[0]);
        if (stringArray.length == 2) {
            jLabel2.setDisplayedMnemonic(stringArray[1].charAt(0));
            jLabel2.setLabelFor(this.m_capacitySpinner);
        }
        this.m_cmbBxUnits = new JComboBox(this.m_unitsComboModel);
        this.m_cmbBxUnits.setRenderer(new UnitsRenderer());
        this.m_cmbBxUnits.addItemListener(new UnitsChangeItemListener());
        this.m_cmbBxUnits.setEnabled(false);
        stringArray = Resource.getResourceMnemonic(Resource.getString("LABEL_UNITS", "Uni(t)s:"));
        JLabel jLabel3 = new JLabel(stringArray[0]);
        if (stringArray.length == 2) {
            jLabel3.setDisplayedMnemonic(stringArray[1].charAt(0));
            jLabel3.setLabelFor(this.m_cmbBxUnits);
        }
        jPanel.add(this.m_capacitySpinner);
        jPanel.add(jLabel3);
        jPanel.add(this.m_cmbBxUnits);
        this.vdInfoPanel = new JPanel(new GridBagLayout());
        int n = 0;
        this.vdInfoPanelGBC.gridx = 0;
        int n2 = n;
        n = (byte)(n + 1);
        this.vdInfoPanelGBC.gridy = n2;
        this.vdInfoPanelGBC.anchor = 17;
        this.vdInfoPanelGBC.insets = new Insets(5, 0, 10, 10);
        this.vdInfoPanel.add((Component)jLabel, this.vdInfoPanelGBC);
        this.vdInfoPanelGBC.gridx = 1;
        this.vdInfoPanel.add((Component)this.m_tfVDName, this.vdInfoPanelGBC);
        int n3 = n;
        n = (byte)(n + 1);
        this.vdInfoPanelGBC.gridy = n3;
        this.m_capacityValueLbl = new JLabel(KernelConstants.getConvertedSize(this.m_objSelDriveGroup.getCapacity().getMaxSizeInBlocks()));
        this.vdInfoPanel.add((Component)this.m_capacityValueLbl, this.vdInfoPanelGBC);
        this.vdInfoPanelGBC.gridx = 0;
        this.vdInfoPanel.add((Component)jLabel2, this.vdInfoPanelGBC);
        this.m_cmbBxWritePolicy = new JComboBox();
        if (this.m_isWritebackSupported) {
            this.m_cmbBxWritePolicy.addItem(this.m_cmbObjs[0]);
            this.m_cmbBxWritePolicy.addItem(this.m_cmbObjs[1]);
        } else {
            this.m_cmbBxWritePolicy.addItem(this.m_cmbObjs[0]);
        }
        this.m_cmbBxWritePolicy.setEnabled(this.m_isWritebackSupported);
        stringArray = Resource.getResourceMnemonic(Resource.getString("LABEL_WRITE_POLICY", "(W)rite policy:"));
        JLabel jLabel4 = new JLabel(stringArray[0]);
        if (stringArray.length == 2) {
            jLabel4.setDisplayedMnemonic(stringArray[1].charAt(0));
        }
        this.m_cmbBxWritePolicy.setRenderer(new LDWritePolicyRenderer());
        this.m_cmbBxWritePolicy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (CSAVDCreationPanel.this.m_cmbBxWritePolicy.getSelectedItem() == null) {
                    return;
                }
                byte by = (Byte)CSAVDCreationPanel.this.m_cmbBxWritePolicy.getSelectedItem();
                String string = null;
                if (by == 0) {
                    string = Resource.getString("CSA_CACHECADE_WRITE_THROUGH_SELECTED_DESC", "<html>Write Through means that the cache can only be used for reads.<br>It will not support any writes.</html>");
                } else if (by == 1) {
                    string = Resource.getString("CSA_CACHECADE_WRITE_BACK_SELECTED_DESC", "<html>Write Back means that the cache can be used for both read and <br>write I/O.<br><br>Important: If the Nytro\u2122 Cache drive becomes degraded, <br>the policy may temporarily change to read-only.</html>");
                }
                CSAVDCreationPanel.this.m_cmbBxWritePolicyDesc.setText(string);
                CSAVDCreationPanel.this.vdInfoPanel.remove(CSAVDCreationPanel.this.m_cmbBxWritePolicyDesc);
                CSAVDCreationPanel.this.vdInfoPanel.add((Component)CSAVDCreationPanel.this.m_cmbBxWritePolicyDesc, CSAVDCreationPanel.this.vdInfoPanelGBC);
            }
        });
        if (this.m_isWritebackSupported && by == 1) {
            this.m_cmbBxWritePolicy.setSelectedIndex(1);
        } else {
            this.m_cmbBxWritePolicy.setSelectedIndex(0);
        }
        if (by == 7) {
            this.m_cmbBxWritePolicy.setSelectedIndex(1);
            this.m_cmbBxWritePolicy.setEnabled(false);
        }
        int n4 = n;
        n = (byte)(n + 1);
        this.vdInfoPanelGBC.gridy = n4;
        this.vdInfoPanelGBC.gridx = 1;
        this.vdInfoPanel.add((Component)this.m_cmbBxWritePolicy, this.vdInfoPanelGBC);
        this.vdInfoPanelGBC.gridx = 0;
        this.vdInfoPanel.add((Component)jLabel4, this.vdInfoPanelGBC);
        int n5 = n;
        n = (byte)(n + 1);
        this.vdInfoPanelGBC.gridy = n5;
        this.vdInfoPanelGBC.gridx = 0;
        this.vdInfoPanelGBC.gridwidth = 2;
        this.vdInfoPanel.add((Component)this.m_cmbBxWritePolicyDesc, this.vdInfoPanelGBC);
        return this.vdInfoPanel;
    }

    private void resetVDPanelToSelectedDriveGroup() {
        if (this.m_objAdvConfigEngine.canAddNewVirtualDrive() && this.m_dgTreePanel.canCreateSSCD()) {
            this.m_tfVDName.setEnabled(true);
            this.m_cmbBxWritePolicy.setEnabled(true);
            byte by = this.m_objAdvConfigEngine.getLDTargetId();
            this.m_strSuggestedVDName = "Nytro_Cache_" + by;
            this.m_objAdvConfigEngine.returnLDTargetId(by);
            this.m_tfVDName.setText(this.m_strSuggestedVDName);
        } else {
            this.m_tfVDName.setText("");
            this.m_tfVDName.setEnabled(false);
            this.m_cmbBxWritePolicy.setEnabled(false);
        }
        if (!this.m_isWritebackSupported || this.m_objSelDriveGroup.getRaidLevel() == 7) {
            this.m_cmbBxWritePolicy.setEnabled(false);
        }
        if (this.m_objAdvConfigEngine.canAddNewVirtualDrive() && this.m_objSelDriveGroup.canAddVD()) {
            Capacity capacity = this.m_objSelDriveGroup.getCapacity();
            this.m_dMaxSizeAndUnit = KernelConstants.getSizeAndUnit(capacity.getMaxSizeInBlocks());
            this.m_dMinSizeAndUnit = KernelConstants.getSizeAndUnit(capacity.getMinSizeInBlocks());
            if (this.m_dMaxSizeAndUnit[1] != this.m_dMinSizeAndUnit[1]) {
                this.m_dMinSizeAndUnit[0] = KernelConstants.getSizeInSpecifiedUnit(this.m_dMinSizeAndUnit[0], (int)this.m_dMinSizeAndUnit[1], (int)this.m_dMaxSizeAndUnit[1]);
                this.m_dMinSizeAndUnit[1] = this.m_dMaxSizeAndUnit[1];
            }
            this.m_capacitySpinnerModel.setValue(0);
            this.m_capacityValueLbl.setText(KernelConstants.getConvertedSize(this.m_objSelDriveGroup.getCapacity().getMaxSizeInBlocks()));
            this.m_unitsComboModel.setUnit((int)this.m_dMaxSizeAndUnit[1]);
            this.m_iCurrentUnit = (int)this.m_dMaxSizeAndUnit[1];
            this.m_unitsComboModel.setSelectedItem(this.m_iCurrentUnit);
            this.m_capacitySpinnerModel.setMaximum(Double.valueOf(this.m_dMaxSizeAndUnit[0]));
            this.m_capacitySpinnerModel.setMinimum(Double.valueOf(this.m_dMinSizeAndUnit[0]));
            this.m_capacitySpinnerModel.setValue(this.m_dMaxSizeAndUnit[0]);
        } else {
            this.m_capacitySpinnerModel.setValue(0);
            this.m_capacityValueLbl.setText(KernelConstants.getConvertedSize(this.m_objSelDriveGroup.getCapacity().getMaxSizeInBlocks()));
            this.m_btnCreateVirtualDrive.setEnabled(false);
        }
    }

    private void resetVDPanelToVirtualDrive(VirtualDrive virtualDrive) {
        this.m_tfVDName.setText(virtualDrive.getName());
        this.m_cmbBxWritePolicy.setSelectedItem(virtualDrive.getWritePolicy());
        long l = virtualDrive.getSize();
        double[] dArray = KernelConstants.getSizeAndUnit(l);
        Capacity capacity = virtualDrive.getDriveGroup().getCapacity();
        this.m_dMinSizeAndUnit = KernelConstants.getSizeAndUnit(capacity.getMinSizeInBlocks());
        if (capacity.getMaxSizeInBlocks() != 0L) {
            this.m_dMaxSizeAndUnit = KernelConstants.getSizeAndUnit(capacity.getMaxSizeInBlocks() + virtualDrive.getSize());
            int n = (int)this.m_dMaxSizeAndUnit[1];
            if (dArray[1] == this.m_dMinSizeAndUnit[1]) {
                this.m_dMaxSizeAndUnit[0] = KernelConstants.getSizeInSpecifiedUnit(this.m_dMaxSizeAndUnit[0], (int)this.m_dMaxSizeAndUnit[1], (int)this.m_dMinSizeAndUnit[1]);
                this.m_dMaxSizeAndUnit[1] = this.m_dMinSizeAndUnit[1];
            } else if (dArray[1] == this.m_dMaxSizeAndUnit[1]) {
                this.m_dMinSizeAndUnit[0] = KernelConstants.getSizeInSpecifiedUnit(this.m_dMinSizeAndUnit[0], (int)this.m_dMinSizeAndUnit[1], (int)this.m_dMaxSizeAndUnit[1]);
                this.m_dMinSizeAndUnit[1] = this.m_dMaxSizeAndUnit[1];
            } else {
                this.m_dMinSizeAndUnit[0] = KernelConstants.getSizeInSpecifiedUnit(this.m_dMinSizeAndUnit[0], (int)this.m_dMinSizeAndUnit[1], (int)dArray[1]);
                this.m_dMaxSizeAndUnit[0] = KernelConstants.getSizeInSpecifiedUnit(this.m_dMaxSizeAndUnit[0], (int)this.m_dMaxSizeAndUnit[1], (int)dArray[1]);
                this.m_dMinSizeAndUnit[1] = dArray[1];
                this.m_dMaxSizeAndUnit[1] = dArray[1];
            }
            this.m_capacitySpinnerModel.setValue(0);
            this.m_capacityValueLbl.setText(KernelConstants.getConvertedSize(l));
            this.m_iCurrentUnit = (int)this.m_dMaxSizeAndUnit[1];
            double d = KernelConstants.getSizeInSpecifiedUnit(dArray[0], (int)dArray[1], n);
            if (d == 0.0) {
                --n;
            }
            this.m_unitsComboModel.setUnit(n);
            this.m_cmbBxUnits.setSelectedItem(this.m_iCurrentUnit);
            this.m_capacitySpinnerModel.setValue(dArray[0]);
            this.m_capacitySpinnerModel.setMinimum(Double.valueOf(this.m_dMinSizeAndUnit[0]));
            this.m_capacitySpinnerModel.setMaximum(Double.valueOf(this.m_dMaxSizeAndUnit[0]));
        } else {
            this.m_capacitySpinnerModel.setValue(0);
            this.m_capacityValueLbl.setText(KernelConstants.getConvertedSize(l));
            this.m_dMaxSizeAndUnit[0] = dArray[0];
            this.m_dMaxSizeAndUnit[1] = dArray[1];
            if (this.m_dMaxSizeAndUnit[1] != this.m_dMinSizeAndUnit[1]) {
                this.m_dMinSizeAndUnit[0] = KernelConstants.getSizeInSpecifiedUnit(this.m_dMinSizeAndUnit[0], (int)this.m_dMinSizeAndUnit[1], (int)this.m_dMaxSizeAndUnit[1]);
                this.m_dMinSizeAndUnit[1] = this.m_dMaxSizeAndUnit[1];
            }
            int n = (int)this.m_dMaxSizeAndUnit[1];
            this.m_iCurrentUnit = (int)this.m_dMaxSizeAndUnit[1];
            this.m_unitsComboModel.setUnit(n);
            this.m_cmbBxUnits.setSelectedItem(this.m_iCurrentUnit);
            this.m_capacitySpinnerModel.setValue(dArray[0]);
            this.m_capacitySpinnerModel.setMinimum(Double.valueOf(this.m_dMinSizeAndUnit[0]));
            this.m_capacitySpinnerModel.setMaximum(Double.valueOf(this.m_dMaxSizeAndUnit[0]));
        }
    }

    private void resetPanel() {
        this.m_tfVDName.setText("");
        this.m_tfVDName.setEnabled(false);
        this.m_cmbBxWritePolicy.setEnabled(false);
        this.m_cmbBxWritePolicy.setSelectedIndex(0);
        this.m_capacitySpinnerModel.setValue(0);
        this.m_capacityValueLbl.setText(KernelConstants.getConvertedSize(0.0));
    }

    private void generateChangeEvent() {
        if (this.m_changeListeners != null) {
            for (int i = 0; i < this.m_changeListeners.size(); ++i) {
                this.m_changeListeners.get(i).stateChanged(new ChangeEvent(new Boolean(this.isVDsAvailable())));
            }
        }
    }

    public void addChangeListener(ChangeListener changeListener) {
        if (this.m_changeListeners == null) {
            this.m_changeListeners = new ArrayList<ChangeListener>();
        }
        this.m_changeListeners.add(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        if (this.m_changeListeners == null || !this.m_changeListeners.contains(changeListener)) {
            return;
        }
        this.m_changeListeners.remove(changeListener);
    }

    public void cleanUp() {
        if (this.m_dgTreePanel != null) {
            this.m_dgTreePanel.removeTreeSelectionListener(this.m_dgTreeSelectionListener);
        }
    }

    public boolean isVDsAvailable() {
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.m_dgTreePanel.getDriveGroupTree().getModel();
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)defaultTreeModel.getRoot();
        int n = defaultMutableTreeNode.getChildCount();
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i);
            DriveGroup driveGroup = (DriveGroup)defaultMutableTreeNode2.getUserObject();
            List<VirtualDrive> list = driveGroup.getVirtualDrives();
            if (list == null || list.isEmpty()) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public JButton getDefaultButton() {
        return this.m_btnCreateVirtualDrive;
    }

    class LDWritePolicyRenderer
    extends DefaultListCellRenderer {
        LDWritePolicyRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            JLabel jLabel = (JLabel)super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            String string = "";
            if (object != null) {
                byte by = (Byte)object;
                if (by == 0) {
                    string = Resource.getString("CACHECADE_WRITE_THROUGH", "Write Through");
                } else if (by == 1) {
                    string = Resource.getString("CACHECADE_WRITE_BACK", "Write Back");
                }
                jLabel.setText(string);
            }
            return jLabel;
        }
    }

    class UnitsChangeItemListener
    implements ItemListener {
        UnitsChangeItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            double d;
            int n;
            if (CSAVDCreationPanel.this.m_cmbBxUnits.getSelectedIndex() != -1 && (n = ((Integer)itemEvent.getItem()).intValue()) != CSAVDCreationPanel.this.m_iCurrentUnit && (d = Double.parseDouble(CSAVDCreationPanel.this.m_capacitySpinner.getValue() + "")) > 0.0) {
                double d2 = KernelConstants.getSizeInSpecifiedUnit(d, CSAVDCreationPanel.this.m_iCurrentUnit, n);
                double d3 = KernelConstants.getSizeInSpecifiedUnit(CSAVDCreationPanel.this.m_dMinSizeAndUnit[0], (int)CSAVDCreationPanel.this.m_dMinSizeAndUnit[1], n);
                double d4 = KernelConstants.getSizeInSpecifiedUnit(CSAVDCreationPanel.this.m_dMaxSizeAndUnit[0], (int)CSAVDCreationPanel.this.m_dMaxSizeAndUnit[1], n);
                ((CSAVDCreationPanel)CSAVDCreationPanel.this).m_dMinSizeAndUnit[0] = d3;
                ((CSAVDCreationPanel)CSAVDCreationPanel.this).m_dMaxSizeAndUnit[0] = d4;
                ((CSAVDCreationPanel)CSAVDCreationPanel.this).m_dMaxSizeAndUnit[1] = n;
                ((CSAVDCreationPanel)CSAVDCreationPanel.this).m_dMinSizeAndUnit[1] = n;
                CSAVDCreationPanel.this.m_capacitySpinnerModel.setValue(d2);
                CSAVDCreationPanel.this.m_capacitySpinnerModel.setMaximum(Double.valueOf(CSAVDCreationPanel.this.m_dMaxSizeAndUnit[0]));
                CSAVDCreationPanel.this.m_capacitySpinnerModel.setMinimum(Double.valueOf(CSAVDCreationPanel.this.m_dMinSizeAndUnit[0]));
                CSAVDCreationPanel.this.m_iCurrentUnit = n;
            }
        }
    }

    class DeleteVDAction
    implements ActionListener {
        DeleteVDAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JTree jTree = CSAVDCreationPanel.this.m_dgTreePanel.getDriveGroupTree();
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)jTree.getLeadSelectionPath().getLastPathComponent();
            VirtualDrive virtualDrive = (VirtualDrive)defaultMutableTreeNode.getUserObject();
            CSAVDCreationPanel.this.m_objAdvConfigEngine.returnLDTargetId(virtualDrive.getTargetId());
            DriveGroup driveGroup = (DriveGroup)((DefaultMutableTreeNode)defaultMutableTreeNode.getParent()).getUserObject();
            driveGroup.removeVirtualDrive(virtualDrive);
            CSAVDCreationPanel.this.m_dgTreePanel.removeCurrentlySelectedVirtualDrive();
        }
    }

    class UpdateVDAction
    implements ActionListener {
        UpdateVDAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            long l;
            Object object;
            Object object2;
            if (((SASAdapter)CSAVDCreationPanel.this.m_objAdapterHelper.getDeviceObject()).getAdapterType() == 1) {
                byte by = (Byte)CSAVDCreationPanel.this.m_cmbBxWritePolicy.getSelectedItem();
                object2 = null;
                object = null;
                if (((VirtualDrive)((DefaultMutableTreeNode)CSAVDCreationPanel.this.m_dgTreePanel.getDriveGroupTree().getLeadSelectionPath().getLastPathComponent()).getUserObject()).getDriveGroup().getRaidLevel() == 0 && by == 1) {
                    object2 = Resource.getString("TITLE_CSA_CACHECADE_WRITE_BACK_SELECTED", "Write Back Selected");
                    object = Resource.getString("CSA_CACHECADE_WRITE_BACK_SELECTED_WARNING", "<html>Selecting Write Back policy for RAID 0 Nytro\u2122 Cache drive may result <br>in data loss, if any of the participating flash module drives fail.<br><br> Are you sure you want to proceed?<br><br></html>");
                    if (JOptionPane.showConfirmDialog(null, object, (String)object2, 0, 2) != 0) {
                        return;
                    }
                }
            }
            JTree jTree = CSAVDCreationPanel.this.m_dgTreePanel.getDriveGroupTree();
            object2 = (DefaultMutableTreeNode)jTree.getLeadSelectionPath().getLastPathComponent();
            object = (VirtualDrive)((DefaultMutableTreeNode)object2).getUserObject();
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)((DefaultMutableTreeNode)object2).getParent();
            DriveGroup driveGroup = (DriveGroup)defaultMutableTreeNode.getUserObject();
            long l2 = ((VirtualDrive)object).getSize();
            String string = CSAVDCreationPanel.this.m_tfVDName.getText().trim();
            if (string.length() == 0) {
                string = "CacheCade_" + ((VirtualDrive)object).getTargetId();
            }
            ((VirtualDrive)object).setName(string);
            double[] dArray = KernelConstants.getSizeAndUnit(l2);
            double d = Double.parseDouble(CSAVDCreationPanel.this.m_capacitySpinner.getValue() + "");
            double d2 = ((Integer)CSAVDCreationPanel.this.m_cmbBxUnits.getSelectedItem()).intValue();
            long l3 = KernelConstants.getSizeInBlocks(d, (int)d2);
            if (dArray[1] != d2) {
                dArray[0] = KernelConstants.getSizeInSpecifiedUnit(dArray[0], (int)dArray[1], (int)d2);
                dArray[1] = d2;
                if (driveGroup.getFreeSizeInBlocks() != 0L) {
                    long l4 = KernelConstants.getSizeInBlocks(CSAVDCreationPanel.this.m_dMaxSizeAndUnit[0], (int)CSAVDCreationPanel.this.m_dMaxSizeAndUnit[1]);
                    if (l3 == l4) {
                        l3 = driveGroup.getFreeSizeInBlocks() + l2;
                    }
                } else if (d == dArray[0]) {
                    l3 = l2;
                }
            } else if (d == dArray[0]) {
                l3 = l2;
            } else if (driveGroup.getFreeSizeInBlocks() != 0L && l3 == (l = KernelConstants.getSizeInBlocks(CSAVDCreationPanel.this.m_dMaxSizeAndUnit[0], (int)CSAVDCreationPanel.this.m_dMaxSizeAndUnit[1]))) {
                l3 = driveGroup.getFreeSizeInBlocks() + l2;
            }
            if (l3 != l2) {
                ((VirtualDrive)object).setSize(l3);
            }
            ((VirtualDrive)object).setWritePolicy((Byte)CSAVDCreationPanel.this.m_cmbBxWritePolicy.getSelectedItem());
            if (l2 != l3) {
                driveGroup.updateVirtualDrive((VirtualDrive)object, l2);
            }
            CSAVDCreationPanel.this.m_dgTreePanel.updateCurrentlySelectedVirtualDrive();
        }
    }

    class CreateVDAction
    implements ActionListener {
        CreateVDAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (((SASAdapter)CSAVDCreationPanel.this.m_objAdapterHelper.getDeviceObject()).getAdapterType() == 1) {
                byte by = (Byte)CSAVDCreationPanel.this.m_cmbBxWritePolicy.getSelectedItem();
                String string = null;
                String string2 = null;
                if (((DriveGroup)((DefaultMutableTreeNode)CSAVDCreationPanel.this.m_dgTreePanel.getDriveGroupTree().getLeadSelectionPath().getLastPathComponent()).getUserObject()).getRaidLevel() == 0 && by == 1) {
                    string = Resource.getString("TITLE_CSA_CACHECADE_WRITE_BACK_SELECTED", "Write Back Selected");
                    string2 = Resource.getString("CSA_CACHECADE_WRITE_BACK_SELECTED_WARNING", "<html>Selecting Write Back policy for RAID 0 Nytro\u2122 Cache drive may result <br>in data loss, if any of the participating flash module drives fail.<br><br> Are you sure you want to proceed?<br><br></html>");
                    if (JOptionPane.showConfirmDialog(null, string2, string, 0, 2) != 0) {
                        return;
                    }
                }
            }
            double d = Double.parseDouble(CSAVDCreationPanel.this.m_capacitySpinner.getValue() + "");
            long l = KernelConstants.getSizeInBlocks(d, (Integer)CSAVDCreationPanel.this.m_cmbBxUnits.getSelectedItem());
            JTree jTree = CSAVDCreationPanel.this.m_dgTreePanel.getDriveGroupTree();
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)jTree.getLeadSelectionPath().getLastPathComponent();
            DriveGroup driveGroup = (DriveGroup)defaultMutableTreeNode.getUserObject();
            if (l == KernelConstants.getSizeInBlocks(CSAVDCreationPanel.this.m_dMaxSizeAndUnit[0], (int)CSAVDCreationPanel.this.m_dMaxSizeAndUnit[1])) {
                l = driveGroup.getFreeSizeInBlocks();
            }
            byte by = CSAVDCreationPanel.this.m_objAdvConfigEngine.getLDTargetId();
            String string = CSAVDCreationPanel.this.m_tfVDName.getText().trim();
            if (string.length() == 0) {
                string = CSAVDCreationPanel.this.m_strSuggestedVDName;
            }
            if (string.length() > 15) {
                string = string.substring(0, 15);
            }
            VirtualDrive virtualDrive = new VirtualDrive(driveGroup, by, l, string, CSAVDCreationPanel.this.m_cStripeSize);
            virtualDrive.setWritePolicy((Byte)CSAVDCreationPanel.this.m_cmbBxWritePolicy.getSelectedItem());
            driveGroup.addVirtualDrive(virtualDrive);
            CSAVDCreationPanel.this.m_dgTreePanel.updateCurrentlySelectedVirtualDrive();
            CSAVDCreationPanel.this.m_dgTreePanel.addVirtualDrive(defaultMutableTreeNode, virtualDrive);
            CSAVDCreationPanel.this.resetVDPanelToSelectedDriveGroup();
        }
    }

    class DriveGroupTreeSelectionListener
    implements TreeSelectionListener {
        DriveGroupTreeSelectionListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            TreePath treePath = treeSelectionEvent.getPath();
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            Object object = defaultMutableTreeNode.getUserObject();
            if (object instanceof DriveGroup) {
                if (CSAVDCreationPanel.this.m_objAdvConfigEngine.canAddNewVirtualDrive() && ((DriveGroup)object).canAddVD()) {
                    CSAVDCreationPanel.this.m_btnCreateVirtualDrive.setEnabled(true);
                    CSAVDCreationPanel.this.m_btnUpdateVirtualDrive.setEnabled(false);
                    CSAVDCreationPanel.this.m_btnRemoveVirtualDrive.setEnabled(false);
                    CSAVDCreationPanel.this.m_objSelDriveGroup = (DriveGroup)object;
                    if (CSAVDCreationPanel.this.m_isWritebackSupported) {
                        CSAVDCreationPanel.this.m_cmbBxWritePolicy.removeAllItems();
                        CSAVDCreationPanel.this.m_cmbBxWritePolicy.addItem(CSAVDCreationPanel.this.m_cmbObjs[0]);
                        CSAVDCreationPanel.this.m_cmbBxWritePolicy.addItem(CSAVDCreationPanel.this.m_cmbObjs[1]);
                        if (CSAVDCreationPanel.this.m_objSelDriveGroup.getRaidLevel() == 0) {
                            CSAVDCreationPanel.this.m_cmbBxWritePolicy.setSelectedIndex(0);
                        } else {
                            CSAVDCreationPanel.this.m_cmbBxWritePolicy.setSelectedIndex(1);
                        }
                    }
                    CSAVDCreationPanel.this.m_cmbBxWritePolicy.setEnabled(CSAVDCreationPanel.this.m_isWritebackSupported);
                    CSAVDCreationPanel.this.resetVDPanelToSelectedDriveGroup();
                } else {
                    CSAVDCreationPanel.this.m_btnCreateVirtualDrive.setEnabled(false);
                    CSAVDCreationPanel.this.m_btnUpdateVirtualDrive.setEnabled(false);
                    CSAVDCreationPanel.this.m_btnRemoveVirtualDrive.setEnabled(false);
                    CSAVDCreationPanel.this.resetPanel();
                }
            } else if (object instanceof VirtualDrive) {
                CSAVDCreationPanel.this.m_btnCreateVirtualDrive.setEnabled(false);
                CSAVDCreationPanel.this.m_btnUpdateVirtualDrive.setEnabled(true);
                CSAVDCreationPanel.this.m_btnRemoveVirtualDrive.setEnabled(true);
                CSAVDCreationPanel.this.m_tfVDName.setEnabled(true);
                VirtualDrive virtualDrive = (VirtualDrive)object;
                if (CSAVDCreationPanel.this.m_isWritebackSupported) {
                    CSAVDCreationPanel.this.m_cmbBxWritePolicy.removeAllItems();
                    CSAVDCreationPanel.this.m_cmbBxWritePolicy.addItem(CSAVDCreationPanel.this.m_cmbObjs[0]);
                    CSAVDCreationPanel.this.m_cmbBxWritePolicy.addItem(CSAVDCreationPanel.this.m_cmbObjs[1]);
                    if (virtualDrive.getDriveGroup().getRaidLevel() == 0) {
                        CSAVDCreationPanel.this.m_cmbBxWritePolicy.setSelectedIndex(0);
                    } else {
                        CSAVDCreationPanel.this.m_cmbBxWritePolicy.setSelectedIndex(1);
                    }
                }
                CSAVDCreationPanel.this.m_cmbBxWritePolicy.setEnabled(CSAVDCreationPanel.this.m_isWritebackSupported && virtualDrive.getDriveGroup().getRaidLevel() != 7);
                CSAVDCreationPanel.this.resetVDPanelToVirtualDrive(virtualDrive);
            } else {
                CSAVDCreationPanel.this.m_btnRemoveVirtualDrive.setEnabled(false);
                CSAVDCreationPanel.this.m_btnCreateVirtualDrive.setEnabled(false);
                CSAVDCreationPanel.this.m_btnUpdateVirtualDrive.setEnabled(false);
                CSAVDCreationPanel.this.resetPanel();
            }
        }
    }

    class DriveGroupTreeModelListener
    implements TreeModelListener {
        DriveGroupTreeModelListener() {
        }

        @Override
        public void treeNodesChanged(TreeModelEvent treeModelEvent) {
            CSAVDCreationPanel.this.generateChangeEvent();
        }

        @Override
        public void treeNodesInserted(TreeModelEvent treeModelEvent) {
            CSAVDCreationPanel.this.generateChangeEvent();
        }

        @Override
        public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
            CSAVDCreationPanel.this.generateChangeEvent();
        }

        @Override
        public void treeStructureChanged(TreeModelEvent treeModelEvent) {
            CSAVDCreationPanel.this.generateChangeEvent();
        }
    }
}

