/*
 * Decompiled with CFR 0.152.
 */
package GUI.CSA;

import GUI.VivaldiBaseDialog;
import GUI.VivaldiStartupDialog;
import GUI.venus.configuration.advanced.VirtualDrive;
import GUIHelper.AdapterHelper;
import GUIHelper.LogicalDriveHelper;
import KernelExceptions.VKOperationFailedException;
import SASKernel.SASAdapter.SASAdapter;
import SASKernel.SASLogical.SASLogicalDrive;
import Utils.CustomMsgBox;
import Utils.GUIUtils;
import Utils.HelpContextResourse;
import Utils.Resource;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class ManageCSACachingDialog
extends VivaldiBaseDialog {
    public static final int CONTROLLER_OPERATION = 0;
    public static final int CONFIG_OPERATION = 1;
    private SelectableLogicalDrivesTableModel m_logicalDrivesTableModel = null;
    private int m_operation = 0;
    private JTable m_logicalDrivesTable = new JTable();
    private JCheckBox m_checkAll = new JCheckBox();
    private AdapterHelper m_adapterHelper = null;
    private ArrayList m_CSACacheableLDList = new ArrayList();
    private String m_title = "";
    private String m_topmessage = "";
    private String m_bottomMessage = "";
    private String m_yesOkButton = "";
    private String m_noCancelButton = "";

    public ManageCSACachingDialog(AdapterHelper adapterHelper, ArrayList arrayList, int n) {
        this.m_adapterHelper = adapterHelper;
        this.m_operation = n;
        this.m_CSACacheableLDList = arrayList;
        this.buildPanel();
    }

    public void buildPanel() {
        String[] stringArray = null;
        if (this.m_operation == 0) {
            this.m_title = Resource.getString("MANAGE_CSA_CACHING_TEXT1", "Manage Nytro\u2122 Cache");
            this.m_topmessage = Resource.getString("MANAGE_CSA_CACHING_TEXT2", "<html>When you enable Nytro\u2122 Cache, the virtual drive will become associated with an existing or <br> future Nytro\u2122 Cache drive.<br><br> If you decide to disable Nytro\u2122 Cache, any associations will be removed. It may take some <br> time to complete this operation.</html>");
            this.m_bottomMessage = "";
            this.m_yesOkButton = Resource.getString("BUTTON_LABEL_OK", "OK");
            this.m_noCancelButton = Resource.getString("BUTTON_LABEL_CANCEL", "Cancel");
        } else if (this.m_operation == 1) {
            this.m_title = Resource.getString("ENABLE_CSA_CACHING_TEXT1", "Enable Nytro\u2122 Cache on New Virtual Drives");
            this.m_topmessage = Resource.getString("ENABLE_CSA_CACHING_TEXT2", "It is possible to enable Nytro\u2122 Cache on the following new virtual drives.");
            this.m_bottomMessage = Resource.getString("ENABLE_CSA_CACHING_TEXT3", "<html>When you enable Nytro\u2122 Cache, the virtual drive will become associated with an existing or <br>future Nytro\u2122 Cache drive.<br><br>Do you want to enable Nytro\u2122 Cache on the selected virtual drives?</html>");
            this.m_yesOkButton = Resource.getString("BUTTON_YES_TEXT", "(Y)es");
            this.m_noCancelButton = Resource.getString("BUTTON_NO_TEXT", "(N)o");
        }
        this.setTitle(this.m_title);
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 11;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 6;
        jPanel.add((Component)new JLabel(this.m_topmessage), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        this.m_logicalDrivesTableModel = new SelectableLogicalDrivesTableModel(this.m_CSACacheableLDList);
        this.m_logicalDrivesTableModel.addTableModelListener(new LogicalDrivesTableModelListener());
        this.m_logicalDrivesTable = new JTable(this.m_logicalDrivesTableModel);
        this.m_logicalDrivesTable.setCellSelectionEnabled(false);
        this.m_logicalDrivesTable.setColumnSelectionAllowed(false);
        this.m_logicalDrivesTable.setRowSelectionAllowed(true);
        this.m_logicalDrivesTable.setSelectionMode(0);
        this.m_logicalDrivesTable.getTableHeader().setReorderingAllowed(false);
        this.m_logicalDrivesTable.getTableHeader().setResizingAllowed(true);
        this.m_logicalDrivesTable.setAutoResizeMode(0);
        TableColumn tableColumn = this.m_logicalDrivesTable.getColumnModel().getColumn(0);
        tableColumn.setPreferredWidth(60);
        tableColumn = this.m_logicalDrivesTable.getColumnModel().getColumn(1);
        tableColumn.setPreferredWidth(this.getPreferredSize().width - 54);
        if (this.m_operation == 0) {
            tableColumn = this.m_logicalDrivesTable.getColumnModel().getColumn(0);
            tableColumn.setCellRenderer(new BooleanRenderer());
            tableColumn = this.m_logicalDrivesTable.getColumnModel().getColumn(1);
            tableColumn.setCellRenderer(new VDTableCellRender());
        }
        JScrollPane jScrollPane = new JScrollPane(this.m_logicalDrivesTable, 20, 30);
        jScrollPane.setPreferredSize(new Dimension(this.getPreferredSize().width, 200));
        jPanel.add((Component)jScrollPane, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        stringArray = Resource.getResourceMnemonic(Resource.getString("VIRTUAL_DRIVE_LABEL", "(V)irtual Drives:"));
        JLabel jLabel = new JLabel(stringArray[0]);
        if (stringArray.length == 2) {
            jLabel.setDisplayedMnemonic(stringArray[1].charAt(0));
            jLabel.setLabelFor(this.m_logicalDrivesTable);
        }
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        stringArray = Resource.getResourceMnemonic(Resource.getString("CHECK_BOX_TEXT_ALL", "(A)ll"));
        this.m_checkAll.setText(stringArray[0]);
        if (stringArray.length == 2) {
            this.m_checkAll.setMnemonic(stringArray[1].charAt(0));
        }
        this.m_checkAll.setSelected(this.m_logicalDrivesTableModel.getSelectedRowCount() == this.m_CSACacheableLDList.size());
        this.m_checkAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ArrayList<Integer> arrayList = ManageCSACachingDialog.this.m_logicalDrivesTableModel.getDisableRows();
                int n = ManageCSACachingDialog.this.m_logicalDrivesTableModel.getRowCount();
                if (ManageCSACachingDialog.this.m_checkAll.isSelected()) {
                    for (int i = 0; i < n; ++i) {
                        if (arrayList.contains(i)) continue;
                        ManageCSACachingDialog.this.m_logicalDrivesTableModel.setValueAt(true, i, 0);
                    }
                    ManageCSACachingDialog.this.m_checkAll.setSelected(true);
                } else if (!ManageCSACachingDialog.this.m_checkAll.isSelected()) {
                    for (int i = 0; i < n; ++i) {
                        if (arrayList.contains(i)) continue;
                        ManageCSACachingDialog.this.m_logicalDrivesTableModel.setValueAt(false, i, 0);
                    }
                    ManageCSACachingDialog.this.m_checkAll.setSelected(false);
                }
            }
        });
        jPanel.add((Component)this.m_checkAll, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        jPanel.add((Component)new JLabel(this.m_bottomMessage), gridBagConstraints);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        JPanel jPanel3 = new JPanel(new GridLayout(1, 2));
        stringArray = Resource.getResourceMnemonic(this.m_yesOkButton);
        JButton jButton = new JButton(stringArray[0]);
        if (stringArray.length == 2) {
            jButton.setMnemonic(stringArray[1].charAt(0));
        }
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (ManageCSACachingDialog.this.m_operation == 0) {
                    if (ManageCSACachingDialog.this.showDisableWarning()) {
                        String string = Resource.getString("MANAGE_CSA_CACHING_TEXT3", "<html>If you disable Nytro\u2122 Cache, any associations that the selected <br>virtual drives have with Nytro\u2122 Cache volumes will be removed. <br>It may take some time to complete this operation.<br><br> Are you sure you want to disable Nytro\u2122 Cache on the selected <br>virtual drives?</html>");
                        String string2 = Resource.getString("MANAGE_CSA_CACHING_TEXT4", "DisableNytro\u2122 Cache");
                        if (CustomMsgBox.confirmWithCheck(VivaldiStartupDialog.mainScreen, string2, string)) {
                            try {
                                ((SASAdapter)ManageCSACachingDialog.this.m_adapterHelper.getDeviceObject()).setOnlyProvidedLdIds(ManageCSACachingDialog.this.m_logicalDrivesTableModel.getSelectedLogicalDrivesID());
                            }
                            catch (VKOperationFailedException vKOperationFailedException) {
                                CustomMsgBox.errorMsg(vKOperationFailedException);
                            }
                            ManageCSACachingDialog.this.dispose();
                        }
                    } else {
                        try {
                            ((SASAdapter)ManageCSACachingDialog.this.m_adapterHelper.getDeviceObject()).setOnlyProvidedLdIds(ManageCSACachingDialog.this.m_logicalDrivesTableModel.getSelectedLogicalDrivesID());
                        }
                        catch (VKOperationFailedException vKOperationFailedException) {
                            CustomMsgBox.errorMsg(vKOperationFailedException);
                        }
                        ManageCSACachingDialog.this.dispose();
                    }
                } else if (ManageCSACachingDialog.this.m_operation == 1) {
                    if (ManageCSACachingDialog.this.m_logicalDrivesTableModel.getSelectedRowCount() > 0) {
                        try {
                            ((SASAdapter)ManageCSACachingDialog.this.m_adapterHelper.getDeviceObject()).setAssociatedLdIds(ManageCSACachingDialog.this.m_logicalDrivesTableModel.getSelectedLogicalDrivesID());
                        }
                        catch (VKOperationFailedException vKOperationFailedException) {
                            CustomMsgBox.errorMsg(vKOperationFailedException);
                        }
                    }
                    ManageCSACachingDialog.this.dispose();
                }
            }
        });
        jPanel3.add(jButton);
        stringArray = Resource.getResourceMnemonic(this.m_noCancelButton);
        JButton jButton2 = new JButton(stringArray[0]);
        if (stringArray.length == 2) {
            jButton2.setMnemonic(stringArray[1].charAt(0));
        }
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ManageCSACachingDialog.this.dispose();
            }
        });
        jPanel3.add(jButton2);
        jPanel2.add((Component)jPanel3, "Center");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 0;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        this.getContentPane().add((Component)jPanel, "South");
        this.setResizable(false);
        this.setModal(true);
        this.pack();
        jButton.requestFocusInWindow();
        GUIUtils.centerDialogOnScreen(this);
        this.setVisible(true);
    }

    private boolean showDisableWarning() {
        ArrayList arrayList = this.m_logicalDrivesTableModel.getUnselectedLogicalDrives();
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            if (!((LogicalDriveHelper)arrayList.get(i)).isLdCached()) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getHelpPage() {
        return HelpContextResourse.getHelpPageName("MSM_CSA_USING_THE_NYTRO_CACHE_DRIVE");
    }

    class VDTableCellRender
    extends DefaultTableCellRenderer {
        VDTableCellRender() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            JLabel jLabel = (JLabel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            SelectableLogicalDrivesTableModel selectableLogicalDrivesTableModel = (SelectableLogicalDrivesTableModel)jTable.getModel();
            ArrayList<Integer> arrayList = selectableLogicalDrivesTableModel.getDisableRows();
            if (arrayList.contains(n)) {
                jLabel.setBorder(noFocusBorder);
                jLabel.setBackground(Color.white);
                jLabel.setEnabled(false);
            } else {
                jLabel.setEnabled(true);
            }
            return jLabel;
        }
    }

    public class BooleanRenderer
    extends JCheckBox
    implements TableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Border border = UIManager.getBorder("Table.focusCellHighlightBorder");
            if (!jTable.isCellEditable(n, n2)) {
                EmptyBorder emptyBorder = new EmptyBorder(border.getBorderInsets(this));
                this.setEnabled(false);
                this.setBorder(emptyBorder);
                this.setBackground((Color)UIManager.get("Table.background"));
            } else {
                this.setEnabled(true);
                this.setBorder(border);
                if (bl2 || jTable.getSelectedRow() == n) {
                    this.setBackground((Color)UIManager.get("Table.selectionBackground"));
                } else {
                    this.setBackground((Color)UIManager.get("Table.background"));
                }
            }
            this.setHorizontalAlignment(0);
            this.setSelected((Boolean)object);
            return this;
        }
    }

    class SelectableLogicalDrivesTableModel
    extends AbstractTableModel {
        private ArrayList l_objCSACacheableLDs = null;
        private boolean[] l_selectedRows = null;
        private ArrayList<Integer> l_disabledrows = new ArrayList();

        public SelectableLogicalDrivesTableModel(ArrayList arrayList) {
            this.l_objCSACacheableLDs = arrayList;
            int n = this.l_objCSACacheableLDs.size();
            this.l_selectedRows = new boolean[n];
            for (int i = 0; i < n; ++i) {
                if (ManageCSACachingDialog.this.m_operation == 0) {
                    this.l_selectedRows[i] = ((LogicalDriveHelper)this.l_objCSACacheableLDs.get(i)).isLdCached();
                    continue;
                }
                if (ManageCSACachingDialog.this.m_operation != 1) continue;
                this.l_selectedRows[i] = true;
            }
            this.initialiseDisableRows();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return this.l_objCSACacheableLDs.size();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            Object object = null;
            if (n2 == 0) {
                object = new Boolean(this.l_selectedRows[n]);
            }
            if (n2 == 1) {
                if (ManageCSACachingDialog.this.m_operation == 0) {
                    object = ((LogicalDriveHelper)this.l_objCSACacheableLDs.get(n)).getText();
                } else if (ManageCSACachingDialog.this.m_operation == 1) {
                    object = ((VirtualDrive)this.l_objCSACacheableLDs.get(n)).getText();
                }
            }
            return object;
        }

        @Override
        public Class<?> getColumnClass(int n) {
            if (n == 0) {
                return Boolean.class;
            }
            return super.getColumnClass(n);
        }

        @Override
        public String getColumnName(int n) {
            String string = null;
            if (n == 0) {
                if (ManageCSACachingDialog.this.m_operation == 0) {
                    string = Resource.getString("ENABLED_TEXT", "Enabled");
                } else if (ManageCSACachingDialog.this.m_operation == 1) {
                    string = Resource.getString("ENABLE_TEXT", "Enable");
                }
            } else if (n == 1) {
                string = Resource.getString("VIRTUAL_DRIVE_TEXT", "Virtual Drive");
            }
            return string;
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            if (this.l_disabledrows.contains(n)) {
                return false;
            }
            return n2 == 0;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (n2 == 0) {
                this.l_selectedRows[n] = (Boolean)object;
                this.fireTableCellUpdated(n, n2);
            }
        }

        public int getSelectedRowCount() {
            int n = 0;
            int n2 = this.l_selectedRows.length;
            for (int i = 0; i < n2; ++i) {
                if (!this.l_selectedRows[i]) continue;
                ++n;
            }
            return n;
        }

        public ArrayList getSelectedLogicalDrives() {
            ArrayList arrayList = new ArrayList();
            int n = this.l_selectedRows.length;
            for (int i = 0; i < n; ++i) {
                if (!this.l_selectedRows[i]) continue;
                arrayList.add(this.l_objCSACacheableLDs.get(i));
            }
            return arrayList;
        }

        public ArrayList getUnselectedLogicalDrives() {
            ArrayList arrayList = new ArrayList();
            int n = this.l_selectedRows.length;
            for (int i = 0; i < n; ++i) {
                if (this.l_selectedRows[i]) continue;
                arrayList.add(this.l_objCSACacheableLDs.get(i));
            }
            return arrayList;
        }

        public byte[] getSelectedLogicalDrivesID() {
            ArrayList arrayList = this.getSelectedLogicalDrives();
            int n = arrayList.size();
            byte[] byArray = new byte[n];
            for (int i = 0; i < n; ++i) {
                if (ManageCSACachingDialog.this.m_operation == 0) {
                    byArray[i] = (byte)((SASLogicalDrive)((LogicalDriveHelper)arrayList.get(i)).getDeviceObject()).getID();
                    continue;
                }
                if (ManageCSACachingDialog.this.m_operation != 1) continue;
                byArray[i] = ((VirtualDrive)arrayList.get(i)).getTargetId();
            }
            return byArray;
        }

        public ArrayList<Integer> getDisableRows() {
            return this.l_disabledrows;
        }

        public void initialiseDisableRows() {
            if (ManageCSACachingDialog.this.m_operation == 0) {
                ArrayList arrayList = ManageCSACachingDialog.this.m_adapterHelper.getDisassociatedSSCLDList(this.l_objCSACacheableLDs, 0);
                int n = arrayList.size();
                for (int i = 0; i < n; ++i) {
                    if (!this.l_objCSACacheableLDs.contains(arrayList.get(i))) continue;
                    this.l_disabledrows.add(this.l_objCSACacheableLDs.indexOf(arrayList.get(i)));
                }
            }
        }
    }

    class LogicalDrivesTableModelListener
    implements TableModelListener {
        LogicalDrivesTableModelListener() {
        }

        @Override
        public void tableChanged(TableModelEvent tableModelEvent) {
            if (ManageCSACachingDialog.this.m_logicalDrivesTableModel.getSelectedRowCount() == ManageCSACachingDialog.this.m_logicalDrivesTableModel.getRowCount()) {
                ManageCSACachingDialog.this.m_checkAll.setSelected(true);
            } else {
                ManageCSACachingDialog.this.m_checkAll.setSelected(false);
            }
        }
    }
}

