/*
 * Decompiled with CFR 0.152.
 */
package GUI;

import GUI.venus.configuration.ConfigurationSummaryPage;
import GUI.venus.configuration.ModeSelectionPage;
import GUI.venus.configuration.advanced.AdvanceConfigEngine;
import GUI.venus.configuration.advanced.DriveGroup;
import GUI.venus.configuration.advanced.VirtualDiskCreationPage;
import GUI.venus.configuration.simple.SimpleConfigEngine;
import GUI.venus.wizard.WizardController;
import GUI.venus.wizard.WizardNavigationException;
import GUIHelper.AdapterHelper;
import GUIHelper.ArrayHelper;
import GUIHelper.CapacityHelper;
import GUIHelper.ContainerNodeHelper;
import SASKernel.Operations.OperationDetails;
import SASKernel.SASAdapter.SASAdapter;
import Utils.Resource;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.JMenuItem;

public class CapacityNode {
    private ContainerNodeHelper m_nodeHelper = null;
    private AdapterHelper adapter = null;
    private ArrayHelper m_arrayHelper = null;
    private CapacityHelper m_capacityHelper = null;

    public CapacityNode(ContainerNodeHelper containerNodeHelper) {
        this.m_nodeHelper = containerNodeHelper;
        this.adapter = this.m_nodeHelper.getAdapterHelper();
        this.m_arrayHelper = this.m_nodeHelper.getArrayHelper();
    }

    public JMenuItem getCreateVDMenuItem() {
        if (!this.m_arrayHelper.isRebuildInProgress()) {
            OperationDetails operationDetails = new OperationDetails(9, null);
            int n = 0;
            try {
                ((SASAdapter)this.adapter.getDeviceObject()).fireConfigOperation(operationDetails);
                n = (Integer)operationDetails.getParam();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            if (this.m_capacityHelper == null) {
                this.m_capacityHelper = this.getCapacityHelper();
            }
            if (n & true && this.m_arrayHelper.canAddLd() && !this.m_arrayHelper.isHolePartOfSlicedBootVolume()) {
                String[] stringArray = null;
                stringArray = Resource.getResourceMnemonic(Resource.getString("OPERATION_CREATE_VD", "Create (V)irtual Drive"));
                JMenuItem jMenuItem = new JMenuItem(stringArray[0]);
                if (stringArray.length == 2) {
                    jMenuItem.setMnemonic(stringArray[1].charAt(0));
                }
                jMenuItem.addActionListener(new CreateVDAction());
                return jMenuItem;
            }
        }
        return null;
    }

    public CapacityHelper getCapacityHelper() {
        ArrayList<CapacityHelper> arrayList = this.m_arrayHelper.getCapacityHelpers();
        for (int i = 0; i < arrayList.size(); ++i) {
            if (arrayList.get(i).getFreeIndex() != this.m_nodeHelper.getHoleid()) continue;
            return arrayList.get(i);
        }
        return null;
    }

    class CreateVDAction
    implements ActionListener {
        CreateVDAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                Object object;
                if (CapacityNode.this.m_capacityHelper == null) {
                    CapacityNode.this.m_capacityHelper = CapacityNode.this.getCapacityHelper();
                }
                SimpleConfigEngine simpleConfigEngine = new SimpleConfigEngine(CapacityNode.this.adapter);
                AdvanceConfigEngine advanceConfigEngine = new AdvanceConfigEngine(CapacityNode.this.adapter);
                List<DriveGroup> list = advanceConfigEngine.getExistingDriveGroups();
                Object object2 = null;
                for (int n = 0; n < list.size(); n = (int)((byte)(n + 1))) {
                    object = list.get(n);
                    if (!((DriveGroup)object).getArrayHelpers().contains(CapacityNode.this.m_arrayHelper)) continue;
                    object2 = object;
                    advanceConfigEngine.addNewDriveGroup((DriveGroup)object2);
                    ((DriveGroup)object2).setSelectedSpanHoleIndex((byte)CapacityNode.this.m_capacityHelper.getFreeIndex());
                    break;
                }
                WizardController wizardController = new WizardController();
                object = wizardController.getWizardData();
                ((HashMap)object).put("isSimpleAllowed", CapacityNode.this.m_arrayHelper.getSpanDepth() == 1);
                ((HashMap)object).put("ArrayData", CapacityNode.this.m_capacityHelper);
                ((HashMap)object).put("SimpleConfigEngine", simpleConfigEngine);
                ((HashMap)object).put("AdapterHelper", CapacityNode.this.adapter);
                ((HashMap)object).put("AdvanceConfigEngine", advanceConfigEngine);
                if (object2 != null) {
                    ((HashMap)object).put("SelectedSpanHole", ((DriveGroup)object2).getCurrentlySelectedSpanHole());
                }
                ((HashMap)object).put("CapacityNodeLaunch", true);
                ((HashMap)object).put("WarningDialogTitle", Resource.getString("CONFIG_CONFIRMATION_TITLE", "Create virtual Drive - Confirmation"));
                wizardController.addPage(ModeSelectionPage.class.getName(), "ModeSelectionPage");
                wizardController.addPage(VirtualDiskCreationPage.class.getName(), "AdvanceVDCreationPage");
                wizardController.addPage(ConfigurationSummaryPage.class.getName(), "ConfigurationSummaryPage");
                wizardController.setFirstPage("ModeSelectionPage");
                wizardController.addPageTransition("ModeSelectionPage", 0, "ConfigurationSummaryPage");
                wizardController.addPageTransition("ModeSelectionPage", 1, "AdvanceVDCreationPage");
                wizardController.addPageTransition("AdvanceVDCreationPage", 0, "ConfigurationSummaryPage");
                wizardController.launchWizard();
            }
            catch (WizardNavigationException wizardNavigationException) {
                wizardNavigationException.printStackTrace();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

