/*
 * Decompiled with CFR 0.152.
 */
package GUI;

import GUI.RemoteServer;
import GUI.RemoteServerPanel;
import GUI.VivaldiBaseDialog;
import Utils.HelpContext;
import Utils.Resource;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ClusteredServersDialog
extends VivaldiBaseDialog
implements ListSelectionListener {
    public ClusteredServersDialog psDialog = this;
    private JLabel hostName;
    private JButton loginButton;
    private JButton closeButton;
    private JButton helpButton;
    private RemoteServerPanel remoteobj;
    private JList list;
    private DefaultListModel listModel;
    private static RemoteServer remoteServer;

    public ClusteredServersDialog(HashMap hashMap, RemoteServerPanel remoteServerPanel) {
        this.remoteobj = remoteServerPanel;
        this.addComponets(hashMap);
    }

    public void addComponets(HashMap hashMap) {
        JComponent jComponent;
        Object object;
        this.listModel = new DefaultListModel();
        String[] stringArray = Resource.getResourceMnemonic(Resource.getString("BUTTON_LOGIN_TEXT", "Login"));
        this.loginButton = new JButton(stringArray[0]);
        if (stringArray.length == 2) {
            this.loginButton.setMnemonic(stringArray[1].charAt(0));
        }
        stringArray = Resource.getResourceMnemonic(Resource.getString("HELP_BUTTON_TEXT", "(H)elp"));
        this.helpButton = new JButton(stringArray[0]);
        if (stringArray.length == 2) {
            this.helpButton.setMnemonic(stringArray[1].charAt(0));
        }
        stringArray = Resource.getResourceMnemonic(Resource.getString("CLOSE_TEXT ", "(C)lose"));
        this.closeButton = new JButton(stringArray[0]);
        if (stringArray.length == 2) {
            this.closeButton.setMnemonic(stringArray[1].charAt(0));
        }
        this.helpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HelpContext.executeHelpProcess(ClusteredServersDialog.this.getHelpPage());
            }
        });
        final JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(5, 10));
        JPanel jPanel2 = new JPanel(new BorderLayout());
        this.setTitle("View Clustered Servers");
        JLabel jLabel = new JLabel("Click on the Clusterted Server link to log in.                                  ");
        JLabel jLabel2 = new JLabel("       ");
        JLabel jLabel3 = new JLabel("       ");
        jPanel.add((Component)jLabel2, "Before");
        jPanel.add((Component)jLabel3, "East");
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 11;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(10, 0, 0, 30);
        stringArray = Resource.getResourceMnemonic(Resource.getString("TITLE_CLUSTER_DIALOG", "Clustered Servers:               "));
        JLabel jLabel4 = new JLabel(stringArray[0]);
        if (stringArray.length == 2) {
            jLabel4.setDisplayedMnemonic(stringArray[1].charAt(0));
        }
        jPanel3.add((Component)jLabel, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets = new Insets(20, 0, 0, 0);
        jPanel3.add((Component)jLabel4, gridBagConstraints);
        Set set = hashMap.keySet();
        Iterator iterator = set.iterator();
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.anchor = 11;
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.insets = new Insets(10, 20, 0, 10);
        int n = 0;
        while (iterator.hasNext()) {
            ++n;
            object = (String)iterator.next();
            jComponent = new JLabel("   ");
            String string = "<html><b><FONT face=Times>High Availability Cluster  " + (String)object + "</FONT></b></html>";
            JLabel jLabel5 = new JLabel(string);
            JPopupMenu.Separator separator = new JPopupMenu.Separator();
            if (n != 1) {
                this.listModel.addElement(((JLabel)jComponent).getText());
            }
            this.listModel.addElement(jLabel5.getText());
            ArrayList arrayList = (ArrayList)hashMap.get(object);
            for (RemoteServer remoteServer : arrayList) {
                System.out.println("remoteServer.getHealth()=" + remoteServer.getHealth());
                this.listModel.addElement(remoteServer);
            }
        }
        this.list = new JList(this.listModel);
        this.list.setCellRenderer(new SelectedListCellRenderer());
        gridBagConstraints2.insets = new Insets(0, 0, 0, 0);
        jPanel2.add((Component)this.list, "Before");
        jPanel2.setBackground(Color.white);
        object = new JScrollPane(jPanel2);
        jPanel.add((Component)jPanel3, "First");
        jPanel.add((Component)object, "Center");
        jComponent = new JPanel();
        this.loginButton.setEnabled(false);
        jComponent.add(this.closeButton);
        jComponent.add(this.helpButton);
        jPanel.add((Component)jComponent, "Last");
        this.add(jPanel);
        this.setResizable(true);
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ClusteredServersDialog.this.dispose();
            }
        });
        this.loginButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ClusteredServersDialog.this.remoteobj.tryToConnect(ClusteredServersDialog.this.getRemoteServerObject());
                ClusteredServersDialog.this.loginButton.setEnabled(false);
                jPanel.setVisible(false);
                ClusteredServersDialog.this.psDialog.dispose();
            }
        });
        this.list.setCellRenderer(new ComboSeparatorsRenderer(this.list.getCellRenderer()){

            @Override
            protected boolean addSeparatorAfter(JList jList, Object object, int n) {
                return object instanceof String && ((String)object).contains("High Availability Cluster");
            }
        });
        this.list.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                int n = mouseEvent.getClickCount();
                int n2 = ClusteredServersDialog.this.list.getSelectedIndex();
                RemoteServer remoteServer = null;
                try {
                    remoteServer = (RemoteServer)ClusteredServersDialog.this.listModel.get(n2);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (remoteServer != null && remoteServer instanceof RemoteServer) {
                    ClusteredServersDialog.this.remoteobj.tryToConnect(remoteServer);
                }
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
            }
        });
    }

    public void setRemoteServerObject(RemoteServer remoteServer) {
        ClusteredServersDialog.remoteServer = remoteServer;
    }

    public RemoteServer getRemoteServerObject() {
        return remoteServer;
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        try {
            Object e = this.list.getSelectedValue();
            if (e instanceof RemoteServer) {
                this.loginButton.setEnabled(true);
                this.setRemoteServerObject((RemoteServer)e);
            } else {
                this.loginButton.setEnabled(false);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public class SelectedListCellRenderer
    extends DefaultListCellRenderer {
        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            Component component = super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            Object e = jList.getSelectedValue();
            if (bl && e instanceof RemoteServer) {
                component.setBackground(Color.white);
            }
            return component;
        }
    }

    public abstract class ComboSeparatorsRenderer
    implements ListCellRenderer {
        private ListCellRenderer delegate;
        private JPanel separatorPanel = new JPanel(new BorderLayout());
        private JSeparator separator = new JSeparator();

        public ComboSeparatorsRenderer(ListCellRenderer listCellRenderer) {
            this.delegate = listCellRenderer;
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            Component component = this.delegate.getListCellRendererComponent(jList, object, n, bl, bl2);
            if (n != -1 && this.addSeparatorAfter(jList, object, n)) {
                this.separatorPanel.removeAll();
                this.separatorPanel.add(component, "Center");
                this.separatorPanel.add((Component)this.separator, "South");
                return this.separatorPanel;
            }
            return component;
        }

        protected abstract boolean addSeparatorAfter(JList var1, Object var2, int var3);
    }
}

