/*
 * Decompiled with CFR 0.152.
 */
package GUI;

import GUI.DrivesSpinUpProgressDialog;
import GUI.VivaldiStartupDialog;
import GUIHelper.AdapterHelper;
import GUIHelper.ServerObjectHelper;
import KernelExceptions.VKObjectNotPresentException;
import KernelExceptions.VKOperationFailedException;
import SASKernel.LibraryAPI.StoreLib.MR_ARRAY;
import SASKernel.LibraryAPI.StoreLib.MR_CONFIG_DATA;
import SASKernel.LibraryAPI.StoreLib.MR_LD_CONFIG;
import SASKernel.LibraryAPI.StoreLib.MR_PD_REF;
import SASKernel.LibraryAPI.StoreLib.MR_SPARE;
import SASKernel.LibraryAPI.StoreLib.pdType_MR_PD_INFO;
import SASKernel.LibraryAPI.StoreLib.pd_MR_ARRAY;
import SASKernel.Operations.OperationDetails;
import SASKernel.SASAdapter.SASAdapter;
import SASKernel.SASPhysical.SASPhysicalDrive;
import SASKernel.SASServer;
import Services.NetworkToJavaConverter;
import Utils.CustomMsgBox;
import Utils.Resource;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import javax.swing.JFileChooser;

public class ConfigFileManager {
    private AdapterHelper m_adapterHelper = null;

    public ConfigFileManager(AdapterHelper adapterHelper) {
        this.m_adapterHelper = adapterHelper;
    }

    public boolean saveConfig() {
        SASAdapter sASAdapter = (SASAdapter)this.m_adapterHelper.getDeviceObject();
        try {
            OperationDetails operationDetails = new OperationDetails(0, "", "", null);
            sASAdapter.fireConfigOperation(operationDetails);
            byte[] byArray = ((MR_CONFIG_DATA)operationDetails.getParam()).getByteArray();
            JFileChooser jFileChooser = new JFileChooser();
            SASServer sASServer = (SASServer)((ServerObjectHelper)this.m_adapterHelper.getParent()).getDeviceObject();
            String string = new String(sASServer.getInformation().getHostName() + ".cfg");
            jFileChooser.setCurrentDirectory(new File("."));
            jFileChooser.setSelectedFile(new File(string));
            if (jFileChooser.showSaveDialog(VivaldiStartupDialog.mainScreen) == 0) {
                byte[] byArray2;
                File file = jFileChooser.getSelectedFile();
                if (file.exists() && !CustomMsgBox.confirm(Resource.getString("MSG_CONFIRM_CFG_FILE_OVERWRITE", "File already exists. Do you want to overwrite ?"))) {
                    return true;
                }
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                byte[] byArray3 = new byte[4];
                NetworkToJavaConverter.intToByteArray(byArray.length, byArray3);
                ((OutputStream)fileOutputStream).write(byArray3);
                ((OutputStream)fileOutputStream).write(byArray);
                NetworkToJavaConverter.intToByteArray(this.getChecksum(byArray), byArray3);
                ((OutputStream)fileOutputStream).write(byArray3);
                if (this.m_adapterHelper.isSSCEnabled() && this.m_adapterHelper.getAdapterInfo().getldOperations_MR_CTRL_INFO().isSupportSSCAssociation() && (byArray2 = this.m_adapterHelper.getAssociatedLdIds()) != null && byArray2.length > 0) {
                    NetworkToJavaConverter.intToByteArray(byArray2.length, byArray3);
                    ((OutputStream)fileOutputStream).write(byArray3);
                    ((OutputStream)fileOutputStream).write(byArray2);
                }
                ((OutputStream)fileOutputStream).close();
            }
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public boolean loadConfig() {
        Object object;
        if (!CustomMsgBox.confirm(Resource.getString("MSG_CONFIRM_ADDCFG", "<html>This operation will try to configure the controller based on a saved configuration.<br>Unstable conditions might arise due to difference in physical devices in the two configurations.<br>Are you sure ?</html>"))) {
            return true;
        }
        if (this.m_adapterHelper.getLogicalDrives() != null && this.m_adapterHelper.getLogicalDrives().length != 0) {
            new CustomMsgBox(Resource.getString("MSG_CONF_EXISTS", "Configuration exists . You must clear the existing configuration before adding a new one ."));
            return true;
        }
        byte[] byArray = null;
        byte[] byArray2 = null;
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setCurrentDirectory(new File("."));
        jFileChooser.setMultiSelectionEnabled(false);
        if (jFileChooser.showOpenDialog(VivaldiStartupDialog.mainScreen) == 1) {
            return true;
        }
        File file = jFileChooser.getSelectedFile();
        try {
            int n;
            FileInputStream fileInputStream = new FileInputStream(file);
            object = new byte[4];
            if (((InputStream)fileInputStream).read((byte[])object, 0, 4) == -1) {
                ((InputStream)fileInputStream).close();
                return false;
            }
            int n2 = NetworkToJavaConverter.byteArrayToInt((byte[])object, 0);
            try {
                byArray = new byte[n2];
            }
            catch (OutOfMemoryError outOfMemoryError) {
                ((InputStream)fileInputStream).close();
                return false;
            }
            for (n = 0; n < n2; n += 1024) {
                int n3 = 0;
                n3 = n2 > n + 1024 ? 1024 : n2 - n;
                if (((InputStream)fileInputStream).read(byArray, n, n3) != -1) continue;
                ((InputStream)fileInputStream).close();
                return false;
            }
            if (((InputStream)fileInputStream).read((byte[])object, 0, 4) == -1) {
                ((InputStream)fileInputStream).close();
                return false;
            }
            if (this.getChecksum(byArray) != NetworkToJavaConverter.byteArrayToInt((byte[])object, 0)) {
                return false;
            }
            if (this.m_adapterHelper.isSSCEnabled() && this.m_adapterHelper.getAdapterInfo().getldOperations_MR_CTRL_INFO().isSupportSSCAssociation()) {
                n = 0;
                if (((InputStream)fileInputStream).read((byte[])object, 0, 4) != -1 && (n = NetworkToJavaConverter.byteArrayToInt((byte[])object, 0)) > 0 && ((InputStream)fileInputStream).read(byArray2 = new byte[n], 0, n) == -1) {
                    byArray2 = null;
                }
            }
            ((InputStream)fileInputStream).close();
        }
        catch (IOException iOException) {
            return false;
        }
        catch (Exception exception) {
            return false;
        }
        object = (SASAdapter)this.m_adapterHelper.getDeviceObject();
        MR_CONFIG_DATA mR_CONFIG_DATA = new MR_CONFIG_DATA(byArray, 0);
        if (!this.validateConfigData(mR_CONFIG_DATA, (SASAdapter)object)) {
            return false;
        }
        try {
            ((SASAdapter)object).fireConfigOperation(new OperationDetails(1, mR_CONFIG_DATA));
        }
        catch (VKOperationFailedException vKOperationFailedException) {
            CustomMsgBox.errorMsg(vKOperationFailedException);
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            Thread.sleep(1000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (byArray2 != null) {
            try {
                ((SASAdapter)object).setOnlyProvidedLdIds(byArray2);
            }
            catch (VKOperationFailedException vKOperationFailedException) {
                CustomMsgBox.errorMsg(vKOperationFailedException);
            }
        }
        return true;
    }

    public int getChecksum(byte[] byArray) {
        int n = 0;
        for (int i = 0; i < byArray.length; ++i) {
            n += byArray[i];
        }
        return n;
    }

    public char[] byteArrayToCharArray(byte[] byArray) {
        char[] cArray = new char[byArray.length];
        for (int i = 0; i < byArray.length; ++i) {
            cArray[i] = (char)byArray[i];
        }
        return cArray;
    }

    public byte[] charArrayToByteArray(char[] cArray) {
        byte[] byArray = new byte[cArray.length];
        for (int i = 0; i < cArray.length; ++i) {
            byArray[i] = (byte)cArray[i];
        }
        return byArray;
    }

    public boolean validateConfigData(MR_CONFIG_DATA mR_CONFIG_DATA, SASAdapter sASAdapter) {
        try {
            MR_PD_REF mR_PD_REF;
            int n;
            pd_MR_ARRAY[] pd_MR_ARRAYArray;
            int n2;
            ArrayList arrayList = sASAdapter.getSASObjectsArrayList((short)4096);
            int n3 = arrayList.size();
            MR_ARRAY[] mR_ARRAYArray = mR_CONFIG_DATA.getarray();
            ArrayList<SASPhysicalDrive> arrayList2 = new ArrayList<SASPhysicalDrive>();
            boolean bl = sASAdapter.getInformation().getpdOperations_MR_CTRL_INFO().isPowerStateForConfig();
            for (n2 = 0; n2 < mR_ARRAYArray.length; ++n2) {
                pd_MR_ARRAYArray = mR_ARRAYArray[n2].getpd_MR_ARRAY1();
                for (n = 0; n < mR_ARRAYArray[n2].getnumDrives(); ++n) {
                    mR_PD_REF = pd_MR_ARRAYArray[n].getref();
                    SASPhysicalDrive sASPhysicalDrive = null;
                    boolean bl2 = false;
                    for (int i = 0; i < n3; ++i) {
                        sASPhysicalDrive = (SASPhysicalDrive)arrayList.get(i);
                        if (mR_PD_REF.getdeviceId() == -1) {
                            bl2 = true;
                            break;
                        }
                        if (mR_PD_REF.getdeviceId() != sASPhysicalDrive.getDeviceId()) continue;
                        mR_PD_REF.setseqNum(sASPhysicalDrive.getSeqNum());
                        bl2 = true;
                        break;
                    }
                    if (bl && (sASPhysicalDrive != null && sASPhysicalDrive.getInformation().getPowerState() == 1 || sASPhysicalDrive.getInformation().getdisabledForRemoval() == '\u0001')) {
                        arrayList2.add(sASPhysicalDrive);
                    }
                    if (bl2) continue;
                    return false;
                }
            }
            if (arrayList2.size() > 0) {
                DrivesSpinUpProgressDialog drivesSpinUpProgressDialog = new DrivesSpinUpProgressDialog(sASAdapter, arrayList2);
            }
            for (n2 = 0; n2 < mR_ARRAYArray.length; ++n2) {
                pd_MR_ARRAYArray = mR_ARRAYArray[n2].getpd_MR_ARRAY1();
                for (n = 0; n < pd_MR_ARRAYArray.length; ++n) {
                    mR_PD_REF = pd_MR_ARRAYArray[n].getref();
                    for (int i = 0; i < n3; ++i) {
                        SASPhysicalDrive sASPhysicalDrive = (SASPhysicalDrive)arrayList.get(i);
                        if (mR_PD_REF.getdeviceId() != sASPhysicalDrive.getDeviceId()) continue;
                        pdType_MR_PD_INFO pdType_MR_PD_INFO2 = sASPhysicalDrive.getInformation().getstate_MR_PD_INFO1().getpdType_MR_PD_INFO1();
                        if (sASPhysicalDrive.getState() == 0) {
                            if (pdType_MR_PD_INFO2.getisForeign() != 1) continue;
                            return false;
                        }
                        return false;
                    }
                }
            }
            MR_SPARE[] mR_SPAREArray = mR_CONFIG_DATA.getspare();
            for (int i = 0; i < mR_SPAREArray.length; ++i) {
                n = 0;
                for (int j = 0; j < arrayList.size(); ++j) {
                    SASPhysicalDrive sASPhysicalDrive = (SASPhysicalDrive)arrayList.get(j);
                    if (mR_SPAREArray[i].getref().getdeviceId() != sASPhysicalDrive.getDeviceId()) continue;
                    mR_SPAREArray[i].getref().setseqNum(sASPhysicalDrive.getSeqNum());
                    n = 1;
                }
                if (n != 0) continue;
                return false;
            }
            MR_LD_CONFIG[] mR_LD_CONFIGArray = mR_CONFIG_DATA.getld();
            for (n = 0; n < mR_LD_CONFIGArray.length; ++n) {
                mR_LD_CONFIGArray[n].getproperties().getldRef().setseqNum((short)0);
            }
        }
        catch (VKObjectNotPresentException vKObjectNotPresentException) {
            return false;
        }
        return true;
    }
}

